/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.readline;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.gnu.readline.Readline;
import org.gnu.readline.ReadlineLibrary;

public class ReadlineReader
extends Reader {
    public static final String DEFAULT_PROMPT = "";
    private StringBuffer iBuff = new StringBuffer();
    private String iLineSeparator;
    private String iPrompt;
    private File iHistoryFile;

    public String getPrompt() {
        return this.iPrompt;
    }

    public void setPrompt(String string) {
        this.iPrompt = string;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        try {
            Object object;
            if (this.iBuff.length() == 0) {
                object = Readline.readline(this.iPrompt);
                this.iBuff.append((String)(object == null ? DEFAULT_PROMPT : object) + this.iLineSeparator);
            }
            if (n2 > this.iBuff.length()) {
                n2 = this.iBuff.length();
            }
            if (n2 == 0) {
                return 0;
            }
            object = this.iBuff.substring(0, n2).toCharArray();
            System.arraycopy(object, 0, cArray, n, n2);
            this.iBuff.delete(0, n2);
            return n2;
        }
        catch (EOFException eOFException) {
            throw eOFException;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw unsupportedEncodingException;
        }
    }

    public void close() throws IOException {
        this.iBuff = null;
        this.iPrompt = null;
        if (this.iHistoryFile != null) {
            Readline.writeHistoryFile(this.iHistoryFile.getAbsolutePath());
            this.iHistoryFile = null;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new ReadlineReader("hmm ", new File("test"), ReadlineLibrary.GnuReadline));
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                System.out.println("got: " + string);
            }
        }
        finally {
            Object var4_3 = null;
            bufferedReader.close();
        }
    }

    public ReadlineReader(String string, ReadlineLibrary readlineLibrary) {
        this.setPrompt(string);
        Readline.load(readlineLibrary);
        Readline.initReadline("ReadlineReader");
        this.iLineSeparator = System.getProperty("line.separator", "\n");
    }

    public ReadlineReader(ReadlineLibrary readlineLibrary) {
        this(DEFAULT_PROMPT, readlineLibrary);
    }

    public ReadlineReader(File file, ReadlineLibrary readlineLibrary) throws IOException {
        this(DEFAULT_PROMPT, readlineLibrary);
        Readline.readHistoryFile(file.getAbsolutePath());
        this.iHistoryFile = file;
    }

    public ReadlineReader(String string, File file, ReadlineLibrary readlineLibrary) throws IOException {
        this(file, readlineLibrary);
        this.setPrompt(string);
    }
}

