/*
 * Decompiled with CFR 0.152.
 */
package helliker.id3;

import helliker.id3.BinaryParser;
import helliker.id3.ID3v2FormatException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class ID3v2ExtendedHeader {
    private final int EXT_HEAD_LOCATION;
    private final int MIN_SIZE;
    private final int CRC_SIZE;
    private final int[] MAX_TAG_FRAMES_TABLE = new int[]{128, 64, 32, 32};
    private final int[] MAX_TAG_SIZE_TABLE = new int[]{8000000, 1024000, 320000, 32000};
    private final int[] MAX_TEXT_SIZE_TABLE = new int[]{-1, 1024, 128, 30};
    private File mp3 = null;
    private int size;
    private int numFlagBytes;
    private boolean update;
    private boolean crced;
    private byte[] crc;
    private int maxFrames;
    private int maxTagSize;
    private boolean textEncode;
    private int maxTextSize;
    private boolean imageEncode;
    private int imageRestrict;

    private final void readExtendedHeader(RandomAccessFile randomAccessFile) throws FileNotFoundException, IOException, ID3v2FormatException {
        randomAccessFile.seek(10L);
        byte[] byArray = new byte[4];
        if (randomAccessFile.read(byArray) != byArray.length) {
            throw new IOException("Error reading extended header:size");
        }
        this.size = BinaryParser.convertToSynchsafeInt(byArray);
        if (this.size < 6) {
            throw new ID3v2FormatException("The extended header size data is less than the minimum required size.");
        }
        byArray = new byte[1];
        if (randomAccessFile.read(byArray) != byArray.length) {
            throw new IOException("Error reading extended header:numflags");
        }
        this.numFlagBytes = byArray[0];
        byArray = new byte[this.numFlagBytes + 1];
        if (randomAccessFile.read(byArray) != byArray.length) {
            throw new IOException("Error reading extended header:flags");
        }
        this.parseFlags(byArray);
    }

    private final void parseFlags(byte[] byArray) throws ID3v2FormatException {
        int n = 1;
        if (BinaryParser.bitSet(byArray[0], 6)) {
            this.update = true;
            ++n;
        }
        if (BinaryParser.bitSet(byArray[0], 5)) {
            this.crced = true;
            ++n;
            int n2 = 0;
            while (n2 < this.crc.length) {
                this.crc[n2] = byArray[n++];
                ++n2;
            }
        }
        if (BinaryParser.bitSet(byArray[0], 4)) {
            this.maxTagSize = BinaryParser.convertToDecimal(byArray[++n], 6, 7);
            this.textEncode = BinaryParser.bitSet(byArray[n], 5);
            this.maxTextSize = BinaryParser.convertToDecimal(byArray[n], 3, 4);
            this.imageEncode = BinaryParser.bitSet(byArray[n], 2);
            this.imageRestrict = BinaryParser.convertToDecimal(byArray[n], 0, 1);
            ++n;
        }
        if (n != this.numFlagBytes) {
            throw new ID3v2FormatException("The number of found flag bytes in the extended header is not equal to the number specified in the extended header.");
        }
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.size];
        int n = 0;
        System.arraycopy(BinaryParser.convertToSynchsafeBytes(this.size), 0, byArray, n, 4);
        n += 4;
        byArray[n++] = (byte)this.numFlagBytes;
        System.arraycopy(this.getFlagBytes(), 0, byArray, n, this.numFlagBytes);
        n += this.numFlagBytes;
        return byArray;
    }

    private final byte[] getFlagBytes() {
        byte[] byArray = new byte[this.numFlagBytes];
        int n = 1;
        byArray[0] = 0;
        if (this.update) {
            byArray[0] = BinaryParser.setBit(byArray[0], 7);
            byArray[n++] = 0;
        }
        if (this.crced) {
            byArray[0] = BinaryParser.setBit(byArray[0], 6);
            byArray[n++] = (byte)this.crc.length;
            System.arraycopy(this.crc, 0, byArray, n, this.crc.length);
            n += this.crc.length;
        }
        if (this.maxTagSize != -1 || this.textEncode || this.maxTextSize != -1 || this.imageEncode || this.imageRestrict != -1) {
            byArray[0] = BinaryParser.setBit(byArray[0], 5);
            byArray[n++] = 1;
            byte by = 0;
            if (this.maxTagSize != -1) {
                if (BinaryParser.bitSet((byte)this.maxTagSize, 0)) {
                    by = BinaryParser.setBit(by, 6);
                }
                if (BinaryParser.bitSet((byte)this.maxTagSize, 1)) {
                    by = BinaryParser.setBit(by, 7);
                }
            }
            if (this.textEncode) {
                by = BinaryParser.setBit(by, 5);
            }
            if (this.maxTextSize != -1) {
                if (BinaryParser.bitSet((byte)this.maxTextSize, 0)) {
                    by = BinaryParser.setBit(by, 3);
                }
                if (BinaryParser.bitSet((byte)this.maxTextSize, 1)) {
                    by = BinaryParser.setBit(by, 4);
                }
            }
            if (this.imageEncode) {
                by = BinaryParser.setBit(by, 2);
            }
            if (this.imageRestrict != -1) {
                if (BinaryParser.bitSet((byte)this.imageRestrict, 0)) {
                    by = BinaryParser.setBit(by, 0);
                }
                if (BinaryParser.bitSet((byte)this.imageRestrict, 1)) {
                    by = BinaryParser.setBit(by, 1);
                }
            }
            byArray[n++] = by;
        }
        return byArray;
    }

    public int getSize() {
        return this.size;
    }

    public int getNumFlagBytes() {
        return this.numFlagBytes;
    }

    public int getMaxFrames() {
        int n = -1;
        if (this.maxTagSize >= 0 && this.maxTagSize < this.MAX_TAG_FRAMES_TABLE.length) {
            n = this.MAX_TAG_FRAMES_TABLE[this.maxTagSize];
        }
        return n;
    }

    public int getMaxTagSize() {
        int n = -1;
        if (this.maxTagSize >= 0 && this.maxTagSize < this.MAX_TAG_SIZE_TABLE.length) {
            n = this.MAX_TAG_SIZE_TABLE[this.maxTagSize];
        }
        return n;
    }

    public boolean getTextEncode() {
        return this.textEncode;
    }

    public int getMaxTextSize() {
        int n = -1;
        if (this.maxTextSize >= 0 && this.maxTextSize < this.MAX_TEXT_SIZE_TABLE.length) {
            n = this.MAX_TEXT_SIZE_TABLE[this.maxTextSize];
        }
        return n;
    }

    public boolean getImageEncode() {
        return this.imageEncode;
    }

    public int getImageRestriction() {
        return this.imageRestrict;
    }

    public boolean getUpdate() {
        return this.update;
    }

    public boolean getCRCed() {
        return this.crced;
    }

    public byte[] getCRC() {
        return this.crc;
    }

    public String toString() {
        return "ExtendedSize:\t\t\t" + this.getSize() + " bytes" + "\nNumFlagBytes:\t\t\t" + this.getNumFlagBytes() + "\nUpdated:\t\t\t" + this.getUpdate() + "\nCRC:\t\t\t\t" + this.getCRCed() + "\nMaxFrames:\t\t\t" + this.getMaxFrames() + "\nMaxTagSize:\t\t\t" + this.getMaxTagSize() + "\nTextEncoded:\t\t\t" + this.getTextEncode() + "\nMaxTextSize:\t\t\t" + this.getMaxTextSize() + "\nImageEncoded:\t\t\t" + this.getImageEncode() + "\nImageRestriction:\t\t" + this.getImageRestriction();
    }

    public ID3v2ExtendedHeader(File file) throws FileNotFoundException, IOException, ID3v2FormatException {
        this.EXT_HEAD_LOCATION = 10;
        this.MIN_SIZE = 6;
        this.CRC_SIZE = 5;
        this.mp3 = file;
        this.size = 0;
        this.numFlagBytes = 0;
        this.update = false;
        this.crced = false;
        this.crc = new byte[5];
        this.maxFrames = -1;
        this.maxTagSize = -1;
        this.textEncode = false;
        this.maxTextSize = -1;
        this.imageEncode = false;
        this.imageRestrict = -1;
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(file, "r");
            this.readExtendedHeader(randomAccessFile);
        }
        finally {
            Object var4_3 = null;
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
        }
    }
}

