/*
 * dumppcf.c - read PCF font file and dumps font informations
 */

#include <stdio.h>
#include <stdlib.h>
#include "font.h"

FontPtr ReadPcfFont(FILE *fp) ;     /* in readpcf.c */

int main(int ac, char *av[])
{
    int     i  ;
    FILE    *filePtr ;
    FontPtr fontPtr  ;

    _wildcard(&ac, &av) ;

    for (i = 1 ; i < ac ; i++) {
        if ((filePtr = fopen(av[i], "rb")) == NULL) {
	    fprintf(stderr, "cannot open %s\n", av[i]) ;
	    continue ;
	}
	if ((fontPtr = ReadPcfFont(filePtr)) == NULL) {
	    fprintf(stderr, "failed to get PCF font in %s\n", av[i]) ;
	} else {
	    DumpFontInfo(fontPtr) ;
	    FreeFontInfo(fontPtr) ;
	}
        fclose(filePtr) ;
    }
    return 0 ;
}
