/* crear objetos de instalacin de XFolder
   Versin espaola (034) por Alfredo Fernndez Daz
   (W) (C) Ulrich Mller. Todos los derechos reservados.
*/

/* Este archivo es ejecutado nicamente por el script de instalacin de
XFolder. */

/* Cambie el siguiente cdigo por el correspondiente a su idioma. */
LanguageCode = "034";

/* Ttulos de los objetos que se crearn.
   Tradzcalos a su idioma. */

/* Ttulo de la carpeta de instalacin; escoja uno bastante largo
   o la instalacin podra fallar si ese objeto ya existe */

XFolderMain         = "Instalacin de XFolder";
/* Objeto "Introduccin" (SmartGuide) */
XFolderIntro        = "Introduccin";
OnlineReference     = "Manual de referencia en lnea de XFolder";
/* otros objetos */
WorkplaceShell      = "Workplace Shell";
OS2Kernel           = "OS/2 Kernel";
XShutdown           = "Concluir eXtendido...";

/* NO CAMBIE lo siguiente */
call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs

parse source dir;
parse var dir x1 x2 dir;
dir = filespec("D", dir)||filespec("P", dir);
pdir = left(dir, length(dir)-8);
idir = dir;
dir = pdir||"bin\";

OnlineReferenceFile = "xfldr"LanguageCode".inf";
XFolderIntroFile    = "xfldr"LanguageCode".sgs";

rc = SysCreateObject("WPFolder", XFolderMain, "<WP_DESKTOP>", "DEFAULTVIEW=ICON;SHOWALLINTREEVIEW=YES;ALWAYSSORT=NO;OBJECTID=<XFOLDER_MAIN>", "U");
if (SysSearchPath("PATH", "sguide.exe") \= "") then
    rc = SysCreateObject("WPProgram", XFolderIntro, "<XFOLDER_MAIN>", "EXENAME=sguide.exe;PARAMETERS="XFolderIntroFile";STARTUPDIR="dir";ICONFILE="idir"xfolder.ico;OBJECTID=<XFOLDER_INTRO>", "U");
rc = SysCreateObject("WPProgram", OnlineReference, "<XFOLDER_MAIN>", "EXENAME=view.exe;PARAMETERS="pdir||OnlineReferenceFile";OBJECTID=<XFOLDER_REF>", "U");
rc = SysCreateObject("WPProgram", XShutdown, "<XFOLDER_MAIN>", "EXENAME="dir"xshutdwn.exe;OBJECTID=<XFOLDER_XSHUTDOWN>", "U");

/* crear "OS/2 Kernel" */
rc = SysCreateObject("XFldSystem", OS2Kernel, "<WP_CONFIG>", "OBJECTID=<XFOLDER_KERNEL>;", "U");
if (\rc) then
    rc = SysCreateObject("XFldSystem", OS2Kernel, "<WP_DESKTOP>", "OBJECTID=<XFOLDER_KERNEL>;", "U");
rc = SysCreateObject("WPShadow", OS2Kernel, "<XFOLDER_MAIN>", "SHADOWID=<XFOLDER_KERNEL>;OBJECTID=<XFOLDER_KERNELSHADOW>;", "U");

/* crear "Workplace Shell" */
rc = SysCreateObject("XFldWPS", WorkplaceShell, "<WP_CONFIG>", "OBJECTID=<XFOLDER_WPS>", "U");
if (\rc) then
    rc = SysCreateObject("XFldWPS", WorkplaceShell, "<WP_DESKTOP>", "OBJECTID=<XFOLDER_WPS>", "U");
rc = SysCreateObject("WPShadow", WorkplaceShell, "<XFOLDER_MAIN>", "SHADOWID=<XFOLDER_WPS>;OBJECTID=<XFOLDER_WPSSHADOW>;", "U");

"@call "idir"crobj"LanguageCode
