#
# Makefile for the XFolder project w/out NLS support.
#
# For use with IBM NMAKE, which is part of IBM C-Set/2 and VisualAge C++.
# This file will probably not work with other MAKE utilities, such as
# GNU make or DMAKE.
#
# I admit that this is a monster makefile, but it's fairly intelligent.
#
#       Copyright (C) 1997-99 Ulrich Mller.
#       This file is part of the XFolder source package.
#       XFolder is free software; you can redistribute it and/or modify
#       it under the terms of the GNU General Public License as published
#       by the Free Software Foundation, in version 2 as it comes in the
#       "COPYING" file of the XFolder main distribution.
#       This program is distributed in the hope that it will be useful,
#       but WITHOUT ANY WARRANTY; without even the implied warranty of
#       MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#       GNU General Public License for more details.
#

# VARIABLES
# ---------
# Set up a few environment variables. This is done with
# "macros" (in NMAKE terminology), which are assumed when
# a "=" is encountered.
# You might want to change a few things in this section, notably
# the XFOLDERPATH variable.

# The following checks for the environment variable XFOLDERPATH,
# which should be the directory where XFolder is installed.
# The output files will be copied there to.
# This is set by MAKE.CMD, for example.
# If this var is not defined yet, we set a default value (which
# is probably wrong for your system).
!ifndef XFOLDERPATH
XFOLDERPATH=G:\develop\C\XFolder\running
!endif
XFRUNNING = $(XFOLDERPATH)

# The following is the directory for precompiled header files.
# This is a feature of VAC++ 3.0 to speed up compilation. If
# the PRECH variable is not defined, precompiled header files
# will not be used. I strongly recommend using a RAM disk for
# this (as for TEMP files in general).
# We create a _separate_ precompiled header file for each
# source file (in the $(PRECH) directory). This eats up a lot
# of disk space, but makes sure that the precompiled header
# does not get recreated for each source file. If you don't
# like this, get rid of it. That's slower though.
# PRECH = $(TEMP)

# Define the suffixes for files which NMAKE will work on.
# .SUFFIXES is a reserved NMAKE keyword ("pseudotarget") for
# defining file extensions that NMAKE will recognize in inference
# rules.

.SUFFIXES: .c .obj .dll .idl .h .ih .rc .res

# HELPERS contains the C helper sources. This is relative to
# /MAIN.
HELPERS = ..\helpers

# Some SOM variables. You won't have to change these.
SOMTEMP = $(TEMP)
!if [set SOMTMP=$(TEMP)] || \
    [set SMTMP=$(SOMTEMP)] || \
    [set SMEMIT=ih;h;c] || \
    [set SMADDSTAR=1] || \
    [set SMNOTC=1]
!endif

INCLUDE = $(INCLUDE);$(HELPERS);J:/develop/STL
LIB     = $(LIB);..\helpers

# Compiler macro. This is used for each .OBJ file to be created.
# If the XFRELEASE environment variable was set to anything, we
# won't use debugging compiler options. This variable is set by
# MAKE.CMD.

!ifdef XFRELEASE
CC      = icc /c /gd- /ge- /gi+ /gm+ /q+ /se /ss /o+ /ol- /Tn+ /W2
!else
CC      = icc /c /gd- /ge- /gi+ /gm+ /q+ /se /ss /o- /ol- /Ti+ /Tn+ /W2
!endif

# /oi- /w2 /fi+
#/ti+

# Some VisualAge C++ compiler options explained:
# /c:   compile only, no link (we'll call the linker explicitly)
# /fi+: precompile header files
# /gd-: link runtime statically
# /ge-: create DLL code
# /gi+: fast integer execution
# /Gl+: remove unreferenced functions (when comp.+link in 1 step)
# /gm+: multithread libraries
# /kc+: produce preprocessor warnings
# /o+:  optimization (inlining etc.)
# /oi-: no inlining (?)
# /ol+: use intermediate linker; do _not_ use with debug code
# /q+:  suppress icc logo
# /Re : don't use subsystem libraries (!= Rn)
# /se:  all language extensions
# /si+: allow use of precompiled header files
# /ss:  allow double slashes comments in C too
# /ti+: debug code
# /tdp: compile everything as C++, even if it has a .C suffix
# /Tn:  add source line numbers to object files (for mapfile)
# /Wcls: class problems
# /Wcnd: conditional exprs problems (= / == etc.)
# /Wcmp: possible unsigned comparison redundancies
# /Wcns: operations involving constants
# /Wcnv: conversions
# /Wcpy: copy constructor problems
# /Wgen: generic debugging msgs
# /Wobs: obsolete features
# /Word: unspecified evaluation order
# /Wpar: list not-referenced parameters (annoying)
# /Wppc: list possible preprocessor problems (.h dependencies)
# /Wpro: warn if funcs have not been prototyped
# /Wrea: mark code that cannot be reached
# /Wret: check consistency of return levels
# /Wuni: uninitialized variables
# /Wuse: unused variables
# /w2:   produce error and warning messages, but no infos


#
# Link macro. This is used for final linking.
#

!ifdef XFRELEASE
LINK =  ilink /noe /map /linenumbers /optfunc /exepack:2
!else
LINK =  ilink /noe /map /linenumbers /debug
!endif

# Some LINK386 cmd line options
# (Visual Age ILINK understands these too if /nofree is specified):
# /align:  executable pages align factor (in bytes)
# /noe:    no extended dictionary. Required for replacing _DLL_InitTerm.
# /noi:    no ignore case (necc. for C)
# /map:    list public symbols
# /nod:    no default library search (explicitly specify libs)
# /nol:    no logo (link386 startup)
# /packcode: group neighboring code segments
# /packdata: group neighboring data segments
# /de:     include debug code

#
# Resource compiler macro.
#

RC      = rc -p -x2

# The LIBS macro contains all the .LIB files, either from the compiler or
# others, which are needed for this project:
#   somtk       is the SOM toolkit lib
#   pmprintf    is for debugging (in /HELPERS)
# The other OS/2 libraries are used by default.
LIBS = somtk.lib $(HELPERS)\pmprintf.lib

# The OBJS macro contains all the .OBJ files which belong to this project.
OBJS = xfobj.obj xfldr.obj xfdesk.obj xfsys.obj xfdisk.obj xfdataf.obj xfpgmf.obj \
       apm.obj classlst.obj cnrsort.obj common.obj debug.obj except.obj menus.obj module.obj \
       notebook.obj statbars.obj xshutdwn.obj xthreads.obj xwps.obj

# The HLPOBJS macro contains all the .OBJ files from the helpers directory.
# These will be created in the /MAIN directory too.
HLPOBJS = animate.obj dosh.obj eas.obj gpih.obj linklist.obj procstat.obj \
          prfh.obj progbars.obj shapewin.obj stringh.obj threads.obj winh.obj wphandle.obj

#
# Now define inference rules for what to do with certain file
# types, based on their file extension.
# The syntax we need here is ".fromext.toext".
# So whenever NMAKE encounters a .toext file, it
# executes what we specify here.
#
# Special macros used here: $* is the current target w/out ext.
#

# 1) compile C files to .OBJ files, using the CC macro above.

.c.obj:
        @ echo Compiling $*.c:
!ifndef PRECH
        $(CC) -I$(INCLUDE) $*.c
!else
        $(CC) /fi"$(PRECH)\$*.pch" /si"$(PRECH)\$*.pch" -I$(INCLUDE) $*.c
!endif

# 2) same thing for the source files in /HELPERS; the .OBJ files
#    will be created in /MAIN too.
{$(HELPERS)}.c.obj:
        @ echo Compiling $*.c:
!ifndef PRECH
        $(CC) -I$(INCLUDE) $(HELPERS)\$*.c
!else
        $(CC) /fi"$(PRECH)\$*.pch" /si"$(PRECH)\$*.pch" -I$(INCLUDE) $(HELPERS)\$*.c
!endif

# 3) create/update .H, .IH, .C files when .IDL has changed
.idl.h:
        sc -p -v -r -maddstar -mnoint -S128000 -C128000  $*.idl
        sc -p -v -r -maddstar -mnoint -S128000 -C128000 -sc $*.idl
        sc -p -v -r -maddstar -mnoint -S128000 -C128000 -s def $*.idl
        strrpl $*.ih "#pragma checkout(suspend)" " "
        strrpl $*.ih "#pragma checkout(resume)" " "

.idl.ih:
        sc -p -v -r -maddstar -mnoint -S128000 -C128000  $*.idl
        sc -p -v -r -maddstar -mnoint -S128000 -C128000 -sc $*.idl
        sc -p -v -r -maddstar -mnoint -S128000 -C128000 -s def $*.idl
        strrpl $*.ih "#pragma checkout(suspend)" " "
        strrpl $*.ih "#pragma checkout(resume)" " "

# The main target files are sound.dll and xfldr.dll in the XFolder
# installation directory (see the rules at the very bottom). These
# are dependent of the DLLs in /MAIN, so that everything always
# gets updated properly.
all: $(XFRUNNING)\bin\sound.dll $(XFRUNNING)\bin\xfldr.dll
# all: doc.exe

#
# Now define rules for invoking the SOM compiler (sc.exe),
# using the .idl.h rule defined above. E.g., xfobj.h/.ih/.c will be
# updated by the SOM compiler when xfobj.idl has changed.
#

# XFldObject class
xfobj.h:   xfobj.idl
xfobj.ih:  xfobj.idl

# XFolder classes
xfldr.h:   xfldr.idl
xfldr.ih:  xfldr.idl

# XFldDisk class
xfdisk.h:   xfdisk.idl

# XFldDesktop class
xfdesk.h:   xfdesk.idl

# XFldSystem/XFldWPS classes
xfsys.h:   xfsys.idl

# XFldDataFile class
xfdataf.h:   xfdataf.idl

# XFldProgramFile class (new with V0.84)
xfpgmf.h:   xfpgmf.idl

#
# Now define inference rules for all our .OBJ files by telling NMAKE
# which .OBJ file depends on what. For each .OBJ we define what files
# will enforce a recompilation when they've been changed.
#

# The INFALL macro is used with inference rules to determine which
# include file will cause all files to be rebuilt.
INFALL = $(HELPERS)\dosh.h

# The INCOMMON macro is used with inference rules for files which
# include common.h. Since common.h includes other headers, we're
# dependent of them too.
INFCOMMON = common.h $(HELPERS)\pmprintf.h

# Special macros used here: $* is the current target w/out ext.

# Helper .OBJ files from /HELPERS. The object files are created in the
# /MAIN directory too.

animate.obj:   $(HELPERS)\$*.c $(HELPERS)\$*.h \
               $(HELPERS)\winh.h $(HELPERS)\gpih.h \
               $(INFALL)

dosh.obj:      $(HELPERS)\$*.c $(HELPERS)\$*.h \
               $(INFALL)

eas.obj:       $(HELPERS)\$*.c $(HELPERS)\$*.h \
               $(INFALL)

gpih.obj:      $(HELPERS)\$*.c $(HELPERS)\$*.h \
               $(HELPERS)\winh.h \
               $(INFALL)

linklist.obj:  $(HELPERS)\$*.c $(HELPERS)\$*.h \
               $(INFALL)

progbars.obj:  $(HELPERS)\$*.c $(HELPERS)\$*.h \
               $(HELPERS)\gpih.h \
               $(INFALL)

procstat.obj:  $(HELPERS)\$*.c $(HELPERS)\$*.h \
               $(INFALL)

shapewin.obj:  $(HELPERS)\$*.c $(HELPERS)\$*.h \
               $(HELPERS)\gpih.h \
               $(INFALL)

stringh.obj:   $(HELPERS)\$*.c $(HELPERS)\$*.h \
               $(INFALL)

threads.obj:   $(HELPERS)\$*.c $(HELPERS)\$*.h \
               $(INFALL)

winh.obj:      $(HELPERS)\$*.c $(HELPERS)\$*.h \
               $(HELPERS)\gpih.h $(HELPERS)\winh.h \
               $(INFALL)

prfh.obj:      $(HELPERS)\$*.c $(HELPERS)\$*.h \
               $(INFALL)

wphandle.obj:  $(HELPERS)\$*.c $(HELPERS)\$*.h \
               $(INFALL)

# XFolder "library" .OBJ files used by several classes.

apm.obj        :      $*.c $*.h \
                      $(INFALL)

classlst.obj        : $*.c $*.h \
                      $(HELPERS)\winh.h $(HELPERS)\linklist.h \
                      dlgids.h cnrsort.h \
                      $(INFALL) $(INFCOMMON)

common.obj        :   $*.c $*.h \
                      $(HELPERS)\winh.h $(HELPERS)\linklist.h $(HELPERS)\undoc.h \
                      dlgids.h module.h sound.h except.h statbars.h xshutdwn.h xwps.h \
                      xfldr.h \
                      $(INFALL) $(INFCOMMON)

cnrsort.obj        :  $*.c $*.h \
                      $(INFALL)

debug.obj:            $*.c $*.h \
                      $(INFALL)

except.obj:           $*.c $*.h \
                      dlgids.h xthreads.h debug.h \
                      xfldr.h \
                      $(INFALL)

menus.obj        :    $*.c $*.h \
                      $(HELPERS)\winh.h $(HELPERS)\linklist.h $(HELPERS)\stringh.h $(HELPERS)\undoc.h \
                      dlgids.h except.h module.h sound.h xshutdwn.h xthreads.h xwps.h \
                      xfldr.ih xfdisk.h \
                      $(INFALL) $(INFCOMMON)

module.obj        :   $*.c $*.h \
                      $(INFALL)

notebook.obj      :   $*.c $*.h \
                      $(HELPERS)\winh.h $(HELPERS)\linklist.h \
                      dlgids.h except.h \
                      xfdesk.h \
                      $(INFALL) $(INFCOMMON)

statbars.obj        : $*.c $*.h \
                      $(HELPERS)\winh.h $(HELPERS)\stringh.h \
                      dlgids.h except.h xwps.h \
                      xfldr.h xfobj.h xfdisk.h \
                      $(INFALL) $(INFCOMMON)

xshutdwn.obj:         $*.c $*.h \
                      $(HELPERS)\winh.h $(HELPERS)\prfh.h $(HELPERS)\animate.h $(HELPERS)\linklist.h $(HELPERS)\procstat.h $(HELPERS)\progbars.h \
                      dlgids.h apm.h except.h menus.h module.h notebook.h sound.h xthreads.h xwps.h \
                      xfldr.h \
                      $(INFALL)

xthreads.obj:         $*.c $*.h \
                      $(HELPERS)\winh.h $(HELPERS)\prfh.h $(HELPERS)\animate.h $(HELPERS)\eas.h $(HELPERS)\linklist.h $(HELPERS)\shapewin.h \
                      xfldr.h xfdesk.h \
                      dlgids.h apm.h except.h module.h sound.h xthreads.h xwps.h \
                      $(INFALL) $(INFCOMMON)

xwps.obj:             $*.c $*.h \
                      $(HELPERS)\winh.h \
                      except.h \
                      $(INFALL) $(INFCOMMON)

# Now follow the .OBJs for the SOM/WPS classes. Each class needs to be
# recompiled when its SOM header files change (due to SOM recompilation)
# or when the "library" header files have changed.

xfdataf.obj        :  $*.c $*.ih $*.h \
                      $(HELPERS)\winh.h \
                      dlgids.h menus.h \
                      $(INFALL) $(INFCOMMON)

xfdesk.obj        :   $*.c $*.ih $*.h \
                      $(HELPERS)\winh.h $(HELPERS)\animate.h \
                      dlgids.h apm.h notebook.h sound.h xshutdwn.h xthreads.h \
                      $(INFALL) $(INFCOMMON)

xfdisk.obj        :   $*.c $*.ih $*.h \
                      $(HELPERS)\undoc.h \
                      xfldr.h \
                      menus.h statbars.h xwps.h \
                      $(INFALL) $(INFCOMMON)

xfldr.obj        :    $*.c $*.ih $*.h \
                      $(HELPERS)\winh.h $(HELPERS)\gpih.h $(HELPERS)\eas.h $(HELPERS)\linklist.h $(HELPERS)\wphandle.h \
                      dlgids.h cnrsort.h except.h menus.h module.h notebook.h sound.h statbars.h xthreads.h xwps.h \
                      xfobj.h xfdesk.h xfdisk.h \
                      $(INFALL) $(INFCOMMON)

xfobj.obj        :    $*.c $*.ih $*.h \
                      $(HELPERS)\winh.h $(HELPERS)\linklist.h $(HELPERS)\procstat.h $(HELPERS)\progbars.h $(HELPERS)\stringh.h $(HELPERS)\undoc.h $(HELPERS)\wphandle.h \
                      dlgids.h classlst.h cnrsort.h xshutdwn.h xthreads.h \
                      xfldr.h \
                      $(INFALL) $(INFCOMMON)

xfpgmf.obj        :   $*.c $*.ih $*.h \
                      $(INFALL) $(INFCOMMON)

xfsys.obj        :    $*.c $*.ih $*.h \
                      $(HELPERS)\winh.h $(HELPERS)\animate.h $(HELPERS)\linklist.h $(HELPERS)\procstat.h $(HELPERS)\stringh.h $(HELPERS)\undoc.h \
                      dlgids.h classlst.h cnrsort.h module.h notebook.h statbars.h xthreads.h \
                      xfldr.h xfdesk.h xfobj.h \
                      $(INFALL) $(INFCOMMON)

# XFolder language-in dependent resource file
xfldr.res: xfldr.rc dlgids.h *.ico
         $(RC) -r xfldr.rc $*.res

#
# Finally, define rules for linking XFLDR.DLL.
# This uses the $OBJS and $HLPOBJS macros defined at the top.
# Note that the linker is invoked if any of the OBJS files
# or any file in the /HELPERS directory have changed.
#

# If the file in the installation directory is older than the one
# in the source directory, update it.
# This also sets the dependency on xfldr.dll at the bottom.
$(XFRUNNING)\bin\xfldr.dll: xfldr.dll
        unlock $(XFRUNNING)\bin\xfldr.dll
        cmd.exe /c copy xfldr.dll $(XFRUNNING)\bin
        cmd.exe /c copy xfldr.sym $(XFRUNNING)\bin

xfldr.dll: xfjoint.def $(OBJS) $(HLPOBJS) xfldr.res xfldr.mak
        $(LINK) /OUT:xfldr.dll xfjoint.def $(LIBS) $(OBJS) $(HLPOBJS)
        $(RC) xfldr.res xfldr.dll
        mapsym /n $*.map

# Here comes SOUND.DLL which is new with V0.82.
# For compiling, we use an additional compiler option because
# we're using the subsystem libraries (/rn).

sound.obj         :  $*.c $*.h $(INFALL)
!ifndef PRECH
    $(CC) /rn -I$(INCLUDE) $*.c
!else
    $(CC) /rn /fi"$(PRECH)\$*.pch" /si"$(PRECH)\$*.pch" -I$(INCLUDE) $*.c
!endif

$(XFRUNNING)\bin\sound.dll: sound.dll
        unlock $(XFRUNNING)\bin\sound.dll
        cmd.exe /c copy sound.dll $(XFRUNNING)\bin
        cmd.exe /c copy sound.sym $(XFRUNNING)\bin

sound.dll: sound.def sound.obj xfldr.mak
         $(LINK) /OUT:sound.dll sound.obj sound.def mmpm2.lib $(HELPERS)\pmprintf.lib
        mapsym /n $*.map




doc.exe: doc.cpp
        icc /c /tdp doc.cpp
        ilink doc.obj /pmtype:vio

