
/*
 * stringh.h:
 *      header file for stringh.c. See notes there.
 *
 *      Copyright (C) 1997-99 Ulrich Mller.
 *      This file is part of the XFolder source package.
 *      XFolder is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published
 *      by the Free Software Foundation, in version 2 as it comes in the
 *      "COPYING" file of the XFolder main distribution.
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 */

#if __cplusplus
extern "C" {
#endif

#ifndef STRINGH_HEADER_INCLUDED
    #define STRINGH_HEADER_INCLUDED

    PSZ strhReplace(PSZ str, PSZ oldStr, PSZ newStr);

    PSZ strhInsert(PSZ out_str, PSZ in_str, PSZ to_insert, int place);

    PSZ strhistr(PSZ string1, PSZ string2);

    PSZ strhThousandsULong(PSZ pszTarget, ULONG ul, CHAR cThousands);

    PSZ strhThousandsDouble(PSZ pszTarget, double dbl, CHAR cThousands);

    VOID strhFileDate(PSZ pszBuf, FDATE* pfDate, ULONG ulDateFormat, CHAR cDateSep);

    VOID strhFileTime(PSZ pszBuf, FTIME* pfTime, ULONG ulTimeFormat, CHAR cTimeSep);

    PSZ strhFindEOL(PSZ pszSearchIn, ULONG *pulOffset);

    PSZ strhFindKey(PSZ pszSearchIn,
                   PSZ pszKey,
                   BOOL *pfIsAllUpperCase);

    PSZ strhGetParameter(PSZ pszSearchIn, PSZ pszKey, PSZ pszCopyTo, ULONG cbCopyTo);

    PSZ strhSetParameter(PSZ pszSearchIn,
                        PSZ pszKey,
                        PSZ pszNewParam,
                        BOOL fRespectCase);

    BOOL strhDeleteLine(PSZ pszSearchIn, PSZ pszKey);

    BOOL strhBeautifyTitle(PSZ psz);

#endif

#if __cplusplus
}
#endif

