.*
.* Panel definition : Other Calendars
.*
:h2 id=743 res=743   x=0% y=0% width=100% height=100% group=2.Other Calendars
:i2 refid=740.Other Calendars
:p.
Calendars are usually based on astronomical events, and the two most important astronomical objects are the Sun and the Moon. Main Calendar systems are&colon.
:dl compact tsize=15.
:dt.:hp2.Solar:ehp2.
:dd.based on the motion of the Earth around the Sun, while the months have no connection with the motion of the Moon.
:dt.:hp2.Lunar:ehp2.
:dd.based on the motion of the Moon, while the year has no connection with the motion of the Earth around the Sun.
:dt.:hp2.Lunisolar:ehp2.
:dd.years are linked to the motion of the Earth around the Sun, and its months are linked to the motion of the Moon.
:edl.
:p.
:warning.
&greename. assumes that days run from midnight to midnight.
:ul compact.
:li.When days run from sunrise to sunrise (Coptic, Ethiopian, Indian), substract one day in calendar if time is before sunrise.
:li.When days run from sunset to sunset (Hebrew, Islamic, Bahai), add one day in calendar if time is after sunset.
:eul.
:ewarning.
:p.
:hp7.Gregorian:ehp7. (solar)
:i2 refid=740.Gregorian Calendar
:p.
The Gregorian Calendar is the one commonly used today.
It was proposed by Aloysius Lilius, a physician from Naples, and decreed by Pope Gregory XIII in a papal bull in February 1582, to correct for errors in the older Julian Calendar.
Year has 12 months of varying days to bring the calendar to 365 days (366 days in leap year) and a seven-day week that cycles independently of the months and years.
:p.
In most settings, including religious calendars, Sunday is the first day of the week.
International Standard ISO 8601 and some business settings will show Monday as the first day of the week. Days run from midnight to midnight.
:p.
:hp5.New year:ehp5.&colon. The new year falls on January 1.
:p.
:hp5.Leap year rule:ehp5.&colon. Every year divisible by 4 is a leap year, every year divisible by 100 is not a leap year, every year divisible by 400 is a leap year.
:p.
:hp2.Names:ehp2. (months and weekdays are named differently in different languages)
:dl compact tsize=15.
:dt.Months&colon.
:dd.January, February, March, April, May, June, July, August, September, October, November, December
:dt.Weekdays&colon.
:dd.Sunday, Monday, Tuesday, Wednesday, Thursday, Friday, Saturday
:edl.
:p.
:p.
:hp7.Day numbers:ehp7.
:p.
See :link reftype=hd res=745.Universal date &amp. time:elink.
:p.
:p.
:hp7.Coptic:ehp7. (solar)
:i2 refid=740.Coptic Calendar
:p.
The Coptic (Egyptian, Era of Martyrs) calendar is based on the solar Egyptian Calendar, oldest in history.
Calendar begins on August 29, 284 CE (Julian), when Diocletian became Roman emperor. Anti-Christian laws were published, which led to brutal repressions against the Christians.
After the massive killing that was so traumatic, the Egyptians began a new calendar called "Era of Martyrs".
Year has 13 months&colon. the first 12 months have 30 days and the last month, al-Nasi, has 5 days (6 days in leap year).
A seven-day week cycles independently of the months and years. Days run from sunrise to sunrise.
:p.
:hp5.New year:ehp5.&colon. The new year falls on Tut 1 (September 21/22 in Gregorian Calendar).
:p.
:hp5.Leap year rule:ehp5.&colon. Leap years by the Coptic Calendar are those that end in a Gregorian Calendar year preceding a Gregorian Calendar leap year.
:p.
:hp2.Names:ehp2.
:dl compact tsize=15.
:dt.Months&colon.
:dd.Tut, Babah, Hatur, Kiyahk, Tubah, Amshir, Baramhat, Barmundah, Bashans, Baunah, Abib, Misra, al-Nasi
:edl.
:p.
:p.
:hp7.Ethiopian:ehp7. (solar)
:i2 refid=740.Ethiopian Calendar
:p.
The Ethiopian Calendar is similar to the Coptic Calendar. Month names are different and it is 7 or 8 years behind the Gregorian Calendar. Calendar begins on August 29, 7 CE (Julian).
This discrepancy results from differences between the Ethiopian Orthodox Church and the Roman Catholic Church as to the date of the creation of the world.
Year has 13 months&colon. the first 12 months have 30 days and the last month, Paguem, has 5 days (6 days in leap year).
A seven-day week cycles independently of the months and years. Days run from sunrise to sunrise.
:p.
:hp5.New year:ehp5.&colon. The new year falls on Maskaram 1 (September 21/22 in Gregorian Calendar).
:p.
:hp5.Leap year rule:ehp5.&colon. Leap years by the Ethiopian Calendar are those that end in a Gregorian Calendar year preceding a Gregorian Calendar leap year.
:p.
:hp2.Names:ehp2.
:dl compact tsize=15.
:dt.Months&colon.
:dd.Maskaram, Teqemt, Khedar, Takhsas, Ter, Yakatit, Magabit, Miyazya, Genbot, Sane, Hamle, Nahas, Paguem
:dt.Days&colon.
:dd.Ehud, Segno, Maksegno, Rebu, Hamus, Arb, Kidamie
:edl.
:p.
:p.
:hp7.Hebrew:ehp7. (lunisolar)
:i2 refid=740.Hebrew Calendar
:p.
The Hebrew Calendar is used for religious purposes, and it is the official calendar of Israel. Calendar begins in year 3,760 BCE.
It is a combined solar/lunar calendar&colon. it strives to have its years coincide with the tropical year and its months coincide with the synodic months.
An ordinary (non-leap) year has 12 months and 353, 354, or 355 days. A leap year has 13 months (an intercalary month, veAdar, is added) and 383, 384, or 385 days.
The three lengths of the years are named&colon. "deficient", "regular", and "complete".
A seven-day week cycles independently of the months and years.
Every month starts (approximately) on the day of a new moon. Days run from sunset to sunset.
:p.
:hp5.New year:ehp5.&colon. The new year (Rosh haShana) falls on Tishri 1 (September/October in Gregorian Calendar).
:p.
:hp5.Leap year rule:ehp5.&colon. An intercalary month, veAdar, is added on the year 3, 6, 8, 11, 14, 17 and 19 of a 19-year cycle.
:p.
:hp2.Names:ehp2.
:dl compact tsize=15.
:dt.Months&colon.
:dd.Tishri, Marheshvan, Kislev, Teveth, Shevat, Adar, :hp9.veAdar:ehp9., Nisan, Iyyar, Sivan, Tammuz, Av, Elul
:dt.Weekdays&colon.
:dd.Rishon, Sheni, Shlishi, Revi'i, Hamishi, Shishi, Shabbat
:edl.
:p.
:p.
:hp7.Indian civil:ehp7. (solar)
:i2 refid=740.Indian Calendar
:p.
The Indian civil (Hindu, Saka) Calendar is established in 1957 CE by the Calendar Reform Committee.
Calendar counts its years from the vernal equinox of 79 CE, and refers to itself as the Saka Era.
Year has 12 months of varying days to bring the calendar to 365 days (366 days in leap year) and a seven-day week that cycles independently of the months and years.
Days run from sunrise to sunrise.
:p.
:hp5.New year:ehp5.&colon. The new year falls on Caitra 1 (March 21/22 in Gregorian Calendar).
:p.
:hp5.Leap year rule:ehp5.&colon. Leap years conform to leap years of the Gregorian Calendar.
:p.
:hp2.Names:ehp2.
:dl compact tsize=15.
:dt.Months&colon.
:dd.Caitra, Vaisakha, Jyaistha, Asadha, Sravana, Bhadra, Asvina, Kartika, Agrahayana, Pausa, Magha, Phalguna
:dt.Weekdays&colon.
:dd.Ravivara, Somavara, Mangalavara, Budhavara, Brahaspativara, Sukravara, Sanivara
:edl.
:p.
:p.
:hp7.Islamic:ehp7. (lunar)
:i2 refid=740.Islamic Calendar
:p.
The Islamic (Hijri) Calendar is a purely lunar calendar. Years are counted since the Hijra (Mohammed's flight to Medina), July 16, 622.
It is the official calendar in countries around the Gulf, especially Saudi Arabia.
Other Muslim countries use the Gregorian Calendar for civil purposes and only turn to the Islamic Calendar for religious purposes.
Year has 12 months that are based on the motion of the moon, and because 12 synodic months is only 354.36 days,
the Islamic Calendar is consistently shorter than a tropical year.
A seven-day week cycles independently of the months and years. Days run from sunset to sunset.
:p.
:hp5.New year:ehp5.&colon. The new year falls on Muharram 1 (can be any date in Gregorian Calendar).
:p.
Each month starts when the lunar crescent is first seen after a new moon.
The visibility of the crescent is difficult to predict, because it depends on weather, the optical properties of the atmosphere, and the location of the observer.
Also, some Muslims depend on a local sighting of the moon and others depend on a sighting by authorities somewhere in the Muslim world.
Both are valid practices, but they may lead to different starting days for the months. So, it is not possible to print a reliable Islamic Calendar in advance.
:p.
Calendars printed for planning purposes are based on estimates of the visibility of the lunar crescent, and the actual month may start a day earlier or later than predicted in the printed calendar.
&greename. uses a crude system in which all odd numbered months have 30 days and all even numbered months have 29 days with an extra day added to the last month in 'leap years' (a concept otherwise unknown in the calendar).
Year 2, 5, 7, 10, 13, 16, 18, 21, 24, 26 29 of a 30-year cycle are leap years.
This calendar gives an average month length of 29.53056 days, which is quite close to the synodic month of 29.53059 days.
:p.
:hp2.Names:ehp2.
:dl compact tsize=15.
:dt.Months&colon.
:dd.Muharram, Safar, Rabi, Al-Awal, Rabi Al-Thani, Jumad Al-Ula, Jumad Al-Tani, Rajab, Shaban, Ramadhan, Shawwal, Zul-Qida, Zul-Hijja
:dt.Weekdays&colon.
:dd.al-'ahad, al-'ithnayn, ath-thalatha', al-'arb'a', al-khamis, al-jum'a, as-sabt
:edl.
:p.
:p.
:hp7.Julian:ehp7. (solar)
:i2 refid=740.Julian Calendar
:p.
The Julian Calendar was introduced by Julius Caesar in 45 BCE. It was in common use until the 1500s, when countries started changing to the Gregorian Calendar.
However, some countries (for example, Greece and Russia) used it into this century, and some Orthodox churches still use it.
Year has 12 months of varying days to bring the calendar to 365 days (366 days in leap year) and a seven-day week that cycles independently of the months and years.
Month and day names are same as in Gregorian Calendar.
:p.
:hp5.New year:ehp5.&colon. The new year falls on January 1 (January 13 in Gregorian Calendar).
:p.
:hp5.Leap year rule:ehp5.&colon. Every year divisible by 4 is a leap year.
:p.
:p.
:hp7.Persian:ehp7. (solar)
:i2 refid=740.Persian Calendar
:p.
The Persian (Iranian, Jalali, Sun's Hijri, Shamsi) Calendar is official in Iran and surrounding areas,
and was named after Jalaal-ol-Din Malek-shaah-e Saljuqi (by Omar Khayyam, who reworked the calendar). The start of this calendar is March 19, 622 (Julian).
Year has 12 months of varying days to bring the calendar to 365 days (366 days in leap year) and a seven-day week that cycles independently of the months and years.
:p.
:hp5.New year:ehp5.&colon. The new year (Farvardin 1) comes at the point when the sun appears to cross the equator from the southern to the northern hemisphere, as viewed from the center of the earth.
If this is before midday in Tehran, Iran, the new year is that day; otherwise it is the following day. (March 21/22 in Gregorian Calendar).
:p.
:hp5.Leap year rule:ehp5.&colon. Years are grouped into cycles which begin with four normal years after which every fourth subsequent year in the cycle is a leap year.
Cycles are grouped into grand cycles of either 128 years (composed of cycles of 29, 33, 33, and 33 years) or 132 years, containing cycles of of 29, 33, 33, and 37 years.
A great grand cycle is composed of 21 consecutive 128 year grand cycles and a final 132 grand cycle, for a total of 2820 years.
:p.
Each 2820 year great grand cycle contains 2137 normal years of 365 days and 683 leap years of 366 days, with the average year length over the great grand cycle of 365.24219852.
So close is this to the actual solar tropical year of 365.24219878 days that the Persian Calendar accumulates an error of one day only every 3.8 million years.
:p.
:hp2.Names:ehp2.
:dl compact tsize=15.
:dt.Months&colon.
:dd.Farvardin, Ordibehesht, Khordad, Tir, Mordad, Shahrevar, Mihr, Aban, Azar, Day, Bahman, Esphand
:dt.Weekdays&colon.
:dd.Yekshanbeh, Doshanbeh, Seshhanbeh, Chaharshanbeh, Panjshanbeh, Jomeh, Shanbeh
:edl.
:p.
:p.
:hp7.Bahai:ehp7. (solar)
:i2 refid=740.Bahai Calendar
:p.
The Bahai Calendar is based on the number 19. The Bahai Era began in 1844 CE, the year of the Bab's prophecy.
Year has 19 months of 19 days each, with Ayyam-i-Ha, a period of 4 days (5 days in leap year), to bring the calendar to 365 days.
Each cycle of 19 years is called a Vahid. 19 cycles of the Vahid constitute a period called a Kull-i-Shay.
:p.
Days run from sunset to sunset, and each day of the month is given a name in the same sequence as the names of the months.
Additionally, the Bahai Calendar follows a seven-day week, so each day has two names, one for its sequence in the month and the other for its sequence in the 7-day week.
:p.
:hp5.New year:ehp5.&colon. The beginning of the year corresponds to March 21.
(Some sources indicate that the year begins on the vernal equinox rather than correlating exactly to the date of March 21.)
:p.
:hp5.Leap year rule:ehp5.&colon. Identical to Gregorian Calendar.
:p.
:hp2.Names:ehp2.
:dl compact tsize=15.
:dt.Years&colon.
:dd.Alif, Ba', Ab, Dal, Bab, Vav, Abad, Jad, Baha, Hubb, Bahhaj, Javab, Ahad, Vahhab, Vidad, Badi', Bahi, Abha, Vahid
:dt.Months&colon.
:dd.Baha, Jalal, Jamal, 'Azamat, Nur, Rahmat, Kalimat, Kamal, Asma', 'Izzat, Mashiyyat, 'Ilm, Qudrat, Qawl, Masail, Sharaf, Sultan, Mulk, :hp9.Ayyam-i-Ha:ehp9., 'Ala
:dt.Days&colon.
:dd.Baha, Jalal, Jamal, 'Azamat, Nur, Rahmat, Kalimat, Kamal, Asma', 'Izzat, Mashiyyat, 'Ilm, Qudrat, Qawl, Masail, Sharaf, Sultan, Mulk, 'Ala
:dt.Weekdays&colon.
:dd.Jamal, Kamal, Fidal, Idal, Istijlal, Istiqlal, Jalal
:edl.
:p.
:p.
:hp7.French Republic:ehp7. (solar)
:i2 refid=740.French Republic Calendar
:p.
During the French Revolution, the Republican Calendar was adopted to rid the calendar of religious connections.
The calendar began on September 22, 1792, the day the republic was proclaimed.
Year in Republican Calendar had 12 months of 30 days. Each month consisted of three 10-day weeks, the last day of each week being a day of rest.
Five celebratory days, called Sans-culottides, are appended at the end of the year. In leap year an additional day is appended.
:p.
:hp5.New year:ehp5.&colon. The new year falls on Vendemiaire 1 (September 22/23 in Gregorian Calendar).
:p.
:hp5.Leap year rule:ehp5.&colon.
Originally, the calendar proposed to use a leap system to force 1 Vendemiaire to fall on the autumnal equinox. This rule is used by &greename..
When this was found to be impractical, it was decided that after the 20th year (but the Republican Calendar didn't survive in common usage for 20 years)
the leap system would be similar to the Gregorian Calendar&colon.
every year divisible by 4 is a leap year, every year divisible by 100 is not a leap year, every year divisible by 400 is a leap year, every year divisible by 4000 is not a leap year.
:p.
:hp2.Names:ehp2.
:dl compact tsize=15.
:dt.Months&colon.
:dd.Vendemiaire, Brumaire, Frimaire, Nivose, Pluviose, Ventose, Germinal, Floreal, Prairial, Messidor, Thermidor, Fructidor, :hp9.Sans-culottides:ehp9.
:dt.Days&colon.
:dd.du Primidi, du Duodi, du Tridi, du Quartidi, du Quintidi, du Sextidi, du Septidi, du Octidi, du Nonidi, du Decadi
:dt.Celebratory&colon.
:dd.de la Vertu, du Genie, du Travail, de l'Opinion, des Recompenses, :hp9.de la Revolution:ehp9.
:edl.
:p.
:p.
:hp7.Mayan:ehp7.
:i2 refid=740.Mayan Calendar
:p.
The Maya had three methods of dating&colon. Long Count, Tzolkin (divine calendar), and Haab (civil calendar).
:parml tsize=5.
:pt.:hp2.Long Count:ehp2.
:pd.
The Long Count is a cycle of 2,880,000 days (about 7,885 years), at the end of which the Maya believed the universe is destroyed and re-created.
It is similar to the Julian Day numbers. The units of the Long Count are&colon.
:dl compact tsize=10.
:dt.kin
:dd.1 day
:dt.uinal
:dd.20 kin = 20 days
:dt.tun
:dd.18 uinal = 360 days (approx. 1 year)
:dt.katun
:dd.20 tun = 7,200 days (approx. 20 years)
:dt.baktun
:dd.20 katun = 144,000 days (approx. 394 years)
:edl.
:p.
The Maya also had units for time periods greater than a full Long Count&colon.
:dl compact tsize=10.
:dt.pictun
:dd.20 baktun = 2,880,000 days (approx. 7885 years)
:dt.calabtun
:dd.20 pictun = 57,600,000 days (approx. 158,000 years)
:dt.kinchiltun
:dd.20 calabtun = 1,152,000,000 days (approx. 3 million years)
:dt.alautun
:dd.20 kinchiltun = 23,040,000,000 days (approx. 63 million years - probably the longest named period in any calendar)
:edl.
:pt.:hp2.Tzolkin:ehp2.
:pd.
The Tzolkin Calendar was the Mayan religious calendar ("Tzolkin" means "Divine"),
and used two independent cycles which advanced simultaneously - a thirteen-day count and a twenty-name cycle.
The count and names advance independently. This results in 260 distinct dates.
At the end of its cycle, the Tzolkin Calendar resets&colon. there is no system (counting years) for distinguishing one Tzolkin Calendar cycle from another.
:pt.:hp2.Haab:ehp2.
:pd.
The Haab was the Mayan civil calendar and has 18 twenty-day months, but years are not designated.
The days of the Haab months are numbered from zero to nineteen (to indicate the number of days elapsed in each month).
To bring the calendar to 365 days, the Maya appended a month called Wayeb, five "days without souls" of which were considered unnamed and unlucky.
The Maya were aware of the discrepancy between their 365-day calendar and the actual solar year,
but they did not account for it in their system. Therefore, the Maya calendar drifted slowly backward through the seasons.
:eparml.
:p.
The 260-day Tzolkin Calendar and 365-day Haab Calendar ran concurrently, forming a long cycle of 18,980 days, which was called a Calendar Round.
Dates in the Calendar Round are given by indicating first the Tzolkin date and then the Haab date.
:p.
The Mayan Long Count 0.0.0.0.0 correlated to the Tzolkin Calendar date 4 Ahaw and the Haab date 8 Cumku.
The problem is what was the equivalent date for the beginning of Long Count&colon.
Belief in the 584,283 correlation is based on the Calendar Round dates in use both during the conquest and maintained by some of the highland Maya today.
The 584,285 correlation is based on the relationship between astronomical events recorded by the classic Maya and the times these events were known to have ocurred.
The correct number is still a matter of debate, but &greename. uses 584,285 correlation.

:p.
:hp2.Names:ehp2.
:dl compact tsize=15.
:dt.Tzolkin cycles&colon.
:dd.Ahau, Imix, Ik, Akbal, Kan, Chicchan, Cimi, Manik, Lamat, Muluc, Oc, Chuen, Eb, Ben, Ix, Men, Cib, Caban, Etznab, Caunac
:dt.Haab months&colon.
:dd.Pop, Uo, Zip, Zotz, Tzec, Xul, Yaxkin, Mol, Chen, Yax, Zac, Ceh, Mac, Kankin, Muan, Pax, Kayab, Cumku, Wayeb
:edl.
:p.
.*
