/*****************************************************************************
	Paint Windows Metafile with OS/2 functions
	 2007 Peter Koller, Maison Anglais. All Rights Reserved
*****************************************************************************/
#ifndef	WINMETA_PAINTPROCESS
#define	WINMETA_PAINTPROCESS

/* PVOID = Your own data, whatever you want, see warnprocData! ULONG = the gpi error code */
typedef ULONG  (APIENTRY _PFNWARNPROC)(PVOID, ULONG);
typedef _PFNWARNPROC* PFNWARNPROC;

#define		WINGDI_SCALEVIEWPORTSZ	0x00000001
#define		WINGDI_SCALEWINDOWSIZE	0x00000002
#define		WINGDI_ALLOWGDISAVEPS	0x00000004
#define		WINGDI_USECOLORTABLES	0x00000008
#define		WINGDI_ALLOWSCALEXFORM	0x00000010

#define		WINGDI_DEFAULTOPTS	(WINGDI_SCALEVIEWPORTSZ | WINGDI_SCALEWINDOWSIZE | WINGDI_ALLOWSCALEXFORM)

/* Check to see that the file is recognised */
BOOL	APIENTRY	IsWinMetafile(PCHAR metadata, ULONG metasize);

/* Initialises Windows Metafile functions */
ULONG	APIENTRY	InitWinMetafile(HAB hab, HPS hps, PFNWARNPROC warnproc, PVOID warnprocData, ULONG useOpts);

/* Paint the metafile, (paint it into a metafile HDC, then paint that on the screen) */ 
ULONG	APIENTRY	PaintWinMetafile(HPS hps, PCHAR metadata, ULONG metasize);

/* Creates a text error or warning message */
char*	APIENTRY	FormatMetafileErrorMsg(char* buffer, ULONG errcode);

#endif
