/* WebCam-Programm fr MMPM/2 (z.B. Fast, WinTV), Elsa Winner 2000 Office                   */
/* mit VideoIn oder Connectix QuickCam VC Parallel                                          */
/* WebCam 2.1 fr OS/2 (c) Thorolf@Godawa.de, Stand 09.11.2002                              */


/* System Funktionen laden */
'@echo off'
call RxFuncAdd    'SysLoadFuncs', 'RexxUtil', 'SysLoadFuncs'
call SysLoadFuncs

Call RxFuncAdd 'GdLoadFuncs', 'rexxgd', 'GdLoadFuncs'
Call GdLoadFuncs


/* Welche Kamera soll verwendet werden (hab noch nie mehr als zwei benutzt) */
WebCam = 0
EWOCam = 0
QV2Cam = 1

/* Wie heien die EXEs, wo liegen sie */
WebCamCmd = "WebCam.Exe"
EWOCamCmd = "EWOCam.Exe"
WebCamSnapCmd = "WCRemote.Exe"
EWOCamSnapCmd = "ECRemote.Exe"
QV2CamSnapCmd = "qv2snap.exe /s /C=100 /B=128 /S=100"

/* Einstellung der max. Auflsung */
MaxAufloesungWebCam = 2 /* 1: 160x120, 2: 320x240, 3: 640x480 */
MaxAufloesungEWOCam = 2 /* 1: 160x120, 2: 320x240, 3: 640x480 */
MaxAufloesungQV2Cam = 2 /* 1: 160x120, 2: 324x243, 3: NA */

/* Wie oft soll ein Bild gemacht werden (0-fortlaufend, 1 bis nnnnn Sekunden) */
WebCamIntervall = 0

/* Bild immer kopieren/hochladen oder nur wenn es eine nderung gab (0/1) */
TesteBewegung = 0

/* Sollen Zeit und Datum im Bild angezeigt werden (0/1) */
ZeigeDatumZeit = 1
ZusDatumZeitText = "WarpStock - "

/* Wohin sollen die Bilder kopiert werden (z.B. fr den lokalen Web-Server) */
SendDirDef = "<LOCAL-DIR oder WEB-SERVER-DIR>"

/* Sollen Bilder auf einen Web-Server hochgeladen werden (0/1)? Dann Zugangsdaten eingeben. */
FtpUpload = 0
FTPServer = "<DOMAIN>"
FTPUser = "<FTP-USER-ID>"
FTPPsw = "<FTP-PASSWORD>"
FTPVerz = "WebCam"

/* Wie heien die EXEs, wo liegen sie */
BMPDiffCmd = "BMPDiff.Exe"
GBMRefCmd = "GBMRef.Exe"
OutJPEGCmd = "OutJPEG.Exe"
ncFtpPutCmd = "ncftpput.exe -u "FTPUser" -p "FTPPsw" "FTPServer" "FTPVerz" "

Debug = 0


/* ************************************************ */
/*                                                  */
/*   Ab hier keine weiteren Einstellungen ntig !   */
/*                                                  */
/* ************************************************ */

call SysCls
say "WebCam 2.1 fr OS/2 (c) Thorolf@Godawa.de, Stand 24.09.2002"
say
say
say "Bitte warten, Programm wird gestartet !"
say
say
say "Programm mit <ESC> beenden"
say

if MaxAufloesungQV2Cam > 2 then MaxAufloesungQV2Cam = 2

if WebCam = 1 then address cmd "start "WebCamCmd
if EWOCam = 1 then address cmd "start "EWOCamCmd
call SysSleep(10)

if Debug = 1 then call beep 4000, 100
if WebCam = 1 then do
  address cmd WebCamSnapCmd
  address cmd "copy webcam.bmp webcam01.bmp > NUL"
end /* if */
if EWOCam = 1 then do
  address cmd EWOCamSnapCmd
  address cmd "copy webcam.bmp webcam02.bmp > NUL"
end /* if */
if QV2Cam = 1 then do
  address cmd QV2CamSnapCmd
  address cmd "copy quickcam.bmp webcam03.bmp > NUL"
end /* if */
if Debug = 1 then call beep 5000, 100

do forever

  Datum0 = date('E')
  Datum = left(Datum0,2)"."substr(Datum0,4,2)"."right(Datum0,2)
  DatumZeit = Datum" "time()

  if WebCam = 1 then do
    if Debug = 1 then call beep 4000, 100
    address cmd WebCamSnapCmd
    address cmd "copy webcam.bmp webcam1.bmp > NUL"
    if Debug = 1 then call beep 5000, 100
    call KonvertBild "webcam01" "webcam1" MaxAufloesungWebCam SendDirDef "wcam11" "wcam13" "wcam16" "wcam1.htm"
  end /* if */

  if EWOCam = 1 then do
    if Debug = 1 then call beep 4000, 100
    address cmd EWOCamSnapCmd
    address cmd "copy ewocam.bmp webcam2.bmp > NUL"
    if Debug = 1 then call beep 5000, 100
    call KonvertBild "webcam02" "webcam2" MaxAufloesungWebCam SendDirDef "wcam21" "wcam23" "wcam26" "wcam2.htm"
  end /* if */

  if QV2Cam = 1 then do
    if Debug = 1 then call beep 4000, 100
    address cmd QV2CamSnapCmd
    address cmd "copy quickcam.bmp webcam3.bmp > NUL"
    if Debug = 1 then call beep 5000, 100
    call KonvertBild "webcam03" "webcam3" MaxAufloesungWebCam SendDirDef "wcam31" "wcam33" "wcam36" "wcam3.htm"
  end /* if */

  if TesteBewegung = 1 then do
    if WebCam = 1 then address cmd "copy webcam1.bmp webcam01.bmp > NUL"
    if EWOCam = 1 then address cmd "copy webcam2.bmp webcam02.bmp > NUL"
    if QV2Cam = 1 then address cmd "quickcam.bmp webcam03.bmp > NUL"
  end /* if */

  if chars() <> 0 then do
    rc = SysGetKey2('NOECHO')
    say
    if rc = '1B'x then do
      say
      say "Programm beendet !                    "
      ProgrammEnde = 1
      leave
    end /* if */
  end /* if */

  if WebCamIntervall > 0 then rc = SysSleep(WebCamIntervall)

end /* forever */

/* Ende Hauptprogramm */

exit


/* Anfang Unterprogramme */

KonvertBild:
  parse arg WebCamPic0 WebCamPic MaxAufloesung SendDir SendFileJpg1 SendFileJpg3 SendFileJpg6 SendFileHtm

  if TesteBewegung = 1 then do
    address cmd BMPDiffCmd" -1:"WebCamPic0" -2:"WebCamPic" -b:3 > NUL"
    /* address cmd BMPDiffCmd" -1:"WebCamPic0" -2:"WebCamPic" -d:webdiff -b:3 > NUL" */
  end /* if */
  else do
    rc = 1000
  end /* else */
  say rc
  if (rc > 100) then do
    /* Bilder sind unterschiedlich, abspeichern! */
    if Debug = 1 then call beep 500, 1000
    address cmd GBMRefCmd" "WebCamPic".bmp "WebCamPic".jpg,quality=75"

    if ZeigeDatumZeit = 1 then do
      gdFont = "GDFONTGIANT"
      gdImg = gdImageCreateFromJpeg(WebCamPic".jpg")
      white = gdImageColorAllocate(gdImg, 255, 255, 255)
      if  white = -1 then do
        white = gdImageColorClosest(gdImg, 255, 255, 255) 
      end /* if */
      /* grey = gdImageColorClosest(gdImg, 127, 127, 127) */
      /* black = gdImageColorClosest(gdImg, 0, 0, 0) */
      gdString = ZusDatumZeitText" - "DatumZeit
      /* Call gdImageString gdImg, gdFont, (gdImageGetWidth(gdImg)%2)-(length(gdString)*gdFontGetWidth(gdFont)%2)+1, gdImageGetHeight(gdImg)-20+1, gdString, grey */
      Call gdImageString gdImg, gdFont, (gdImageGetWidth(gdImg)%2)-(length(gdString)*gdFontGetWidth(gdFont)%2), gdImageGetHeight(gdImg)-20, gdString, white
      Call gdImageJpeg gdImg, WebCamPic".jpg", 75
      Call gdImageDestroy gdImg
    end /* if */

    select
      when MaxAufloesung = 3 then do
        address cmd "copy "WebCamPic".jpg "SendFileJpg6".jpg > NUL"
        address cmd "copy "SendFileJpg6".jpg "SendDir"\"SendFileJpg6".jpg > NUL"
        /* address cmd OutJPEGCmd" /q=45 /s=1/1 "WebCamPic".jpg "SendDir"\"SendFileJpg6".jpg" */
        if Debug = 1 then call beep 2000, 100
        address cmd OutJPEGCmd" /q=45 /s=1/2 "WebCamPic".jpg "SendDir"\"SendFileJpg3".jpg"
        address cmd "copy "SendFileJpg6".jpg "SendDir"\"SendFileJpg6".jpg > NUL"
        if Debug = 1 then call beep 3000, 100
        address cmd OutJPEGCmd" /q=45 /s=1/4 "WebCamPic".jpg "SendFileJpg1".jpg"
        address cmd "copy "SendFileJpg1".jpg "SendDir"\"SendFileJpg1".jpg > NUL"
        if Debug = 1 then call beep 4000, 100
      end /* when */
      when MaxAufloesung = 2 then do
        address cmd "copy "WebCamPic".jpg "SendFileJpg3".jpg > NUL"
        address cmd "copy "SendFileJpg3".jpg "SendDir"\"SendFileJpg3".jpg > NUL"
        /* address cmd OutJPEGCmd" /q=45 /s=1/1 "WebCamPic".jpg "SendDir"\"SendFileJpg3".jpg" */
        if Debug = 1 then call beep 2000, 100
        address cmd OutJPEGCmd" /q=45 /s=1/2 "WebCamPic".jpg "SendFileJpg1".jpg"
        address cmd "copy "SendFileJpg1".jpg "SendDir"\"SendFileJpg1".jpg > NUL"
        if Debug = 1 then call beep 3000, 100
      end /* when */
      otherwise do
        address cmd OutJPEGCmd" /q=45 /s=1/1 "WebCamPic".jpg "SendFileJpg1".jpg"
        address cmd "copy "SendFileJpg1".jpg "SendDir"\"SendFileJpg1".jpg > NUL"
        if Debug = 1 then call beep 2000, 100
      end /* otherwise */
    end /* select */
    say "Stand: "DatumZeit
    if FtpUpload = 1 then do
      if Debug = 1 then do
        call beep 2000, 100
        call beep 4000, 100
        call beep 2000, 100
      end /* if */
      select
        when MaxAufloesung = 3 then do
          address cmd ncFtpPutCmd" "SendFileJpg1".jpg "SendFileJpg3".jpg "SendFileJpg6".jpg"
        end /* when */
        when MaxAufloesung = 2 then do
          address cmd ncFtpPutCmd" "SendFileJpg1".jpg "SendFileJpg3".jpg"
        end /* when */
        otherwise do
          address cmd ncFtpPutCmd" "SendFileJpg1".jpg"
        end /* otherwise */
      end /* select */
      if Debug = 1 then call beep 3000, 1000
    end /* if */
  end /* if */
return


EnCryptPsw:
  parse arg CryptPswDatei
  rc = stream(CryptPswDatei, 'command', 'open read')
  CryptPsw = linein(CryptPswDatei)
  PswKey = linein(CryptPswDatei)
  rc = stream(CryptPswDatei, 'command', 'close')
  EncryptPsw0 = ""
  do i = 1 to length(CryptPsw)-1
    epswn=c2d(substr(CryptPsw, i, 1))-c2d(substr(PswKey, i, 1))
    EncryptPsw0 = EncryptPsw0''d2c(epswn)
  end
Return EncryptPsw0


SysGetKey2:
  parse arg Echo0
  rc = SysGetKey(Echo0)
  if rc = 'E0'x | rc = '00'x then rc = SysGetKey(Echo0)
return rc
