/* VOLUME */
signal on error name fineko
signal on failure name fineko
signal on halt name fineko

parse value init() with rcy
if rcy \= 0 then signal fineko

parse upper arg filein volume ini fin fade

if (filein == "") | (volume == "") | (ini == "") | (fin == "") then do
  say "VOLUME:"
  say "Cambia il volume all'interno di un segmento di file audio WAV stereo,"
  say "ed eventualmente raccorda l'inizio e la fine del segmento per il"
  say "transitorio (fade in/out)."
  say ""
  say "Uso:"
  say "      VOLUME nome_file volume inizio fine [durata_fade]"
  say ""
  say "Parametri:"
  say "      nome_file    il nome di un file WAV stereo (con estenzione)"
  say "      volume       la differenza di volume (decibel) oppure 'MUTE' per azzerare"
  say "      inizio       l'offset di inizio del segmento (secondi)"
  say "      fine         l'offset di fine del segmento (secondi)"
  say "      durata       la durata del fade in/out (secondi)"
  return 1
  end

if fade == "" then fade=0

if fade>((fin - ini)/2) then fade = (fin - ini) / 2
fc=44100
if volume \= "MUTE" then kv = 1 * pow(10, (volume/20))
                    else kv = 0

call SysCls
t=time(R)
c = chkwav(filein)
say "VOLUME:"
say ""
say "   filein      :" filein
say "   volume  (db):" volume "   (kv:" kv ")"
say "   inizio (sec):" ini
say "   fine   (sec):" fin
say "   fade   (sec):" fade
say ""

if ((ini * fc) + (fade * fc))> c then do
   say "Inizio segmento oltre la fine del file"
   signal fineko
   end

if ((fin * fc) - (fade * fc))> c then do
   say "Fine segmento oltre la fine del file"
   signal fineko
   end

if fin == 0 then do
   say "Fino alla fine del file"
   fin = c / fc
   end




tr1 = WavAllocTrac(c)
tr2 = WavAllocTrac(c)
say time(E) ":" c*4 "bytes memoria allocata"
rcy = WavReadStereo(filein, tr1, tr2)
say time(E) ":" filein "caricato in memoria"

maxSx = WavPeak(tr1, c)
say time(E) ":" maxSx * 100 "% di picco SX"
maxDx = WavPeak(tr2, c)
say time(E) ":" maxDx * 100 "% di picco DX"
if (maxSx>maxDx) then kmax = 1 / maxSx
                 else kmax = 1 / maxDx

if (kmax<kv) then do
   kv = kmax
   say "   volume impostato a kv=" kv
   end

/* sinistro */
tri1 = tr1 + (ini * fc)
tro1 = tr1 + (fin * fc) - (fade * fc)
if fade>0 then do
   rcy = WavCopyTrac(tri1, tri1, (fade*fc), 1, kv, 'LOG', 'NOMIX')
   rcy = WavCopyTrac(tro1, tro1, (fade*fc), kv, 1, 'LOG', 'NOMIX')
   end

tri1 = tr1 + (ini * fc) + (fade * fc)
tro1 = tr1 + (fin * fc) - tri1
if kv \= 0 then rcy = rcy = WavCopyTrac(tri1, tri1, tro1, kv, kv, 'LOG', 'NOMIX')
           else rcy = rcy = WavMute(tri1, tro1)
say time(E) ": traccia SX copiata"


/* destro */
tri2 = tr2 + (ini * fc)
tro2 = tr2 + (fin * fc) - (fade * fc)
if fade>0 then do
   rcy = WavCopyTrac(tri2, tri2, (fade*fc), 1, kv, 'LOG', 'NOMIX')
   rcy = WavCopyTrac(tro2, tro2, (fade*fc), kv, 1, 'LOG', 'NOMIX')
   end

tri2 = tr2 + (ini * fc) + (fade * fc)
tro2 = tr2 + (fin * fc) - tri2
if kv \= 0 then rcy = rcy = WavCopyTrac(tri2, tri2, tro2, kv, kv, 'LOG', 'NOMIX')
           else rcy = rcy = WavMute(tri2, tro2)
say time(E) ": traccia DX copiata"

rcy = WavWriteStereo(filein, tr1, tr2, c)
say time(E) ":" c*4 "bytes scritti in" filein


fine:
rcy = WavDropTrac(tr1)
rcy = WavDropTrac(tr2)
say time(E) ": memoria rilasciata"
return 0



fineko:
say "fine ko !!!"
pull k
"exit"
/**********************************************************************/


