/*
 * 
 *   Module Name: WPSam
 * 
 *   OS/2 Workplace Shell Access Manager
 * 
 */


/*
 * This file was generated by the SOM Compiler, Klaus Breining and Bernhard Budnik.
 * FileName: WPSam.c.
 * Generated using:
 *     SOM Precompiler spc: 1.22
 *     SOM Emitter emitc: 1.24
 */



#define WPSam_Class_Source
#define M_WPSam_Class_Source
#include "WPSam.ih"
#include "WPSam.ph"
#include "WPSamPan.h"

#include <string.h>
#include <stdlib.h>
#include <stdio.h>
#include <memory.h>



/*
 * Globale Daten, auf die von allen Instanzen und der Metaklasse
 * gemeinsam zugegriffen werden knnen.
 */

HMODULE hmod    = NULLHANDLE;
HMODULE hmodMag = NULLHANDLE;
CHAR    szSamClassTitle[CCHMAXPATH];
CHAR    szRegUser[CCHMAXREGUSER];               // DosAllocMem ???
CHAR    szRegPassword[CCHMAXREGPWD];
PSHARE1 pShareInitOS2   = 0;
HEV     hevSammy        = 0;

ULONG key[2] = {ULKEY1, ULKEY2};

int SOMLINK myReplacementForSOMOutChar (char);  // ???


SOM_Scope void   SOMLINK wpsam_wpInitData (WPSam *somSelf)
{
    WPSamData *somThis = WPSamGetData (somSelf);
    WPSamMethodDebug ("WPSam","WPSam_wpInitData");

    parent_wpInitData (somSelf); /* Parent method must be called prior own method */

    _szEnvironment      = _wpAllocMem (somSelf, CCHMAXPATH, NULL);
    _szUserResource     = _wpAllocMem (somSelf, CCHMAXPATH, NULL);
    _szUserProfile      = _wpAllocMem (somSelf, CCHMAXPATH, NULL);
    _szSystemProfile    = _wpAllocMem (somSelf, CCHMAXPATH, NULL);
    _szSystemResource   = _wpAllocMem (somSelf, CCHMAXPATH, NULL);
    _szPassword         = _wpAllocMem (somSelf, CCHMAXPASSWORD, NULL);
    _szProtShell        = _wpAllocMem (somSelf, CCHMAXPATH, NULL);
    _ulWrongPwdCount    = 0;
    _ulFlag             = RENENABLE | MOVEENABLE | COPYENABLE | DELENABLE | ININITOS2MENU;
    strcpy (_szEnvironment, "");
    strcpy (_szUserResource, "");
    strcpy (_szUserProfile, "");
    strcpy (_szSystemProfile, "");
    strcpy (_szSystemResource, "");
    strcpy (_szPassword, "");
    strcpy (_szProtShell, "");

    DebugE (D_SWT, "_wpInitData (ulFlag)", _ultoa (_ulFlag, szDebug, 2));
}


SOM_Scope void   SOMLINK wpsam_wpUnInitData (WPSam *somSelf)
{
    WPSamData *somThis = WPSamGetData (somSelf);
    WPSamMethodDebug ("WPSam","WPSam_wpUnInitData");

    _wpFreeMem (somSelf, _szEnvironment);
    _wpFreeMem (somSelf, _szUserResource);
    _wpFreeMem (somSelf, _szUserProfile);
    _wpFreeMem (somSelf, _szSystemResource);
    _wpFreeMem (somSelf, _szSystemProfile);
    _wpFreeMem (somSelf, _szPassword);
    _wpFreeMem (somSelf, _szProtShell);

    parent_wpUnInitData (somSelf);       /* Must be called after own processing */
}


SOM_Scope BOOL   SOMLINK wpsam_wpSetup (WPSam *somSelf,
                PSZ pszSetupString)
    {
    BOOL      bRC;
    ULONG     ul1;
    ULONG     ulBootDrive;
    PCHAR     pszScanEnv;
    CHAR      szEnv[CCHMAXPATH];                // CCHMAXPATH ???
    CHAR      szDefEnv[CCHMAXPATH];             // CCHMAXPATH ???
    CHAR      szEnvT[2 * ENVNUM * CCHMAXPATH];  // CCHMAXPATH ???
    WPSamData *somThis = WPSamGetData (somSelf);
    WPSamMethodDebug ("WPSam","WPSam_wpSetup");

    DebugE (D_SOM, "_wpSetup", pszSetupString);
    bRC = parent_wpSetup (somSelf, pszSetupString);
    DebugE (D_SOM, "_wpSetup: Parent method", bRC ? "passed" : "not passed");

    if (_ulFlag & SETUPPASSED)
        {
        /* Wurden z.B. mit WinSetup die Eigenschaften dieser Instanz verndert, */
        /* so wird dies durch RefreshStyle wieder rckgngig gemacht. (H-H). */

        _RefreshStyle (somSelf);
        return bRC;
        }

    bRC &= _CommonSetup (somSelf);

    /*  _szEnvironment  */ // ??? anders, wenn WPStart fertig, da Defaultenv!=Bootenv
    for (ul1 = 0; ul1 < ENVNUM; ul1++ )
        {
        WinLoadString (WinQueryAnchorBlock (HWND_DESKTOP), hmod,
            IDS_ENV1 + 2*ul1, sizeof (szEnv) - 1, szEnv);
        WinLoadString (WinQueryAnchorBlock (HWND_DESKTOP), hmod,
            IDS_DEF_ENV1 + 2*ul1, sizeof (szDefEnv) - 1, szDefEnv);

        if (DosScanEnv (szEnv, &pszScanEnv) != 0 )
            pszScanEnv = szDefEnv;

        if ((szEnv[0] != '\0') && (pszScanEnv[0] != '\0') )
            {
            strcpy (szEnvT, szEnv);
            strcat (szEnvT, "=");
            strcat (szEnvT, pszScanEnv);
            strcat (szEnvT, "\n");
            }
        }

    _wpFreeMem (somSelf, _szEnvironment);
    _szEnvironment = _wpAllocMem (somSelf, strlen (szEnvT)+1, NULL);
    strcpy (_szEnvironment, szEnvT);

/* Boot-Laufwerk bestimmen */
    DosQuerySysInfo (QSV_BOOT_DRIVE, QSV_BOOT_DRIVE, &ulBootDrive, sizeof (ULONG));

/* _szUserResource  */
//  _szUserResource = _wpAllocMem (somSelf, CCHMAXPATH+2, NULL);
    _szUserResource[0] = (CHAR) (ulBootDrive - 1) + 'A';
    WinLoadString (WinQueryAnchorBlock (HWND_DESKTOP), hmod,
                   IDS_USERRESOURCE, CCHMAXPATH, _szUserResource+1);
    if (_szUserResource[1] == '\0')
       _szUserResource[0] = '\0';

/* _szSystemResource  */
//  _szSystemResource = _wpAllocMem (somSelf, CCHMAXPATH+2, NULL);
    _szSystemResource[0] = (CHAR) (ulBootDrive - 1) + 'A';
    WinLoadString (WinQueryAnchorBlock (HWND_DESKTOP), hmod,
                   IDS_SYSTEMRESOURCE, CCHMAXPATH, _szSystemResource+1);
    if (_szSystemResource[1] == '\0')
       _szSystemResource[0] = '\0';

/* szUserProfile */
//  _szUserProfile = _wpAllocMem (somSelf, CCHMAXPATH, NULL);
    WinLoadString (WinQueryAnchorBlock (HWND_DESKTOP), hmod,
            IDS_USERPROFILE, CCHMAXPATH, _szUserProfile);
    DebugE (D_SOM, "_wpSetup: UserProfile", _szUserProfile);

/* szSystemProfile */
//  _szSystemProfile = _wpAllocMem (somSelf, CCHMAXPATH, NULL);
    WinLoadString (WinQueryAnchorBlock (HWND_DESKTOP), hmod,
            IDS_SYSTEMPROFILE, CCHMAXPATH, _szSystemProfile);
    DebugE (D_SOM, "_wpSetup: SystemProfile", _szSystemProfile);

/* szProtShell */
//  _szProtShell = _wpAllocMem (somSelf, CCHMAXPATH+2, NULL);
    if( !DosScanEnv (ENV_PROTSHELL_FS, &pszScanEnv)  )
       strcpy(_szProtShell, pszScanEnv);
    else
       _szProtShell[0] = '\0';

    _ulFlag |= SETUPPASSED;
    _RefreshStyle (somSelf);

    DebugE (D_SOM, "_wpSetup: ", bRC ? "passed" : "not passed");
    return bRC;
    }


SOM_Scope BOOL   SOMLINK wpsam_CommonSetup (WPSam *somSelf)
    {
    WPSamData *somThis = WPSamGetData (somSelf);
    WPSamMethodDebug ("WPSam","WPSam_CommonSetup");

    /* Diese Methode wird aufgerufen von _wpSetup und _wpCopiedFromTemplate */

    _MyHistory(somSelf, IDS_SETUP);

    /* Laden des Default-Pawortes */
//  _wpFree(somSelf, _szPassword);
//  _szPassword = _wpAllocMem (somSelf, CCHMAXPASSWORD, NULL);
    WinLoadString (WinQueryAnchorBlock (HWND_DESKTOP), hmod,
                   IDS_DEF_PASSWORD, CCHMAXPASSWORD, _szPassword);
    DebugE (D_SOM, "_CommonSetup: Default-Pawort", _szPassword);
    ChiffreSZ (_szPassword);

    _ulWrongPwdCount = 0;

    return (TRUE);
    }


SOM_Scope BOOL   SOMLINK wpsam_wpSaveState (WPSam *somSelf)
{
    WPSamData      *somThis = WPSamGetData (somSelf);
    STRUC_EAT_DATA arValue[2];
    ULONG          cb = CCHMAXPATH;
    CHAR           szMyName[CCHMAXPATH];
    BOOL           bRC;

    WPSamMethodDebug ("WPSam","WPSam_wpSaveState");

    bRC = parent_wpSaveState (somSelf);

    if (bRC == FALSE)
        DebugE (D_SWT, "_wpSaveState", "Error: Parentmethod failed!");

    bRC = TRUE;
    bRC &= _wpSaveLong   (somSelf, CLASSNAME, KEY_FLAG,           _ulFlag);
    bRC &= _wpSaveString (somSelf, CLASSNAME, KEY_PASSWORD,       _szPassword);
    bRC &= _wpSaveLong   (somSelf, CLASSNAME, KEY_WRONGPWDCOUNT,  _ulWrongPwdCount);
    bRC &= _wpSaveString (somSelf, CLASSNAME, KEY_ENVIRONMENT,    _szEnvironment);
    bRC &= _wpSaveString (somSelf, CLASSNAME, KEY_USERRESOURCE,   _szUserResource);
    bRC &= _wpSaveString (somSelf, CLASSNAME, KEY_SYSTEMRESOURCE, _szSystemResource);
    bRC &= _wpSaveString (somSelf, CLASSNAME, KEY_USERPROFILE,    _szUserProfile);
    bRC &= _wpSaveString (somSelf, CLASSNAME, KEY_SYSTEMPROFILE,  _szSystemProfile);
    bRC &= _wpSaveString (somSelf, CLASSNAME, KEY_PROTSHELL,      _szProtShell);

    /* Schreiben der WPSam-EAs */

    if (_wpQueryRealName (somSelf, szMyName, &cb, TRUE))
        {
        bRC &= EAWriteASCII (szMyName, EA_USERPROFILE, _szUserProfile);
        DebugE (D_SWT, "_wpSaveState: EA_USERPROFILE", _szUserProfile);

        bRC &= EAWriteASCII (szMyName, EA_SYSTEMPROFILE,
                             (_ulFlag & PRIVATESYS) ? _szSystemProfile : "");
        DebugE (D_SWT, "_wpSaveState: EA_SYSTEMPROFILE",
                             (_ulFlag & PRIVATESYS) ? _szSystemProfile : "");

        bRC &= EAWriteASCII (szMyName, EA_USERRESOURCE, _szUserResource);
        DebugE (D_SWT, "_wpSaveState: EA_USERRESOURCE", _szUserResource);

        bRC &= EAWriteASCII (szMyName, EA_SYSTEMRESOURCE,
                             (_ulFlag & PRIVATESYS) ? _szSystemResource : "");
        DebugE (D_SWT, "_wpSaveState: EA_SYSTEMRESOURCE",
                             (_ulFlag & PRIVATESYS) ? _szSystemResource : "");

        bRC &= EAWriteASCII (szMyName, EA_PWDNAME,
                             (_ulFlag & PWDENABLE) ? _szPassword : "");
        DebugE (D_SWT, "_wpSaveState: EA_PWDNAME",
                             (_ulFlag & PWDENABLE) ? _szPassword : "");

        bRC &= EAWriteASCII (szMyName, EA_PROTSHELL,
                             (_ulFlag & OTHERPROTSHELL) ? _szProtShell : "");
        DebugE (D_SWT, "_wpSaveState: EA_PROTSHELL",
                             (_ulFlag & OTHERPROTSHELL) ? _szProtShell : "");

        bRC &= EAWriteASCII (szMyName, EA_ENVNAME, _szEnvironment);
        DebugE (D_SWT, "_wpSaveState: EA_ENVNAME", _szEnvironment);

        arValue[0].usEAType = arValue[1].usEAType = EAT_ASCII;
        arValue[0].uscValue = strlen (arValue[0].pValue);
        arValue[0].pValue   = EA_TYPEWPSAM;
        arValue[1].pValue   = NULL;
        bRC &= EAWriteMV (szMyName, EA_TYPENAME, EAT_MVST, arValue);
        DebugE (D_SWT, "_wpSaveState: EA_TYPENAME", arValue[0].pValue);

        arValue[0].usEAType = arValue[1].usEAType = EAT_BINARY;
        arValue[0].uscValue = sizeof (ULONG);
        arValue[0].pValue   = &_ulFlag;
        bRC &= EAWrite (szMyName, EA_FLAGS, arValue);
        DebugULx (D_SWT, "_wpSaveState", "_ulFlag", _ulFlag);
        }
    else
        {
        MessageBox (IDS_REALNAMEERROR, MBTITLE_ERROR, MB_OK | MB_ERROR);
        DebugE (D_SWT, "_wpSaveState", "RealNameError");
        }


    if (bRC)
       DebugE (D_SWT, "_wpSaveState", "Ok");
    else
       MessageBox (IDS_SAVESTATEFAILED, MBTITLE_ERROR, MB_OK | MB_ERROR);

    return bRC;
}


SOM_Scope BOOL   SOMLINK wpsam_wpRestoreState (WPSam *somSelf,
                ULONG ulReserved)
{
    BOOL      bRC = TRUE;
    ULONG     ulLen;

    WPSamData *somThis = WPSamGetData (somSelf);
    WPSamMethodDebug ("WPSam","WPSam_wpRestoreState");

    DebugE (D_SOM, "_wpRestoreState", "Eingang");

    bRC &= parent_wpRestoreState (somSelf, ulReserved); 

    if (bRC == FALSE)
       DebugE (D_SOM, "_wpRestoreState", "Error: Parentmethod failed!");

    bRC &= _wpRestoreLong (somSelf, CLASSNAME, KEY_FLAG,          &_ulFlag);
    bRC &= _wpRestoreLong (somSelf, CLASSNAME, KEY_WRONGPWDCOUNT, &_ulWrongPwdCount);

    _wpRestoreString (somSelf, CLASSNAME, KEY_PASSWORD, NULL, &ulLen);
    DebugULd (D_SOM, "_wpRestoreState", "ulLen", ulLen);
    _wpFreeMem (somSelf, _szPassword);
    _szPassword = _wpAllocMem (somSelf, ulLen+1, NULL);
    bRC &= _wpRestoreString (somSelf, CLASSNAME, KEY_PASSWORD,
                             _szPassword, &ulLen);

    _wpRestoreString (somSelf, CLASSNAME, KEY_ENVIRONMENT, NULL, &ulLen);
    DebugULd (D_SOM, "_wpRestoreState", "ulLen", ulLen);
    _wpFreeMem (somSelf, _szEnvironment);
    _szEnvironment = _wpAllocMem (somSelf, ulLen+1, NULL);
    bRC &= _wpRestoreString (somSelf, CLASSNAME, KEY_ENVIRONMENT,
                             _szEnvironment, &ulLen);

    _wpRestoreString (somSelf, CLASSNAME, KEY_USERRESOURCE, NULL, &ulLen);
//  _wpFreeMem (somSelf, _szUserResource);
//  _szUserResource = _wpAllocMem (somSelf, ulLen+1, NULL);
    bRC &= _wpRestoreString (somSelf, CLASSNAME, KEY_USERRESOURCE,
                             _szUserResource, &ulLen);

    _wpRestoreString (somSelf, CLASSNAME, KEY_SYSTEMRESOURCE, NULL, &ulLen);
//  _wpFreeMem (somSelf, _szSystemResource);
//  _szSystemResource = _wpAllocMem (somSelf, ulLen+1, NULL);
    bRC &= _wpRestoreString (somSelf, CLASSNAME, KEY_SYSTEMRESOURCE,
                             _szSystemResource, &ulLen);

    _wpRestoreString (somSelf, CLASSNAME, KEY_USERPROFILE, NULL, &ulLen);
//  _wpFreeMem (somSelf, _szUserProfile);
//  _szUserProfile = _wpAllocMem (somSelf, ulLen+1, NULL);
    bRC &= _wpRestoreString (somSelf, CLASSNAME, KEY_USERPROFILE,
                             _szUserProfile, &ulLen);

    _wpRestoreString (somSelf, CLASSNAME, KEY_SYSTEMPROFILE, NULL, &ulLen);
//  _wpFreeMem (somSelf, _szSystemProfile);
//  _szSystemProfile = _wpAllocMem (somSelf, ulLen+1, NULL);
    bRC &= _wpRestoreString (somSelf, CLASSNAME, KEY_SYSTEMPROFILE,
                             _szSystemProfile, &ulLen);

    _wpRestoreString (somSelf, CLASSNAME, KEY_PROTSHELL, NULL, &ulLen);
//  _wpFreeMem (somSelf, _szProtShell);
//  _szProtShell = _wpAllocMem (somSelf, ulLen+1, NULL);
    bRC &= _wpRestoreString (somSelf, CLASSNAME, KEY_PROTSHELL,
                             _szProtShell, &ulLen);

    _RefreshStyle (somSelf);

    if (bRC)
        DebugE (D_SOM, "_wpRestoreState", "Ok");
    else
        MessageBox (IDS_RESTORESTATEFAILED, MBTITLE_ERROR, MB_OK | MB_ERROR);

    return bRC;
}


SOM_Scope void   SOMLINK wpsam_wpCopiedFromTemplate (WPSam *somSelf)
{
/*
 *  Reihenfolge: _wpInitData, dann _wpRestoreState, dann _wpCopiedFromTemplate
 */
    /* WPSamData *somThis = WPSamGetData (somSelf); */
    WPSamMethodDebug ("WPSam","WPSam_wpCopiedFromTemplate");

    parent_wpCopiedFromTemplate (somSelf);

    _CommonSetup (somSelf);

    DebugE (D_SOM, "_wpCopiedFromTemplate", "");

    return;
}



SOM_Scope ULONG   SOMLINK wpsam_wpDelete (WPSam *somSelf,
                ULONG fConfirmations)
{
    WPSamData *somThis = WPSamGetData (somSelf);
    ULONG     Confirm = fConfirmations;

    WPSamMethodDebug ("WPSam","WPSam_wpDelete");

    Confirm = _wpConfirmDelete (somSelf, (ULONG) CONFIRM_DELETE);

    if (Confirm != OK_DELETE )
       return (Confirm);
    else
    {
       ULONG    cb = CCHMAXPATH;
       CHAR     szMyName[CCHMAXPATH];

       if (_wpQueryRealName (somSelf, szMyName, &cb, TRUE) )
          {
          strcat (szMyName,"\\*");
          DebugE (D_SOM, "_wpDelete", szMyName);

          _ulFlag |= WPSDISABLED;
          _wpSaveImmediate (somSelf);

          if (DelDir (szMyName) )
             return (parent_wpDelete (somSelf, (ULONG) NULL));
          }

       else
          {
          MessageBox (IDS_REALNAMEERROR, MBTITLE_ERROR, MB_OK | MB_ERROR);
          return (NO_DELETE);
          }
    }

    DebugE (D_SOM, "_wpDelete", "NO_DELETE");

    return (NO_DELETE);
}


SOM_Scope ULONG   SOMLINK wpsam_wpConfirmDelete (WPSam *somSelf,
                ULONG fConfirmations)
{
   ULONG ulConfirm;

    /* WPSamData *somThis = WPSamGetData (somSelf); */
    WPSamMethodDebug ("WPSam","WPSam_wpConfirmDelete");

    ulConfirm = parent_wpConfirmDelete (somSelf, fConfirmations);

    if (ulConfirm == OK_DELETE)
       if (_CheckPassword (somSelf) == FALSE )
          ulConfirm = NO_DELETE;

    return (ulConfirm);
}


SOM_Scope BOOL   SOMLINK wpsam_CheckPassword (WPSam *somSelf)
{
    WPSamData *somThis = WPSamGetData (somSelf);
    ULONG      ulResult = 1;
    CHAR       szBuffer[CCHMAXMSG];
    CHAR       szTitle[CCHMAXMSG];

    WPSamMethodDebug ("WPSam","WPSam_CheckPassword");

    if (_ulFlag & PWDENABLE)
    {
        ulResult = WinDlgBox (HWND_DESKTOP, HWND_DESKTOP,
            (PFNWP) PwdDlgProc, hmod, IDD_PWDIN, somSelf);

       if (ulResult == 1 && _ulWrongPwdCount > 0)
       {
          _ultoa (_ulWrongPwdCount, szBuffer, 10);
          WinLoadString (WinQueryAnchorBlock (HWND_DESKTOP), hmod, IDS_WRONGPWDS,
                         sizeof (szBuffer)-1-strlen (szBuffer), szBuffer+strlen (szBuffer));
          WinLoadString (WinQueryAnchorBlock (HWND_DESKTOP), hmod, IDS_INFORMATION,
                         sizeof (szTitle), szTitle);
          WinAlarm (HWND_DESKTOP, WA_NOTE);
          WinMessageBox (HWND_DESKTOP, HWND_DESKTOP, szBuffer,
                         szTitle, 0, MB_ENTER | MB_INFORMATION);
          _ulWrongPwdCount = 0;
          _wpSaveDeferred (somSelf);
       }

       DebugULd (D_SOM, "_CheckPassword", "ulResult", ulResult);
    }

    return ((ulResult == 1) ? TRUE : FALSE );
}


SOM_Scope BOOL   SOMLINK wpsam_RefreshStyle (WPSam *somSelf)
{
    ULONG     ulStyle;
    WPSamData *somThis = WPSamGetData (somSelf);
    WPSamMethodDebug ("WPSam","WPSam_RefreshStyle");

    if ( _ProfilesCreated(somSelf) )
       _ulFlag &= ~COPYENABLE;

    /* Zurcksetzen aller in Frage kommenden Style-Bits */
    ulStyle = _wpQueryStyle (somSelf) &
                   ~OBJSTYLE_NORENAME &
                   ~OBJSTYLE_NOMOVE   &
                   ~OBJSTYLE_NOCOPY   &
                   #ifdef DEBUG
                   ~OBJSTYLE_NODELETE &
                   #endif
                   ~OBJSTYLE_NODROP;

    /* Setzen aller zu setzenden Style-Bits */
    ulStyle |= ((_ulFlag & RENENABLE)  ? 0: OBJSTYLE_NORENAME) |
               ((_ulFlag & MOVEENABLE) ? 0: OBJSTYLE_NOMOVE)   |
               ((_ulFlag & COPYENABLE) ? 0: OBJSTYLE_NOCOPY)   |
               #ifdef DEBUG
               ((_ulFlag & DELENABLE)  ? 0: OBJSTYLE_NODELETE) |
               #endif
               ((_ulFlag & DROPALLOW)  ? 0: OBJSTYLE_NODROP) ;

    DebugE (D_SOM, "_RefreshStyle (ulFlag)", _ultoa (_ulFlag, szDebug, 2));
    DebugE (D_SOM, "_RefreshStyle (ulStyle)", _ultoa (ulStyle, szDebug, 2));

    if ( !_wpSaveDeferred (somSelf) )
       DebugE (D_SOM, "_RefreshStyle", "wpSaveDeferred rejected");

    return (_wpSetStyle (somSelf, ulStyle));
}
/*
 * Mgliche Optionen: OBJSTYLE_NOMOVE, NOLINK, NOCOPY, NOTDEFAULTICON,
 * TEMPLATE, NODELETE, NOPRINT, NODRAG, NOTVISIBLE, NORENAME, NODROP
 */


SOM_Scope BOOL   SOMLINK wpsam_wpAddSettingsPages (WPSam *somSelf,
                HWND hwndNotebook)
{
    /* WPSamData *somThis = WPSamGetData (somSelf); */
    PAGEINFO  pageinfo;
    CHAR      szPageName[CCHMAXPGNAME];

    WPSamMethodDebug ("WPSam","WPSam_wpAddSettingsPages");

    if (!parent_wpAddSettingsPages (somSelf, hwndNotebook) ) {
       DebugE (D_SOM, "_wpAddSettingsPages", " Failed to add parent's settings pages.");
       return (FALSE );
       }

    memset ((PCH)&pageinfo,0,sizeof (PAGEINFO));
    WinLoadString (WinQueryAnchorBlock (HWND_DESKTOP), hmod,
                   IDS_WPSAM_INIT, CCHMAXPGNAME, szPageName);
    pageinfo.cb                 = sizeof (PAGEINFO);
    pageinfo.hwndPage           = NULLHANDLE;
    pageinfo.usPageStyleFlags   = BKA_MAJOR | BKA_STATUSTEXTON;
    pageinfo.usPageInsertFlags  = BKA_FIRST;
    pageinfo.usSettingsFlags    = SETTINGS_PAGE_NUMBERS;
    pageinfo.pfnwp              = InitOS2DlgProc;
    pageinfo.resid              = hmod;
    pageinfo.dlgid              = IDD_INITOS2;
    pageinfo.pszName            = szPageName;
    pageinfo.pCreateParams      = somSelf;
    pageinfo.idDefaultHelpPanel = PANEL_INITOS2;
    pageinfo.pszHelpLibraryName = HELPFILE;

    if (!_wpInsertSettingsPage (somSelf, hwndNotebook, &pageinfo ) ) {
       DebugE (D_SOM, "_wpAddSettingsPages", " Failed to add Adjustments settings page.");
       return (FALSE );
       }

    memset ((PCH)&pageinfo,0,sizeof (PAGEINFO));
    pageinfo.cb                 = sizeof (PAGEINFO);
    pageinfo.hwndPage           = NULLHANDLE;
    pageinfo.usPageStyleFlags   = BKA_MINOR | BKA_STATUSTEXTON;
    pageinfo.usPageInsertFlags  = BKA_FIRST;
    pageinfo.usSettingsFlags    = SETTINGS_PAGE_NUMBERS;
    pageinfo.pfnwp              = CreateDlgProc;
    pageinfo.resid              = hmod;
    pageinfo.dlgid              = IDD_CREATE;
    pageinfo.pszName            = "";
    pageinfo.pCreateParams      = somSelf;
    pageinfo.idDefaultHelpPanel = PANEL_CREATE;
    pageinfo.pszHelpLibraryName = HELPFILE;

    if (!_wpInsertSettingsPage (somSelf, hwndNotebook, &pageinfo ) ) {
       DebugE (D_SOM, "_wpAddSettingsPages", " Failed to add Adjustments settings page.");
       return (FALSE );
       }

    memset ((PCH)&pageinfo,0,sizeof (PAGEINFO));
    pageinfo.cb                 = sizeof (PAGEINFO);
    pageinfo.hwndPage           = NULLHANDLE;
    pageinfo.usPageStyleFlags   = BKA_MINOR | BKA_STATUSTEXTON;
    pageinfo.usPageInsertFlags  = BKA_FIRST;
    pageinfo.usSettingsFlags    = SETTINGS_PAGE_NUMBERS;
    pageinfo.pfnwp              = AdjustDlgProc;
    pageinfo.resid              = hmod;
    pageinfo.dlgid              = IDD_ADJUSTMENTS;
    pageinfo.pszName            = "";
    pageinfo.pCreateParams      = somSelf;
    pageinfo.idDefaultHelpPanel = PANEL_ADJUSTMENTS;
    pageinfo.pszHelpLibraryName = HELPFILE;

    if (!_wpInsertSettingsPage (somSelf, hwndNotebook, &pageinfo ) ) {
       DebugE (D_SOM, "_wpAddSettingsPages", " Failed to add Adjustments settings page.");
       return (FALSE );
       }

    memset ((PCH)&pageinfo,0,sizeof (PAGEINFO));
    WinLoadString (WinQueryAnchorBlock (HWND_DESKTOP), hmod,
                   IDS_WPSAM_PG1, CCHMAXPGNAME, szPageName);
    pageinfo.cb                 = sizeof (PAGEINFO);
    pageinfo.hwndPage           = NULLHANDLE;
    pageinfo.usPageStyleFlags   = BKA_MAJOR | BKA_STATUSTEXTON;
    pageinfo.usPageInsertFlags  = BKA_FIRST;
    pageinfo.usSettingsFlags    = SETTINGS_PAGE_NUMBERS;
    pageinfo.pfnwp              = PwdNewDlgProc;
    pageinfo.resid              = hmod;
    pageinfo.dlgid              = IDD_PWD;
    pageinfo.pszName            = szPageName;
    pageinfo.pCreateParams      = somSelf;
    pageinfo.idDefaultHelpPanel = PANEL_PWD;
    pageinfo.pszHelpLibraryName = HELPFILE;

    if (!_wpInsertSettingsPage (somSelf, hwndNotebook, &pageinfo ) ) {
       DebugE (D_SOM, "_wpAddSettingsPages", " Failed to add Password settings page.");
       return (FALSE );
       }

    return TRUE;
}


SOM_Scope BOOL   SOMLINK wpsam_wpModifyPopupMenu (WPSam *somSelf,
                HWND hwndMenu,
                HWND hwndCnr,
                ULONG iPosition)
{
    WPSamData *somThis = WPSamGetData (somSelf);
    WPSamMethodDebug ("WPSam","WPSam_wpModifyPopupMenu");

    if (! (_wpQueryStyle (somSelf) & OBJSTYLE_TEMPLATE) &&
        ! (_ulFlag & WPSDISABLED ) )
        _wpInsertPopupMenuItems (somSelf, hwndMenu, 0, hmod,
                                 ID_SHELL, WPMENUID_OPEN);

    _wpInsertPopupMenuItems (somSelf, hwndMenu, 0, hmod,
                             ID_ABOUT, WPMENUID_PRIMARY);

    #ifdef DEBUG
       DebugE (D_SOM, "_wpModifyPopupMenu",
           _wpInsertPopupMenuItems (somSelf, hwndMenu, 0, hmod,
                                    ID_OPENDEBUG, WPMENUID_PRIMARY) ?
                                    "Item inserted" : "Error occurred");
    #endif

    return (parent_wpModifyPopupMenu (somSelf,hwndMenu,hwndCnr,iPosition));
}


SOM_Scope BOOL   SOMLINK wpsam_wpMenuItemSelected (WPSam *somSelf,
                HWND hwndFrame,
                ULONG ulMenuId)
    {
    SOMClass *Metaclass;

    /* WPSamData *somThis = WPSamGetData (somSelf); */
    WPSamMethodDebug ("WPSam","WPSam_wpMenuItemSelected");

    switch (ulMenuId )
        {
        case IDM_OPENWP:
            return (_wpViewObject (somSelf, hwndFrame, OPEN_WP, 0) != NULLHANDLE );

        case IDM_ABOUT:
            DebugE (D_SOM, "_wpMenuItemSelected", "IDM_ABOUT");
            Metaclass = SOM_GetClass (somSelf);
            wpsamM_clsAbout (Metaclass);
            return TRUE;

        #ifdef DEBUG
        case IDM_OPENDEBUG:
            DebugE (D_SOM, "_wpMenuItemSelected", "Open debug selected");
            return (_wpViewObject (somSelf, hwndFrame, PRIMARY_DEBUG, 0) != NULLHANDLE );
        #endif

        default:
            return parent_wpMenuItemSelected (somSelf, hwndFrame, ulMenuId);
        }
    }


SOM_Scope BOOL   SOMLINK wpsam_wpMenuItemHelpSelected (WPSam *somSelf,
                ULONG MenuId)
{
    /* WPSamData *somThis = WPSamGetData (somSelf); */
    WPSamMethodDebug ("WPSam","WPSam_wpMenuItemHelpSelected");
   switch (MenuId )
   {
  /*  case IDM_OPENWP:    no help written at this time
   *
   *     return (_wpDisplayHelp (somSelf,ID_HELP_OPENWPS,szHelpLibrary));
   *     break;
   */
      default:
         return (parent_wpMenuItemHelpSelected (somSelf,MenuId));
   }
}


SOM_Scope HWND   SOMLINK wpsam_wpOpen (WPSam *somSelf,
                HWND hwndCnr,
                ULONG ulView,
                ULONG param)
    {
    WPSamData    *somThis = WPSamGetData (somSelf);
    WPSamMethodDebug ("WPSam","WPSam_wpOpen");

    switch (ulView)
        {
        #ifdef DEBUG
        case PRIMARY_DEBUG:
            {
            ULONG ulResult;

            DebugE (D_SOM, "_wpOpen", "DEBUG");
            SOMOutCharRoutine = myReplacementForSOMOutChar;

            ulResult = WinDlgBox (HWND_DESKTOP, HWND_DESKTOP,
                (PFNWP) DbgDlgProc, hmod, IDD_DEBUG, NULL);

            SOM_TraceLevel  = (ulResult >> SHFT_TRACE)  & 3;
            SOM_WarnLevel   = (ulResult >> SHFT_WARN)   & 3;
            SOM_AssertLevel = (ulResult >> SHFT_ASSERT) & 3;
            DebugE (D_SOM, "_wpOpen", "Trace level modified");
            }
            break;
        #endif

        case OPEN_WP:
            {
            ULONG       cb1, cb2;
            CHAR        szMyPath[CCHMAXPATH], szMyName[CCHMAXPATH];
            CHAR        szBuffer[CCHMAXMSG];
            HAB         hab = WinQueryAnchorBlock (HWND_DESKTOP);
            CHAR        *szUserIni;
            static TID  tid, tid2;
            static USER User;
            static PRFPROFILE   prfProfile;

            if (!_wpSwitchTo (somSelf, ulView) &&
                !(_wpQueryStyle (somSelf) & OBJSTYLE_TEMPLATE) &&
                !(_ulFlag & WPSDISABLED) &&
                _CheckPassword (somSelf))
                {
                cb1 = cb2 = CCHMAXPATH;

                if (!_wpQueryRealName (somSelf, szMyPath, &cb1, TRUE) ||
                    !_wpQueryRealName (somSelf, szMyName, &cb2, FALSE))
                    {
                    MessageBox (IDS_REALNAMEERROR, MBTITLE_ERROR, MB_OK | MB_ERROR);
                    DebugE (D_SOM, "_wpOpen: OPEN_WP", "RealNameError");
                    break;
                    }

                DebugE (D_SOM, "_wpOpen: OPEN_WP", "Create Ini-file(s)");
                User.pszMyName         = szMyName;
                User.pszMyPath         = szMyPath;
                User.pszUserProfile    = _szUserProfile;
                User.pszUserResource   = _szUserResource;
                User.pszSystemProfile  = _szSystemProfile;
                User.pszSystemResource = (_ulFlag & PRIVATESYS) ? _szSystemResource : "";
                User.pszDesktopName    = szBuffer;
                WinLoadString (WinQueryAnchorBlock (HWND_DESKTOP),
                    hmod, IDS_DESKTOP, CCHMAXMSG, szBuffer);

                DosCreateThread (&tid, (PFNTHREAD) thCreate,
                                 (ULONG) &User, 0, THREADSTACK);
                WinSetPointer (HWND_DESKTOP,
                        WinQuerySysPointer (HWND_DESKTOP, SPTR_WAIT, FALSE));
                DosWaitThread (&tid, DCWW_WAIT);
                WinSetPointer (HWND_DESKTOP,
                    WinQuerySysPointer (HWND_DESKTOP, SPTR_ARROW, FALSE));

                if (User.ulErrorMsg)
                    {
                    switch (User.ulErrorMsg)
                        {
                        case ERR_NOUSERRESOURCE:
                            User.ulErrorMsg = IDS_NOUSERRESOURCE;
                            break;
                        case ERR_NOSYSTEMRESOURCE:
                            User.ulErrorMsg = IDS_NOSYSTEMRESOURCE;
                            break;
                        case ERR_NOUSERINICREATED:
                            User.ulErrorMsg = IDS_NOUSERINICREATED;
                            break;
                        case ERR_NOSYSTEMINICREATED:
                            User.ulErrorMsg = IDS_NOSYSTEMINICREATED;
                            break;
                        case ERR_NODESKINRC:
                            User.ulErrorMsg = IDS_NODESKINRC;
                            break;
                        case ERR_PATHTOOLONG:
                            User.ulErrorMsg = IDS_PATHTOOLONG;
                            break;
                        }
                    WinAlarm (HWND_DESKTOP, WA_ERROR);
                    MessageBox (User.ulErrorMsg, MBTITLE_ERROR, MB_OK | MB_ERROR);
                    break;
                    }

                _RefreshStyle (somSelf);

                if (_ulFlag & PRIVATESYS)
                   {
                   WinAlarm (HWND_DESKTOP, WA_NOTE);
                   MessageBox (IDS_USERWITHSYSTEMINI, IDS_INFORMATION, MB_ENTER | MB_INFORMATION);
                   break;
                   }

                /* Namen der laufenden User- und System-INI-Dateien   */
                prfProfile.cchUserName = 0L;
                prfProfile.cchSysName = 0L;
                PrfQueryProfile (hab, &prfProfile);
                prfProfile.pszUserName = malloc (prfProfile.cchUserName);
                prfProfile.pszSysName = malloc (prfProfile.cchSysName);
                PrfQueryProfile (hab, &prfProfile);

                DebugE (D_SOM, "_wpOpen: OPEN_WP (curr user-INI)",
                          prfProfile.pszUserName);

                /* Name der User-INI */
                szUserIni = malloc (strlen (szMyPath) + strlen (_szUserProfile) + 6);

                strcpy (szUserIni, szMyPath);
                strcat (szUserIni, "\\");
                strcat (szUserIni, _szUserProfile);

                /* Untersuchen, ob User bereits aktiv ist */

                if (strcmpi (szUserIni, prfProfile.pszUserName) == 0)
                    {
                    WinAlarm (HWND_DESKTOP, WA_NOTE);
                    MessageBox (IDS_ALREADYINUSER, IDS_INFORMATION, MB_ENTER | MB_INFORMATION);
                    free(szUserIni);
                    goto ende_open_wp;
                    }
                else
                   {
                   free (prfProfile.pszUserName);
                   prfProfile.cchUserName = strlen (szUserIni) + 1;
                   prfProfile.pszUserName = szUserIni;
                   }

                /* Umschalten der Profiles */
                DebugE (D_SOM, "_wpOpen: OPEN_WP (dest system-INI)",
                          prfProfile.pszUserName);

                if (_ProfilesCreated(somSelf))
                   {
                   _MyHistory(somSelf, IDS_PRFRESET);

                   if (hevSammy)
                      {
                      _wpSaveImmediate(somSelf);
                      strcpy (pShareInitOS2->pszUserIni,     prfProfile.pszUserName);
                      strcpy (pShareInitOS2->pszSystemIni,   prfProfile.pszSysName);
                      strcpy (pShareInitOS2->pszEnvironment, _szEnvironment);
                      pShareInitOS2->ulFlag = _ulFlag;
                      DosPostEventSem(hevSammy);
                      goto ende_open_wp;
                      }
                   }
ende_open_wp:
                free (prfProfile.pszUserName);
                free (prfProfile.pszSysName);
                }

            break;
            }

        default:
            if (_CheckPassword (somSelf))
                return parent_wpOpen (somSelf,hwndCnr,ulView,param);
            break;
        }
    return NULLHANDLE; /* Nothing opened */
    }


SOM_Scope BOOL   SOMLINK wpsam_ProfilesCreated(WPSam *somSelf)
{
    WPSamData *somThis = WPSamGetData(somSelf);
    ULONG cb;
    BOOL bCreated;
    CHAR szProfile[CCHMAXPATH];

    WPSamMethodDebug("WPSam","wpsam_ProfilesCreated");

/* Returns TRUE, if the profile(s) are created */

   cb = CCHMAXPATH;

   if (!_wpQueryRealName (somSelf, szProfile, &cb, TRUE))
       {
       MessageBox (IDS_REALNAMEERROR, MBTITLE_ERROR, MB_OK | MB_ERROR);
       DebugE (D_SOM, "_ProfilesCreated", "RealNameError");
       }

   strcat (szProfile, "\\");
   strcat (szProfile, _szUserProfile);

   bCreated = FileExist(szProfile);

   if ( (_ulFlag & PRIVATESYS) && (_szSystemResource[0] != '\0'))
      {
      cb = CCHMAXPATH;

      if (!_wpQueryRealName (somSelf, szProfile, &cb, TRUE))
          {
          MessageBox (IDS_REALNAMEERROR, MBTITLE_ERROR, MB_OK | MB_ERROR);
          DebugE (D_SOM, "_ProfilesCreated", "RealNameError");
          }

      strcat (szProfile, "\\");
      strcat (szProfile, _szSystemProfile);

      bCreated &= FileExist(szProfile);
      }

   return (bCreated);
}


SOM_Scope BOOL   SOMLINK wpsam_MyHistory(WPSam *somSelf,
       ULONG ulIDS)
{
    /* WPSamData *somThis = WPSamGetData(somSelf); */
    ULONG     cb = CCHMAXPATH;
    CHAR      szMyName[CCHMAXPATH];
    CHAR      szEvent[CCHMAXHISTORY];

    WPSamMethodDebug("WPSam","wpsam_MyHistory");

    if (_wpQueryRealName (somSelf, szMyName, &cb, TRUE) )
       {
       szEvent[0] = '\0';
       WinLoadString (WinQueryAnchorBlock (HWND_DESKTOP), hmod,
                      ulIDS, sizeof (szEvent) - 1, szEvent);

       DebugE (D_SOM, "_MyHistory", szEvent);

       return( History(szMyName, CLASSNAME, szEvent) );
       }

    else
       {
       MessageBox (IDS_REALNAMEERROR, MBTITLE_ERROR, MB_OK | MB_ERROR);
       DebugE (D_SOM, "_MyHistory", "RealNameError");
       }

    return FALSE;
}


#undef SOM_CurrentClass
#define SOM_CurrentClass SOMMeta


SOM_Scope HMODULE   SOMLINK wpsamM_clsQueryModuleHandle (M_WPSam *somSelf)
{
    /* M_WPSamData *somThis = M_WPSamGetData (somSelf); */
    M_WPSamMethodDebug ("M_WPSam","WPSamM_clsQueryModuleHandle");

    /* Beschaffung aller global bentigten Handles: Module-Handle, Shared-Memory */
    if( !pShareInitOS2 )
       if ( DosGetNamedSharedMem ( (PPVOID) &pShareInitOS2,
                                        SHARE_INITOS2,
                                        PAG_READ | PAG_WRITE))
          pShareInitOS2 = 0;

    if( !hevSammy )
       if ( DosOpenEventSem (HEV_SAMMY, &hevSammy))
          hevSammy = 0;

    if (hmod == NULLHANDLE)
    {
       zString zsPathName;

       /*
        *   Retrieve registered pathname of our module (DLL) and query the
        *   module handle.
        */
       zsPathName =
       _somLocateClassFile (SOMClassMgrObject, SOM_IdFromString (CLASSNAME),
                            WPSam_MajorVersion, WPSam_MinorVersion);

       if (DosQueryModuleHandle (zsPathName, &hmod) )
       {
          DebugE (D_SOM, "_clsQueryModuleHandle", "Failed to load module");
          hmod = NULLHANDLE;
       }
    }   /* end if (hmod == NULLHANDLE) */

    return (hmod);
}


SOM_Scope void   SOMLINK wpsamM_clsAbout (M_WPSam *somSelf)
    {
    PCHAR          pszPathName;
    STRUC_EAT_DATA arValue[3];
    BOOL           bRegOld, bRegNew;

    M_WPSamData *somThis = M_WPSamGetData (somSelf);
    M_WPSamMethodDebug ("M_WPSam","WPSamM_clsAbout");

    DebugULx (D_SOM, "_clsAbout", "somSelf", (ULONG)somSelf);

    bRegOld = _clsIsShareware (somSelf);

    WinDlgBox (HWND_DESKTOP, HWND_DESKTOP,
        (PFNWP) AboutDlgProc, hmod, IDD_ABOUT, somSelf);

    bRegNew = _clsIsShareware (somSelf);

    /* Wurde die Version bei diesem Aufruf von _clsAbout registriert? */
    if (bRegOld != bRegNew)
        {
        /* Instanzdaten des Class Object in erweiterte Attribute schreiben */
        arValue[0].usEAType = arValue[1].usEAType = EAT_ASCII;
        arValue[0].uscValue = strlen (_szRegUser);
        arValue[0].pValue   = _szRegUser;
        arValue[1].uscValue = strlen (_szRegPassword);
        arValue[1].pValue   = _szRegPassword;
        arValue[2].pValue   = NULL;
        pszPathName = _clsQueryRegFile (somSelf);
        bRegNew = FALSE;            /* Am Ende: FALSE heit Messagebox rufen */
        if (pszPathName != NULL)
            if (EAWriteMV (pszPathName, EA_REGISTERNAME, EAT_MVST, arValue))
                bRegNew = TRUE;
        if (!bRegNew)
            MessageBox (IDS_SAVEREGPWD, MBTITLE_ERROR, MB_OK | MB_ERROR);
        }

    DebugE (D_SOM, "_clsAbout: _szRegUser    ", _szRegUser);
    DebugE (D_SOM, "_clsAbout: _szRegPassword", _szRegPassword);
    return;
    }


SOM_Scope BOOL   SOMLINK wpsamM_clsIsShareware(M_WPSam *somSelf)
    {
    BOOL bRet;
    USHORT usSerial;
    M_WPSamData *somThis = M_WPSamGetData(somSelf);
    M_WPSamMethodDebug("M_WPSam","WPSamM_clsIsShareware");

    DebugE (D_SOM, "_clsIsShareware", "Entry");
    bRet = RegCheck (_szRegUser, _szRegPassword, &usSerial,
                     WPSam_MajorVersion, WPSam_MinorVersion)
           != REGCHECK_OK;

    DebugE (D_SOM, "_clsIsShareware: bRet", bRet ? "TRUE" : "FALSE");
           
    return bRet;
    }


SOM_Scope void   SOMLINK wpsamM_wpclsInitData (M_WPSam *somSelf)
    {
    STRUC_EAT_DATA arValue[3];

    M_WPSamData *somThis = M_WPSamGetData (somSelf);
    M_WPSamMethodDebug ("M_WPSam","WPSamM_wpclsInitData");

    parent_wpclsInitData (somSelf);     /* Must be called before own processing */

    /* Get Class Title */
    if (!WinLoadString (WinQueryAnchorBlock (HWND_DESKTOP),
                        _clsQueryModuleHandle (somSelf),
                        IDS_TITLE_WPSAM,
                        sizeof (szSamClassTitle) - 1,
                        szSamClassTitle))
        strcpy (szSamClassTitle, parent_wpclsQueryTitle (somSelf));

    _szRegUser     = szRegUser;
    _szRegPassword = szRegPassword;

    /* erweiterte Attribute aus Instanzdaten des Class Objects lesen */
    arValue[0].uscValue = CCHMAXREGUSER;
    arValue[0].pValue   = _szRegUser;
    arValue[1].uscValue = CCHMAXREGPWD;
    arValue[1].pValue   = _szRegPassword;
    arValue[2].pValue   = NULL;
    EAReadMV (_clsQueryRegFile (somSelf), EA_REGISTERNAME, EAT_MVST, arValue);
    if (arValue[0].usEAType != EAT_ASCII)
        *_szRegUser = '\0';
    if (arValue[1].usEAType != EAT_ASCII)
        *_szRegPassword = '\0';

    DebugE (D_SOM, "_wpclsInitData: szRegUser", _szRegUser);
    DebugE (D_SOM, "_wpclsInitData: szRegPassword", _szRegPassword);
    DebugE (D_SOM, "_wpClsInitData: szSamClassTitle", szSamClassTitle);

    MCInit();
    DebugULd (D_SOM, "_wpClsInitData", "hmodMag", hmodMag);
    }


SOM_Scope void   SOMLINK wpsamM_wpclsUnInitData (M_WPSam *somSelf)
    {
    STRUC_EAT_DATA arValue[3];

    M_WPSamData *somThis = M_WPSamGetData (somSelf);
    M_WPSamMethodDebug ("M_WPSam","WPSamM_wpclsUnInitData");

    MCFree();

    parent_wpclsUnInitData (somSelf);     /* Must be called after own processing */
    }


SOM_Scope ULONG   SOMLINK wpsamM_wpclsQueryIconData (M_WPSam *somSelf,
                PICONINFO pIconInfo)
{
    /* M_WPSamData *somThis = M_WPSamGetData (somSelf); */
    M_WPSamMethodDebug ("M_WPSam","WPSamM_wpclsQueryIconData");

    if (pIconInfo)
    {
        /* fill in icon information */
        pIconInfo->fFormat = ICON_RESOURCE;
        pIconInfo->hmod= _clsQueryModuleHandle (somSelf);
        pIconInfo->resid= ID_ICON;
    }

    return (sizeof (ICONINFO));
}


SOM_Scope ULONG   SOMLINK wpsamM_wpclsQueryStyle (M_WPSam *somSelf)
{
    /* M_WPSamData *somThis = M_WPSamGetData (somSelf); */
    M_WPSamMethodDebug ("M_WPSam","WPSamM_wpclsQueryStyle");

    return (parent_wpclsQueryStyle (somSelf));
/*
Mgliche Optionen:
CLSSTYLE_NEVERMOVE, NEVERLINK, NEVERCOPY, NEVERTEMPLATE,
NEVERDELETE, NEVERPRINT, NEVERDRAG, NEVERVISIBLE, NEVERRENAME
*/
}


SOM_Scope ULONG   SOMLINK wpsamM_wpclsQueryDefaultView (M_WPSam *somSelf)
{
    /* M_WPSamData *somThis = M_WPSamGetData (somSelf); */
    M_WPSamMethodDebug ("M_WPSam","WPSamM_wpclsQueryDefaultView");

    return OPEN_WP;
}


SOM_Scope PSZ   SOMLINK wpsamM_wpclsQueryTitle (M_WPSam *somSelf)
{
    /* M_WPSamData *somThis = M_WPSamGetData (somSelf); */
    M_WPSamMethodDebug ("M_WPSam","WPSamM_wpclsQueryTitle");

    DebugE (D_SOM, "_wpclsQueryTitle", szSamClassTitle);

    if (*szSamClassTitle )
       return (szSamClassTitle );

    else
       return (parent_wpclsQueryTitle (somSelf));
}


SOM_Scope PCHAR   SOMLINK wpsamM_clsQueryRegFile(M_WPSam *somSelf)
    {
    PCHAR        pEnv;

    /* M_WPSamData *somThis = M_WPSamGetData(somSelf); */
    M_WPSamMethodDebug("M_WPSam","WPSamM_clsQueryRegFile");

    /* Diese Funktion liest die im Shared-Memory Bereich bergebene Datei,  */
    /* in deren Attributen die Registrierinformation verwaltet werden.      */
    /* Falls der Shared-Memory nicht allokiert ist, oder die bergebene     */
    /* Datei nicht existiert, wird das System-Profile aus der Environment   */
    /* bergeben.                                                           */

    if (pShareInitOS2)
        if (FileExist (pShareInitOS2->pszRegFile))
            return (pShareInitOS2->pszRegFile);

    return (DosScanEnv (ENV_SYSTEM_INI, &pEnv) ? NULL : pEnv);
    }  
