/*
 * Patch for Merlin's OS2KRNL to avoid trap in dos sessions
 * caused by some programs which delete multiple files via FCB functions
 *
 * Developed by Rinat H. Sadretdinow, FidoNet: 2:5020/620
 *
 * THE AUTHOR PROVIDES ABSOLUTELY NO WARRANTY !!!
 * IN NO EVENT WILL THE AUTHOR BE LIABLE TO YOU FOR ANY DAMAGE
 * OR LOSS OF DATA OR ANYTHING CAUSED BY USING THIS PATCH.
 * USE THIS PATCH AT YOUR OWN RISK.
*/

#include <stdio.h>
#include <string.h>

static char buggy[] =
{
    0x55,       0x8b, 0x2e, 0xf0, 0xff, 0xc7, 0x86,
    0x9a, 0x01, 0x00, 0x00, 0x5d, 0xc9, 0x66, 0xcb
};

static char patch[] =
{
    0x55, 0x36, 0x8b, 0x2e, 0xf0, 0xff, 0xc7, 0x86,
    0x9a, 0x01, 0x00, 0x00, 0x5d, 0xc9, 0x66, 0xcb
};

static char os2krnl[]  = "os2krnl.";
static char buggyMsg[] = "buggy";
static char patchMsg[] = "patch";

static char buf[16384];

main()
{
    FILE   *f;
    char   *lookFor = buggy;
    int     i, bytesRead, endOfSearch, coreLen = sizeof(buggy);
    short   displ = 0;
    long    whereBug, prevOfs;

    printf("Patch for Merlin's OS2KRNL to avoid trap in dos sessions\n"
           "caused by some programs which delete multiple files via "
           "FCB functions\n\n"
           "Developed by Rinat H. Sadretdinow, FidoNet: 2:5020/620\n\n"
           "THE AUTHOR PROVIDES ABSOLUTELY NO WARRANTY !!!\n"
           "IN NO EVENT WILL THE AUTHOR BE LIABLE TO YOU FOR ANY DAMAGE\n"
           "OR LOSS OF DATA OR ANYTHING CAUSED BY USING THIS PATCH.\n"
           "USE THIS PATCH AT YOUR OWN RISK.\n\n"
           "Press ENTER if you agree with all above, Ctrl-C otherwise\n\n");

    fgetc(stdin);

    if (!(f = fopen(os2krnl, "rb+")))
    {
        printf("unable to open %s\n", os2krnl);
    }
    else
    {
        for (;;)
        {
            prevOfs = ftell(f);

            if (!(bytesRead = fread(buf, 1, sizeof(buf), f)))
                break;

            printf("\rsearching for %s code in range %08lX - %08lX",
                   (coreLen == sizeof(buggy)) ? buggyMsg : patchMsg,
                   prevOfs, prevOfs + bytesRead);
            fflush(stdout);

            endOfSearch = bytesRead - coreLen;

            for (i = 0; i <= endOfSearch; i++)
            {
                if (!memcmp(&buf[i], lookFor, coreLen))
                {
                    break;
                }
            }
            if (i > endOfSearch)
            {
                if (bytesRead == sizeof(buf))
                    fseek(f, ftell(f) - coreLen, SEEK_SET);
                continue;
            }
            printf("\n%s code found at %08lX\n",
                   (coreLen == sizeof(buggy)) ? buggyMsg : patchMsg,
                   prevOfs + i);

            if (coreLen == sizeof(buggy))
            {
                lookFor = patch;
                coreLen = sizeof(patch);
                whereBug = prevOfs + i;
                fseek(f, whereBug, SEEK_SET);
                continue;
            }
            printf("applying patch...");
            fflush(stdout);

            displ = (short) ((prevOfs + i) - (whereBug + 3));

            fseek(f, whereBug, SEEK_SET);
            fputc('\xe9', f);
            fputc(displ & 0xff, f);
            fputc((displ >> 8) & 0xff, f);
            break;
        }
        printf("%s\n", (displ) ? "done" : "\ncan't find anything to patch");
        fclose(f);
    }
}
