/*---------------------------------------------------------------------------

               Copyright (c) 1994 SandStone Software Inc.
                          All rights reserved

----------------------------------------------------------------------------*/
#if !defined( SSYACC)
#  define SSYACC
#  include<ssref.hpp>
#  include<sslex.hpp>

#  define SSYaccEofLexeme        "eof"
#  define SSYaccErrorLexeme      "%error"
#  define SSYaccErrorToken       0xfffffffe
#  define SSYaccEofToken         0xffffffff

#  define SSYaccMsgOpen          "SSYacc0101e: Open file failed, %s"
#  define SSYaccMsgParse         "SSYacc0102e: Parse failed, invalid table"
#  define SSYaccMsgEof           "SSYacc0103e: Attempted read past eof"
#  define SSYaccMsgSelect        "SSYacc0104e: Error panic failed, no valid token"
#  define SSYaccMsgTokenState    "SSYacc0105e: Error token failed, no valid token"
#  define SSYaccMsgErrorTokenEof "SSYacc0106e: Error token failed, eof"
#  define SSYaccMsgGoto          "SSYacc0107e: Invalid goto on %ld"
#  define SSYaccMsgProdSize      "SSYacc0108e: Invalid index on elementFromProduction, %ld"
#  define SSYaccMsgMissingTable  "SSYacc0109e: setTable missing, required"
#  define SSYaccMsgMissingLex    "SSYacc0110e: setLex missing, required"
#  define SSYaccMsgRead          "SSYacc0111e: Error reading table, %s"
#  define SSYaccMsgTableSize     "SSYacc0112e: Table too big"
#  define SSYaccMsgPermError     "SSYacc0113e: Permanent error"

   class SSYacc;
   class SSYaccTable;
   class SSYaccStackElement;

   typedef SSRef< SSYaccStackElement> SSYaccStackElementRef;

   class SSYaccTable : public SSExceptionPresent
      {
      friend class SSYacc;

      public:
         SSConstr         SSYaccTable( const char*);
         SSDestr          SSYaccTable( void);

      protected:
         void*            opTable;
      };

   class SSYaccStackElement : public SSRefCount
      {
      friend class SSYacc;

      public:
         SSConstr         SSYaccStackElement( void);

         SSUnsigned32     state( void);
         SSLexLexeme*     lexeme( void);
         void             refFree( void);

         void             setState( SSUnsigned32);
         void             setLexeme( SSLexLexeme&);
 
      protected:
         SSLexLexemeRef   oLexeme;
         SSUnsigned32     oulState;
      };

   class SSYacc : public SSExceptionPresent
      {
      public:
         SSConstr                    SSYacc( const char* = 0);
         SSConstr                    SSYacc( SSLex&, const char*);
         SSConstr                    SSYacc( SSLex&, SSYaccTable&);

         virtual SSBooleanValue      accept( void);
         virtual SSLexLexeme*        nextLexeme( void);
         virtual SSYaccStackElement* stackElement( void);
         virtual SSYaccStackElement* shift( SSLexLexeme&);
         virtual SSBooleanValue      error( SSUnsigned32, SSLexLexeme&);
         virtual SSYaccStackElement* reduce( SSUnsigned32, SSUnsigned32) = 0;

         void                        setLex( SSLex&);
         void                        setTable( const char*);
         void                        setTable( SSYaccTable&);

         SSLex*                      lex( void);
         void                        reset( void);
         SSUnsigned32                state( void);
         SSBooleanValue              parse( void);
         void                        setEof( void);
         SSBooleanValue              wasError( void);
         void                        setAbort( void);
         SSLexLexeme&                lookahead( void);
         SSBooleanValue              wasAborted( void);
         SSBooleanValue              errorToken( void);
         SSUnsigned32                production( void);
         SSUnsigned32                productionSize( void);
         SSBooleanValue              pop( SSUnsigned32 = 1);
         SSUnsigned32                shiftedSinceError( void);
         SSBooleanValue              push( SSYaccStackElement&);
         SSYaccStackElement*         elementFromStack( SSUnsigned32 = 0);
         SSYaccStackElement*         elementFromProduction( SSSigned32);
         SSUnsigned32*               validLookaheads( SSUnsigned32,
                                        SSUnsigned32&);
         SSBooleanValue              errorPanic( SSUnsigned32* = 0,
                                        SSUnsigned32 = 0);

         virtual SSDestr             SSYacc( void);

      protected:
         SSLex*                      opLex;
         SSBooleanValue              oOwner;
         SSBooleanValue              oError;
         SSBooleanValue              oAbort;
         SSYaccTable*                opTable;
         SSUnsigned32                oulState;
         SSUnsigned32                oulError;
         SSLexLexemeRef              oLookahead;
         SSBooleanValue              oEndOfInput;
         SSUnsigned32                oulProduction;
         SSUnsigned32                oulProductionSize;

      protected:
         void*                       opTab;
         SSUnsigned32                oAction;
         void*                       opStack;
         SSYaccStackElementRef       oElement;
         SSLexLexemeRef              orEndLexeme;
         SSUnsigned32                oulLeftside;

         SSBooleanValue              push( void);
         void                        setStack( void);
         SSUnsigned32                leftside( void);
         SSBooleanValue              getLexeme( void);
         SSBooleanValue              goTo( SSUnsigned32);
         SSBooleanValue              lookupGoto( SSUnsigned32, SSUnsigned32);
         void                        lookupAction( SSUnsigned32, SSUnsigned32);
         void                        selectToken( SSUnsigned32*, SSUnsigned32,
                                        SSBooleanValue = SSFalse);
      };

#  include<ssyacc.inl>

#endif
