/*:VRX         Main
*/
/*  Main
*/
Main:
/*  Process the arguments.
    Get the parent window.
*/
    parse source . calledAs .
    parent = ""
    argCount = arg()
    argOff = 0
    if( calledAs \= "COMMAND" )then do
        if argCount >= 1 then do
            parent = arg(1)
            argCount = argCount - 1
            argOff = 1
        end
    end
    InitArgs.0 = argCount
    if( argCount > 0 )then do i = 1 to argCount
        InitArgs.i = arg( i + argOff )
    end
    drop calledAs argCount argOff

/*  Load the windows
*/
    call VRInit
    parse source . . spec
    _VREPrimaryWindowPath = ,
        VRParseFileName( spec, "dpn" ) || ".VRW"
    _VREPrimaryWindow = ,
        VRLoad( parent, _VREPrimaryWindowPath )
    drop parent spec
    if( _VREPrimaryWindow == "" )then do
        call VRMessage "", "Cannot load window:" VRError(), ,
            "Error!"
        _VREReturnValue = 32000
        signal _VRELeaveMain
    end

/*  Process events
*/
    if( Init() )then do
        signal on halt
        do while( \ VRGet( _VREPrimaryWindow, "Shutdown" ) )
            _VREEvent = VREvent()
            interpret _VREEvent
        end
    end
_VREHalt:
    _VREReturnValue = Fini()
    call VRDestroy _VREPrimaryWindow
_VRELeaveMain:
    call VRFini
exit _VREReturnValue

VRLoadSecondary: procedure
    name = arg( 1 )

    window = VRLoad( VRWindow(), VRWindowPath(), name )
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
return window

/*:VRX         CNCT_Database_Fini
*/
CNCT_Database_Fini:
    /*  Disconnect from the database
    */
 
    if( VRMethod( "CNCT_Database", "Disconnect" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not close connection:",
            VRGet( "CNCT_Database", "Status" )
    end
return
/*:VRX         CNCT_Database_Init
*/
CNCT_Database_Init: 
    procedure expose Globals. database_type
 
    /*  Connect to the database
    */
    ok = VRMethod( "CNCT_Database", "Connect" )
    if( ok = 0 ) then do
        message = "Could not open connection: " || VRGet("CNCT_Database","Status") || "0A"x || "0A"x ||,
                  "Please ensure that your database engine is running." 
        if (database_type = "DB2") then do
           message = message || "0A"x || "0A"x || "Make sure you have run BINDDBI.EXE on the database you intend to use." || "0A"x
        end
        call VRMessage VRWindow(), message
        call Halt
    end
return

/*:VRX         DDCB_Course_Change
*/
DDCB_Course_Change: 
    /* Refresh the query
    */

    call VRSet "Window1", "Pointer", "Wait"    

    call VRMethod "QRY_Chart_Course", "Close"
    call QRY_Chart_Course_Init

    call VRSet "Window1", "Pointer", "<default>"            
return

/*:VRX         FindSampleDB
*/
FindSampleDB: procedure
    /* Finds the location of the WATCOM SQL VX-Rexx database
    */

    vxdir = VALUE( 'vxrexx', , 'os2environment' )

    if( RIGHT(vxdir, 1) = '\' ) then do 
        vxdir = LEFT( vxdir, LENGTH(vxdir) - 1 )
    end
    
    vxdir = vxdir || "\wsample.db"
    
return vxdir
/*:VRX         Fini
*/
Fini:
    call QRY_Courses_Fini
    call QRY_Chart_Course_Fini
    call CNCT_Database_Fini

    /* Destroy the window
    */

    window = VRWindow()
    call VRSet window, "Visible", 0
    drop window
return 0













/*:VRX         Halt
*/
Halt:
    signal _VREHalt
return

/*:VRX         Init
*/
Init:
    /* Get the database type.
    */

    database_type = dbcnct( VRWindow() )

    if( database_type = "Abort" ) then do
        call Halt
    end

    /* Change the connection object according to the database type
    */

    if( database_type = "WSQL" ) then do
        call VRSet "CNCT_Database", "DataSource", "WATCOM SQL" 
        call VRSet "CNCT_Database", "userid", "dba" 
        call VRSet "CNCT_Database", "password", "sql" 

        /* Find wsample.db
        */

        fspec = FindSampleDB( )
        call VRSet "CNCT_Database", "database", fspec         

    end
    else do
        /* IBM DB2/2 database was selected.
        */

        call VRSet "CNCT_Database", "DataSource", "IBM DB2/2"    
        call VRSet "CNCT_Database", "userid", "" 
        call VRSet "CNCT_Database", "password", "" 
        call VRSet "CNCT_Database", "database", "wsample" 
    end

    /* Initialize the queries
    */

    call CNCT_Database_Init
    call QRY_Courses_Init


    /* Set the default course to the first one  */

    cur_course = VRMethod( "DDCB_Course", "GetString", 1 )
    if( LENGTH(cur_course) > 1 ) then do        
        call VRSet "DDCB_Course", "Value", cur_course 
    end

    call QRY_Chart_Course_Init

    /* Create the window
    */

    window = VRWindow()
    call VRMethod window, "CenterWindow"
    call VRSet window, "Visible", 1
    call VRMethod window, "Activate"
    drop window

return 1









/*:VRX         MI_ProdInfo_Click
*/
MI_ProdInfo_Click:
    /* Display the product information as a multiline message
       dialog.
    */

    buttons.0 = 1
    buttons.1 = "Ok"
    
    message.0 = 4
    message.1 = "Bound Chart Sample #2"
    message.2 = ""
    message.3 = "This sample application is an example"
    message.4 = "of a chart that is bound to a database."

    call VRMessageStem VRWindow(), "message.", ,
        "Product Information", "I", "buttons.", 1, 1
return

/*:VRX         QRY_Chart_Course_Fini
*/
QRY_Chart_Course_Fini:
 
    /*  Close a query
    */
    if( VRMethod( "QRY_Chart_Course", "Close" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not close query:",
            VRGet( "QRY_Chart_Course", "Status" ),,"I"
    end
return
/*:VRX         QRY_Chart_Course_Init
*/
QRY_Chart_Course_Init:
    /*  Get the current course
    */
    
    course = VRGet( "DDCB_Course", "Value" )
     
    /*  Open the query
    */
    if( VRMethod( "QRY_Chart_Course", "Open" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not open query:",
            VRGet( "QRY_Chart_Course", "Status" )
    end
return
/*:VRX         QRY_Courses_Fini
*/
QRY_Courses_Fini: 
    /*  Close a query
    */

    if( VRMethod( "QRY_Courses", "Close" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not close query:",
            VRGet( "QRY_Courses", "Status" ),,"I"
    end
return
/*:VRX         QRY_Courses_Init
*/
QRY_Courses_Init:
    /*  Open the query
    */

    if( VRMethod( "QRY_Courses", "Open" ) = 0 ) then do
        call VRMessage VRWindow(), "Could not open query:",
            VRGet( "QRY_Courses", "Status" )
    end
return
/*:VRX         Quit
*/
Quit:
    /* Close the application    
    */

    window = VRWindow()
    call VRSet window, "Shutdown", 1
    drop window
return

/*:VRX         Window1_Close
*/
Window1_Close:
    call Quit
return

