{}
{                                                       }
{      Virtual Pascal Examples. Version 1.10            }
{      Graph/VP mouse input example                     }
{      }
{      Copyright (C) 1995-96 fPrint UK Ltd              }
{                                                       }
{}

program Draw;

uses
  Use32,
{$IFDEF TEXTMODE}
  {$PMTYPE VIO}
  Crt, Graph;
{$ELSE}
  {$PMTYPE PM}
  DGraph;
{$ENDIF}

const
  EventTxt: Array[MouseEventT] of String
   = ( 'mb1Click', 'mb1DblClick', 'mb1BeginDrag', 'mb1EndDrag', 'mb1Down', 'mb1Up',
       'mb2Click', 'mb2DblClick', 'mb2BeginDrag', 'mb2EndDrag', 'mb2Down', 'mb2Up' );

procedure Drawing;
var
  x,y, LastX,LastY : Word;
  Mx, My : Word;
  StartX, StartY: Word;
  NewX, NewY: Word;
  Event: MouseEventT;
  Mouse: Boolean;
  Ch: Char;
  Dragging: Boolean;
  GotEvent: Boolean;
  Color: Word;

  procedure DrawDragRect;
  begin
    SetColor( 15 );
    SetWriteMode(XORPut);
    NewX := Mx;
    NewY := My;
    {$IFDEF TEXTMODE}
    Gotoxy( 1, WhereY );
    Write( '   Dragging to ',Newx:10,Newy:10);
    {$ENDIF}
    Rectangle( StartX, StartY, Newx, Newy );
    SetWriteMode(NormalPut);
  end;

begin
  Dragging := False;
  repeat
    if Dragging then
      begin
        GotEvent := ReadKeyOrMouse( 30, Mouse, Ch, Event, Mx, My );
        DrawDragRect;
        if not GotEvent then
          // Get mouse position
          GetMousePos( Mx, My );
      end
    else
      GotEvent := ReadKeyOrMouse( -1, Mouse, Ch, Event, Mx, My );
    if GotEvent then
      if Mouse then
        begin
          {$IFDEF TEXTMODE}
          if Dragging then
            Writeln;
          Writeln( EventTxt[Event]:15, Mx:10, My:10 );
          {$ENDIF}
          case Event of
            mb1Click: begin
              SetColor( 10 ); Circle( mx,my,20 );
            end;
            mb2Click: begin
              SetColor( 13 ); FloodFill( mx,my, 15 );
            end;
            mb1BeginDrag, mb2BeginDrag: begin
              StartX := Mx;   StartY := My;
              Dragging := True;
            end;
            mb1EndDrag: begin
              Dragging := False;
              SetColor( Random(255) );
              SetLineStyle( 0, 0, ThickWidth );
              Ellipse( (Mx+StartX) div 2, (My+StartY) div 2, 0, 360,
                       abs(Mx-StartX) div 2, abs(My-StartY) div 2 );
              SetLineStyle( 0, 0, NormWidth );
            end;
            mb2EndDrag: begin
              Dragging := False;
              Color := Random(255);
              SetColor( Color );
              SetLineStyle( 0, 0, ThickWidth );
              SetFillStyle(Random(12), Color);
              FillEllipse( (Mx+StartX) div 2, (My+StartY) div 2,
                       abs(Mx-StartX) div 2, abs(My-StartY) div 2 );
              SetLineStyle( 0, 0, NormWidth );
            end;
          end;
        end
      else
        begin
          GetMousePos( x, y );
          OutTextXY( x, y, Ch );
        end;
    if Dragging then
      DrawDragRect;
  until ( Ch = #27 );
end;

begin
//  AutoStartServer := False;
  {$IFDEF TEXTMODE}
  Writeln( 'BGI/VP mouse demo                 (C) fPrint UK Ltd 1996' );
  Writeln;
  Writeln( 'Try clicking with the mouse buttons and dragging');
  Writeln( 'with both mb1 and mb2' );
  {$ENDIF}
  VPInitGraph( 500, 400, '' );
  {$IFNDEF TEXTMODE}
  SetTextJustify( CenterText, TopText );
  OutTextXY( 250, 3, 'BGI/VP mouse demo         (C) fPrint UK Ltd 1996' );
  {$ENDIF}

  Randomize;
  Drawing;
  CloseGraph;
end.
