/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.dom.svg;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.batik.anim.values.AnimatableLengthListValue;
import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;
import org.apache.batik.dom.svg.AbstractElement;
import org.apache.batik.dom.svg.AbstractSVGAnimatedValue;
import org.apache.batik.dom.svg.AbstractSVGLengthList;
import org.apache.batik.dom.svg.AbstractSVGList;
import org.apache.batik.dom.svg.LiveAttributeException;
import org.apache.batik.dom.svg.SVGItem;
import org.apache.batik.dom.svg.SVGOMElement;
import org.apache.batik.parser.ParseException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGAnimatedLengthList;
import org.w3c.dom.svg.SVGException;
import org.w3c.dom.svg.SVGLength;
import org.w3c.dom.svg.SVGLengthList;

public class SVGOMAnimatedLengthList
extends AbstractSVGAnimatedValue
implements SVGAnimatedLengthList {
    protected BaseSVGLengthList baseVal;
    protected AnimSVGLengthList animVal;
    protected boolean changing;
    protected String defaultValue;
    protected boolean emptyAllowed;
    protected short direction;

    public SVGOMAnimatedLengthList(AbstractElement abstractElement, String string, String string2, String string3, boolean bl, short s) {
        super(abstractElement, string, string2);
        this.defaultValue = string3;
        this.emptyAllowed = bl;
        this.direction = s;
    }

    public SVGLengthList getBaseVal() {
        if (this.baseVal == null) {
            this.baseVal = new BaseSVGLengthList();
        }
        return this.baseVal;
    }

    public SVGLengthList getAnimVal() {
        if (this.animVal == null) {
            this.animVal = new AnimSVGLengthList();
        }
        return this.animVal;
    }

    public void check() {
        if (!this.hasAnimVal) {
            if (this.baseVal == null) {
                this.baseVal = new BaseSVGLengthList();
            }
            this.baseVal.revalidate();
            if (this.baseVal.missing) {
                throw new LiveAttributeException((Element)((Object)this.element), this.localName, 0, null);
            }
            if (this.baseVal.malformed) {
                throw new LiveAttributeException((Element)((Object)this.element), this.localName, 1, this.baseVal.getValueAsString());
            }
        }
    }

    public AnimatableValue getUnderlyingValue(AnimationTarget animationTarget) {
        SVGLengthList sVGLengthList = this.getBaseVal();
        int n = sVGLengthList.getNumberOfItems();
        short[] sArray = new short[n];
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            SVGLength sVGLength = sVGLengthList.getItem(i);
            sArray[i] = sVGLength.getUnitType();
            fArray[i] = sVGLength.getValueInSpecifiedUnits();
        }
        return new AnimatableLengthListValue(animationTarget, sArray, fArray, animationTarget.getPercentageInterpretation(this.getNamespaceURI(), this.getLocalName(), false));
    }

    protected void updateAnimatedValue(AnimatableValue animatableValue) {
        if (animatableValue == null) {
            this.hasAnimVal = false;
        } else {
            this.hasAnimVal = true;
            AnimatableLengthListValue animatableLengthListValue = (AnimatableLengthListValue)animatableValue;
            if (this.animVal == null) {
                this.animVal = new AnimSVGLengthList();
            }
            this.animVal.setAnimatedValue(animatableLengthListValue.getLengthTypes(), animatableLengthListValue.getLengthValues());
        }
        this.fireAnimatedAttributeListeners();
    }

    public void attrAdded(Attr attr, String string) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrModified(Attr attr, String string, String string2) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    public void attrRemoved(Attr attr, String string) {
        if (!this.changing && this.baseVal != null) {
            this.baseVal.invalidate();
        }
        this.fireBaseAttributeListeners();
        if (!this.hasAnimVal) {
            this.fireAnimatedAttributeListeners();
        }
    }

    protected class AnimSVGLengthList
    extends AbstractSVGLengthList {
        public AnimSVGLengthList() {
            super(SVGOMAnimatedLengthList.this.direction);
            this.itemList = new ArrayList(1);
        }

        protected DOMException createDOMException(short s, String string, Object[] objectArray) {
            return SVGOMAnimatedLengthList.this.element.createDOMException(s, string, objectArray);
        }

        protected SVGException createSVGException(short s, String string, Object[] objectArray) {
            return ((SVGOMElement)SVGOMAnimatedLengthList.this.element).createSVGException(s, string, objectArray);
        }

        protected Element getElement() {
            return SVGOMAnimatedLengthList.this.element;
        }

        public int getNumberOfItems() {
            if (SVGOMAnimatedLengthList.this.hasAnimVal) {
                return super.getNumberOfItems();
            }
            return SVGOMAnimatedLengthList.this.getBaseVal().getNumberOfItems();
        }

        public SVGLength getItem(int n) throws DOMException {
            if (SVGOMAnimatedLengthList.this.hasAnimVal) {
                return super.getItem(n);
            }
            return SVGOMAnimatedLengthList.this.getBaseVal().getItem(n);
        }

        protected String getValueAsString() {
            if (this.itemList.size() == 0) {
                return "";
            }
            StringBuffer stringBuffer = new StringBuffer(this.itemList.size() * 8);
            Iterator iterator = this.itemList.iterator();
            if (iterator.hasNext()) {
                stringBuffer.append(((SVGItem)iterator.next()).getValueAsString());
            }
            while (iterator.hasNext()) {
                stringBuffer.append(this.getItemSeparator());
                stringBuffer.append(((SVGItem)iterator.next()).getValueAsString());
            }
            return stringBuffer.toString();
        }

        protected void setAttributeValue(String string) {
        }

        public void clear() throws DOMException {
            throw SVGOMAnimatedLengthList.this.element.createDOMException((short)7, "readonly.length.list", null);
        }

        public SVGLength initialize(SVGLength sVGLength) throws DOMException, SVGException {
            throw SVGOMAnimatedLengthList.this.element.createDOMException((short)7, "readonly.length.list", null);
        }

        public SVGLength insertItemBefore(SVGLength sVGLength, int n) throws DOMException, SVGException {
            throw SVGOMAnimatedLengthList.this.element.createDOMException((short)7, "readonly.length.list", null);
        }

        public SVGLength replaceItem(SVGLength sVGLength, int n) throws DOMException, SVGException {
            throw SVGOMAnimatedLengthList.this.element.createDOMException((short)7, "readonly.length.list", null);
        }

        public SVGLength removeItem(int n) throws DOMException {
            throw SVGOMAnimatedLengthList.this.element.createDOMException((short)7, "readonly.length.list", null);
        }

        public SVGLength appendItem(SVGLength sVGLength) throws DOMException {
            throw SVGOMAnimatedLengthList.this.element.createDOMException((short)7, "readonly.length.list", null);
        }

        protected void setAnimatedValue(short[] sArray, float[] fArray) {
            int n;
            int n2 = this.itemList.size();
            for (n = 0; n < n2 && n < sArray.length; ++n) {
                AbstractSVGLengthList.SVGLengthItem sVGLengthItem = (AbstractSVGLengthList.SVGLengthItem)this.itemList.get(n);
                sVGLengthItem.unitType = sArray[n];
                sVGLengthItem.value = fArray[n];
                sVGLengthItem.direction = this.direction;
            }
            while (n < sArray.length) {
                this.appendItemImpl(new AbstractSVGLengthList.SVGLengthItem(sArray[n], fArray[n], this.direction));
                ++n;
            }
            while (n2 > sArray.length) {
                this.removeItemImpl(--n2);
            }
        }

        protected void resetAttribute() {
        }

        protected void resetAttribute(SVGItem sVGItem) {
        }

        protected void revalidate() {
            this.valid = true;
        }
    }

    public class BaseSVGLengthList
    extends AbstractSVGLengthList {
        protected boolean missing;
        protected boolean malformed;

        public BaseSVGLengthList() {
            super(SVGOMAnimatedLengthList.this.direction);
        }

        protected DOMException createDOMException(short s, String string, Object[] objectArray) {
            return SVGOMAnimatedLengthList.this.element.createDOMException(s, string, objectArray);
        }

        protected SVGException createSVGException(short s, String string, Object[] objectArray) {
            return ((SVGOMElement)SVGOMAnimatedLengthList.this.element).createSVGException(s, string, objectArray);
        }

        protected Element getElement() {
            return SVGOMAnimatedLengthList.this.element;
        }

        protected String getValueAsString() {
            Attr attr = SVGOMAnimatedLengthList.this.element.getAttributeNodeNS(SVGOMAnimatedLengthList.this.namespaceURI, SVGOMAnimatedLengthList.this.localName);
            if (attr == null) {
                return SVGOMAnimatedLengthList.this.defaultValue;
            }
            return attr.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setAttributeValue(String string) {
            try {
                SVGOMAnimatedLengthList.this.changing = true;
                SVGOMAnimatedLengthList.this.element.setAttributeNS(SVGOMAnimatedLengthList.this.namespaceURI, SVGOMAnimatedLengthList.this.localName, string);
            }
            finally {
                SVGOMAnimatedLengthList.this.changing = false;
            }
        }

        protected void resetAttribute() {
            super.resetAttribute();
            this.missing = false;
            this.malformed = false;
        }

        protected void resetAttribute(SVGItem sVGItem) {
            super.resetAttribute(sVGItem);
            this.missing = false;
            this.malformed = false;
        }

        protected void revalidate() {
            boolean bl;
            if (this.valid) {
                return;
            }
            this.valid = true;
            this.missing = false;
            this.malformed = false;
            String string = this.getValueAsString();
            boolean bl2 = bl = string != null && string.length() == 0;
            if (string == null || bl && !SVGOMAnimatedLengthList.this.emptyAllowed) {
                this.missing = true;
                return;
            }
            if (bl) {
                this.itemList = new ArrayList(1);
            } else {
                try {
                    AbstractSVGList.ListBuilder listBuilder = new AbstractSVGList.ListBuilder();
                    this.doParse(string, listBuilder);
                    if (listBuilder.getList() != null) {
                        this.clear(this.itemList);
                    }
                    this.itemList = listBuilder.getList();
                }
                catch (ParseException parseException) {
                    this.itemList = new ArrayList(1);
                    this.valid = true;
                    this.malformed = true;
                }
            }
        }
    }
}

