/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.font;

import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.batik.gvt.font.AWTFontFamily;
import org.apache.batik.gvt.font.AWTGVTFont;
import org.apache.batik.gvt.font.GVTFontFamily;
import org.apache.batik.gvt.font.UnresolvedFontFamily;

public class FontFamilyResolver {
    public static final AWTFontFamily defaultFont;
    protected static final Map fonts;
    protected static final List awtFontFamilies;
    protected static final List awtFonts;
    protected static final Map resolvedFontFamilies;

    public static String lookup(String string) {
        return (String)fonts.get(string.toLowerCase());
    }

    public static GVTFontFamily resolve(String string) {
        GVTFontFamily gVTFontFamily = (GVTFontFamily)resolvedFontFamilies.get(string = string.toLowerCase());
        if (gVTFontFamily == null) {
            String string2 = (String)fonts.get(string);
            if (string2 != null) {
                gVTFontFamily = new AWTFontFamily(string2);
            }
            resolvedFontFamilies.put(string, gVTFontFamily);
        }
        return gVTFontFamily;
    }

    public static GVTFontFamily resolve(UnresolvedFontFamily unresolvedFontFamily) {
        return FontFamilyResolver.resolve(unresolvedFontFamily.getFamilyName());
    }

    public static GVTFontFamily getFamilyThatCanDisplay(char c) {
        for (int i = 0; i < awtFontFamilies.size(); ++i) {
            AWTFontFamily aWTFontFamily = (AWTFontFamily)awtFontFamilies.get(i);
            AWTGVTFont aWTGVTFont = (AWTGVTFont)awtFonts.get(i);
            if (!aWTGVTFont.canDisplay(c) || aWTFontFamily.getFamilyName().indexOf("Song") != -1) continue;
            return aWTFontFamily;
        }
        return null;
    }

    static {
        Object object;
        defaultFont = new AWTFontFamily("SansSerif");
        fonts = new HashMap();
        awtFontFamilies = new ArrayList();
        awtFonts = new ArrayList();
        fonts.put("sans-serif", "SansSerif");
        fonts.put("serif", "Serif");
        fonts.put("times", "Serif");
        fonts.put("times new roman", "Serif");
        fonts.put("cursive", "Dialog");
        fonts.put("fantasy", "Symbol");
        fonts.put("monospace", "Monospaced");
        fonts.put("monospaced", "Monospaced");
        fonts.put("courier", "Monospaced");
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        int n = stringArray != null ? stringArray.length : 0;
        for (int i = 0; i < n; ++i) {
            fonts.put(stringArray[i].toLowerCase(), stringArray[i]);
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i]);
            object = "";
            while (stringTokenizer.hasMoreTokens()) {
                object = (String)object + stringTokenizer.nextToken();
            }
            fonts.put(((String)object).toLowerCase(), stringArray[i]);
            String string = stringArray[i].replace(' ', '-');
            if (string.equals(stringArray[i])) continue;
            fonts.put(string.toLowerCase(), stringArray[i]);
        }
        Font[] fontArray = graphicsEnvironment.getAllFonts();
        for (int i = 0; i < fontArray.length; ++i) {
            object = fontArray[i];
            fonts.put(((Font)object).getFontName().toLowerCase(), ((Font)object).getFontName());
        }
        awtFontFamilies.add(defaultFont);
        awtFonts.add(new AWTGVTFont(defaultFont.getFamilyName(), 0, 12));
        Collection collection = fonts.values();
        for (String string : collection) {
            AWTFontFamily aWTFontFamily = new AWTFontFamily(string);
            awtFontFamilies.add(aWTFontFamily);
            AWTGVTFont aWTGVTFont = new AWTGVTFont(string, 0, 12);
            awtFonts.add(aWTGVTFont);
        }
        resolvedFontFamilies = new HashMap();
    }
}

