/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.search;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.SearchPredicate;
import org.jdesktop.swingx.search.AbstractSearchable;

public class TableSearchable
extends AbstractSearchable {
    protected JXTable table;
    private AbstractHighlighter matchHighlighter;

    public TableSearchable(JXTable table) {
        this.table = table;
    }

    protected void findMatchAndUpdateState(Pattern pattern, int startRow, boolean backwards) {
        AbstractSearchable.SearchResult matchRow = null;
        if (backwards) {
            for (int r = startRow; r >= -1 && matchRow == null; --r) {
                matchRow = this.findMatchBackwardsInRow(pattern, r);
                this.updateState(matchRow);
            }
        } else {
            for (int r = startRow; r <= this.getSize() && matchRow == null; ++r) {
                matchRow = this.findMatchForwardInRow(pattern, r);
                this.updateState(matchRow);
            }
        }
    }

    protected AbstractSearchable.SearchResult findExtendedMatch(Pattern pattern, int row) {
        return this.findMatchAt(pattern, row, this.lastSearchResult.foundColumn);
    }

    private AbstractSearchable.SearchResult findMatchForwardInRow(Pattern pattern, int row) {
        int startColumn;
        int n = startColumn = this.lastSearchResult.foundColumn < 0 ? 0 : this.lastSearchResult.foundColumn;
        if (this.isValidIndex(row)) {
            for (int column = startColumn; column < this.table.getColumnCount(); ++column) {
                AbstractSearchable.SearchResult result = this.findMatchAt(pattern, row, column);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private AbstractSearchable.SearchResult findMatchBackwardsInRow(Pattern pattern, int row) {
        int startColumn;
        int n = startColumn = this.lastSearchResult.foundColumn < 0 ? this.table.getColumnCount() - 1 : this.lastSearchResult.foundColumn;
        if (this.isValidIndex(row)) {
            for (int column = startColumn; column >= 0; --column) {
                AbstractSearchable.SearchResult result = this.findMatchAt(pattern, row, column);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    protected AbstractSearchable.SearchResult findMatchAt(Pattern pattern, int row, int column) {
        Matcher matcher;
        String text = this.table.getStringAt(row, column);
        if (text != null && text.length() > 0 && (matcher = pattern.matcher(text)).find()) {
            return this.createSearchResult(matcher, row, column);
        }
        return null;
    }

    protected int adjustStartPosition(int startIndex, boolean backwards) {
        this.lastSearchResult.foundColumn = -1;
        return super.adjustStartPosition(startIndex, backwards);
    }

    protected int moveStartPosition(int startRow, boolean backwards) {
        if (backwards) {
            --this.lastSearchResult.foundColumn;
            if (this.lastSearchResult.foundColumn < 0) {
                --startRow;
            }
        } else {
            ++this.lastSearchResult.foundColumn;
            if (this.lastSearchResult.foundColumn >= this.table.getColumnCount()) {
                this.lastSearchResult.foundColumn = -1;
                ++startRow;
            }
        }
        return startRow;
    }

    protected boolean isEqualStartIndex(int startIndex) {
        return super.isEqualStartIndex(startIndex) && this.isValidColumn(this.lastSearchResult.foundColumn);
    }

    private boolean isValidColumn(int column) {
        return column >= 0 && column < this.table.getColumnCount();
    }

    protected int getSize() {
        return this.table.getRowCount();
    }

    protected void moveMatchByHighlighter() {
        AbstractHighlighter searchHL = this.getConfiguredMatchHighlighter();
        if (!this.hasMatch(this.lastSearchResult)) {
            return;
        }
        this.ensureInsertedSearchHighlighters(searchHL);
        Rectangle cellRect = this.table.getCellRect(this.lastSearchResult.foundRow, this.lastSearchResult.foundColumn, true);
        if (cellRect != null) {
            this.table.scrollRectToVisible(cellRect);
        }
    }

    protected AbstractHighlighter getConfiguredMatchHighlighter() {
        AbstractHighlighter searchHL = this.getMatchHighlighter();
        HighlightPredicate predicate = HighlightPredicate.NEVER;
        if (this.hasMatch(this.lastSearchResult)) {
            predicate = new SearchPredicate(this.lastSearchResult.pattern, this.lastSearchResult.foundRow, this.table.convertColumnIndexToModel(this.lastSearchResult.foundColumn));
        }
        searchHL.setHighlightPredicate(predicate);
        return searchHL;
    }

    protected boolean hasMatch(AbstractSearchable.SearchResult result) {
        boolean noMatch = result.getFoundRow() < 0 || result.getFoundColumn() < 0;
        return !noMatch;
    }

    protected void moveMatchBySelection() {
        Rectangle cellRect;
        if (!this.hasMatch(this.lastSearchResult)) {
            return;
        }
        int row = this.lastSearchResult.foundRow;
        int column = this.lastSearchResult.foundColumn;
        this.table.changeSelection(row, column, false, false);
        if (!this.table.getAutoscrolls() && (cellRect = this.table.getCellRect(row, column, true)) != null) {
            this.table.scrollRectToVisible(cellRect);
        }
    }

    protected void moveMatchMarker() {
        if (this.markByHighlighter()) {
            this.moveMatchByHighlighter();
        } else {
            this.moveMatchBySelection();
        }
    }

    protected boolean markByHighlighter() {
        return Boolean.TRUE.equals(this.table.getClientProperty("match.highlighter"));
    }

    private void ensureInsertedSearchHighlighters(Highlighter highlighter) {
        if (!this.isInPipeline(highlighter)) {
            this.table.addHighlighter(highlighter);
        }
    }

    private boolean isInPipeline(Highlighter searchHighlighter) {
        Highlighter[] inPipeline = this.table.getHighlighters();
        if (inPipeline.length > 0 && searchHighlighter.equals(inPipeline[inPipeline.length - 1])) {
            return true;
        }
        this.table.removeHighlighter(searchHighlighter);
        return false;
    }

    protected AbstractHighlighter getMatchHighlighter() {
        if (this.matchHighlighter == null) {
            this.matchHighlighter = this.createMatchHighlighter();
        }
        return this.matchHighlighter;
    }

    protected AbstractHighlighter createMatchHighlighter() {
        return new ColorHighlighter(HighlightPredicate.NEVER, Color.YELLOW.brighter(), null, Color.YELLOW.brighter(), null);
    }
}

