/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.FilterPipeline;
import org.jdesktop.swingx.decorator.SelectionMapper;
import org.jdesktop.swingx.rollover.RolloverProducer;
import org.jdesktop.swingx.rollover.RolloverRenderer;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableCellEditor;
import org.jdesktop.swingx.treetable.TreeTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXTreeTable
extends JXTable {
    private static final Logger LOG = Logger.getLogger(JXTreeTable.class.getName());
    public static final String DRAG_HACK_FLAG_KEY = "treeTable.dragHackFlag";
    public static final String DROP_HACK_FLAG_KEY = "treeTable.dropHackFlag";
    private TreeTableCellRenderer renderer;
    private TreeTableCellEditor hierarchicalEditor;
    private TreeTableHacker treeTableHacker;
    private boolean consumedOnPress;

    public JXTreeTable() {
        this(new DefaultTreeTableModel());
    }

    public JXTreeTable(TreeTableModel treeModel) {
        this(new TreeTableCellRenderer(treeModel));
    }

    private JXTreeTable(TreeTableCellRenderer renderer) {
        super(new TreeTableModelAdapter(renderer));
        this.init(renderer);
        this.initActions();
        super.setSortable(false);
        this.setShowGrid(false, false);
        this.hierarchicalEditor = new TreeTableCellEditor(renderer);
    }

    private void init(TreeTableCellRenderer renderer) {
        this.renderer = renderer;
        assert (((TreeTableModelAdapter)this.getModel()).tree == this.renderer);
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        if (renderer != null) {
            renderer.bind(this);
            renderer.setSelectionModel(selectionWrapper);
        }
        this.adjustTreeRowHeight(this.getRowHeight());
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        PropertyChangeListener l = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JXTreeTable.this.renderer.putClientProperty(evt.getPropertyName(), evt.getNewValue());
            }
        };
        this.addPropertyChangeListener("JTree.lineStyle", l);
    }

    private void initActions() {
        ActionMap map = this.getActionMap();
        map.put("expand-all", new Actions("expand-all"));
        map.put("collapse-all", new Actions("collapse-all"));
    }

    @Override
    public void setSortable(boolean sortable) {
    }

    @Override
    public void setFilters(FilterPipeline pipeline) {
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.renderer.setEnabled(enabled);
        super.setEnabled(enabled);
    }

    @Override
    public void setSelectionBackground(Color selectionBackground) {
        if (this.renderer != null) {
            this.renderer.setSelectionBackground(selectionBackground);
        }
        super.setSelectionBackground(selectionBackground);
    }

    @Override
    public void setSelectionForeground(Color selectionForeground) {
        if (this.renderer != null) {
            this.renderer.setSelectionForeground(selectionForeground);
        }
        super.setSelectionForeground(selectionForeground);
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        this.getTreeTableHacker().hitHandleDetectionFromEditCell(column, e);
        boolean canEdit = super.editCellAt(row, column, e);
        if (canEdit && this.isHierarchical(column)) {
            this.repaint(this.getCellRect(row, column, false));
        }
        return canEdit;
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (e.getID() == 502 && this.consumedOnPress) {
            this.consumedOnPress = false;
            e.consume();
            return;
        }
        if (this.getTreeTableHacker().hitHandleDetectionFromProcessMouse(e)) {
            this.consumedOnPress = true;
            e.consume();
            return;
        }
        this.consumedOnPress = false;
        super.processMouseEvent(e);
    }

    protected TreeTableHacker getTreeTableHacker() {
        if (this.treeTableHacker == null) {
            this.treeTableHacker = this.createTreeTableHacker();
        }
        return this.treeTableHacker;
    }

    protected TreeTableHacker createTreeTableHacker() {
        return new TreeTableHackerExt();
    }

    protected boolean hackAroundDragEnabled(MouseEvent me) {
        Boolean dragHackFlag = (Boolean)this.getClientProperty(DRAG_HACK_FLAG_KEY);
        if (dragHackFlag == null) {
            String priority = null;
            try {
                priority = System.getProperty("sun.swing.enableImprovedDragGesture");
            }
            catch (Exception ex) {
                // empty catch block
            }
            dragHackFlag = priority == null;
            this.putClientProperty(DRAG_HACK_FLAG_KEY, dragHackFlag);
        }
        return this.getDragEnabled() && dragHackFlag != false;
    }

    @Override
    public int getEditingRow() {
        return this.isHierarchical(this.editingColumn) ? -1 : this.editingRow;
    }

    private int realEditingRow() {
        return this.editingRow;
    }

    public void setTreeTableModel(TreeTableModel treeModel) {
        TreeTableModel old = this.getTreeTableModel();
        this.renderer.setModel(treeModel);
        this.firePropertyChange("treeTableModel", old, this.getTreeTableModel());
    }

    public TreeTableModel getTreeTableModel() {
        return (TreeTableModel)this.renderer.getModel();
    }

    @Override
    public final void setModel(TableModel tableModel) {
        if (tableModel instanceof TreeTableModelAdapter) {
            if (((TreeTableModelAdapter)tableModel).getTreeTable() != null) {
                throw new IllegalArgumentException("model already bound");
            }
        } else {
            throw new IllegalArgumentException("unsupported model type");
        }
        super.setModel(tableModel);
        ((TreeTableModelAdapter)tableModel).bind(this);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.isStructureChanged(e) || this.isUpdate(e)) {
            super.tableChanged(e);
        } else {
            this.resizeAndRepaint();
        }
    }

    @Override
    public SelectionMapper getSelectionMapper() {
        if (this.selectionMapper == null) {
            this.selectionMapper = this.createSelectionMapper();
        }
        return this.selectionMapper;
    }

    protected SelectionMapper createSelectionMapper() {
        SelectionMapper mapper = new SelectionMapper(){
            private ListSelectionModel viewSelectionModel = new DefaultListSelectionModel();

            public ListSelectionModel getViewSelectionModel() {
                return this.viewSelectionModel;
            }

            public void setViewSelectionModel(ListSelectionModel viewSelectionModel) {
                this.viewSelectionModel = viewSelectionModel;
            }

            public void setFilters(FilterPipeline pipeline) {
            }

            public void insertIndexInterval(int start, int length, boolean before) {
            }

            public void removeIndexInterval(int start, int end) {
            }

            public void setEnabled(boolean enabled) {
            }

            public boolean isEnabled() {
                return false;
            }

            public void clearModelSelection() {
            }
        };
        return mapper;
    }

    @Override
    public final void setRowHeight(int row, int rowHeight) {
        throw new UnsupportedOperationException("variable height rows not supported");
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        this.adjustTreeRowHeight(this.getRowHeight());
    }

    protected void adjustTreeRowHeight(int tableRowHeight) {
        if (this.renderer != null && this.renderer.getRowHeight() != tableRowHeight) {
            this.renderer.setRowHeight(tableRowHeight);
        }
    }

    protected void adjustTableRowHeight(int treeRowHeight) {
        if (this.getRowHeight() != treeRowHeight) {
            this.adminSetRowHeight(treeRowHeight);
        }
    }

    @Override
    public void setSelectionMode(int mode) {
        if (this.renderer != null) {
            switch (mode) {
                case 1: {
                    this.renderer.getSelectionModel().setSelectionMode(2);
                    break;
                }
                case 2: {
                    this.renderer.getSelectionModel().setSelectionMode(4);
                    break;
                }
                default: {
                    this.renderer.getSelectionModel().setSelectionMode(1);
                }
            }
        }
        super.setSelectionMode(mode);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component component = super.prepareRenderer(renderer, row, column);
        return this.applyRenderer(component, this.getComponentAdapter(row, column));
    }

    protected Component applyRenderer(Component component, ComponentAdapter adapter) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (adapter == null) {
            throw new IllegalArgumentException("null component data adapter");
        }
        if (this.isHierarchical(adapter.column)) {
            TreeCellRenderer tcr = this.renderer.getCellRenderer();
            if (tcr instanceof JXTree.DelegatingRenderer) {
                tcr = ((JXTree.DelegatingRenderer)tcr).getDelegateRenderer();
            }
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                if (adapter.isSelected()) {
                    dtcr.setTextSelectionColor(component.getForeground());
                    dtcr.setBackgroundSelectionColor(component.getBackground());
                } else {
                    dtcr.setTextNonSelectionColor(component.getForeground());
                    dtcr.setBackgroundNonSelectionColor(component.getBackground());
                }
            }
        }
        return component;
    }

    public void setTreeCellRenderer(TreeCellRenderer cellRenderer) {
        if (this.renderer != null) {
            this.renderer.setCellRenderer(cellRenderer);
        }
    }

    public TreeCellRenderer getTreeCellRenderer() {
        return this.renderer.getCellRenderer();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int column = this.columnAtPoint(event.getPoint());
        if (this.isHierarchical(column)) {
            int row = this.rowAtPoint(event.getPoint());
            return this.renderer.getToolTipText(event, row, column);
        }
        return super.getToolTipText(event);
    }

    public void setCollapsedIcon(Icon icon) {
        this.renderer.setCollapsedIcon(icon);
    }

    public void setExpandedIcon(Icon icon) {
        this.renderer.setExpandedIcon(icon);
    }

    public void setOpenIcon(Icon icon) {
        this.renderer.setOpenIcon(icon);
    }

    public void setClosedIcon(Icon icon) {
        this.renderer.setClosedIcon(icon);
    }

    public void setLeafIcon(Icon icon) {
        this.renderer.setLeafIcon(icon);
    }

    public void setOverwriteRendererIcons(boolean overwrite) {
        this.renderer.setOverwriteRendererIcons(overwrite);
    }

    public boolean isOverwriteRendererIcons() {
        return this.renderer.isOverwriteRendererIcons();
    }

    @Override
    public void clearSelection() {
        if (this.renderer != null) {
            this.renderer.clearSelection();
        }
        super.clearSelection();
    }

    public void collapseAll() {
        this.renderer.collapseAll();
    }

    public void expandAll() {
        this.renderer.expandAll();
    }

    public void collapsePath(TreePath path) {
        this.renderer.collapsePath(path);
    }

    public void expandPath(TreePath path) {
        this.renderer.expandPath(path);
    }

    public void scrollPathToVisible(TreePath path) {
        this.renderer.scrollPathToVisible(path);
    }

    public void collapseRow(int row) {
        this.renderer.collapseRow(row);
    }

    public void expandRow(int row) {
        this.renderer.expandRow(row);
    }

    public boolean isVisible(TreePath path) {
        return this.renderer.isVisible(path);
    }

    public boolean isExpanded(TreePath path) {
        return this.renderer.isExpanded(path);
    }

    public boolean isExpanded(int row) {
        return this.renderer.isExpanded(row);
    }

    public boolean isCollapsed(TreePath path) {
        return this.renderer.isCollapsed(path);
    }

    public boolean isCollapsed(int row) {
        return this.renderer.isCollapsed(row);
    }

    public Enumeration<?> getExpandedDescendants(TreePath parent) {
        return this.renderer.getExpandedDescendants(parent);
    }

    public TreePath getPathForLocation(int x, int y) {
        int row = this.rowAtPoint(new Point(x, y));
        if (row == -1) {
            return null;
        }
        return this.renderer.getPathForRow(row);
    }

    public TreePath getPathForRow(int row) {
        return this.renderer.getPathForRow(row);
    }

    public int getRowForPath(TreePath path) {
        return this.renderer.getRowForPath(path);
    }

    public void setRootVisible(boolean visible) {
        this.renderer.setRootVisible(visible);
        this.revalidate();
        this.repaint();
    }

    public boolean isRootVisible() {
        return this.renderer.isRootVisible();
    }

    public void setScrollsOnExpand(boolean scroll) {
        this.renderer.setScrollsOnExpand(scroll);
    }

    public boolean getScrollsOnExpand() {
        return this.renderer.getScrollsOnExpand();
    }

    public void setShowsRootHandles(boolean visible) {
        this.renderer.setShowsRootHandles(visible);
        this.repaint();
    }

    public boolean getShowsRootHandles() {
        return this.renderer.getShowsRootHandles();
    }

    public void setExpandsSelectedPaths(boolean expand) {
        this.renderer.setExpandsSelectedPaths(expand);
    }

    public boolean getExpandsSelectedPaths() {
        return this.renderer.getExpandsSelectedPaths();
    }

    public int getToggleClickCount() {
        return this.renderer.getToggleClickCount();
    }

    public void setToggleClickCount(int clickCount) {
        this.renderer.setToggleClickCount(clickCount);
    }

    public boolean isLargeModel() {
        return this.renderer.isLargeModel();
    }

    public void setLargeModel(boolean newValue) {
        this.renderer.setLargeModel(newValue);
    }

    public void addTreeExpansionListener(TreeExpansionListener tel) {
        this.renderer.addTreeExpansionListener(tel);
    }

    public void removeTreeExpansionListener(TreeExpansionListener tel) {
        this.renderer.removeTreeExpansionListener(tel);
    }

    public void addTreeSelectionListener(TreeSelectionListener tsl) {
        this.renderer.addTreeSelectionListener(tsl);
    }

    public void removeTreeSelectionListener(TreeSelectionListener tsl) {
        this.renderer.removeTreeSelectionListener(tsl);
    }

    public void addTreeWillExpandListener(TreeWillExpandListener tel) {
        this.renderer.addTreeWillExpandListener(tel);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener tel) {
        this.renderer.removeTreeWillExpandListener(tel);
    }

    public TreeSelectionModel getTreeSelectionModel() {
        return this.renderer.getSelectionModel();
    }

    @Override
    public void sizeColumnsToFit(int resizingColumn) {
        super.sizeColumnsToFit(resizingColumn);
        if (this.getEditingColumn() != -1 && this.isHierarchical(this.editingColumn)) {
            Rectangle cellRect = this.getCellRect(this.realEditingRow(), this.getEditingColumn(), false);
            Component component = this.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        }
    }

    public boolean isHierarchical(int column) {
        if (column < 0 || column >= this.getColumnCount()) {
            throw new IllegalArgumentException("column must be valid, was" + column);
        }
        return this.getHierarchicalColumn() == column;
    }

    public int getHierarchicalColumn() {
        return this.convertColumnIndexToView(((TreeTableModel)this.renderer.getModel()).getHierarchicalColumn());
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        if (this.isHierarchical(column)) {
            return this.renderer;
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (this.isHierarchical(column)) {
            return this.hierarchicalEditor;
        }
        return super.getCellEditor(row, column);
    }

    @Override
    public String getStringAt(int row, int column) {
        if (this.isHierarchical(column)) {
            return this.getHierarchicalStringAt(row);
        }
        return super.getStringAt(row, column);
    }

    private String getHierarchicalStringAt(int row) {
        return this.renderer.getStringAt(row);
    }

    @Override
    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new TreeTableDataAdapter(this);
        }
        return this.dataAdapter;
    }

    protected static class TreeTableDataAdapter
    extends JXTable.TableAdapter {
        private final JXTreeTable table;

        public TreeTableDataAdapter(JXTreeTable component) {
            super(component);
            this.table = component;
        }

        public JXTreeTable getTreeTable() {
            return this.table;
        }

        public boolean isExpanded() {
            return this.table.isExpanded(this.row);
        }

        public int getDepth() {
            return this.table.getPathForRow(this.row).getPathCount() - 1;
        }

        public boolean isLeaf() {
            TreePath path = this.table.getPathForRow(this.row);
            if (path != null) {
                return this.table.getTreeTableModel().isLeaf(path.getLastPathComponent());
            }
            return true;
        }

        public boolean isHierarchical() {
            return this.table.isHierarchical(this.column);
        }

        public String getFilteredStringAt(int row, int column) {
            if (this.table.getTreeTableModel().getHierarchicalColumn() == column && this.modelToView(column) < 0) {
                return this.table.getHierarchicalStringAt(row);
            }
            return super.getFilteredStringAt(row, column);
        }

        public String getStringAt(int row, int column) {
            if (this.table.getTreeTableModel().getHierarchicalColumn() == column && this.modelToView(column) < 0) {
                return this.table.getHierarchicalStringAt(row);
            }
            return super.getStringAt(row, column);
        }
    }

    static class TreeTableCellRenderer
    extends JXTree
    implements TableCellRenderer {
        private PropertyChangeListener rolloverListener;
        protected Border highlightBorder = null;
        protected JXTreeTable treeTable = null;
        protected int visibleRow = 0;
        private int hierarchicalColumnWidth = 0;

        public TreeTableCellRenderer(TreeTableModel model) {
            super(model);
            this.putClientProperty("JTree.lineStyle", "None");
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
            this.setCellRenderer(new ClippedTreeCellRenderer());
        }

        public boolean isVisible() {
            return this.shouldApplyDropHack() ? false : super.isVisible();
        }

        protected boolean shouldApplyDropHack() {
            return !Boolean.FALSE.equals(this.treeTable.getClientProperty(JXTreeTable.DROP_HACK_FLAG_KEY));
        }

        private String getToolTipText(MouseEvent event, int row, int column) {
            TreePath path;
            Object lastPath;
            if (row < 0) {
                return null;
            }
            String toolTip = null;
            TreeCellRenderer renderer = this.getCellRenderer();
            Component rComponent = renderer.getTreeCellRendererComponent(this, lastPath = (path = this.getPathForRow(row)).getLastPathComponent(), this.isRowSelected(row), this.isExpanded(row), this.getModel().isLeaf(lastPath), row, true);
            if (rComponent instanceof JComponent) {
                Rectangle pathBounds = this.getPathBounds(path);
                Rectangle cellRect = this.treeTable.getCellRect(row, column, false);
                Point mousePoint = event.getPoint();
                mousePoint.translate(-cellRect.x, -cellRect.y);
                mousePoint.translate(-pathBounds.x, 0);
                MouseEvent newEvent = new MouseEvent(rComponent, event.getID(), event.getWhen(), event.getModifiers(), mousePoint.x, mousePoint.y, event.getClickCount(), event.isPopupTrigger());
                toolTip = ((JComponent)rComponent).getToolTipText(newEvent);
            }
            if (toolTip != null) {
                return toolTip;
            }
            return this.getToolTipText();
        }

        public void setToolTipText(String text) {
            this.putClientProperty("ToolTipText", text);
        }

        public final void bind(JXTreeTable treeTable) {
            if (treeTable == null) {
                throw new IllegalArgumentException("null treeTable");
            }
            if (this.treeTable != null) {
                throw new IllegalArgumentException("renderer already bound");
            }
            this.treeTable = treeTable;
        }

        private void bindRollover() {
            this.setRolloverEnabled(this.treeTable.isRolloverEnabled());
            this.treeTable.addPropertyChangeListener(this.getRolloverListener());
        }

        private PropertyChangeListener getRolloverListener() {
            if (this.rolloverListener == null) {
                this.rolloverListener = this.createRolloverListener();
            }
            return this.rolloverListener;
        }

        protected PropertyChangeListener createRolloverListener() {
            PropertyChangeListener l = new PropertyChangeListener(){
                Point rollover = new Point(-1, -1);

                public void propertyChange(PropertyChangeEvent evt) {
                    if (TreeTableCellRenderer.this.treeTable == null || TreeTableCellRenderer.this.treeTable != evt.getSource()) {
                        return;
                    }
                    if ("rolloverEnabled".equals(evt.getPropertyName())) {
                        TreeTableCellRenderer.this.setRolloverEnabled((Boolean)evt.getNewValue());
                    }
                    if ("swingx.rollover".equals(evt.getPropertyName())) {
                        this.rollover(evt);
                    }
                }

                private void rollover(PropertyChangeEvent evt) {
                    boolean isHierarchical = this.isHierarchical((Point)evt.getNewValue());
                    TreeTableCellRenderer.this.putClientProperty(evt.getPropertyName(), isHierarchical ? new Point((Point)evt.getNewValue()) : null);
                }

                private boolean isHierarchical(Point point) {
                    int column;
                    if (point != null && (column = point.x) >= 0) {
                        return TreeTableCellRenderer.this.treeTable.isHierarchical(column);
                    }
                    return false;
                }
            };
            return l;
        }

        protected RolloverProducer createRolloverProducer() {
            return new RolloverProducer(){

                protected void updateRollover(MouseEvent e, String property, boolean fireAlways) {
                    if ("swingx.clicked".equals(property)) {
                        super.updateRollover(e, property, fireAlways);
                    }
                }

                protected void updateRolloverPoint(JComponent component, Point mousePoint) {
                    int col;
                    JXTree tree = (JXTree)component;
                    int row = tree.getClosestRowForLocation(mousePoint.x, mousePoint.y);
                    Rectangle bounds = tree.getRowBounds(row);
                    if (bounds == null) {
                        row = -1;
                    } else if (bounds.y + bounds.height < mousePoint.y || bounds.x > mousePoint.x) {
                        row = -1;
                    }
                    this.rollover.x = col = row < 0 ? -1 : 0;
                    this.rollover.y = row;
                }
            };
        }

        public void scrollRectToVisible(Rectangle aRect) {
            this.treeTable.scrollRectToVisible(aRect);
        }

        protected void setExpandedState(TreePath path, boolean state) {
            super.setExpandedState(path, state);
            this.treeTable.getTreeTableHacker().expansionChanged();
            this.treeTable.getTreeTableHacker().completeEditing();
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setBorderSelectionColor(null);
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int rowHeight) {
            super.setRowHeight(rowHeight);
            if (rowHeight > 0 && this.treeTable != null) {
                this.treeTable.adjustTableRowHeight(rowHeight);
            }
        }

        public void setBounds(int x, int y, int w, int h) {
            if (this.treeTable != null) {
                y = 0;
                h = this.treeTable.getRowCount() * this.getRowHeight();
            }
            super.setBounds(x, y, w, h);
        }

        public void paint(Graphics g) {
            Rectangle cellRect = this.treeTable.getCellRect(this.visibleRow, 0, false);
            g.translate(0, -cellRect.y);
            this.hierarchicalColumnWidth = this.getWidth();
            super.paint(g);
            if (this.highlightBorder != null) {
                this.highlightBorder.paintBorder(this, g, 0, cellRect.y, this.getWidth(), cellRect.height);
            }
        }

        public void doClick() {
            if (this.getCellRenderer() instanceof RolloverRenderer && ((RolloverRenderer)((Object)this.getCellRenderer())).isEnabled()) {
                ((RolloverRenderer)((Object)this.getCellRenderer())).doClick();
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            assert (table == this.treeTable);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.highlightBorder = null;
            if (this.treeTable != null && (this.treeTable.realEditingRow() != row || this.treeTable.getEditingColumn() != column) && hasFocus) {
                this.highlightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.visibleRow = row;
            return this;
        }

        private class ClippedTreeCellRenderer
        extends DefaultTreeCellRenderer {
            private boolean inpainting;
            private String shortText;
            private final Rectangle iconRect = new Rectangle();
            private final Rectangle textRect = new Rectangle();
            private final Rectangle itemRect = new Rectangle();

            private ClippedTreeCellRenderer() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paint(Graphics g) {
                String fullText = super.getText();
                this.shortText = SwingUtilities.layoutCompoundLabel(this, g.getFontMetrics(), fullText, this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this.getItemRect(this.itemRect), this.iconRect, this.textRect, this.getIconTextGap());
                try {
                    this.inpainting = true;
                    this.setText(this.shortText);
                    super.paint(g);
                }
                finally {
                    this.inpainting = false;
                    this.setText(fullText);
                }
            }

            private Rectangle getItemRect(Rectangle itemRect) {
                this.getBounds(itemRect);
                itemRect.width = TreeTableCellRenderer.this.hierarchicalColumnWidth - itemRect.x;
                return itemRect;
            }

            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Object val = value;
                if (TreeTableCellRenderer.this.treeTable != null) {
                    int treeColumn = TreeTableCellRenderer.this.treeTable.getTreeTableModel().getHierarchicalColumn();
                    Object o = null;
                    if (treeColumn >= 0) {
                        o = TreeTableCellRenderer.this.treeTable.getTreeTableModel().getValueAt(value, treeColumn);
                    }
                    val = o;
                }
                return super.getTreeCellRendererComponent(tree, val, sel, expanded, leaf, row, hasFocus);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TreeTableModelAdapter
    extends AbstractTableModel {
        private TreeModelListener treeModelListener;
        private final JTree tree;
        private JXTreeTable treeTable = null;

        TreeTableModelAdapter(JTree tree) {
            assert (tree != null);
            this.tree = tree;
            tree.getModel().addTreeModelListener(this.getTreeModelListener());
            tree.addTreeExpansionListener(new TreeExpansionListener(){

                public void treeExpanded(TreeExpansionEvent event) {
                    TreeTableModelAdapter.this.updateAfterExpansionEvent(event);
                }

                public void treeCollapsed(TreeExpansionEvent event) {
                    TreeTableModelAdapter.this.updateAfterExpansionEvent(event);
                }
            });
            tree.addPropertyChangeListener("model", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    TreeTableModel model = (TreeTableModel)evt.getOldValue();
                    model.removeTreeModelListener(TreeTableModelAdapter.this.getTreeModelListener());
                    model = (TreeTableModel)evt.getNewValue();
                    model.addTreeModelListener(TreeTableModelAdapter.this.getTreeModelListener());
                    TreeTableModelAdapter.this.fireTableStructureChanged();
                }
            });
        }

        protected void updateAfterExpansionEvent(TreeExpansionEvent event) {
            this.fireTableDataChanged();
        }

        protected JXTreeTable getTreeTable() {
            return this.treeTable;
        }

        protected final void bind(JXTreeTable treeTable) {
            if (treeTable == null) {
                throw new IllegalArgumentException("null treeTable");
            }
            if (this.treeTable != null) {
                throw new IllegalArgumentException("adapter already bound");
            }
            this.treeTable = treeTable;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return ((TreeTableModel)this.tree.getModel()).getColumnClass(column);
        }

        @Override
        public int getColumnCount() {
            return ((TreeTableModel)this.tree.getModel()).getColumnCount();
        }

        @Override
        public String getColumnName(int column) {
            return ((TreeTableModel)this.tree.getModel()).getColumnName(column);
        }

        @Override
        public int getRowCount() {
            return this.tree.getRowCount();
        }

        @Override
        public Object getValueAt(int row, int column) {
            Object node = this.nodeForRow(row);
            return node != null ? ((TreeTableModel)this.tree.getModel()).getValueAt(node, column) : null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            Object node = this.nodeForRow(row);
            return node != null ? ((TreeTableModel)this.tree.getModel()).isCellEditable(node, column) : false;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            Object node = this.nodeForRow(row);
            if (node != null) {
                ((TreeTableModel)this.tree.getModel()).setValueAt(value, node, column);
            }
        }

        protected Object nodeForRow(int row) {
            TreePath path = this.tree.getPathForRow(row);
            return path != null ? path.getLastPathComponent() : null;
        }

        private TreeModelListener getTreeModelListener() {
            if (this.treeModelListener == null) {
                this.treeModelListener = new TreeModelListener(){

                    public void treeNodesChanged(TreeModelEvent e) {
                        TreeTableModelAdapter.this.delayedFireTableDataUpdated(e);
                    }

                    public void treeNodesInserted(TreeModelEvent e) {
                        TreeTableModelAdapter.this.delayedFireTableDataChanged(e, 1);
                    }

                    public void treeNodesRemoved(TreeModelEvent e) {
                        TreeTableModelAdapter.this.delayedFireTableDataChanged(e, 2);
                    }

                    public void treeStructureChanged(TreeModelEvent e) {
                        if (TreeTableModelAdapter.this.isTableStructureChanged(e)) {
                            TreeTableModelAdapter.this.delayedFireTableStructureChanged();
                        } else {
                            TreeTableModelAdapter.this.delayedFireTableDataChanged();
                        }
                    }
                };
            }
            return this.treeModelListener;
        }

        private boolean isTableStructureChanged(TreeModelEvent e) {
            return e.getTreePath() == null || e.getTreePath().getParentPath() == null;
        }

        private void delayedFireTableStructureChanged() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreeTableModelAdapter.this.fireTableStructureChanged();
                }
            });
        }

        private void delayedFireTableDataChanged() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            });
        }

        private void delayedFireTableDataChanged(final TreeModelEvent tme, final int typeChange) {
            if (typeChange < 1 || typeChange > 2) {
                throw new IllegalArgumentException("Event type must be 1 or 2, was " + typeChange);
            }
            final boolean expanded = this.tree.isExpanded(tme.getTreePath());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int[] indices = tme.getChildIndices();
                    TreePath path = tme.getTreePath();
                    if (indices != null) {
                        if (expanded) {
                            int min = indices[0];
                            int max = indices[indices.length - 1];
                            int startingRow = TreeTableModelAdapter.this.tree.getRowForPath(path) + 1;
                            min = startingRow + min;
                            max = startingRow + max;
                            switch (typeChange) {
                                case 1: {
                                    TreeTableModelAdapter.this.fireTableRowsInserted(min, max);
                                    break;
                                }
                                case 2: {
                                    TreeTableModelAdapter.this.fireTableRowsDeleted(min, max);
                                }
                            }
                        } else {
                            int row = TreeTableModelAdapter.this.tree.getRowForPath(path);
                            if (row >= 0) {
                                TreeTableModelAdapter.this.fireTableRowsUpdated(row, row);
                            }
                        }
                    } else {
                        TreeTableModelAdapter.this.fireTableDataChanged();
                    }
                }
            });
        }

        protected void delayedFireTableDataUpdated(final TreeModelEvent tme) {
            final boolean expanded = this.tree.isExpanded(tme.getTreePath());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int[] indices = tme.getChildIndices();
                    TreePath path = tme.getTreePath();
                    if (indices != null) {
                        if (expanded) {
                            Object[] children = tme.getChildren();
                            int min = Integer.MAX_VALUE;
                            int max = Integer.MIN_VALUE;
                            for (int i = 0; i < indices.length; ++i) {
                                Object child = children[i];
                                TreePath childPath = path.pathByAddingChild(child);
                                int index = TreeTableModelAdapter.this.tree.getRowForPath(childPath);
                                if (index < min) {
                                    min = index;
                                }
                                if (index <= max) continue;
                                max = index;
                            }
                            TreeTableModelAdapter.this.fireTableRowsUpdated(Math.max(0, min), Math.max(0, max));
                        } else {
                            int row = TreeTableModelAdapter.this.tree.getRowForPath(path);
                            if (row >= 0) {
                                TreeTableModelAdapter.this.fireTableRowsUpdated(row, row);
                            }
                        }
                    } else {
                        TreeTableModelAdapter.this.fireTableDataChanged();
                    }
                }
            });
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    if (this.listSelectionModel.isSelectionEmpty()) {
                        this.clearSelection();
                    } else {
                        int min = this.listSelectionModel.getMinSelectionIndex();
                        int max = this.listSelectionModel.getMaxSelectionIndex();
                        ArrayList<TreePath> paths = new ArrayList<TreePath>();
                        for (int counter = min; counter <= max; ++counter) {
                            TreePath selPath;
                            if (!this.listSelectionModel.isSelectedIndex(counter) || (selPath = JXTreeTable.this.renderer.getPathForRow(counter)) == null) continue;
                            paths.add(selPath);
                        }
                        this.setSelectionPaths(paths.toArray(new TreePath[paths.size()]));
                        this.leadRow = this.leadIndex;
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
                }
            }
        }
    }

    public class TreeTableHackerExt2
    extends TreeTableHackerExt {
        protected boolean expandOrCollapseNode(int column, EventObject e) {
            if (!JXTreeTable.this.isHierarchical(column)) {
                return false;
            }
            if (!this.mightBeExpansionTrigger(e)) {
                return false;
            }
            boolean changedExpansion = false;
            MouseEvent me = (MouseEvent)e;
            if (JXTreeTable.this.hackAroundDragEnabled(me)) {
                me = new MouseEvent((Component)me.getSource(), 501, me.getWhen(), me.getModifiers(), me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger());
            }
            if (me.getModifiers() == 0 || me.getModifiers() == 16) {
                Point treeMousePoint = new Point(me.getX() - JXTreeTable.this.getCellRect((int)0, (int)column, (boolean)false).x, me.getY());
                int treeRow = JXTreeTable.this.renderer.getRowForLocation(treeMousePoint.x, treeMousePoint.y);
                int row = 0;
                if (treeRow < 0) {
                    row = JXTreeTable.this.renderer.getClosestRowForLocation(treeMousePoint.x, treeMousePoint.y);
                    Rectangle bounds = JXTreeTable.this.renderer.getRowBounds(row);
                    if (bounds == null) {
                        row = -1;
                    } else if (bounds.y + bounds.height < treeMousePoint.y || bounds.x > treeMousePoint.x) {
                        row = -1;
                    }
                    this.expansionChangedFlag = false;
                }
                if (treeRow >= 0 || treeRow < 0 && row < 0) {
                    MouseEvent pressed = new MouseEvent(JXTreeTable.this.renderer, me.getID(), me.getWhen(), me.getModifiers(), treeMousePoint.x, treeMousePoint.y, me.getClickCount(), me.isPopupTrigger());
                    JXTreeTable.this.renderer.dispatchEvent(pressed);
                    MouseEvent released = new MouseEvent(JXTreeTable.this.renderer, 502, pressed.getWhen(), pressed.getModifiers(), pressed.getX(), pressed.getY(), pressed.getClickCount(), pressed.isPopupTrigger());
                    JXTreeTable.this.renderer.dispatchEvent(released);
                }
                if (this.expansionChangedFlag) {
                    changedExpansion = true;
                }
            }
            this.expansionChangedFlag = false;
            return changedExpansion;
        }
    }

    public class TreeTableHackerExt
    extends TreeTableHacker {
        protected boolean isHitDetectionFromProcessMouse() {
            return true;
        }
    }

    public class TreeTableHacker {
        protected boolean expansionChangedFlag;

        protected boolean isHitDetectionFromProcessMouse() {
            return false;
        }

        public void hitHandleDetectionFromEditCell(int column, EventObject e) {
            if (!this.isHitDetectionFromProcessMouse()) {
                this.expandOrCollapseNode(column, e);
            }
        }

        public boolean hitHandleDetectionFromProcessMouse(MouseEvent e) {
            if (!this.isHitDetectionFromProcessMouse()) {
                return false;
            }
            int col = JXTreeTable.this.columnAtPoint(e.getPoint());
            return col >= 0 && this.expandOrCollapseNode(JXTreeTable.this.columnAtPoint(e.getPoint()), e);
        }

        protected void completeEditing() {
            if (JXTreeTable.this.isEditing()) {
                JXTreeTable.this.getCellEditor().cancelCellEditing();
            }
        }

        protected boolean expandOrCollapseNode(int column, EventObject e) {
            if (!JXTreeTable.this.isHierarchical(column)) {
                return false;
            }
            if (!this.mightBeExpansionTrigger(e)) {
                return false;
            }
            boolean changedExpansion = false;
            MouseEvent me = (MouseEvent)e;
            if (JXTreeTable.this.hackAroundDragEnabled(me)) {
                me = new MouseEvent((Component)me.getSource(), 501, me.getWhen(), me.getModifiers(), me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger());
            }
            if (me.getModifiers() == 0 || me.getModifiers() == 16) {
                MouseEvent pressed = new MouseEvent(JXTreeTable.this.renderer, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - JXTreeTable.this.getCellRect((int)0, (int)column, (boolean)false).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                JXTreeTable.this.renderer.dispatchEvent(pressed);
                MouseEvent released = new MouseEvent(JXTreeTable.this.renderer, 502, pressed.getWhen(), pressed.getModifiers(), pressed.getX(), pressed.getY(), pressed.getClickCount(), pressed.isPopupTrigger());
                JXTreeTable.this.renderer.dispatchEvent(released);
                if (this.expansionChangedFlag) {
                    changedExpansion = true;
                }
            }
            this.expansionChangedFlag = false;
            return changedExpansion;
        }

        protected boolean mightBeExpansionTrigger(EventObject e) {
            if (!(e instanceof MouseEvent)) {
                return false;
            }
            MouseEvent me = (MouseEvent)e;
            if (!SwingUtilities.isLeftMouseButton(me)) {
                return false;
            }
            return me.getID() == 501;
        }

        protected void expansionChanged() {
            this.expansionChangedFlag = true;
        }
    }

    private class Actions
    extends UIAction {
        Actions(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent evt) {
            if ("expand-all".equals(this.getName())) {
                JXTreeTable.this.expandAll();
            } else if ("collapse-all".equals(this.getName())) {
                JXTreeTable.this.collapseAll();
            }
        }
    }
}

