/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.io;

import VASSAL.tools.concurrent.listener.DummyEventListener;
import VASSAL.tools.concurrent.listener.EventListener;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.io.InputStreamPump;
import VASSAL.tools.io.OutputStreamPump;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputOutputStreamPump
implements InputStreamPump,
OutputStreamPump {
    protected InputStream in;
    protected OutputStream out;
    protected volatile boolean running = false;
    protected final EventListener<IOException> ioexListener;

    public InputOutputStreamPump() {
        this(null, null, new DummyEventListener<IOException>());
    }

    public InputOutputStreamPump(EventListener<IOException> eventListener) {
        this(null, null, eventListener);
    }

    public InputOutputStreamPump(InputStream inputStream, OutputStream outputStream) {
        this(inputStream, outputStream, new DummyEventListener<IOException>());
    }

    public InputOutputStreamPump(InputStream inputStream, OutputStream outputStream, EventListener<IOException> eventListener) {
        this.in = inputStream;
        this.out = outputStream;
        this.ioexListener = eventListener;
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        if (this.running) {
            throw new UnsupportedOperationException();
        }
        this.in = inputStream;
    }

    @Override
    public void setOutputStream(OutputStream outputStream) {
        if (this.running) {
            throw new UnsupportedOperationException();
        }
        this.out = outputStream;
    }

    @Override
    public void run() {
        this.running = true;
        try {
            IOUtils.copy((InputStream)this.in, (OutputStream)this.out);
        }
        catch (IOException iOException) {
            this.ioexListener.receive(this, iOException);
        }
    }
}

