/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.tilecache;

import VASSAL.tools.image.tilecache.TileUtils;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TileTask
implements Callable<Void> {
    protected final BufferedImage src;
    protected final File dst;
    protected final int tx;
    protected final int ty;
    protected final int tw;
    protected final int th;
    protected final int dw;
    protected final int dh;

    public TileTask(BufferedImage bufferedImage, File file, int n, int n2, int n3, int n4, int n5, int n6) {
        this.src = bufferedImage;
        this.dst = file;
        this.tx = n;
        this.ty = n2;
        this.tw = n3;
        this.th = n4;
        this.dw = n5;
        this.dh = n6;
    }

    @Override
    public Void call() throws IOException {
        BufferedImage bufferedImage = this.sliceTile();
        TileUtils.write(bufferedImage, this.dst);
        return null;
    }

    protected BufferedImage sliceTile() {
        int n = Math.min(this.tw, this.dw - this.tx * this.tw);
        int n2 = Math.min(this.th, this.dh - this.ty * this.th);
        int n3 = this.src.getType();
        BufferedImage bufferedImage = new BufferedImage(n, n2, n3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(this.src, 0, 0, n, n2, this.tx * this.tw, this.ty * this.th, this.tx * this.tw + n, this.ty * this.th + n2, null);
        graphics2D.dispose();
        return bufferedImage;
    }
}

