/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script;

import VASSAL.script.CompileResult;
import VASSAL.script.ScriptInterpreter;
import VASSAL.tools.WarningDialog;
import bsh.BeanShellExpressionValidator;
import bsh.EvalError;
import bsh.NameSpace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;

public class BeanShell {
    private static BeanShell instance = new BeanShell();
    protected static final String INIT_SCRIPT = "/VASSAL/script/init_script.bsh";
    protected ScriptInterpreter globalInterpreter = new ScriptInterpreter(this.getClass().getClassLoader());

    public static BeanShell getInstance() {
        return instance;
    }

    public BeanShell() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        URL uRL = instance.getClass().getResource(INIT_SCRIPT);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
            CompileResult compileResult = this.compile(bufferedReader);
            if (!compileResult.isSuccess()) {
                compileResult.printStackTrace();
            }
        }
        catch (IOException iOException) {
            WarningDialog.show(iOException, "", new Object[0]);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public CompileResult compile(Reader reader) {
        try {
            this.globalInterpreter.eval(reader);
        }
        catch (EvalError evalError) {
            return new CompileResult(evalError);
        }
        return new CompileResult();
    }

    public NameSpace getGlobalNameSpace() {
        return this.globalInterpreter.getNameSpace();
    }

    public void executeActionScript(String string) {
        try {
            this.globalInterpreter.evaluate(string + "();");
        }
        catch (EvalError evalError) {
            evalError.printStackTrace();
        }
    }

    public static boolean validateExpression(String string) {
        return new BeanShellExpressionValidator(string).isValid();
    }

    public static Object wrap(String string) {
        if (string == null) {
            return "";
        }
        if ("true".equals(string)) {
            return Boolean.TRUE;
        }
        if ("false".equals(string)) {
            return Boolean.FALSE;
        }
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return string;
        }
    }
}

