/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.i18n;

import java.util.IllegalFormatException;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleHelper {
    private static final Logger logger = LoggerFactory.getLogger(BundleHelper.class);
    private ResourceBundle bundle;

    public BundleHelper(ResourceBundle resourceBundle) {
        this.bundle = resourceBundle;
    }

    public String getString(String string) {
        try {
            return this.bundle.getString(string);
        }
        catch (ClassCastException classCastException) {
            logger.error("No Translation: " + string);
        }
        catch (MissingResourceException missingResourceException) {
            logger.error("No Translation: " + string);
        }
        return string;
    }

    public String getString(String string, Object ... objectArray) {
        try {
            return String.format(this.getString(string), objectArray);
        }
        catch (IllegalFormatException illegalFormatException) {
            logger.error("Illegal Message Format: " + string);
            return string;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.bundle;
    }
}

