/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.tools.NamedKeyManager;
import VASSAL.tools.NamedKeyStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class NamedHotKeyConfigurer
extends Configurer
implements KeyListener {
    private JTextField tf = new JTextField(16);
    private JPanel p;
    private boolean named;
    private JTextField keyName = new JTextField(16);
    private char lastChar;

    public NamedHotKeyConfigurer(String string, String string2) {
        this(string, string2, new NamedKeyStroke());
    }

    public NamedHotKeyConfigurer(String string, String string2, NamedKeyStroke namedKeyStroke) {
        super(string, string2, namedKeyStroke);
        this.named = namedKeyStroke != null && namedKeyStroke.isNamed();
    }

    public void setValue(Object object) {
        super.setValue(object);
        boolean bl = this.named = this.value != null && ((NamedKeyStroke)this.value).isNamed();
        if (!this.named && this.tf != null && !this.tf.getText().equals(this.keyToString())) {
            this.tf.setText(this.keyToString());
        }
    }

    public String keyToString() {
        return NamedHotKeyConfigurer.getString((NamedKeyStroke)this.getValue());
    }

    public Object getValue() {
        return super.getValue();
    }

    public String getValueString() {
        return NamedHotKeyConfigurer.encode((NamedKeyStroke)this.getValue());
    }

    public NamedKeyStroke getValueNamedKeyStroke() {
        return (NamedKeyStroke)this.value;
    }

    public void setValue(String string) {
        this.setValue(string == null ? null : NamedHotKeyConfigurer.decode(string));
    }

    public void setEnabled(boolean bl) {
        this.tf.setEnabled(bl);
        this.keyName.setEnabled(bl);
    }

    public Component getControls() {
        if (this.p == null) {
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 0));
            this.tf.setMaximumSize(new Dimension(this.tf.getMaximumSize().width, this.tf.getPreferredSize().height));
            this.tf.setText(this.keyToString());
            this.tf.addKeyListener(this);
            this.p.add(new JLabel(this.getName()));
            this.p.add(this.tf);
            this.keyName.setText(this.getValueNamedKeyStroke() == null ? null : this.getValueNamedKeyStroke().getName());
            this.keyName.setMaximumSize(new Dimension(this.keyName.getMaximumSize().width, this.keyName.getPreferredSize().height));
            this.keyName.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent keyEvent) {
                    switch (keyEvent.getKeyCode()) {
                        case 8: 
                        case 127: {
                            if (NamedHotKeyConfigurer.this.keyName.getText().length() == 0) {
                                NamedHotKeyConfigurer.this.named = false;
                                NamedHotKeyConfigurer.this.setValue(NamedKeyStroke.NULL_KEYSTROKE);
                                NamedHotKeyConfigurer.this.updateVisibility();
                                break;
                            }
                            NamedHotKeyConfigurer.this.setValue(new NamedKeyStroke(NamedKeyManager.getMarkerKeyStroke(), NamedHotKeyConfigurer.this.keyName.getText()));
                            break;
                        }
                        case 16: 
                        case 17: 
                        case 18: 
                        case 157: {
                            break;
                        }
                        default: {
                            if (NamedHotKeyConfigurer.this.isPrintableAscii(keyEvent.getKeyChar())) {
                                NamedHotKeyConfigurer.this.setValue(new NamedKeyStroke(NamedKeyManager.getMarkerKeyStroke(), NamedHotKeyConfigurer.this.keyName.getText()));
                                break;
                            }
                            NamedHotKeyConfigurer.this.named = false;
                            NamedHotKeyConfigurer.this.setValue(NamedKeyStroke.getKeyStrokeForEvent(keyEvent));
                            NamedHotKeyConfigurer.this.updateVisibility();
                        }
                    }
                }

                public void keyPressed(KeyEvent keyEvent) {
                }

                public void keyTyped(KeyEvent keyEvent) {
                }
            });
            this.p.add(this.keyName);
            this.updateVisibility();
        }
        return this.p;
    }

    protected void updateVisibility() {
        this.tf.setVisible(!this.isNamed());
        this.keyName.setVisible(this.isNamed());
        this.lastChar = '\u0000';
        Window window = SwingUtilities.getWindowAncestor(this.p);
        if (window != null) {
            window.pack();
        }
    }

    public boolean isNamed() {
        return this.named;
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.lastChar = keyEvent.getKeyChar();
    }

    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 8: 
            case 127: {
                this.setValue(NamedKeyStroke.NULL_KEYSTROKE);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 157: {
                break;
            }
            default: {
                NamedKeyStroke namedKeyStroke = this.getValueNamedKeyStroke();
                if (namedKeyStroke != null) {
                    char c = keyEvent.getKeyChar();
                    if (this.isPrintableAscii(this.lastChar) && this.isPrintableAscii((int)c)) {
                        String string = "" + this.lastChar + keyEvent.getKeyChar();
                        this.named = true;
                        this.keyName.setText(string);
                        this.setValue(new NamedKeyStroke(string));
                        this.updateVisibility();
                        this.keyName.requestFocus();
                        break;
                    }
                }
                this.setValue(NamedKeyStroke.getKeyStrokeForEvent(keyEvent));
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (!this.named) {
            this.tf.setText(NamedHotKeyConfigurer.getString((NamedKeyStroke)this.getValue()));
        }
    }

    protected boolean isPrintableAscii(char c) {
        return this.isPrintableAscii((int)c);
    }

    protected boolean isPrintableAscii(int n) {
        return n >= 32 && n <= 126;
    }

    public static String getString(NamedKeyStroke namedKeyStroke) {
        return namedKeyStroke == null || namedKeyStroke.isNull() ? "" : NamedHotKeyConfigurer.getString(namedKeyStroke.getStroke());
    }

    public static String getFancyString(NamedKeyStroke namedKeyStroke) {
        String string = NamedHotKeyConfigurer.getString(namedKeyStroke);
        if (string.length() > 0) {
            string = "[" + string + "]";
        }
        return string;
    }

    public static String getString(KeyStroke keyStroke) {
        return NamedKeyManager.isNamed(keyStroke) ? "" : HotKeyConfigurer.getString(keyStroke);
    }

    public static NamedKeyStroke decode(String string) {
        if (string == null) {
            return NamedKeyStroke.NULL_KEYSTROKE;
        }
        String[] stringArray = string.split(",");
        if (stringArray.length < 2) {
            return NamedKeyStroke.NULL_KEYSTROKE;
        }
        try {
            KeyStroke keyStroke = KeyStroke.getKeyStroke(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
            String string2 = null;
            if (stringArray.length > 2) {
                string2 = stringArray[2];
            }
            return new NamedKeyStroke(keyStroke, string2);
        }
        catch (Exception exception) {
            return NamedKeyStroke.NULL_KEYSTROKE;
        }
    }

    public static String encode(NamedKeyStroke namedKeyStroke) {
        if (namedKeyStroke == null) {
            return "";
        }
        KeyStroke keyStroke = namedKeyStroke.getStroke();
        if (keyStroke == null) {
            return "";
        }
        String string = keyStroke.getKeyCode() + "," + keyStroke.getModifiers();
        if (namedKeyStroke.isNamed()) {
            string = string + "," + namedKeyStroke.getName();
        }
        return string;
    }
}

