/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.configure.Configurer;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.ImageFileFilter;
import VASSAL.tools.imageop.Op;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IconConfigurer
extends Configurer {
    private JPanel controls;
    private String imageName;
    private String defaultImage;
    private Icon icon;

    public IconConfigurer(String string, String string2, String string3) {
        super(string, string2);
        this.defaultImage = string3;
    }

    public String getValueString() {
        return this.imageName;
    }

    public void setValue(String string) {
        BufferedImage bufferedImage;
        this.icon = null;
        String string2 = this.imageName = string == null ? "" : string;
        if (this.imageName.length() > 0 && (bufferedImage = Op.load(this.imageName).getImage()) != null) {
            this.icon = new ImageIcon(bufferedImage);
        }
        this.setValue((Object)this.imageName);
    }

    public Icon getIconValue() {
        return this.icon;
    }

    public Component getControls() {
        if (this.controls == null) {
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 0));
            this.controls.add(new JLabel(this.getName()));
            final JPanel jPanel = new JPanel(){
                private static final long serialVersionUID = 1L;

                public void paint(Graphics graphics) {
                    graphics.clearRect(0, 0, this.getSize().width, this.getSize().height);
                    Icon icon = IconConfigurer.this.getIconValue();
                    if (icon != null) {
                        icon.paintIcon(this, graphics, this.getSize().width / 2 - icon.getIconWidth() / 2, this.getSize().height / 2 - icon.getIconHeight() / 2);
                    }
                }
            };
            jPanel.setPreferredSize(new Dimension(32, 32));
            this.controls.add(jPanel);
            JButton jButton = new JButton("Select");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    IconConfigurer.this.selectImage();
                    jPanel.repaint();
                }
            });
            this.controls.add(jButton);
            if (this.defaultImage != null) {
                JButton jButton2 = new JButton("Default");
                jButton2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        IconConfigurer.this.setValue(IconConfigurer.this.defaultImage);
                        jPanel.repaint();
                    }
                });
                this.controls.add(jButton2);
            }
        }
        return this.controls;
    }

    private void selectImage() {
        FileChooser fileChooser = GameModule.getGameModule().getFileChooser();
        fileChooser.setFileFilter(new ImageFileFilter());
        if (fileChooser.showOpenDialog(this.getControls()) != 0) {
            this.setValue(null);
        } else {
            File file = fileChooser.getSelectedFile();
            if (file != null && file.exists()) {
                GameModule.getGameModule().getArchiveWriter().addImage(file.getPath(), file.getName());
                this.setValue(file.getName());
            }
        }
    }
}

