/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.command;

import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.HighlightLastMoved;
import VASSAL.command.Command;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceVisitorDispatcher;
import VASSAL.counters.Stack;
import java.awt.Point;

public class MovePiece
extends Command {
    private String id;
    private String newMapId;
    private String oldMapId;
    private Point newPosition;
    private Point oldPosition;
    private String newUnderneathId;
    private String oldUnderneathId;
    private String playerId;

    public MovePiece(String string, String string2, Point point, String string3, String string4, Point point2, String string5, String string6) {
        this.id = string;
        this.newMapId = string2;
        this.oldMapId = string4;
        this.newPosition = point;
        this.oldPosition = point2;
        this.newUnderneathId = string3;
        this.oldUnderneathId = string5;
        this.playerId = string6;
    }

    public String getId() {
        return this.id;
    }

    public String getNewMapId() {
        return this.newMapId;
    }

    public String getOldMapId() {
        return this.oldMapId;
    }

    public Point getNewPosition() {
        return this.newPosition;
    }

    public Point getOldPosition() {
        return this.oldPosition;
    }

    public String getNewUnderneathId() {
        return this.newUnderneathId;
    }

    public String getOldUnderneathId() {
        return this.oldUnderneathId;
    }

    public String getPlayerId() {
        return this.playerId;
    }

    protected void executeCommand() {
        GamePiece gamePiece = GameModule.getGameModule().getGameState().getPieceForId(this.id);
        if (gamePiece != null) {
            BoundsTracker boundsTracker = new BoundsTracker();
            boundsTracker.addPiece(gamePiece);
            Map map = Map.getMapById(this.newMapId);
            if (map != null) {
                PieceVisitorDispatcher pieceVisitorDispatcher = this.createMergeFinder(map, gamePiece, this.newPosition);
                if (this.newUnderneathId != null) {
                    GamePiece gamePiece2 = GameModule.getGameModule().getGameState().getPieceForId(this.newUnderneathId);
                    if (gamePiece2 != null && gamePiece2.getPosition().equals(this.newPosition)) {
                        map.getStackMetrics().merge(gamePiece2, gamePiece);
                    } else if (map.apply(pieceVisitorDispatcher) == null) {
                        map.placeAt(gamePiece, this.newPosition);
                    }
                } else {
                    if (map.apply(pieceVisitorDispatcher) == null) {
                        map.placeAt(gamePiece, this.newPosition);
                    }
                    if (gamePiece.getParent() != null) {
                        gamePiece.getParent().insert(gamePiece, 0);
                    }
                }
            } else {
                Map map2 = Map.getMapById(this.oldMapId);
                if (map2 != null) {
                    map2.removePiece(gamePiece);
                }
            }
            boundsTracker.addPiece(gamePiece);
            HighlightLastMoved.setLastMoved(gamePiece);
            boundsTracker.repaint();
            if (gamePiece.getMap() != null && GlobalOptions.getInstance().centerOnOpponentsMove() && !Boolean.TRUE.equals(gamePiece.getProperty("Invisible"))) {
                gamePiece.getMap().ensureVisible(gamePiece.getMap().selectionBoundsOf(gamePiece));
            }
        }
    }

    protected Command myUndoCommand() {
        return new MovePiece(this.id, this.oldMapId, this.oldPosition, this.oldUnderneathId, this.newMapId, this.newPosition, this.newUnderneathId, this.playerId);
    }

    protected PieceVisitorDispatcher createMergeFinder(final Map map, final GamePiece gamePiece, final Point point) {
        DeckVisitorDispatcher deckVisitorDispatcher = new DeckVisitorDispatcher(new DeckVisitor(){

            public Object visitDeck(Deck deck) {
                if (deck.getPosition().equals(point)) {
                    return map.getStackMetrics().merge(deck, gamePiece);
                }
                return null;
            }

            public Object visitStack(Stack stack) {
                if (stack.getPosition().equals(point) && map.getStackMetrics().isStackingEnabled() && !Boolean.TRUE.equals(gamePiece.getProperty("NoStack")) && stack.topPiece(MovePiece.this.playerId) != null && map.getPieceCollection().canMerge(gamePiece, stack)) {
                    return map.getStackMetrics().merge(stack, gamePiece);
                }
                return null;
            }

            public Object visitDefault(GamePiece gamePiece2) {
                if (gamePiece2.getPosition().equals(point) && map.getStackMetrics().isStackingEnabled() && !Boolean.TRUE.equals(gamePiece.getProperty("NoStack")) && !Boolean.TRUE.equals(gamePiece2.getProperty("NoStack")) && map.getPieceCollection().canMerge(gamePiece, gamePiece2)) {
                    String string = (String)gamePiece2.getProperty("hiddenBy");
                    if (string == null || string.equals(MovePiece.this.playerId)) {
                        return map.getStackMetrics().merge(gamePiece2, gamePiece);
                    }
                    return null;
                }
                return null;
            }
        });
        return deckVisitorDispatcher;
    }

    public String getDetails() {
        return "id=" + this.id + ",map=" + this.newMapId + ",position=" + this.newPosition + ",under=" + this.newUnderneathId;
    }
}

