/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;

public class TextClient {
    private boolean reportRooms = true;
    private ChatServerConnection client;

    public TextClient(ChatServerConnection chatServerConnection) {
        this.client = chatServerConnection;
        chatServerConnection.addPropertyChangeListener("AvailableRooms", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TextClient.this.availableRoomsChanged(propertyChangeEvent);
            }
        });
        chatServerConnection.addPropertyChangeListener("Msg", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TextClient.this.incomingMessageReceived(propertyChangeEvent);
            }
        });
        chatServerConnection.addPropertyChangeListener("Status", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                TextClient.this.statusReceived(propertyChangeEvent);
            }
        });
        chatServerConnection.setConnected(true);
    }

    public ChatServerConnection getClient() {
        return this.client;
    }

    private void statusReceived(PropertyChangeEvent propertyChangeEvent) {
        System.out.println(String.valueOf(propertyChangeEvent.getNewValue()));
    }

    private void incomingMessageReceived(PropertyChangeEvent propertyChangeEvent) {
        String string = (String)propertyChangeEvent.getNewValue();
        if (string.startsWith("CHAT")) {
            System.out.println(string.substring(4));
        }
    }

    private void availableRoomsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.reportRooms) {
            System.out.println("----------" + new Date() + "---------");
            System.out.print(TextClient.report((Room[])propertyChangeEvent.getNewValue()));
        }
    }

    public static String report(Room[] roomArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < roomArray.length; ++i) {
            stringBuilder.append(roomArray[i].getName() + ": ");
            Player[] playerArray = (Player[])roomArray[i].getPlayerList().toArray();
            for (int j = 0; j < playerArray.length; ++j) {
                stringBuilder.append(playerArray[j]);
                if (j >= playerArray.length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static class Encoder
    implements CommandEncoder {
        public Command decode(String string) {
            ShowText showText = null;
            if (string.startsWith("CHAT")) {
                showText = new ShowText(string.substring(4));
            }
            return showText;
        }

        public String encode(Command command) {
            String string = null;
            if (command instanceof ShowText) {
                return "CHAT" + ((ShowText)command).getMessage();
            }
            return string;
        }
    }

    public static class ShowText
    extends Command {
        private String msg;

        public ShowText(String string) {
            this.msg = string;
        }

        public String getMessage() {
            return this.msg;
        }

        protected void executeCommand() {
            System.out.println(this.msg);
        }

        protected Command myUndoCommand() {
            return null;
        }
    }
}

