/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.metadata;

import VASSAL.build.GameModule;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.tools.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ModuleMetaData
extends AbstractMetaData {
    private static final Logger logger = LoggerFactory.getLogger(ModuleMetaData.class);
    public static final String ZIP_ENTRY_NAME = "moduledata";
    public static final String DATA_VERSION = "1";
    protected AbstractMetaData.Attribute nameAttr;

    public ModuleMetaData(ZipFile zipFile) {
        this.read(zipFile);
    }

    public ModuleMetaData(GameModule gameModule) {
        this.nameAttr = new AbstractMetaData.Attribute(gameModule, "name");
        this.setDescription(new AbstractMetaData.Attribute(gameModule, "description"));
        this.setVersion(gameModule.getGameVersion());
    }

    public ModuleMetaData(String string, String string2) {
        this.nameAttr = new AbstractMetaData.Attribute("name", string);
        this.setVersion(string2);
    }

    public String getName() {
        return this.nameAttr == null ? "" : this.nameAttr.getValue();
    }

    public String getLocalizedName() {
        return this.nameAttr == null ? "" : this.nameAttr.getLocalizedValue();
    }

    public String getZipEntryName() {
        return ZIP_ENTRY_NAME;
    }

    public String getMetaDataVersion() {
        return DATA_VERSION;
    }

    protected void addElements(Document document, Element element) {
        this.nameAttr.generateXML(document, element, "name");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ZipFile zipFile) {
        this.version = "";
        try {
            DefaultHandler defaultHandler = null;
            ZipEntry zipEntry = zipFile.getEntry(ZIP_ENTRY_NAME);
            if (zipEntry == null) {
                zipEntry = zipFile.getEntry("buildFile");
                if (zipEntry == null) {
                    return;
                }
                defaultHandler = new ModuleBuildFileXMLHandler();
            } else {
                defaultHandler = new MetadataXMLHandler();
            }
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                XMLReader xMLReader = parser;
                synchronized (xMLReader) {
                    parser.setContentHandler(defaultHandler);
                    parser.setDTDHandler(defaultHandler);
                    parser.setEntityResolver(defaultHandler);
                    parser.setErrorHandler(defaultHandler);
                    parser.parse(new InputSource(bufferedInputStream));
                }
                bufferedInputStream.close();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedInputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)bufferedInputStream);
            zipFile.close();
        }
        catch (IOException iOException) {
            logger.error("", (Throwable)iOException);
        }
        catch (AbstractMetaData.SAXEndException sAXEndException) {
        }
        catch (SAXException sAXException) {
            logger.error("", (Throwable)sAXException);
        }
        finally {
            IOUtils.closeQuietly(zipFile);
        }
    }

    private class ModuleBuildFileXMLHandler
    extends AbstractMetaData.BuildFileXMLHandler {
        private ModuleBuildFileXMLHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws AbstractMetaData.SAXEndException {
            super.startElement(string, string2, string3, attributes);
            if ("VASSAL.launch.BasicModule".equals(string3) || "VASSAL.build.GameModule".equals(string3)) {
                ModuleMetaData.this.nameAttr = new AbstractMetaData.Attribute("name", this.getAttr(attributes, "name"));
                ModuleMetaData.this.setVersion(this.getAttr(attributes, "version"));
                ModuleMetaData.this.setVassalVersion(this.getAttr(attributes, "vassalVersion"));
                ModuleMetaData.this.setDescription(this.getAttr(attributes, "description"));
                throw new AbstractMetaData.SAXEndException();
            }
        }
    }

    private class MetadataXMLHandler
    extends AbstractMetaData.XMLHandler {
        private MetadataXMLHandler() {
        }

        public void endElement(String string, String string2, String string3) {
            if ("name".equals(string3)) {
                if (ModuleMetaData.this.nameAttr == null) {
                    ModuleMetaData.this.nameAttr = new AbstractMetaData.Attribute("name", this.accumulator.toString().trim());
                } else {
                    ModuleMetaData.this.nameAttr.addTranslation(this.language, this.accumulator.toString().trim());
                }
            } else {
                super.endElement(string, string2, string3);
            }
        }
    }
}

