/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.Drawable;
import VASSAL.counters.ColoredBorder;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.EventFilter;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Immobilized;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.PieceFinder;
import VASSAL.counters.PieceVisitorDispatcher;
import VASSAL.counters.Stack;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyBufferer
extends MouseAdapter
implements Buildable,
MouseMotionListener,
Drawable {
    protected Map map;
    protected Rectangle selection;
    protected Point anchor;
    protected Color color = Color.black;
    protected int thickness = 3;

    public void addTo(Buildable buildable) {
        this.map = (Map)buildable;
        this.map.addLocalMouseListenerFirst(this);
        this.map.getView().addMouseMotionListener(this);
        this.map.addDrawComponent(this);
    }

    public void add(Buildable buildable) {
    }

    public Element getBuildElement(Document document) {
        return document.createElement(this.getClass().getName());
    }

    public void build(Element element) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl;
        if (mouseEvent.isConsumed()) {
            return;
        }
        GamePiece gamePiece = this.map.findPiece(mouseEvent.getPoint(), PieceFinder.PIECE_IN_STACK);
        EventFilter eventFilter = null;
        if (gamePiece != null) {
            eventFilter = (EventFilter)gamePiece.getProperty("selectEventFilter");
        }
        boolean bl2 = bl = eventFilter != null && eventFilter.rejectEvent(mouseEvent);
        if (gamePiece != null && !bl) {
            boolean bl3 = (Boolean)GameModule.getGameModule().getPrefs().getValue("movingStacksPickupUnits");
            if (!KeyBuffer.getBuffer().contains(gamePiece)) {
                if (!mouseEvent.isShiftDown() && !mouseEvent.isControlDown()) {
                    KeyBuffer.getBuffer().clear();
                }
                if (!mouseEvent.isControlDown()) {
                    if (bl3 || gamePiece.getParent() == null || gamePiece.getParent().isExpanded() || mouseEvent.isMetaDown() || Boolean.TRUE.equals(gamePiece.getProperty("Selected"))) {
                        KeyBuffer.getBuffer().add(gamePiece);
                    } else {
                        Stack stack = gamePiece.getParent();
                        for (int i = 0; i < stack.getPieceCount(); ++i) {
                            KeyBuffer.getBuffer().add(stack.getPieceAt(i));
                        }
                    }
                }
            } else if (mouseEvent.isControlDown() && Boolean.TRUE.equals(gamePiece.getProperty("Selected"))) {
                Stack stack = gamePiece.getParent();
                if (stack == null) {
                    KeyBuffer.getBuffer().remove(gamePiece);
                } else if (!stack.isExpanded()) {
                    for (int i = 0; i < stack.getPieceCount(); ++i) {
                        KeyBuffer.getBuffer().remove(stack.getPieceAt(i));
                    }
                }
            }
            if (gamePiece.getParent() != null) {
                this.map.getPieceCollection().moveToFront(gamePiece.getParent());
            } else {
                this.map.getPieceCollection().moveToFront(gamePiece);
            }
        } else {
            if (!mouseEvent.isShiftDown() && !mouseEvent.isControlDown()) {
                KeyBuffer.getBuffer().clear();
            }
            this.anchor = this.map.componentCoordinates(mouseEvent.getPoint());
            this.selection = new Rectangle(this.anchor.x, this.anchor.y, 0, 0);
            if (this.map.getHighlighter() instanceof ColoredBorder) {
                ColoredBorder coloredBorder = (ColoredBorder)this.map.getHighlighter();
                this.color = coloredBorder.getColor();
                this.thickness = coloredBorder.getThickness();
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.selection != null) {
            this.selection.setLocation(this.map.mapCoordinates(this.selection.getLocation()));
            this.selection.width = (int)((double)this.selection.width / this.map.getZoom());
            this.selection.height = (int)((double)this.selection.height / this.map.getZoom());
            PieceVisitorDispatcher pieceVisitorDispatcher = this.createDragSelector(!mouseEvent.isControlDown(), mouseEvent.isAltDown());
            if (!mouseEvent.isShiftDown() && !mouseEvent.isControlDown()) {
                KeyBuffer.getBuffer().clear();
            }
            this.map.apply(pieceVisitorDispatcher);
            this.repaintSelectionRect();
        }
        this.selection = null;
    }

    protected PieceVisitorDispatcher createDragSelector(boolean bl, boolean bl2) {
        return new PieceVisitorDispatcher(new KBDeckVisitor(bl, bl2));
    }

    protected void repaintSelectionRect() {
        int n = this.thickness / 2 + this.thickness % 2;
        int n2 = 2 * n;
        this.map.getView().repaint(this.selection.x - n, this.selection.y - n, n2, this.selection.height + n2);
        this.map.getView().repaint(this.selection.x + this.selection.width - n, this.selection.y - n, n2, this.selection.height + n2);
        this.map.getView().repaint(this.selection.x - n, this.selection.y - n, this.selection.width + n2, n2);
        this.map.getView().repaint(this.selection.x - n, this.selection.y + this.selection.width - n, this.selection.width + n2, n2);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.selection != null) {
            this.repaintSelectionRect();
            this.selection.x = Math.min(mouseEvent.getX(), this.anchor.x);
            this.selection.y = Math.min(mouseEvent.getY(), this.anchor.y);
            this.selection.width = Math.abs(mouseEvent.getX() - this.anchor.x);
            this.selection.height = Math.abs(mouseEvent.getY() - this.anchor.y);
            this.repaintSelectionRect();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void draw(Graphics graphics, Map map) {
        if (this.selection != null) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(this.thickness));
            graphics2D.setColor(this.color);
            graphics2D.drawRect(this.selection.x, this.selection.y, this.selection.width, this.selection.height);
            graphics2D.setStroke(stroke);
        }
    }

    public boolean drawAboveCounters() {
        return true;
    }

    public class KBDeckVisitor
    implements DeckVisitor {
        boolean selecting = false;
        boolean altDown = false;

        public KBDeckVisitor(boolean bl, boolean bl2) {
            this.selecting = bl;
            this.altDown = bl2;
        }

        public Object visitDeck(Deck deck) {
            return null;
        }

        public Object visitStack(Stack stack) {
            block4: {
                block5: {
                    if (stack.topPiece() == null) break block4;
                    if (!stack.isExpanded()) break block5;
                    Point[] pointArray = new Point[stack.getPieceCount()];
                    KeyBufferer.this.map.getStackMetrics().getContents(stack, pointArray, null, null, stack.getPosition().x, stack.getPosition().y);
                    for (int i = 0; i < pointArray.length; ++i) {
                        if (!KeyBufferer.this.selection.contains(pointArray[i])) continue;
                        if (this.selecting) {
                            KeyBuffer.getBuffer().add(stack.getPieceAt(i));
                            continue;
                        }
                        KeyBuffer.getBuffer().remove(stack.getPieceAt(i));
                    }
                    break block4;
                }
                if (!KeyBufferer.this.selection.contains(stack.getPosition())) break block4;
                int n = stack.getPieceCount();
                for (int i = 0; i < n; ++i) {
                    if (this.selecting) {
                        KeyBuffer.getBuffer().add(stack.getPieceAt(i));
                        continue;
                    }
                    KeyBuffer.getBuffer().remove(stack.getPieceAt(i));
                }
            }
            return null;
        }

        public Object visitDefault(GamePiece gamePiece) {
            if (KeyBufferer.this.selection.contains(gamePiece.getPosition()) && !Boolean.TRUE.equals(gamePiece.getProperty("Invisible"))) {
                if (this.selecting) {
                    boolean bl;
                    EventFilter eventFilter = (EventFilter)gamePiece.getProperty("selectEventFilter");
                    boolean bl2 = bl = this.altDown && eventFilter instanceof Immobilized.UseAlt;
                    if (eventFilter == null || bl) {
                        KeyBuffer.getBuffer().add(gamePiece);
                    }
                } else {
                    KeyBuffer.getBuffer().remove(gamePiece);
                }
            }
            return null;
        }
    }
}

