/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.build.module.gamepieceimage.ColorSwatchConfigurer;
import VASSAL.build.module.gamepieceimage.GamePieceLayout;
import VASSAL.build.module.gamepieceimage.ImageItemInstance;
import VASSAL.build.module.gamepieceimage.InstanceConfigurer;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.build.module.gamepieceimage.ItemInstance;
import VASSAL.build.module.gamepieceimage.ShapeItemInstance;
import VASSAL.build.module.gamepieceimage.SymbolItemInstance;
import VASSAL.build.module.gamepieceimage.TextBoxItemInstance;
import VASSAL.build.module.gamepieceimage.TextItemInstance;
import VASSAL.build.module.gamepieceimage.Visualizable;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.UniqueIdManager;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.SourceOp;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GamePieceImage
extends AbstractConfigurable
implements Visualizable,
Cloneable,
UniqueIdManager.Identifyable {
    protected static final String NAME = "name";
    protected static final String PROPS = "props";
    public static final String PART_SIZE = "Size";
    public static final String PART_SYMBOL1 = "Symbol1";
    public static final String PART_SYMBOL2 = "Symbol2";
    public static final String BG_COLOR = "bgColor";
    public static final String BORDER_COLOR = "borderColor";
    protected List<ItemInstance> instances = new ArrayList<ItemInstance>();
    protected InstanceConfigurer defnConfig = null;
    protected GamePieceLayout layout;
    protected ColorSwatch bgColor = ColorSwatch.getWhite();
    protected ColorSwatch borderColor = ColorSwatch.getBlack();
    protected String id;
    protected static UniqueIdManager idMgr = new UniqueIdManager("GamePieceImage");
    protected String nameInUse;
    protected Image visImage = null;
    protected SourceOp srcOp;
    private VisibilityCondition borderCond = new VisibilityCondition(){

        public boolean shouldBeVisible() {
            if (GamePieceImage.this.getLayout() == null) {
                return false;
            }
            return GamePieceImage.this.getLayout().isColoredBorder();
        }
    };

    public GamePieceImage() {
        this.setConfigureName("");
    }

    public GamePieceImage(String string) {
        this.instances = InstanceConfigurer.StringToProperties(string, this);
    }

    public GamePieceImage(GamePieceLayout gamePieceLayout) {
        this();
        this.setConfigureName(gamePieceLayout.getConfigureName());
        this.layout = gamePieceLayout;
    }

    public GamePieceImage(GamePieceImage gamePieceImage) {
        this();
        this.setConfigureName(gamePieceImage.getConfigureName());
        this.layout = gamePieceImage.getLayout();
        this.bgColor = gamePieceImage.getBgColor();
        this.borderColor = gamePieceImage.getBorderColor();
        this.instances.addAll(gamePieceImage.getInstances());
    }

    public Object clone() {
        return new GamePieceImage(this);
    }

    public List<ItemInstance> getInstances() {
        return this.instances;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Background Color:  ", "Border Color:  ", ""};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, BgColorSwatchConfig.class, BorderColorSwatchConfig.class, DefnConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, BG_COLOR, BORDER_COLOR, PROPS};
    }

    public ColorSwatch getBgColor() {
        return this.bgColor;
    }

    public ColorSwatch getBorderColor() {
        return this.borderColor;
    }

    @Override
    public void setAttribute(String string, Object list) {
        if (NAME.equals(string)) {
            String string2 = (String)((Object)list);
            String string3 = this.getConfigureName();
            if (string2 != string3 && string3.length() > 0) {
                ArchiveWriter archiveWriter = GameModule.getGameModule().getArchiveWriter();
                archiveWriter.removeImage(string3);
                archiveWriter.addImage(string2, this.getEncodedImage((BufferedImage)this.visImage));
            }
            this.setConfigureName(string2);
        } else if (BG_COLOR.equals(string)) {
            if (list instanceof String) {
                list = new ColorSwatch((String)((Object)list));
            }
            this.bgColor = (ColorSwatch)((Object)list);
            if (this.defnConfig != null) {
                this.defnConfig.visualizer.rebuild();
            }
        } else if (BORDER_COLOR.equals(string)) {
            if (list instanceof String) {
                list = new ColorSwatch((String)((Object)list));
            }
            this.borderColor = (ColorSwatch)((Object)list);
            if (this.defnConfig != null) {
                this.defnConfig.visualizer.rebuild();
            }
        } else if (PROPS.equals(string)) {
            if (list instanceof String) {
                list = InstanceConfigurer.StringToProperties((String)((Object)list), this);
            }
            if (this.instances instanceof List) {
                this.instances = list;
            }
            if (this.defnConfig != null) {
                this.rebuildInstances();
                this.defnConfig.visualizer.rebuild();
                this.defnConfig.repack();
            }
        }
        if (this.defnConfig != null) {
            this.rebuildVisualizerImage();
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (NAME.equals(string)) {
            return this.getConfigureName();
        }
        if (BG_COLOR.equals(string)) {
            return this.bgColor.encode();
        }
        if (BORDER_COLOR.equals(string)) {
            return this.borderColor.encode();
        }
        if (PROPS.equals(string)) {
            return InstanceConfigurer.PropertiesToString(this.instances);
        }
        return null;
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String string) {
        if (BORDER_COLOR.equals(string)) {
            return this.borderCond;
        }
        return super.getAttributeVisibility(string);
    }

    @Override
    public void removeFrom(Buildable buildable) {
        idMgr.remove(this);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePieceImage.htm");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addTo(Buildable buildable) {
        this.layout = (GamePieceLayout)buildable;
        idMgr.add(this);
        this.validator = idMgr;
        this.setAllAttributesUntranslatable();
        this.rebuildInstances();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String string) {
        this.id = string;
    }

    public static String getConfigureTypeName() {
        return "Game Piece Image";
    }

    public void refreshConfig() {
        this.rebuildVisualizerImage();
    }

    public GamePieceLayout getLayout() {
        return this.layout;
    }

    @Override
    public int getVisualizerHeight() {
        return this.getLayout().getVisualizerHeight();
    }

    @Override
    public int getVisualizerWidth() {
        return this.getLayout().getVisualizerWidth();
    }

    @Override
    public Image getVisualizerImage() {
        if (this.visImage == null) {
            this.rebuildVisualizerImage();
        }
        return this.visImage;
    }

    @Override
    public void rebuildVisualizerImage() {
        if (this.layout != null) {
            this.visImage = this.layout.buildImage(this);
            ArchiveWriter archiveWriter = GameModule.getGameModule().getArchiveWriter();
            if (archiveWriter != null && this.getConfigureName() != null && this.getConfigureName().length() > 0) {
                archiveWriter.addImage(this.getConfigureName(), this.getEncodedImage((BufferedImage)this.visImage));
                SourceOp sourceOp = Op.load(this.getConfigureName());
                sourceOp.update();
            }
        }
    }

    public byte[] getEncodedImage(BufferedImage bufferedImage) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        }
        catch (IOException iOException) {
            ErrorDialog.bug(iOException);
            return new byte[1];
        }
        return byteArrayOutputStream.toByteArray();
    }

    public ItemInstance getInstance(String string) {
        for (ItemInstance itemInstance : this.instances) {
            if (!string.equals(itemInstance.getName())) continue;
            return itemInstance;
        }
        return null;
    }

    public TextItemInstance getTextInstance(String string) {
        for (ItemInstance itemInstance : this.instances) {
            if (!(itemInstance instanceof TextItemInstance) || !string.equals(itemInstance.getName())) continue;
            return (TextItemInstance)itemInstance;
        }
        return null;
    }

    public TextBoxItemInstance getTextBoxInstance(String string) {
        for (ItemInstance itemInstance : this.instances) {
            if (!(itemInstance instanceof TextBoxItemInstance) || !string.equals(itemInstance.getName())) continue;
            return (TextBoxItemInstance)itemInstance;
        }
        return null;
    }

    public SymbolItemInstance getSymbolInstance(String string) {
        for (ItemInstance itemInstance : this.instances) {
            if (!(itemInstance instanceof SymbolItemInstance) || !string.equals(itemInstance.getName())) continue;
            return (SymbolItemInstance)itemInstance;
        }
        return null;
    }

    public ShapeItemInstance getShapeInstance(String string) {
        for (ItemInstance itemInstance : this.instances) {
            if (!(itemInstance instanceof ShapeItemInstance) || !string.equals(itemInstance.getName())) continue;
            return (ShapeItemInstance)itemInstance;
        }
        return null;
    }

    public ImageItemInstance getImageInstance(String string) {
        for (ItemInstance itemInstance : this.instances) {
            if (!(itemInstance instanceof ImageItemInstance) || !string.equals(itemInstance.getName())) continue;
            return (ImageItemInstance)itemInstance;
        }
        return null;
    }

    protected void rebuildInstances() {
        Object object;
        ArrayList<ItemInstance> arrayList = new ArrayList<ItemInstance>();
        for (ItemInstance abstractConfigurable : this.instances) {
            object = this.layout.getItem(abstractConfigurable.getName());
            if (object == null || !((Item)object).getType().equals(abstractConfigurable.getType())) continue;
            abstractConfigurable.setLocation(((Item)object).getLocation());
            arrayList.add(abstractConfigurable);
        }
        if (this.layout != null) {
            for (Item item : this.layout.getItems()) {
                ItemInstance itemInstance;
                object = item.getConfigureName();
                String string = item.getType();
                String string2 = item.getLocation();
                boolean bl = false;
                Object object2 = this.instances.iterator();
                while (object2.hasNext() && !(bl = ((String)object).equals((itemInstance = object2.next()).getName()))) {
                }
                if (bl) continue;
                object2 = ItemInstance.newDefaultInstance((String)object, string, string2);
                ((ItemInstance)object2).addTo(this);
                arrayList.add((ItemInstance)object2);
            }
        }
        this.instances = arrayList;
        if (this.defnConfig != null) {
            this.defnConfig.setValue(this.instances);
        }
        this.rebuildVisualizerImage();
    }

    public static class DefnConfig
    implements ConfigurerFactory {
        static GamePieceImage id;

        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            id = (GamePieceImage)autoConfigurable;
            DefnConfig.id.defnConfig = new InstanceConfigurer(string, string2, id);
            id.rebuildInstances();
            return DefnConfig.id.defnConfig;
        }

        public static void refresh() {
            if (DefnConfig.id.defnConfig != null) {
                DefnConfig.id.defnConfig.repack();
            }
        }
    }

    public static class BorderColorSwatchConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new ColorSwatchConfigurer(string, string2, ((GamePieceImage)autoConfigurable).getBorderColor());
        }
    }

    public static class BgColorSwatchConfig
    implements ConfigurerFactory {
        public Configurer getConfigurer(AutoConfigurable autoConfigurable, String string, String string2) {
            return new ColorSwatchConfigurer(string, string2, ((GamePieceImage)autoConfigurable).getBgColor());
        }
    }
}

