/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.ExtensionMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.WriteErrorDialog;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionsManager {
    private File moduleFile;
    private File extensionsDir;
    private File inactiveDir;
    private final FilenameFilter filter = new FilenameFilter(){

        public boolean accept(File file, String string) {
            File file2 = new File(file, string);
            return !file2.isHidden() && !file2.isDirectory();
        }
    };

    public ExtensionsManager(File file) {
        this.moduleFile = file;
    }

    public ExtensionsManager(GameModule gameModule) {
        this.moduleFile = new File(GameModule.getGameModule().getDataArchive().getName());
    }

    public ExtensionsManager(String string) {
        this.extensionsDir = this.ensureExists(new File(Info.getHomeDir(), string));
    }

    public File getExtensionsDirectory(boolean bl) {
        if (this.extensionsDir == null && this.moduleFile != null) {
            String string = this.moduleFile.getPath();
            int n = string.lastIndexOf(46);
            if (n > 0) {
                string = string.substring(0, n);
            }
            File file = new File(string + "_ext");
            if (bl) {
                file = this.ensureExists(file);
            }
            this.extensionsDir = file;
            if (this.extensionsDir == null) {
                return null;
            }
        }
        if (bl && !this.extensionsDir.exists()) {
            this.extensionsDir = this.ensureExists(this.extensionsDir);
        }
        return this.extensionsDir;
    }

    public void setExtensionsDirectory(File file) {
        this.extensionsDir = file == null ? null : this.ensureExists(file);
    }

    protected File ensureExists(File file) {
        if (file.exists() && !file.isDirectory()) {
            WriteErrorDialog.error(new IOException(file + "is not a directory"), file);
            return null;
        }
        if (!file.exists() && !file.mkdirs()) {
            WriteErrorDialog.error(new IOException("Could not create " + file), file);
            return null;
        }
        return file;
    }

    public File getInactiveExtensionsDirectory(boolean bl) {
        if (this.inactiveDir == null) {
            File file = this.getExtensionsDirectory(bl);
            if (file == null) {
                return null;
            }
            this.inactiveDir = new File(file, "inactive");
            if (bl) {
                this.inactiveDir = this.ensureExists(this.inactiveDir);
                if (this.inactiveDir == null) {
                    return null;
                }
            }
        }
        if (bl && !this.inactiveDir.exists()) {
            this.inactiveDir = this.ensureExists(this.inactiveDir);
        }
        return this.inactiveDir;
    }

    public File setActive(File file, boolean bl) {
        File file2;
        if (bl) {
            File file3 = this.getExtensionsDirectory(true);
            if (file3 == null) {
                return file;
            }
            file2 = new File(file3, file.getName());
        } else {
            File file4 = this.getInactiveExtensionsDirectory(true);
            if (file4 == null) {
                return file;
            }
            file2 = new File(file4, file.getName());
        }
        file.renameTo(file2);
        return file2;
    }

    private List<File> getExtensions(File file) {
        ArrayList<File> arrayList = new ArrayList<File>(0);
        if (file != null && file.exists()) {
            File[] fileArray = file.listFiles(this.filter);
            if (fileArray == null) {
                ReadErrorDialog.error(new IOException(), file);
            } else {
                for (File file2 : fileArray) {
                    AbstractMetaData abstractMetaData = MetaDataFactory.buildMetaData(file2);
                    if (abstractMetaData == null || !(abstractMetaData instanceof ExtensionMetaData)) continue;
                    arrayList.add(file2);
                }
            }
        }
        return arrayList;
    }

    public List<File> getActiveExtensions() {
        return this.getExtensions(this.getExtensionsDirectory(false));
    }

    public List<File> getInactiveExtensions() {
        return this.getExtensions(this.getInactiveExtensionsDirectory(false));
    }

    public boolean isExtensionActive(File file) {
        for (File file2 : this.getActiveExtensions()) {
            if (!file2.getName().equals(file.getName())) continue;
            return true;
        }
        return false;
    }
}

