/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.GameModule;
import VASSAL.build.module.ExtensionsManager;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.ModuleExtension;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.DataArchive;
import VASSAL.tools.SequenceEncoder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionsLoader
implements CommandEncoder {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionsLoader.class);
    public static final String COMMAND_PREFIX = "EXT\t";
    public static final String SPECIFY_DIR_IN_PREFS = "specifyExtensionDirInPrefs";
    public static final String EXTENSION_DIR = "extensionDIR";
    protected Set<String> loadedExtensions = new HashSet<String>();
    protected HashMap<String, String> loadedIds = new HashMap();
    protected ExtensionsManager extMgr;
    protected ExtensionsManager globalExtMgr;

    public void addTo(GameModule gameModule) {
        this.extMgr = new ExtensionsManager(gameModule);
        this.globalExtMgr = new ExtensionsManager("ext");
        gameModule.addCommandEncoder(this);
        if ("true".equals(GlobalOptions.getInstance().getAttributeValueString(SPECIFY_DIR_IN_PREFS))) {
            DirectoryConfigurer directoryConfigurer = new DirectoryConfigurer(EXTENSION_DIR, Resources.getString("ExtensionsLoader.extensions_directory"));
            directoryConfigurer.setValue((Object)null);
            GameModule.getGameModule().getPrefs().addOption(Resources.getString("ExtensionsLoader.extensions_tab"), directoryConfigurer);
            this.extMgr.setExtensionsDirectory(directoryConfigurer.getFileValue());
            if (directoryConfigurer.getFileValue() == null) {
                directoryConfigurer.setValue(this.extMgr.getExtensionsDirectory(false).getAbsoluteFile());
            }
            directoryConfigurer.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    ExtensionsLoader.this.extMgr.setExtensionsDirectory((File)propertyChangeEvent.getNewValue());
                    ExtensionsLoader.this.addExtensions();
                }
            });
        }
        this.addExtensions();
    }

    protected void addExtensions() {
        for (File file : this.globalExtMgr.getActiveExtensions()) {
            if (this.addExtension(file)) continue;
            this.globalExtMgr.setActive(file, false);
        }
        for (File file : this.extMgr.getActiveExtensions()) {
            if (this.addExtension(file)) continue;
            GameModule.getGameModule().warn(Resources.getString("ExtensionsLoader.deactivating_extension", file.getName()));
            this.extMgr.setActive(file, false);
        }
    }

    protected boolean addExtension(File file) {
        logger.info("Loading extension " + file);
        String string = file.getPath();
        boolean bl = this.loadedExtensions.contains(string);
        if (!bl) {
            try {
                ModuleExtension moduleExtension = this.createExtension(string);
                moduleExtension.build();
                String string2 = moduleExtension.getExtensionId();
                String string3 = "";
                if (string2.length() > 0) {
                    for (String string4 : this.loadedIds.keySet()) {
                        if (!string4.equals(string2)) continue;
                        string3 = Resources.getString("ExtensionsLoader.id_conflict", file.getName(), string2, this.loadedIds.get(string2));
                    }
                    this.loadedIds.put(string2, string);
                }
                String string5 = this.getLoadedMessage(moduleExtension.getName(), moduleExtension.getVersion());
                this.loadedExtensions.add(string);
                GameModule.getGameModule().warn(string5);
                logger.info(string5);
                if (string3.length() > 0) {
                    GameModule.getGameModule().warn(string3);
                    logger.info(string3);
                }
                bl = true;
            }
            catch (ZipException zipException) {
            }
            catch (IOException iOException) {
                this.reportBuildError(iOException, file.getName());
            }
            catch (LoadExtensionException loadExtensionException) {
                this.reportBuildError(loadExtensionException, file.getName());
            }
        }
        return bl;
    }

    protected ModuleExtension createExtension(String string) throws ZipException, IOException {
        return new ModuleExtension(new DataArchive(string));
    }

    protected String getLoadedMessage(String string, String string2) {
        return Resources.getString("ExtensionsLoader.extension_loaded", string, string2);
    }

    private void reportBuildError(Exception exception, String string) {
        String string2 = exception.getMessage();
        if (string2 == null || string2.length() == 0) {
            string2 = exception.getClass().getName();
            string2 = string2.substring(string2.lastIndexOf(46));
        }
        GameModule.getGameModule().warn(this.getErrorMessage(string, string2));
    }

    protected String getErrorMessage(String string, String string2) {
        return Resources.getString("ExtensionsLoader.unable_to_load", string, string2);
    }

    public Command decode(String string) {
        ModuleExtension.RegCmd regCmd = null;
        if (string.startsWith(COMMAND_PREFIX)) {
            SequenceEncoder.Decoder decoder = new SequenceEncoder.Decoder(string.substring(COMMAND_PREFIX.length()), '\t');
            regCmd = new ModuleExtension.RegCmd(decoder.nextToken(), decoder.nextToken());
        }
        return regCmd;
    }

    public String encode(Command command) {
        String string = null;
        if (command instanceof ModuleExtension.RegCmd) {
            ModuleExtension.RegCmd regCmd = (ModuleExtension.RegCmd)command;
            SequenceEncoder sequenceEncoder = new SequenceEncoder('\t');
            sequenceEncoder.append(regCmd.getName()).append(regCmd.getVersion());
            string = COMMAND_PREFIX + sequenceEncoder.getValue();
        }
        return string;
    }

    public static class LoadExtensionException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public LoadExtensionException() {
        }

        public LoadExtensionException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public LoadExtensionException(String string) {
            super(string);
        }

        public LoadExtensionException(Throwable throwable) {
            super(throwable);
        }
    }
}

