/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.Info;
import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Builder;
import VASSAL.build.GpIdChecker;
import VASSAL.build.GpIdSupport;
import VASSAL.build.IllegalBuildException;
import VASSAL.build.module.BasicCommandEncoder;
import VASSAL.build.module.ChartWindow;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.DiceButton;
import VASSAL.build.module.DoActionButton;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.GameState;
import VASSAL.build.module.GlobalKeyCommand;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Inventory;
import VASSAL.build.module.Map;
import VASSAL.build.module.ModuleExtension;
import VASSAL.build.module.MultiActionButton;
import VASSAL.build.module.NotesWindow;
import VASSAL.build.module.PieceWindow;
import VASSAL.build.module.PlayerHand;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.Plugin;
import VASSAL.build.module.PredefinedSetup;
import VASSAL.build.module.PrivateMap;
import VASSAL.build.module.PrototypesContainer;
import VASSAL.build.module.RandomTextButton;
import VASSAL.build.module.ServerConnection;
import VASSAL.build.module.SpecialDiceButton;
import VASSAL.build.module.StartupGlobalKeyCommand;
import VASSAL.build.module.ToolbarMenu;
import VASSAL.build.module.WizardSupport;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.build.module.properties.ChangePropertyCommandEncoder;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.build.module.turn.TurnTracker;
import VASSAL.build.widget.PieceSlot;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.Logger;
import VASSAL.command.NullCommand;
import VASSAL.configure.CompoundValidityChecker;
import VASSAL.configure.MandatoryComponent;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.launch.PlayerWindow;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.ArrayUtils;
import VASSAL.tools.CRCUtils;
import VASSAL.tools.DataArchive;
import VASSAL.tools.KeyStrokeListener;
import VASSAL.tools.KeyStrokeSource;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.ToolBarComponent;
import VASSAL.tools.WarningDialog;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.image.ImageTileSource;
import VASSAL.tools.image.tilecache.ImageTileDiskCache;
import VASSAL.tools.io.IOUtils;
import java.awt.FileDialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GameModule
extends AbstractConfigurable
implements CommandEncoder,
ToolBarComponent,
PropertySource,
MutablePropertiesContainer,
GpIdSupport {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(GameModule.class);
    protected static final String DEFAULT_NAME = "Unnamed module";
    public static final String MODULE_NAME = "name";
    public static final String MODULE_VERSION = "version";
    public static final String DESCRIPTION = "description";
    public static final String VASSAL_VERSION_CREATED = "VassalVersion";
    public static final String VASSAL_VERSION_RUNNING = "runningVassalVersion";
    public static final String NEXT_PIECESLOT_ID = "nextPieceSlotId";
    public static final String BUILDFILE = "buildFile";
    private static GameModule theModule;
    protected String moduleVersion = "0.0";
    protected String vassalVersionCreated = "0.0";
    protected String gameName = "Unnamed module";
    protected String localizedGameName = null;
    protected String description = "";
    protected String lastSavedConfiguration;
    protected FileChooser fileChooser;
    protected FileDialog fileDialog;
    protected MutablePropertiesContainer propsContainer = new MutablePropertiesContainer.Impl();
    protected PropertyChangeListener repaintOnPropertyChange = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            for (Map map : Map.getMapList()) {
                map.repaint();
            }
        }
    };
    protected PlayerWindow frame = new PlayerWindow();
    protected JPanel controlPanel = this.frame.getControlPanel();
    protected GameState theState;
    protected DataArchive archive;
    protected Prefs preferences;
    protected Logger logger;
    protected Chatter chat;
    protected Random RNG = new SecureRandom();
    protected ServerConnection server;
    protected ImageTileSource tcache;
    protected WizardSupport wizardSupport;
    protected PropertyChangeSupport idChangeSupport;
    protected List<KeyStrokeSource> keyStrokeSources = new ArrayList<KeyStrokeSource>();
    protected List<KeyStrokeListener> keyStrokeListeners = new ArrayList<KeyStrokeListener>();
    protected CommandEncoder[] commandEncoders = new CommandEncoder[0];
    protected List<String> deferredChat = new ArrayList<String>();
    protected int nextGpId = 0;
    protected boolean loggingPaused = false;
    protected Object loggingLock = new Object();
    protected Command pausedCommands;
    protected GpIdSupport gpidSupport = null;
    protected Long crc = null;
    public static final String REAL_NAME = "RealName";
    public static final String SECRET_NAME = "SecretName";
    public static final String PERSONAL_INFO = "Profile";
    private static String userId;

    public JFrame getFrame() {
        return this.frame;
    }

    public void initFrameTitle() {
        this.frame.setTitle(this.getLocalizedGameName());
    }

    public WizardSupport getWizardSupport() {
        if (this.wizardSupport == null) {
            this.wizardSupport = new WizardSupport();
        }
        return this.wizardSupport;
    }

    protected GameModule(DataArchive dataArchive) {
        this.archive = dataArchive;
        this.frame.setDefaultCloseOperation(0);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GameModule.this.quit();
            }
        });
        this.addKeyStrokeSource(new KeyStrokeSource(this.frame.getRootPane(), 2));
        this.validator = new CompoundValidityChecker(new MandatoryComponent(this, Documentation.class), new MandatoryComponent(this, GlobalOptions.class));
        this.addCommandEncoder(new ChangePropertyCommandEncoder(this.propsContainer));
    }

    protected abstract void build() throws IOException;

    @Override
    public void setAttribute(String string, Object object) {
        if (MODULE_NAME.equals(string)) {
            if (Localization.getInstance().isTranslationInProgress()) {
                this.localizedGameName = (String)object;
            } else {
                this.gameName = (String)object;
            }
            this.setConfigureName((String)object);
        } else if (MODULE_VERSION.equals(string)) {
            this.moduleVersion = (String)object;
        } else if (VASSAL_VERSION_CREATED.equals(string)) {
            this.vassalVersionCreated = (String)object;
            String string2 = Info.getVersion();
            if (Info.compareVersions(this.vassalVersionCreated, string2) > 0) {
                WarningDialog.show("GameModule.version_warning", this.vassalVersionCreated, string2);
            }
        } else if (NEXT_PIECESLOT_ID.equals(string)) {
            try {
                this.nextGpId = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalBuildException(numberFormatException);
            }
        } else if (DESCRIPTION.equals(string)) {
            this.description = (String)object;
        }
    }

    @Override
    public String getAttributeValueString(String string) {
        if (MODULE_NAME.equals(string)) {
            return this.gameName;
        }
        if (MODULE_VERSION.equals(string)) {
            return this.moduleVersion;
        }
        if (VASSAL_VERSION_CREATED.equals(string)) {
            return this.vassalVersionCreated;
        }
        if (VASSAL_VERSION_RUNNING.equals(string)) {
            return Info.getVersion();
        }
        if (NEXT_PIECESLOT_ID.equals(string)) {
            return String.valueOf(this.nextGpId);
        }
        if (DESCRIPTION.equals(string)) {
            return this.description;
        }
        return null;
    }

    @Deprecated
    public static int compareVersions(String string, String string2) {
        return Info.compareVersions(string, string2);
    }

    @Override
    public void addTo(Buildable buildable) {
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.GameModule.component_type");
    }

    @Override
    public void removeFrom(Buildable buildable) {
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm");
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{MODULE_NAME, MODULE_VERSION, DESCRIPTION, VASSAL_VERSION_CREATED, NEXT_PIECESLOT_ID};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.GameModule.name_label"), Resources.getString("Editor.GameModule.version_label"), Resources.getString("Editor.GameModule.description")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, String.class};
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{Map.class, PieceWindow.class, PrototypesContainer.class, ToolbarMenu.class, MultiActionButton.class, DoActionButton.class, DiceButton.class, GlobalKeyCommand.class, StartupGlobalKeyCommand.class, Inventory.class, RandomTextButton.class, SpecialDiceButton.class, PredefinedSetup.class, ChartWindow.class, PrivateMap.class, PlayerHand.class, NotesWindow.class, TurnTracker.class};
    }

    public void addKeyStrokeSource(KeyStrokeSource keyStrokeSource) {
        this.keyStrokeSources.add(keyStrokeSource);
        for (KeyStrokeListener keyStrokeListener : this.keyStrokeListeners) {
            keyStrokeListener.addKeyStrokeSource(keyStrokeSource);
        }
    }

    public void addKeyStrokeListener(KeyStrokeListener keyStrokeListener) {
        this.keyStrokeListeners.add(keyStrokeListener);
        for (KeyStrokeSource keyStrokeSource : this.keyStrokeSources) {
            keyStrokeListener.addKeyStrokeSource(keyStrokeSource);
        }
    }

    @Deprecated
    public void fireKeyStroke(KeyStroke keyStroke) {
        if (keyStroke != null) {
            for (KeyStrokeListener keyStrokeListener : this.keyStrokeListeners) {
                keyStrokeListener.keyPressed(keyStroke);
            }
        }
    }

    public void fireKeyStroke(NamedKeyStroke namedKeyStroke) {
        if (namedKeyStroke != null && !namedKeyStroke.isNull()) {
            this.fireKeyStroke(namedKeyStroke.getKeyStroke());
        }
    }

    public String getGameName() {
        return this.gameName;
    }

    public String getLocalizedGameName() {
        return this.localizedGameName == null ? this.gameName : this.localizedGameName;
    }

    public String getGameVersion() {
        return this.moduleVersion;
    }

    public void addIdChangeListener(PropertyChangeListener propertyChangeListener) {
        this.idChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removeIdChangeListener(PropertyChangeListener propertyChangeListener) {
        this.idChangeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public Prefs getPrefs() {
        if (this.preferences == null) {
            this.setPrefs(new Prefs(Prefs.getGlobalPrefs().getEditor(), this.gameName));
        }
        return this.preferences;
    }

    @Deprecated
    public Prefs getGlobalPrefs() {
        return Prefs.getGlobalPrefs();
    }

    public void addCommandEncoder(CommandEncoder commandEncoder) {
        this.commandEncoders = ArrayUtils.append(this.commandEncoders, commandEncoder);
    }

    public void removeCommandEncoder(CommandEncoder commandEncoder) {
        this.commandEncoders = ArrayUtils.remove(this.commandEncoders, commandEncoder);
    }

    public GamePiece createPiece(String string) {
        for (int i = 0; i < this.commandEncoders.length; ++i) {
            GamePiece gamePiece;
            if (!(this.commandEncoders[i] instanceof BasicCommandEncoder) || (gamePiece = ((BasicCommandEncoder)this.commandEncoders[i]).createPiece(string)) == null) continue;
            return gamePiece;
        }
        return null;
    }

    public GamePiece createPiece(String string, GamePiece gamePiece) {
        for (int i = 0; i < this.commandEncoders.length; ++i) {
            Decorator decorator;
            if (!(this.commandEncoders[i] instanceof BasicCommandEncoder) || (decorator = ((BasicCommandEncoder)this.commandEncoders[i]).createDecorator(string, gamePiece)) == null) continue;
            return decorator;
        }
        return null;
    }

    public void warn(String string) {
        if (this.chat == null) {
            this.deferredChat.add(string);
        } else {
            this.chat.show(" - " + string);
        }
    }

    public Random getRNG() {
        return this.RNG;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setChatter(Chatter chatter) {
        this.chat = chatter;
        if (this.deferredChat.size() > 0) {
            for (String string : this.deferredChat) {
                this.warn(string);
            }
            this.deferredChat.clear();
        }
    }

    public JComponent getControlPanel() {
        return this.controlPanel;
    }

    public Chatter getChatter() {
        return this.chat;
    }

    public void setPrefs(Prefs prefs) {
        this.preferences = prefs;
        this.preferences.getEditor().initDialog(this.getFrame());
    }

    @Deprecated
    public void setGlobalPrefs(Prefs prefs) {
    }

    @Override
    public Command decode(String string) {
        if (string == null) {
            return null;
        }
        Command command = null;
        for (int i = 0; i < this.commandEncoders.length && command == null; ++i) {
            command = this.commandEncoders[i].decode(string);
        }
        if (command == null) {
            System.err.println("Failed to decode " + string);
        }
        return command;
    }

    @Override
    public String encode(Command command) {
        if (command == null) {
            return null;
        }
        String string = null;
        for (int i = 0; i < this.commandEncoders.length && string == null; ++i) {
            string = this.commandEncoders[i].encode(command);
        }
        if (string == null) {
            System.err.println("Failed to encode " + command);
        }
        return string;
    }

    public FileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = FileChooser.createFileChooser(this.getFrame(), this.getGameState().getSavedGameDirectoryPreference());
        } else {
            this.fileChooser.resetChoosableFileFilters();
            this.fileChooser.rescanCurrentDirectory();
        }
        return this.fileChooser;
    }

    @Deprecated
    public FileDialog getFileDialog() {
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog(this.getFrame());
            File file = this.getGameState().getSavedGameDirectoryPreference().getFileValue();
            if (file != null) {
                this.fileDialog.setDirectory(file.getPath());
            }
            this.fileDialog.setModal(true);
        } else {
            this.fileDialog.setDirectory(this.fileDialog.getDirectory());
        }
        return this.fileDialog;
    }

    @Override
    public JToolBar getToolBar() {
        return this.frame.getToolBar();
    }

    public void appendToTitle(String string) {
        if (string == null) {
            this.frame.setTitle(Resources.getString("GameModule.frame_title", this.getLocalizedGameName()));
        } else {
            this.frame.setTitle(this.frame.getTitle() + string);
        }
        for (Map map : this.getComponentsOf(Map.class)) {
            map.appendToTitle(string);
        }
    }

    public void quit() {
        if (this.shutDown()) {
            System.exit(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutDown() {
        this.getGameState().setup(false);
        boolean bl = this.getGameState().isGameStarted();
        if (!bl) {
            if (this.getDataArchive() instanceof ArchiveWriter && !this.buildString().equals(this.lastSavedConfiguration)) {
                switch (JOptionPane.showConfirmDialog(this.frame, Resources.getString("GameModule.save_module"), "", 1)) {
                    case 0: {
                        this.save();
                        break;
                    }
                    case -1: 
                    case 2: {
                        bl = true;
                    }
                }
            }
            for (ModuleExtension moduleExtension : this.getComponentsOf(ModuleExtension.class)) {
                bl = !moduleExtension.confirmExit();
            }
        }
        if (!bl) {
            Object object = null;
            try {
                object = this.getPrefs();
                ((Prefs)object).write();
                ((Prefs)object).close();
            }
            catch (IOException iOException) {
                WriteErrorDialog.error(iOException, ((Prefs)object).getFile());
            }
            finally {
                IOUtils.closeQuietly((Closeable)object);
            }
            try {
                this.archive.close();
            }
            catch (IOException iOException) {
                ReadErrorDialog.error(iOException, this.archive.getName());
            }
            log.info("Exiting");
        }
        return !bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAndLog(Command command) {
        if (command != null && !command.isNull()) {
            Object object = this.loggingLock;
            synchronized (object) {
                if (this.loggingPaused) {
                    if (this.pausedCommands == null) {
                        this.pausedCommands = command;
                    } else {
                        this.pausedCommands.append(command);
                    }
                } else {
                    this.getServer().sendToOthers(command);
                    this.getLogger().log(command);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pauseLogging() {
        Object object = this.loggingLock;
        synchronized (object) {
            if (this.loggingPaused) {
                return false;
            }
            this.loggingPaused = true;
            this.pausedCommands = null;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command resumeLogging() {
        Command command = null;
        Object object = this.loggingLock;
        synchronized (object) {
            command = this.pausedCommands == null ? new NullCommand() : this.pausedCommands;
            this.pausedCommands = null;
            this.loggingPaused = false;
        }
        return command;
    }

    public void clearPausedCommands() {
        this.pausedCommands = null;
    }

    public static String getUserId() {
        return userId;
    }

    public static void setUserId(String string) {
        userId = string;
    }

    public ServerConnection getServer() {
        return this.server;
    }

    public static void init(GameModule gameModule) throws IOException {
        if (theModule != null) {
            throw new UnsupportedOperationException(Resources.getString("GameModule.open_error", theModule.getDataArchive().getName()));
        }
        theModule = gameModule;
        theModule.setGpIdSupport(theModule);
        try {
            theModule.build();
        }
        catch (IOException iOException) {
            theModule = null;
            throw iOException;
        }
        if (theModule.getDataArchive() instanceof ArchiveWriter) {
            theModule.checkGpIds();
        }
        for (Plugin plugin : theModule.getComponentsOf(Plugin.class)) {
            plugin.init();
        }
    }

    public static void unload() {
        if (theModule != null && theModule.shutDown()) {
            theModule = null;
        }
    }

    public void updateLastSave() {
        this.lastSavedConfiguration = this.buildString();
    }

    @Override
    public String generateGpId() {
        return String.valueOf(this.nextGpId++);
    }

    @Override
    public int getNextGpId() {
        return this.nextGpId;
    }

    @Override
    public void setNextGpId(int n) {
        this.nextGpId = n;
    }

    public void setGpIdSupport(GpIdSupport gpIdSupport) {
        this.gpidSupport = gpIdSupport;
    }

    public GpIdSupport getGpIdSupport() {
        return this.gpidSupport;
    }

    protected void checkGpIds() {
        GpIdChecker gpIdChecker = new GpIdChecker(this);
        for (PieceSlot pieceSlot : theModule.getAllDescendantComponentsOf(PieceSlot.class)) {
            gpIdChecker.add(pieceSlot);
        }
        gpIdChecker.fixErrors();
    }

    public DataArchive getDataArchive() {
        return this.archive;
    }

    public ArchiveWriter getArchiveWriter() {
        return this.archive.getWriter();
    }

    public ImageTileSource getImageTileSource() {
        if (this.tcache == null) {
            String string = DigestUtils.shaHex((String)(this.getGameName() + "_" + this.getGameVersion()));
            File file = new File(Info.getConfDir(), "tiles/" + string);
            this.tcache = new ImageTileDiskCache(file.getAbsolutePath());
        }
        return this.tcache;
    }

    public boolean isLocalizationEnabled() {
        return this.getArchiveWriter() == null;
    }

    public static GameModule getGameModule() {
        return theModule;
    }

    public GameState getGameState() {
        return this.theState;
    }

    public void saveAs() {
        this.save(true);
    }

    public void save() {
        this.save(false);
    }

    protected void save(boolean bl) {
        this.vassalVersionCreated = Info.getVersion();
        ArchiveWriter archiveWriter = this.getArchiveWriter();
        try {
            new ModuleMetaData(this).save(archiveWriter);
        }
        catch (IOException iOException) {
            WriteErrorDialog.error(iOException, archiveWriter.getName());
        }
        try {
            String string = this.buildString();
            archiveWriter.addFile(BUILDFILE, new ByteArrayInputStream(string.getBytes("UTF-8")));
            if (bl) {
                archiveWriter.saveAs(true);
            } else {
                archiveWriter.save(true);
            }
            this.lastSavedConfiguration = string;
        }
        catch (IOException iOException) {
            WriteErrorDialog.error(iOException, archiveWriter.getName());
        }
    }

    protected String buildString() {
        Document document = Builder.createNewDocument();
        document.appendChild(this.getBuildElement(document));
        return Builder.toString(document);
    }

    @Override
    public Object getProperty(Object object) {
        if ("PlayerSide".equals(object) || "playerSide".equals(object)) {
            String string = PlayerRoster.getMySide();
            return string == null ? "" : string;
        }
        if ("PlayerName".equals(object) || "playerName".equals(object)) {
            return this.getPrefs().getValue(REAL_NAME);
        }
        if ("PlayerId".equals(object) || "playerId".equals(object)) {
            return GlobalOptions.getInstance().getPlayerId();
        }
        MutableProperty mutableProperty = this.propsContainer.getMutableProperty(String.valueOf(object));
        return mutableProperty == null ? null : mutableProperty.getPropertyValue();
    }

    @Override
    public MutableProperty getMutableProperty(String string) {
        return this.propsContainer.getMutableProperty(string);
    }

    @Override
    public void addMutableProperty(String string, MutableProperty mutableProperty) {
        this.propsContainer.addMutableProperty(string, mutableProperty);
        mutableProperty.addMutablePropertyChangeListener(this.repaintOnPropertyChange);
    }

    @Override
    public MutableProperty removeMutableProperty(String string) {
        MutableProperty mutableProperty = this.propsContainer.removeMutableProperty(string);
        if (mutableProperty != null) {
            mutableProperty.removeMutablePropertyChangeListener(this.repaintOnPropertyChange);
        }
        return mutableProperty;
    }

    @Override
    public String getMutablePropertiesContainerId() {
        return "Module";
    }

    @Override
    public Object getLocalizedProperty(Object object) {
        if ("PlayerSide".equals(object) || "playerSide".equals(object)) {
            String string = PlayerRoster.getMyLocalizedSide();
            return string == null ? "" : string;
        }
        return this.getProperty(object);
    }

    public long getCrc() {
        if (this.crc == null) {
            this.crc = this.buildCrc();
        }
        return this.crc;
    }

    protected Long buildCrc() {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (this.getDataArchive().getArchive() != null) {
            arrayList.add(new File(this.getDataArchive().getName()));
        }
        for (ModuleExtension moduleExtension : this.getComponentsOf(ModuleExtension.class)) {
            if (moduleExtension.getDataArchive().getArchive() == null) continue;
            arrayList.add(new File(moduleExtension.getDataArchive().getName()));
        }
        try {
            return CRCUtils.getCRC(arrayList);
        }
        catch (IOException iOException) {
            log.error("Error generating CRC", (Throwable)iOException);
            return 0L;
        }
    }

    @Override
    public ComponentI18nData getI18nData() {
        ComponentI18nData componentI18nData = super.getI18nData();
        componentI18nData.setAttributeTranslatable(MODULE_VERSION, false);
        return componentI18nData;
    }

    static {
        userId = null;
    }
}

