//------------------------------------------------------------------------
//
//			ODBC Demo for OS/2
//
//  Purpose: To demonstrate the usage of the INTERSOLV DataDirect drivers
//	     to access data	
//
//  Author: Joe Vas  
//
//  Copyright (c) 1995 INTERSOLV, Inc.
// 
//------------------------------------------------------------------------

#define INCL_WIN
#define INCL_WINDIALOGS
#define INCL_GPI
#define INCL_WINSYS
#define INCL_WINERRORS
#define INCL_WINMLE
#define INCL_WINLISTBOXES
#define INCL_WINBUTTONS
#define INCL_WINWINDOWMGR
#define INCL_DOSRESOURCES

#include <os2.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
extern "C" {
	#include "demoodbc.h"
	#include <sqlext.h>
}

//
// Prototypes
//
RETCODE EnvInit(HENV *henv, HDBC *hdbc);
RETCODE ODBC_Connect(			// Perform Driver Connection
	HENV henv,			// ODBC Environment Handle
	HDBC hdbc);			// ODBC Connection Handle
void EnvClose(HENV henv, HDBC hdbc);
void ODBC_error (		// Obtain ODBC Error
	HENV henv,		// ODBC Environment
	HDBC hdbc,		// ODBC Connection Handle
	HSTMT hstmt);		// ODBC SQL Handle


PDataStruct pDataStruct = NULL;
ULONG   ulRecordCount; 
HWND	hWndFrame1 = 0;
HWND	hWndFrame2 = 0;
HWND	hWndFrame3 = 0;
HWND	hWndClient1 = 0;
HWND	hWndClient2 = 0;
HWND	hWndClient3 = 0;
CHAR    szClientClass1[] = "DemoODBC" ;
CHAR    szClientClass2[] = "DemoCode" ;
CHAR    szClientClass3[] = "DemoData" ;
HWND	hDemoCodeWnd = 0;


//-------------------------------------------------------------------------
//
//
//
//
int main (void)
{
	HMQ	  hmq;
	QMSG	  qmsg;
	HAB       hab;
	hab = WinInitialize (0);
	hmq = WinCreateMsgQueue (hab, 0);
	
	InitInstance(hab);
	
	while (WinGetMsg (hab, &qmsg, NULLHANDLE, 0, 0))
		WinDispatchMsg(hab, &qmsg);

	WinDestroyWindow(hWndFrame1);
	WinDestroyMsgQueue(hmq);
	WinTerminate(hab);
	return 0;
}


//-------------------------------------------------------------------------
//
//
//
//
BOOL InitInstance(HAB hab)
{
	ULONG flFrameFlags = FCF_TITLEBAR      | FCF_SYSMENU  |
			     FCF_MINMAX	       | FCF_SIZEBORDER   |
			     FCF_SHELLPOSITION | FCF_TASKLIST |
			     FCF_MENU	       | FCF_ICON ;

	WinRegisterClass (hab, (PSZ)szClientClass1, MainWndProc, 0, 0) ;
	WinRegisterClass (hab, (PSZ)szClientClass2, DemoCodeWndProc, 0, 0) ;
	WinRegisterClass (hab, (PSZ)szClientClass3, DemoDataWndProc, 0, 0) ;

	hWndFrame1 = WinCreateStdWindow (HWND_DESKTOP, WS_VISIBLE,
			&flFrameFlags,
			(PSZ)szClientClass1, (PSZ)"ODBC Demo",
			CS_SIZEREDRAW, NULLHANDLE,
			ID_RESOURCE, &hWndClient1) ;

	WinSetWindowPos (hWndFrame1, HWND_TOP,
	       WinQuerySysValue(HWND_DESKTOP,SV_CXICON) * 2,
	       WinQuerySysValue(HWND_DESKTOP,SV_CYICON) * 2,
	       WinQuerySysValue(HWND_DESKTOP,SV_CXSCREEN) - 200,
	       WinQuerySysValue(HWND_DESKTOP,SV_CYSCREEN) - 200,
	       SWP_SHOW | SWP_ACTIVATE | SWP_ZORDER | SWP_SIZE | SWP_MOVE);

	return (TRUE);
}


//-------------------------------------------------------------------------
//
//
//
//
MRESULT EXPENTRY MainWndProc(
	HWND hWnd,			 /* window handle */
	ULONG message,			 /* type of message */
	MPARAM mp1,			 /* additional information */
	MPARAM mp2)			 /* additional information */
{

	HWND    hDataWnd;
	HPS	hps;

	ULONG flFrameFlags1 = FCF_TITLEBAR | FCF_SYSMENU | FCF_BORDER
				| FCF_SHELLPOSITION | FCF_TASKLIST;
	ULONG flFrameFlags2 = FCF_TITLEBAR | FCF_SYSMENU | FCF_SIZEBORDER
				| FCF_SHELLPOSITION | FCF_TASKLIST;

	
	switch (message) {

	case WM_PAINT:
		hps = WinBeginPaint(hWnd, 0, 0);
		GpiErase(hps);
		WinEndPaint(hps);
		return 0;


	case WM_COMMAND:	   /* message: command from application menu*/
		switch (COMMANDMSG(&message)->cmd) {
			
			case IDM_DISPLAYDEMO:
				if(hWndFrame2 == NULL) {
					hWndFrame2 =
						WinCreateStdWindow (
							hWndClient1,
							WS_VISIBLE,
							&flFrameFlags1,
							(PSZ)szClientClass2,
							(PSZ)"Demo Code",
							CS_SIZEREDRAW,
							NULLHANDLE,
							ID_RESOURCE,
							&hWndClient2) ;

					RECTL rcl;
					WinQueryWindowRect(hWndClient1,
						(PRECTL)&rcl);
					WinSetWindowPos (hWndFrame2, HWND_TOP,
							(SHORT)rcl.xLeft,
							(SHORT)rcl.yBottom,
							(SHORT)rcl.xRight,
							(SHORT)rcl.yTop,
							SWP_SHOW | SWP_ACTIVATE
							| SWP_ZORDER | SWP_SIZE
							| SWP_MOVE);

					SHORT sTitleBarHeight =
						WinQuerySysValue(HWND_DESKTOP,
								SV_CYTITLEBAR);
					
					hDemoCodeWnd =
					WinCreateWindow(hWndClient2,
						WC_MLE, (PSZ)NULL,
						MLS_HSCROLL | MLS_VSCROLL
						| MLS_WORDWRAP | MLS_BORDER
						| MLS_READONLY | WS_VISIBLE,
						(SHORT)rcl.xLeft,
						(SHORT)rcl.yBottom,
						(SHORT)rcl.xRight,
						(SHORT)(rcl.yTop -
						sTitleBarHeight),
						hWndClient2, HWND_TOP, 1,
						NULL, NULL);
				}
				
				LoadCode(DEMOCODE);
				break;

								
			case IDM_EXECUTEDEMO:
			{

				if(!Demo())
					break;

				if(hWndFrame3 == NULL) {
									
					HWND hWndFrame3 =
						WinCreateStdWindow (
							hWndClient1,
							WS_VISIBLE,
							&flFrameFlags2,
							(PSZ)szClientClass3,
							(PSZ)"Demo Data",
							CS_SIZEREDRAW,
							NULLHANDLE,
							ID_RESOURCE,
							&hWndClient3) ;

				
					RECTL rcl;
					WinQueryWindowRect(hWndClient1,
							(PRECTL)&rcl);
					WinSetWindowPos (hWndFrame3, HWND_TOP,
							rcl.xLeft,
							rcl.yBottom,
							rcl.xRight - 5,
							rcl.yTop - 5,
							SWP_SHOW |
							SWP_ACTIVATE |
							SWP_ZORDER
							| SWP_SIZE
							| SWP_MOVE);
				}
				
			}	
			break;
			
			case IDM_QUIT:
				WinPostMsg(hWnd, WM_QUIT, 0L, 0L) ;
				break;
				
		}
		break;
		
	case WM_DESTROY:	
		WinPostMsg(hWnd, WM_QUIT, 0L, 0L) ;
		return 0;

		
	}
	return (WinDefWindowProc(hWnd, message, mp1, mp2));
}



//-------------------------------------------------------------------------
//
//
//
//
MRESULT EXPENTRY DemoCodeWndProc(HWND hWnd, ULONG message, MPARAM mp1,
							MPARAM mp2)		
{

	HPS	hps;
	
	switch (message) {

	case WM_PAINT:
		hps = WinBeginPaint(hWnd, 0, 0);
		GpiErase(hps);
		WinEndPaint(hps);
		return 0;

	case WM_CLOSE:		 
		WinDestroyWindow(WinQueryWindow(hWnd, QW_PARENT)) ;
		hWndFrame2 = NULL;
		return 0;

	}
	return (WinDefWindowProc(hWnd, message, mp1, mp2));
}


//-------------------------------------------------------------------------
//
//
//
//
MRESULT EXPENTRY DemoDataWndProc(HWND hWnd, ULONG message, MPARAM mp1,
							MPARAM mp2)
{

	static SHORT cxChar, cxCaps, cyChar, cyDesc, cxClient, cyClient;
	FONTMETRICS fm;
	POINTL ptl;
	
	HPS	hps;
	
	switch (message) {

		case WM_CREATE:	
			hps = WinGetPS(hWnd);
			GpiQueryFontMetrics(hps, (LONG)sizeof(fm), &fm);
			cxChar = (SHORT) fm.lAveCharWidth;
			cxCaps = (SHORT) fm.lEmInc;
			cyChar = (SHORT) fm.lMaxBaselineExt;
			cyDesc = (SHORT) fm.lMaxDescender;
			WinReleasePS(hps);
			return 0;

		case WM_SIZE:	
			cxClient = SHORT1FROMMP(mp2);
			cyClient = SHORT2FROMMP(mp2);
			return 0;
		
		case WM_PAINT:
		{	
			hps = WinBeginPaint(hWnd, 0, 0);
			GpiErase(hps);
			if(pDataStruct == NULL) {
				WinEndPaint(hps);
				return 0;
			}	
								
			for(int i = 0; i <= ulRecordCount; i++) {
				
				ptl.x = cxCaps;
				ptl.y = cyClient - cyChar * (i + 1) + cyDesc;
					
				GpiCharStringAt(hps, &ptl,
					strlen(pDataStruct[i].fname),
					(PCH)pDataStruct[i].fname);
				
				ptl.x += 10 * cxCaps;
				GpiCharStringAt(hps, &ptl,
					strlen(pDataStruct[i].lname),
					(PCH)pDataStruct[i].lname);
			
				ptl.x += 10 * cxCaps;
				GpiCharStringAt(hps, &ptl,
					strlen(pDataStruct[i].hiredate),
					(PCH)pDataStruct[i].hiredate);
			
				ptl.x += 10 * cxCaps;
				GpiCharStringAt(hps, &ptl,
					strlen(pDataStruct[i].salary),
					(PCH)pDataStruct[i].salary);
			
				ptl.x += 10 * cxCaps;
				GpiCharStringAt(hps, &ptl,
					strlen(pDataStruct[i].dept),
					(PCH)pDataStruct[i].dept);
					
			}							
			WinEndPaint(hps);
			return 0;
		}	

	case WM_CLOSE:		
		WinDestroyWindow(WinQueryWindow(hWnd, QW_PARENT)) ;
		hWndFrame3 = NULL;
		if(pDataStruct != NULL) {
			free(pDataStruct);
			pDataStruct = NULL;
			ulRecordCount = 0;
		}	
		return 0;
		

	}
	return (WinDefWindowProc(hWnd, message, mp1, mp2));
}


//-------------------------------------------------------------------------
//
//
//
//
VOID LoadCode(ULONG ulNameID)
{ 

	PVOID	pResource = 0;
	static  ULONG	size = 0;
	CHAR	*szMleBuf;
	IPT	lOffset = 0;

	//
	// Clear the MLE
	//
	WinSendMsg(hDemoCodeWnd, MLM_SETSEL,
		MPFROMP(lOffset), MPFROMP(size));
	WinSendMsg(hDemoCodeWnd, MLM_CLEAR, 0L, 0L);

	
	DosGetResource((HMODULE)0, RT_CODE, ulNameID, &pResource);
	DosQueryResourceSize(0, RT_CODE, ulNameID, &size);
	szMleBuf = (CHAR *)malloc(size);
	memset(szMleBuf, 0, size);
	WinSendMsg(hDemoCodeWnd, MLM_SETIMPORTEXPORT,
		   MPFROMP(szMleBuf),
		   MPFROMSHORT((USHORT)size));
	WinSendMsg(hDemoCodeWnd, MLM_FORMAT,
		   MPFROMSHORT((USHORT)MLFIE_CFTEXT),
		   0L);
	memcpy(szMleBuf, pResource, size);
	WinSendMsg(hDemoCodeWnd, MLM_IMPORT,
			 MPFROMP(&lOffset), MPFROMP(&size));
	DosFreeResource ((PVOID)pResource);
	free(szMleBuf);
}



	

//------------------------------------------------------------------------
//
//
//
//
ULONG Demo()
{
	HDBC	hdbc;
	HENV	henv;
	HSTMT	hstmt;
	RETCODE	rc;
	UCHAR	sql[255];
	UCHAR	table[255];
	UCHAR	emp_id[15],
		first_name[15],
		last_name[15],
		hire_date[30],
		salary[15],
		dept[15];
	SDWORD	val_emp_id,
		val_first_name,
		val_last_name,
		val_hire_date,
		val_salary,
		val_dept;

//
// Define Table and Driver
//
	strcpy ((char *) table, "EMP");
	EnvInit (&henv, &hdbc);
	rc = ODBC_Connect (henv, hdbc);
	if ((rc != SQL_SUCCESS) && (rc != SQL_SUCCESS_WITH_INFO))
		return 0;	// Exit with failure
//
// Allocate a HSTMT to communicate with ODBC DB Driver.
//
	rc = SQLAllocStmt (hdbc, &hstmt);
	if ((rc != SQL_SUCCESS) && (rc != SQL_SUCCESS_WITH_INFO)) {
		ODBC_error (henv, hdbc, hstmt);
		EnvClose (henv, hdbc);
		return 0;
	}

	
//
// Build the SQL statement
//
	strcpy ((char *) table, "EMP");
	strcpy ((char *) sql, "SELECT EMP_ID, FIRST_NAME, LAST_NAME, ");
	strcat ((char *) sql, "HIRE_DATE, SALARY, DEPT FROM ");
	strcat ((char *) sql, (char *) table);
//
// Prepare our SQL Statement for Executions.
//
	rc = SQLPrepare (hstmt, sql, (SDWORD)strlen((char *) sql));
	if ((rc != SQL_SUCCESS) && (rc != SQL_SUCCESS_WITH_INFO)) {
		ODBC_error (henv, hdbc, hstmt);
		EnvClose (henv, hdbc);
		return 0;
	}
//
// Bind variables to SQL Columns
//
	rc = SQLBindCol (hstmt, 1, SQL_C_CHAR,
				&emp_id,
				(SDWORD)sizeof(emp_id),
				&val_emp_id);
	rc = SQLBindCol (hstmt, 2, SQL_C_CHAR,
				&first_name,
				(SDWORD)sizeof(first_name),
				&val_first_name);
	rc = SQLBindCol (hstmt, 3, SQL_C_CHAR,
				&last_name,
				(SDWORD)sizeof(last_name),
				&val_last_name);
	rc = SQLBindCol (hstmt, 4, SQL_C_CHAR,
				&hire_date,
				(SDWORD)sizeof(hire_date),
				&val_hire_date);
	rc = SQLBindCol (hstmt, 5, SQL_C_CHAR,
				&salary,
				(SDWORD)sizeof(salary),
				&val_salary);
	rc = SQLBindCol (hstmt, 6, SQL_C_CHAR,
				&dept,
				(SDWORD)sizeof(dept),
				&val_dept);
//
// Execute Prepared SQL
//
	rc = SQLExecute (hstmt);
	if ((rc != SQL_SUCCESS) && (rc != SQL_SUCCESS_WITH_INFO)) {
		ODBC_error (henv, hdbc, hstmt);
		EnvClose (henv, hdbc);
		return 0;
	}
//
// Fetch Data
//
	ulRecordCount = 0;
	for( ; ; ) {
		rc = SQLFetch (hstmt);
		if (rc == SQL_NO_DATA_FOUND) {
			if(ulRecordCount != 0)
				ulRecordCount--;
			break;
		}
		
		if ((rc != SQL_SUCCESS) && (rc != SQL_SUCCESS_WITH_INFO)) {
			ODBC_error (henv, hdbc, hstmt);
			break;
		}

		if(ulRecordCount == 0) {
			if(pDataStruct != NULL)
				free (pDataStruct);
			pDataStruct = (PDataStruct)malloc(sizeof(DataStruct));
			memset(pDataStruct, 0, sizeof(DataStruct));
			strcpy(pDataStruct->fname, (PCU8)"First_Name");
			strcpy(pDataStruct->lname, (PCU8)"Last_Name");
			strcpy(pDataStruct->hiredate, (PCU8)"Hire_Date");
			strcpy(pDataStruct->salary, (PCU8)"Salary");
			strcpy(pDataStruct->dept, (PCU8)"Dept");
			ulRecordCount++;
		}
		
		pDataStruct = (PDataStruct)realloc((void *)pDataStruct,
					sizeof(DataStruct)*(ulRecordCount+1));
		memset(&pDataStruct[ulRecordCount], 0, sizeof(DataStruct));
		strcpy(pDataStruct[ulRecordCount].fname,
					(PCU8)first_name);
		strcpy(pDataStruct[ulRecordCount].lname,
					(PCU8)last_name);
		strcpy(pDataStruct[ulRecordCount].hiredate,
					(PCU8)hire_date);
		strcpy(pDataStruct[ulRecordCount].salary,
					(PCU8)salary);
		strcpy(pDataStruct[ulRecordCount].dept,
					(PCU8)dept);
		ulRecordCount++;
	}
//
// Free Bind Buffers
//
	rc = SQLFreeStmt (hstmt, SQL_UNBIND);
	EnvClose(henv, hdbc);
	return 1;
}


//------------------------------------------------------------------------
//
// function:	EnvInit
//
// Purpose:	Allocates ODBC HENV and HDBC.
//
// Arguments:	henv    _ Pointer to environment handle
//		hdbc    - Pointer to connection handle
// Returns:	RETCODE status from ODBC Functions.
//
RETCODE EnvInit(HENV *henv, HDBC *hdbc)
{
	RETCODE rc;

	rc = SQLAllocEnv (henv);
	if ((rc == SQL_SUCCESS) || (rc == SQL_SUCCESS_WITH_INFO))
		rc = SQLAllocConnect (*henv, hdbc);
	return (rc);
}


//------------------------------------------------------------------------
//
// function: ODBC_Connect
//
// Purpose:	Allocates ODBC HENV and HDBC.
//
// Arguments:	henv    _ Pointer to environment handle
//		hdbc    - Pointer to connection handle
//
// Returns:	RETCODE - Return status from last ODBC Function.
//
//

RETCODE ODBC_Connect(			// Perform Driver Connection
	HENV henv,			// ODBC Environment Handle
	HDBC hdbc)			// ODBC Connection Handle
{
	RETCODE	rc;
	int	retries;
	
#if defined(TRACING)
	rc = SQLSetConnectOption(hdbc, SQL_OPT_TRACE, 1);
	if ((rc != SQL_SUCCESS) && (rc != SQL_SUCCESS_WITH_INFO))
		return (rc);
#endif


//
// try connecting up to 3 times
//
	for (retries = 1; retries <= 3; retries++) {
		//rc = SQLConnect (hdbc, dsn, SQL_NTS,
		//         uid, SQL_NTS, pwd, SQL_NTS);
		UCHAR ConnectionString[STR_LEN];  
		UCHAR strout[STR_LEN];
		SHORT pcbstrout;  
		strcpy((char *)ConnectionString, (const char *)"DSN=Oracle6");
		rc = SQLDriverConnect (hdbc, hWndClient1, ConnectionString,
			SQL_NTS, strout, STR_LEN, &pcbstrout,
			SQL_DRIVER_PROMPT); 
		
		if ((rc == SQL_SUCCESS) || (rc == SQL_SUCCESS_WITH_INFO)) {
			rc = SQLSetConnectOption (hdbc, 1041,
				(UDWORD)"Q+E ODBC FoxPro Driver License");
			rc = SQLSetConnectOption (hdbc, 1042,
				(UDWORD)"k75Lr2397JKlmNoyu#*bu2[x");
			return (rc);
                } else {
			ODBC_error (henv, hdbc, SQL_NULL_HSTMT);
		}
	}
//
// Attempt to obtain a meaningful error as to why connect failed.
//
	ODBC_error (henv, hdbc, SQL_NULL_HSTMT);
	return (SQL_INVALID_HANDLE);
}

//------------------------------------------------------------------------
//
// function:	EnvClose
//
// Purpose:	Frees environment and connection handles.
//
// Arguments:	henv    _ environment handle
//		hdbc    - connection to handle
//
void EnvClose(HENV henv, HDBC hdbc)
{
	SQLDisconnect (hdbc);
	SQLFreeConnect (hdbc);
	SQLFreeEnv (henv);

}


//------------------------------------------------------------------------
void ODBC_error (		// Obtain ODBC Error
	HENV henv,		// ODBC Environment
	HDBC hdbc,		// ODBC Connection Handle
	HSTMT hstmt)		// ODBC SQL Handle
{
	UCHAR	sqlstate[10];
	UCHAR	errmsg[SQL_MAX_MESSAGE_LENGTH];
	SDWORD	nativeerr;
	SWORD	actualmsglen;
	RETCODE	rc;
	UCHAR   buf[STR_LEN];


	for( ; ; ) {
		rc = SQLError(henv, hdbc, hstmt,
			sqlstate, &nativeerr, errmsg,
			SQL_MAX_MESSAGE_LENGTH - 1, &actualmsglen);
		
		if (rc == SQL_ERROR) {
			WinMessageBox(HWND_DESKTOP,NULLHANDLE, 
				(PSZ)"SQLError failed", (PSZ)"Error",
				(U16)0, (U32)MB_OK);
			return;
		}

		if (rc == SQL_NO_DATA_FOUND) 
			return;
			
		memset(buf, 0, STR_LEN);
		errmsg[actualmsglen] = '\0';
		sprintf ((char *)buf,
			"SQLSTATE = %s\n, NATIVE ERROR = %d\n, MSG = %s\n.",
			sqlstate, nativeerr, errmsg);
		WinMessageBox(HWND_DESKTOP,NULLHANDLE, (PSZ)buf,
			(PSZ)"Error",(U16)0, (U32)MB_OK);

	}	
}



