.486p
model flat
ideal

; default
Ix=640/1
Iy=480/1

; 1080p
IxMax=1920
IyMax=1080

extrn DosClose:near
extrn DosCloseEventSem:near
extrn DosCloseMutexSem:near
extrn DosConnectNPipe:near
extrn DosCreateEventSem:near
extrn DosCreateMutexSem:near
extrn DosCreateNPipe:near
extrn DosCreateThread:near
extrn DosDisConnectNPipe:near
extrn DosExit:near
extrn DosExitList:near
extrn DosOpen:near
extrn DosPostEventSem:near
extrn DosRequestMutexSem:near
extrn DosReleaseMutexSem:near
extrn DosResetEventSem:near
extrn DosSetPriority:near
extrn DosSleep:near
extrn DosWaitEventSem:near
extrn DosWrite:near

extrn UsbCancelTransfer:near
extrn UsbClose:near
extrn UsbCtrlMessage:near
extrn UsbIsoClose:near
extrn UsbIsoOpen:near
extrn UsbOpen:near
extrn UsbQueryDeviceReport:near
extrn UsbQueryNumberDevices:near
extrn UsbStartIsoTransfer:near

extrn accept:near
extrn bind:near
extrn listen:near
extrn psock_errno:near
extrn recv:near
extrn send:near
extrn setsockopt:near
extrn socket:near
extrn sock_errno:near
;extrn sock_init:near
extrn soclose:near

stack 8192

dataseg
; audio semaphores
iAudioEvent dd 0
sAudioMutex dd 0

dataseg
; video semaphores
iVideoEvent dd 0
oVideoEvent dd 0
sVideoEvent dd 0
sVideoMutex dd 0

dataseg
sFail0 db 'device driver open error.',13,10
sFail1 db 'set configuration failed.',13,10
sFail2 db 'obtain video error.',13,10
sFail3 db 'frame size too small.',13,10
sFail4 db 'image size too large.',13,10
sFail5 db 'obtain audio error.',13,10
sFail6 db 'no webcam.',13,10
label sFail7 byte

dataseg
sGood0 db 'started.',13,10
sGood1 db 'stopped.',13,10
sGood2 db 'waiting.',13,10
sGood3 db 'awaiting...',13,10
sGood4 db 'quitting...',13,10
label sGood5 byte

dataseg
sInfo4 db '[????????]',13,10
sInfo5 db 'format:????',13,10
label sInfo6 byte

dataseg
fhDevice dd 0

dataseg
tidGetAud dd 0
tidGetVid dd 0
tidPutVid dd 0

dataseg
tidAudPipe dd 0
tidVidHttp dd 0
tidVidPipe dd 0
tidVidStdo dd 0

dataseg
; processing
RunAudio db 0
RunVideo db 0

dataseg
; termination
EndThread db 0

udataseg
BytesDone dd ?

dataseg
sDevInfo0 db ' acquire webcam',13,10
sDevInfo1 db ' set configuration',13,10
sDevInfo2 db ' release webcam',13,10
label sDevInfo3 byte

dataseg
; semaphore name
szBreak db '\SEM32\Webcam\Ctrl+C',0
; semaphore handle
iBreakEvent dd 0
iBreakPosts dd 0

codeseg
proc MainRoutine c near
arg @@Mod,@@Nul,@@Env,@@Arg
; determine begin of arguments
  cld ; operate foreward scan
  mov ecx,512 ; max scan length
  mov edi,[@@Arg] ; start address
  repne scasb ; find terminator
; process passed arguments
  call ProcessArguments
; show appropriate started message
  call DosWrite c,2,offset(sGood0),sGood1-sGood0,offset(BytesDone)
; access attached webcam
  call ObtainUvcDevice
  jnz ShowStoppedMessage
label ProcessCompound near
; process compound descriptor
  call ProcessDescriptors
  jnz ShowStoppedMessage
; verify resolution match
  cmp [StreamFormat],'Huh?'
  jne EndVerifyMatch ; ok
; verify default tried
  cmp [VideoIx],Ix
  jne TryDefault
  cmp [VideoIy],Iy
  jne TryDefault
; retry default failure
  jmp ShowStoppedMessage
label TryDefault near
  mov [VideoIx],Ix
  mov [VideoIy],Iy
  jmp ProcessCompound
label EndVerifyMatch near
; verify enough buffer space
  mov eax,[ImgBufferSize]
  cmp eax,IxMax*IyMax*2
  jna EndCheckBufferSize
  call ShowReturnCode ; info
  call DosWrite c,2,offset(sFail4),sFail5-sFail4],offset(BytesDone)
  jmp ShowStoppedMessage
label EndCheckBufferSize near
; open uvc camera device driver
  call DosWrite c,2,offset(sDevInfo0),sDevInfo1-sDevInfo0,offset(BytesDone)
  call UsbOpen c,offset(fhDevice),[idVendor],[idProduct],[bcdDevice],0
  test eax,eax ; check for errors
  jnz DosOpenFailure ; bailout
; set configuration request
  call DosWrite c,2,offset(sDevInfo1),sDevInfo2-sDevInfo1,offset(BytesDone)
  call UsbCtrlMessage c,[fhDevice],000h,09h,0001h,0000h,0,0,0
  test eax,eax ; check for errors
  jnz SetConfigError ; failure
; create stdout break event semaphore
  call DosCreateEventSem c,offset(szBreak),offset(iBreakEvent),0,0
; register termination processing
  call DosExitList c,1,offset(ProcessComplete)
; initialize video processing
  cmp [RunVideo],1 ; yes
  jne EndStartVideoProcessing
; create video buffer mutex semaphore
  call DosCreateMutexSem c,0,offset(sVideoMutex),0,0
; create isochronous video event semaphore
  call DosCreateEventSem c,0,offset(iVideoEvent),1,0
; create obtain video event semaphore
  call DosCreateEventSem c,0,offset(oVideoEvent),0,0
; create supply video event semaphore
  call DosCreateEventSem c,0,offset(sVideoEvent),0,0
; start obtain video control thread
  call DosCreateThread c,offset(tidGetVid),offset(ObtainVideo),0,2,8192
; start supply video control thread
  call DosCreateThread c,offset(tidPutVid),offset(SupplyVideo),0,2,8192
; check video stream to stdo thread
  cmp [VideoStdo],'1' ; selected
  jne NotStartVideoStdoServer
; start video stream to stdo thread
  call DosCreateThread c,offset(tidVidStdo),offset(VidStdoThread),0,2,8192
label NotStartVideoStdoServer near
; check video stream to pipe thread
  cmp [VideoPipe],'1' ; selected
  jne NotStartVideoPipeServer
; start video stream to pipe thread
  call DosCreateThread c,offset(tidVidPipe),offset(VidPipeThread),0,2,8192
label NotStartVideoPipeServer near
; check video stream to http thread
  cmp [VideoHttp],'1' ; selected
  jne NotStartVideoHttpServer
; start video stream to http thread
  call DosCreateThread c,offset(tidVidHttp),offset(VidHttpThread),0,2,8192
label NotStartVideoHttpServer near
label EndStartVideoProcessing near
; initialize audio processing
  cmp [RunAudio],1 ; yes
  jne EndStartAudioProcessing
; create audio buffer mutex semaphore
  call DosCreateMutexSem c,0,offset(sAudioMutex),0,0
; create isochronous audio event semaphore
  call DosCreateEventSem c,0,offset(iAudioEvent),1,0
; start obtain audio control thread
  call DosCreateThread c,offset(tidGetAud),offset(ObtainAudio),0,2,8192
; check audio stream to pipe thread
  cmp [AudioPipe],'1' ; selected
  jne NotStartAudioPipeServer
; start audio stream to pipe thread
  call DosCreateThread c,offset(tidAudPipe),offset(AudPipeThread),0,2,8192
label NotStartAudioPipeServer near
label EndStartAudioProcessing near
label AwaitStdoutBreakEvent near
; await stdo break event semaphore
  call DosWaitEventSem c,[iBreakEvent],-1
  call DosResetEventSem c,[iBreakEvent],offset(iBreakPosts)
  cmp [VideoStdo],'1'
  jne AwaitStdoutBreakEvent
  sub eax,eax ; success
  ret ; uses exit list
label SetConfigError near
; report set configuration failure
  call DosWrite c,2,offset(sFail1),sFail2-sFail1,offset(BytesDone)
; close uvc camera device driver
  call UsbClose c,[fhDevice]
  jmp ShowStoppedMessage
label DosOpenFailure near
; report dos open failure
  call DosWrite c,2,offset(sFail0),sFail1-sFail0,offset(BytesDone)
label ShowStoppedMessage near
; show application stopped message
  call DosWrite c,2,offset(sGood1),sGood2-sGood1,offset(BytesDone)
; exit the process
  call DosExit c,1,0
endp MainRoutine

codeseg
proc ProcessComplete c near
; close stdout break event semaphore
  call DosCloseEventSem c,[iBreakEvent]
; show application quitting message
  call DosWrite c,2,offset(sGood4),sGood5-sGood4,offset(BytesDone)
; terminate thread processing
  mov [EndThread],1 ; terminate
; await isochronous quiescent
  call DosSleep c,1024
; cleanup audio processing
  cmp [RunAudio],1 ; yes
  jne EndStopAudioProcessing
; cancel isochronous audio transfers
  call UsbCancelTransfer c,[fhDevice],[aAddrEndpoint],[aAltInterface],[iAudioEvent]
; close isochronous audio transfer
  call DosWrite c,2,offset(sAudInfo6),sAudInfo7-sAudInfo6,offset(BytesDone)
  call UsbIsoClose c,[fhDevice],[aAddrEndpoint],[aAltInterface]
; reset alternative audio interface request
  call UsbCtrlMessage c,[fhDevice],001h,0Bh,0,[aNumInterface],0,0,0
; close isochronous audio event semaphore
  call DosCloseEventSem c,[iAudioEvent]
; close audio buffer mutex semaphore
  call DosCloseMutexSem c,[sAudioMutex]
; close audio pipe server pipe
  call DosClose c,[fhNPipeA]
label EndStopAudioProcessing near
; cleanup video processing
  cmp [RunVideo],1 ; yes
  jne EndStopVideoProcessing
; cancel isochronous video transfers
  call UsbCancelTransfer c,[fhDevice],[vAddrEndpoint],[vAltInterface],[iVideoEvent]
; close isochronous video transfer
  call DosWrite c,2,offset(sVidInfo6),sVidInfo7-sVidInfo6,offset(BytesDone)
  call UsbIsoClose c,[fhDevice],[vAddrEndpoint],[vAltInterface]
; reset alternative video interface request
  call UsbCtrlMessage c,[fhDevice],001h,0Bh,0,[vNumInterface],0,0,0
; close supply video event semaphore
  call DosCloseEventSem c,[sVideoEvent]
; close obtain video event semaphore
  call DosCloseEventSem c,[oVideoEvent]
; close isochronous video event semaphore
  call DosCloseEventSem c,[iVideoEvent]
; close video buffer mutex semaphore
  call DosCloseMutexSem c,[sVideoMutex]
; close video pipe server pipe
  call DosClose c,[fhNPipe1]
; close http server connection
  call soclose c,[ServerSocket]
label EndStopVideoProcessing near
; close uvc camera device driver
  call DosWrite c,2,offset(sDevInfo2),sDevInfo3-sDevInfo2,offset(BytesDone)
  call UsbClose c,[fhDevice]
; show application stopped message
  call DosWrite c,2,offset(sGood1),sGood2-sGood1,offset(BytesDone)
; exit termination process
  call DosExitList c,3,0)
endp ProcessComplete

udataseg
vdSize=61440 ; max data size
viSize=65536 ; data+parm size
viUsed=8 ; number of buffers
vtSize=viSize*viUsed ; total
; isochronous video buffers
vIsoData db vtSize dup(?)

udataseg
; obtain video buffers
VidBuffer0 db IxMax*IyMax*2 dup(?)
VidBuffer1 db IxMax*IyMax*2 dup(?)
VidBuffer2 db IxMax*IyMax*2 dup(?)

dataseg
; ring of obtain video buffer pointers
VidBufPtr0 dd offset(VidBufPtr1),offset(VidBuffer0),0
VidBufPtr1 dd offset(VidBufPtr2),offset(VidBuffer1),0
VidBufPtr2 dd offset(VidBufPtr0),offset(VidBuffer2),0

dataseg
; current video buffer pointers
oVidBufPtr dd offset(VidBufPtr0)
sVidBufPtr dd offset(VidBufPtr2)

dataseg
; video buffer counters
oVideoCount dd 3 ; current
oVideoPosts dd 0 ; posted
sVideoCount dd 1 ; current
sVideoPosts dd 0 ; posted

dataseg
Negotiate db 26 dup(0)
Suggested db 26 dup(0)

dataseg
vIsoFree dd viUsed
vIsoThis dd offset(vIsoData)

dataseg
vIsoPost dd 0

dataseg
pTimeStamp dd 0

dataseg
ImgBufferSize dd Ix*Iy*2

udataseg
BytesDone1 dd ?

dataseg
sVidInfo0 db ' negotiate video format',13,10
sVidInfo1 db ' obtain video format',13,10
sVidInfo2 db ' commit video format',13,10
sVidInfo3 db ' set video alt interface',13,10
sVidInfo4 db ' starting iso video',13,10
sVidInfo5 db ' queueing iso video',13,10
sVidInfo6 db ' stopping iso video',13,10
label sVidInfo7 byte

codeseg
proc ObtainVideo c near
arg @@parameter:dword
; supply negotiate setting
  call DosWrite c,2,offset(sVidInfo0),sVidInfo1-sVidInfo0,offset(BytesDone1)
  call UsbCtrlMessage c,[fhDevice],021h,01h,0100h,0001h,26,offset(Negotiate),0
  test eax,eax ; check for errors
  jnz BadObtainVideo ; failure
; obtain suggested setting
  call DosWrite c,2,offset(sVidInfo1),sVidInfo2-sVidInfo1,offset(BytesDone1)
  call UsbCtrlMessage c,[fhDevice],0A1h,81h,0100h,0001h,26,offset(Suggested),0
  test eax,eax ; check for errors
  jnz BadObtainVideo ; failure
; commit suggested setting
  call DosWrite c,2,offset(sVidInfo2),sVidInfo3-sVidInfo2,offset(BytesDone1)
  call UsbCtrlMessage c,[fhDevice],021h,01h,0200h,0001h,26,offset(Suggested),0
  test eax,eax ; check for errors
  jnz BadObtainVideo ; failure
; issue set alternative interface
  call DosWrite c,2,offset(sVidInfo3),sVidInfo4-sVidInfo3,offset(BytesDone1)
  call UsbCtrlMessage c,[fhDevice],001h,0Bh,[vAltInterface],[vNumInterface],0,0,0
  test eax,eax ; check for errors
  jnz BadObtainVideo ; failure
; open isochronous video transfer
  call DosWrite c,2,offset(sVidInfo4),sVidInfo5-sVidInfo4,offset(BytesDone1)
  call UsbIsoOpen c,[fhDevice],[vAddrEndpoint],[vAltInterface],viUsed,[vIsoFrameSize]
  test eax,eax ; check for errors
  jnz BadObtainVideo ; failure
; obtain first buffer pointer
  mov eax,[oVidBufPtr] ; current
  mov edi,[eax+4] ; this buffer
  mov eax,[ImgBufferSize] ; size
  lea ebp,[edi+eax] ; boundary
; foreground server priority
  call DosSetPriority c,2,4,15,0
label SupplyVideoIsoBuffer near
; address current isochronous buffer
  mov esi,[vIsoThis] ; this buffer
; check buffer completion status
  movzx eax,[word(esi+vdSize)]
  test eax,eax ; check for errors
  jnz NotVidIsoTransfer ; failure
; use actual completion sizes
  sub ebx,ebx ; frame index
label NextVideoIsoFrame near
  mov eax,[vIsoThis] ; this buffer
  movzx edx,[word(eax+ebx*2+vdSize+4)]
; verify header data available
  cmp edx,12 ; header length
  jb BumpToNextVideoFrame
; validate payload header
  mov eax,[esi] ; HLE/BFH[0]
  cmp al,12 ; header length
  jne BumpToNextVideoFrame
  and ah,7Ch ; fixed flags
  cmp ah,0Ch ; check flags
  jne BumpToNextVideoFrame
; synchronize video frame
  mov eax,[esi+2] ; pts
  cmp eax,[pTimeStamp]
  je EndRestartVideoFrame
  mov [pTimeStamp],eax
; reset this buffer pointer
  mov eax,[oVidBufPtr] ; current
  mov edi,[eax+4] ; this buffer
label EndRestartVideoFrame near
; check for end of write buffer
  lea eax,[edi+edx-12] ; predict
  cmp eax,ebp ; buffer boundary
  jna MoveNewImageData ; fits
; reset this buffer pointer
  mov eax,[oVidBufPtr] ; current
  mov edi,[eax+4] ; this buffer
label MoveNewImageData near
; move isochronous frame
  mov ecx,edx ; frame length
  lea ecx,[ecx-12] ; header
  lea esi,[esi+12] ; header
  rep movsb ; frame data
  sub esi,edx ; start
; check for end of frame
  cmp [StreamFormat],'mjpg'
  jne EndGetVidMJPG ; no
; check for end of image
  cmp [word(edi-2)],0D9FFh
  je ImageComplete ; mjpg
label EndGetVidMJPG near
; check for end of frame
  cmp [StreamFormat],'yuyv'
  jne EndGetVidYUYV ; no
; check for end of write buffer
  cmp edi,ebp ; buffer boundary
  je ImageComplete ; yuyv
label EndGetVidYUYV near
label BumpToNextVideoFrame near
  inc ebx ; current frame index
  cmp ebx,[vIsoFrameUsed] ; last
  jnb EndVideoIsoMove ; queue
  add esi,[vIsoFrameSize] ; next
  jmp NextVideoIsoFrame
label ImageComplete near
; update buffer last address used
  mov eax,[oVidBufPtr] ; current
  mov [eax+8],edi ; last address
; update currently available image buffers
  call DosResetEventSem c,[oVideoEvent],offset(oVideoPosts)
  cmp eax,012Ch ; already reset
  je InspectVidMinimumCount
  test eax,eax ; check for errors
  jnz BadObtainVideo ; failure
  mov eax,[oVideoPosts] ; additional
  add [oVideoCount],eax ; current
label InspectVidMinimumCount near
  cmp [oVideoCount],1 ; minimum
  ja DeliverVideoBuffer ; available
; overrun so reuse this buffer
; reset this buffer pointer
  mov eax,[oVidBufPtr] ; current
  mov edi,[eax+4] ; this buffer
  jmp BumpToNextVideoFrame
label DeliverVideoBuffer near
; deliver image buffer to supply thread
  call DosPostEventSem c,[sVideoEvent]
  cmp eax,012Bh ; already posted
  je InspectNextVideo ; continue
  test eax,eax ; check for errors
  jnz BadObtainVideo ; failure
label InspectNextVideo near
  dec [oVideoCount] ; current
; obtain next buffer pointer
  mov eax,[oVidBufPtr] ; current
  mov eax,[eax] ; chain pointer
  mov [oVidBufPtr],eax ; current
  mov edi,[eax+4] ; this buffer
  mov eax,[ImgBufferSize] ; size
  lea ebp,[edi+eax] ; boundary
  jmp BumpToNextVideoFrame
label NotVidIsoTransfer near
; reset this buffer pointer
  mov eax,[oVidBufPtr] ; current
  mov edi,[eax+4] ; this buffer
label EndVideoIsoMove near
; reset iso frame length array
  mov eax,[vIsoFrameSize] ; length
  mov ecx,[vIsoFrameUsed] ; count
  mov esi,[vIsoThis] ; this buffer
label ResetVidIsoFrameLengthArray near
; reset individual iso frame lengths
  mov [word(esi+ecx*2+vdSize+4-2)],ax
  loop ResetVidIsoFrameLengthArray
  cmp [EndThread],0 ; continue
  jne BadObtainVideo ; terminate
; queue next isochronous video transfer
; call DosWrite c,2,offset(sVidInfo5),sVidInfo6-sVidInfo5,offset(BytesDone1)
  lea eax,[esi+vdSize] ; parm buffer pointer
  mov [word(eax+2)],vdSize ; data buffer size
  call UsbStartIsoTransfer c,[fhDevice],[vAddrEndpoint],[vAltInterface],[iVideoEvent],eax,esi,[vIsoFrameSize],[vIsoFrameUsed]
  test eax,eax ; check for errors
  jnz BadObtainVideo ; failure
; update next isochronous buffer pointer
  add [vIsoThis],viSize ; address next buffer
  cmp [vIsoThis],offset(vIsoData+vtSize)
  jne DecrementVidFreeBuffers ; proper next
  mov [vIsoThis],offset(vIsoData) ; first
label DecrementVidFreeBuffers near
  dec [vIsoFree] ; buffers available
  jnz SupplyVideoIsoBuffer
; await isochronous buffers filled
; call DosWrite c,2,offset(sGood3),sGood4-sGood3,offset(BytesDone1)
  call DosWaitEventSem c,[iVideoEvent],3000
  test eax,eax ; check for errors
  jnz BadObtainVideo ; failure
; update currently filled isochronous buffers
  call DosResetEventSem c,[iVideoEvent],offset(vIsoPost)
  test eax,eax ; check for errors
  jnz BadObtainVideo ; failure
  mov eax,[vIsoPost] ; additional
  add [vIsoFree],eax ; current
  jmp SupplyVideoIsoBuffer
label BadObtainVideo near
  cmp [EndThread],0 ; continue
  jne EndObtainVideo ; terminate
  call ShowReturnCode ; info
; show appropriate error message
  call DosWrite c,2,offset(sFail2),sFail3-sFail2,offset(BytesDone1)
label EndObtainVideo near
; exit the obtain thread
  call DosExit c,0,0
endp ObtainVideo

dataseg
hex2ascii db '0123456789ABCDEF'

codeseg
proc ShowReturnCode near
  pusha ; save registers
; convert return code
  mov ecx,8 ; code length
label ConvertDigit near
  mov edx,eax ; error code
  and edx,0000000Fh ; digit
  mov dl,[hex2ascii+edx]
  mov [sInfo4+ecx],dl
  shr eax,4 ; next one
  loop ConvertDigit
; show appropriate info message
  call DosWrite c,2,offset(sInfo4),sInfo5-sInfo4,offset(BytesDone)
  popa ; restore registers
  ret ; return
endp ShowReturnCode

dataseg
ClientSocket dd 0
ServerSocket dd 0

dataseg
sMsgNr1 db 'Socket Interface not available!',13,10
sMsgNr3 db '/s server (video) On-Line.',13,10
sMsgNr4 db '/n server (video) On-Line.',13,10
sMsgNr5 db '/h server (video) On-line.',13,10
sMsgNr6 db '/a server (audio) On-Line.',13,10
label sMsgNr7 byte

udataseg
; supply video buffer
VidBuffer db IxMax*IyMax*2 dup(?)
VidLength dd ? ; used
VidNumber dd ? ; next

udataseg
BytesDone2 dd ?

codeseg
proc SupplyVideo c near
arg @@parameter:dword
; foreground server priority
  call DosSetPriority c,2,4,15,0
label InspectNextVidSupply near
; send continuous video stream
  dec [sVideoCount] ; available
  jnz ProcessNextVidSupply ; yes
; show application waiting message
; call DosWrite c,2,offset(sGood2),sGood3-sGood2,offset(BytesDone2)
; await supply image semaphore
  call DosWaitEventSem c,[sVideoEvent],-1
  test eax,eax ; check for errors
  jnz BadSupplyVideo ; failure
; update currently available image buffers
  call DosResetEventSem c,[sVideoEvent],offset(sVideoPosts)
  test eax,eax ; check for errors
  jnz BadSupplyVideo ; failure
  mov eax,[sVideoPosts] ; additional buffers available
  add [sVideoCount],eax ; buffers available
label ProcessNextVidSupply near
  cmp [EndThread],0 ; continue
  jne BadSupplyVideo ; terminate
; obtain next buffer pointer
  mov eax,[sVidBufPtr] ; current
  mov eax,[eax] ; chain pointer
  mov [sVidBufPtr],eax ; current
  mov edi,[eax+8] ; last address
  mov esi,[eax+4] ; this buffer
; check for end of frame
  cmp [StreamFormat],'mjpg'
  jne EndPutVidMJPG ; no
; verify mjpg image present
  cmp [word(esi+0)],0D8FFh
  jne SyncReset ; skip
  cmp [word(edi-2)],0D9FFh
  jne SyncReset ; skip
label EndPutVidMJPG near
; check for end of frame
  cmp [StreamFormat],'yuyv'
  jne EndPutVidYUYV ; no
; verify yuyv image complete
  mov eax,[ImgBufferSize] ; size
  lea eax,[esi+eax] ; boundary
  cmp eax,edi ; complete
  jne SyncReset ; skip
; make rgb from yuyv
  call yuyv2rgb ; rgb
; make mjpg from rgb
  call rgb2jpg ; mjpg
label EndPutVidYUYV near
; request video stream buffer
  call DosRequestMutexSem c,[sVideoMutex],-1
  test eax,eax ; check for errors
  jnz BadSupplyVideo ; failure
  inc [VidNumber] ; next
; update Content-Length
  mov eax,edi ; start
  sub eax,esi ; end
  mov [VidLength],eax
  mov ebx,10 ; decimal
  sub ecx,ecx ; #digits
label convert near
; convert to decimal
  sub edx,edx ; zeroes
  div ebx ; decimal
  push edx ; remainder
  inc ecx ; #digits
  test eax,eax ; done
  jnz convert ; more
; store Content-Length
  mov ebx,offset(ImageSize)
label dec2ascii near
  pop eax ; decimal digit
  add al,'0' ; ascii character
  mov [byte(ebx)],al ; digit
  inc ebx ; next position
  loop dec2ascii
; append crlf||crlf again
  mov [dword(ebx)],0A0D0A0Dh
  add ebx,4 ; new @TrailerS00
  sub ebx,offset(HeaderS00)
  mov [HdrLength],ebx
; copy image to video buffer
  mov ecx,edi ; data start
  sub ecx,esi ; data end
  mov edi,offset(VidBuffer)
  rep movsb ; actual copy
; release videostream buffer
  call DosReleaseMutexSem c,[sVideoMutex]
  test eax,eax ; check for errors
  jnz BadSupplyVideo ; failure
label SyncReset near
; deliver buffer to obtain thread
  call DosPostEventSem c,[oVideoEvent]
  cmp eax,012Bh ; already posted
  je InspectNextVidSupply ; continue
  test eax,eax ; check for errors
  jz InspectNextVidSupply ; continue
label BadSupplyVideo near
  cmp [EndThread],0 ; continue
  jne ExitSupplyVideo ; terminate
; show appropriate error message
  call ShowReturnCode ; info
label ExitSupplyVideo near
; exit the supply thread
  call DosExit c,0,0
endp SupplyVideo

dataseg
HdrLength dd TrailerS00-HeaderS00
HeaderS00 db '--ThisUniqueString',13,10
          db 'Content-Type: image/jpeg',13,10
          db 'Content-Length: '
ImageSize db '000000',13,10
          db 13,10
label TrailerS00 byte
safespace db 0,0,0

dataseg
VidStdoNumber dd 0

udataseg
BytesDone3 dd ?

codeseg
proc VidStdoThread c near
arg @@parameter:dword
; issue server is on-line message
  call DosWrite c,2,offset(sMsgNr3),sMsgNr4-sMsgNr3,offset(BytesDone3)
; foreground server priority
  call DosSetPriority c,2,4,10,0
label SendVidStdoStream near
  call DosSleep c,20 ; mSeconds
; request video stream buffer
  call DosRequestMutexSem c,[sVideoMutex],-1
  test eax,eax ; check for errors
  jnz ExitVidStdoThread ; exit
  cmp [VidLength],0 ; nothing
  je SentStdoStream ; ignore
; verify next image available
  mov eax,[VidNumber] ; next
  cmp eax,[VidStdoNumber]
  je SentStdoStream ; ignore
  mov [VidStdoNumber],eax
; send mime headers to stdout
  call DosWrite c,1,offset(HeaderS00),[HdrLength],offset(BytesDone3)
  test eax,eax ; check for errors
  jnz StopVidStdoThread ; stop
; send stream data to stdout
  mov edi,[VidLength] ; size
  mov esi,offset(VidBuffer)
label SendStdoStream near
  mov eax,edi ; image size
  cmp eax,4096 ; maximum
  jna NotTooLargeSize3
  mov eax,4096 ; maximum
label NotTooLargeSize3 near
; send stream data to stdout
  call DosWrite c,1,esi,eax,offset(BytesDone3)
  test eax,eax ; check for errors
  jnz StopVidStdoThread ; stop
  mov eax,[BytesDone3] ; done
  add esi,eax ; next address
  sub edi,eax ; remaining
  jnz SendStdoStream ; more
label SentStdoStream  near
; release videostream buffer
  call DosReleaseMutexSem c,[sVideoMutex]
  test eax,eax ; check for errors
  jnz ExitVidStdoThread ; exit
  jmp SendVidStdoStream ; more
label StopVidStdoThread near
; release video stream buffer
  call DosReleaseMutexSem c,[sVideoMutex]
label ExitVidStdoThread near
; exit video stdout thread
  call DosExit c,0,0
endp VidStdoThread

dataseg
; pipe name
szNPipe1 db '\PIPE\Webcam\Video',0

dataseg
fhNPipe1 dd 0 ; pipe handle

dataseg
VidPipeNumber dd 0

udataseg
BytesDone4 dd ?

codeseg
proc VidPipeThread c near
arg @@parameter:dword
; avoid compiler problem
  nop ; proc+code+label
label CreateVidPipe near
  call DosSleep c,20
; create named output pipe
  call DosCreateNPipe c,offset(szNPipe1),offset(fhNPipe1),81h,01h,4096,0,8000)
  cmp eax,0E7h ; ERROR_PIPE_BUSY
  je CreateVidPipe ; retry
  test eax,eax ; check for errors
  jnz ExitVidPipeThread ; exit
; issue server is on-line message
  call DosWrite c,2,offset(sMsgNr4),sMsgNr5-sMsgNr4,offset(BytesDone4)
; foreground server priority
  call DosSetPriority c,2,4,10,0
label ConnectVidNamedPipe1 near
  call DosConnectNPipe c,[fhNPipe1]
  test eax,eax ; check for errors
  jnz ExitVidPipeThread ; exit
label SendVidPipeStream near
  call DosSleep c,20 ; mSeconds
; request video stream buffer
  call DosRequestMutexSem c,[sVideoMutex],-1
  test eax,eax ; check for errors
  jnz ExitVidPipeThread ; exit
  cmp [VidLength],0 ; nothing
  je SentPipeStream ; ignore
; verify next image available
  mov eax,[VidNumber] ; next
  cmp eax,[VidPipeNumber]
  je SentPipeStream ; ignore
  mov [VidPipeNumber],eax
; send mime headers to named pipe
  call DosWrite c,[fhNPipe1],offset(HeaderS00),[HdrLength],offset(BytesDone4)
  test eax,eax ; check for errors
  jnz StopVidPipeStream ; stop
; send stream data to named pipe
  mov edi,[VidLength] ; size
  mov esi,offset(VidBuffer)
label SendPipeStream near
  mov eax,edi ; image size
  cmp eax,4096 ; maximum
  jna NotTooLargeSize4
  mov eax,4096 ; maximum
label NotTooLargeSize4 near
; send stream data to named pipe
  call DosWrite c,[fhNPipe1],esi,eax,offset(BytesDone4)
  test eax,eax ; check for errors
  jnz StopVidPipeStream ; stop
  mov eax,[BytesDone4] ; done
  add esi,eax ; next address
  sub edi,eax ; remaining
  jnz SendPipeStream ; more
label SentPipeStream near
; release videostream buffer
  call DosReleaseMutexSem c,[sVideoMutex]
  test eax,eax ; check for errors
  jnz ExitVidPipeThread ; exit
  jmp SendVidPipeStream ; more
label StopVidPipeStream near
; release video stream buffer
  call DosReleaseMutexSem c,[sVideoMutex]
  test eax,eax ; check for errors
  jnz ExitVidPipeThread ; exit
; disconnect named output pipe
  call DosDisConnectNPipe c,[fhNPipe1]
  test eax,eax ; check for errors
  jnz ExitVidPipeThread ; exit
  jmp ConnectVidNamedPipe1
label ExitVidPipeThread near
; exit video pipe thread
  call DosExit c,0,0
endp VidPipeThread

dataseg
backlog=5
port=14225
SocketAddress db 2,0,high(port),low(port),0,0,0,0,8 dup(0)
SocketOption dd 4 ; SO_REUSEADDR

dataseg
Header200 db 'HTTP/1.0 200 OK',13,10
          db 'Content-Type: multipart/x-mixed-replace; '
          db 'boundary=ThisUniqueString',13,10
          db 13,10
label Trailer200 byte

dataseg
Header404 db 'HTTP/1.0 404 Not Found',13,10
          db 'Content-Type: text/html',13,10
          db 13,10
          db '<html><title>WebEye 0!0</title>'
          db '404 Not Found</html>'
          db 13,10
label Trailer404 byte

dataseg
Header501 db 'HTTP/1.0 501 Not Implemented',13,10
          db 'Content-Type: text/html',13,10
          db 13,10
          db '<html><title>WebEye 0!0</title>'
          db '501 Not Implemented</html>'
          db 13,10
label Trailer501 byte

udataseg
; http request
Request db 2048 dup(?)

dataseg
szMsgNr0 db 'socket',0
szMsgNr1 db 'setsockopt',0
szMsgNr2 db 'bind',0
szMsgNr3 db 'listen',0
szMsgNr4 db 'accept',0
szMsgNr5 db 'recv',0
szMsgNr6 db 'send',0
szMsgNr7 db 'soclose',0
label szMsgNr8 byte

dataseg
VidHttpNumber dd 0

udataseg
BytesDone5 dd ?

codeseg
proc VidHttpThread c near
arg @@parameter:dword
; open http server socket
; call DosWrite c,2,offset(szMsgNr0),szMsgNr1-szMsgNr0,offset(BytesDone5)
  call socket c,2,1,6 ; create
  cmp eax,-1 ; check for errors
  mov ebx,offset(szMsgNr0)
  je ExitVidHttpThread
  mov [ServerSocket],eax
; avoid address in use error
; call DosWrite c,2,offset(szMsgNr1),szMsgNr2-szMsgNr1,offset(BytesDone5)
  call setsockopt c,[ServerSocket],65535,[SocketOption],offset(SocketOption),4
  cmp eax,-1 ; check for errors
  mov ebx,offset(szMsgNr1)
  je ExitVidHttpThread
; reserve http server port
; call DosWrite c,2,offset(szMsgNr2),szMsgNr3-szMsgNr2,offset(BytesDone5)
  call bind c,[ServerSocket],offset(SocketAddress),16
  cmp eax,-1 ; check for errors
  mov ebx,offset(szMsgNr2)
  je ExitVidHttpThread
; allow client connections
; call DosWrite c,2,offset(szMsgNr3),szMsgNr4-szMsgNr3,offset(BytesDone5)
  call listen c,[ServerSocket],backlog
  cmp eax,-1 ; check for errors
  mov ebx,offset(szMsgNr3)
  je ExitVidHttpThread
; issue server is on-line message
  call DosWrite c,2,offset(sMsgNr5),sMsgNr6-sMsgNr5,offset(BytesDone5)
; foreground server priority
  call DosSetPriority c,2,4,10,0
label AcceptClient near
; accept client connection
; call DosWrite c,2,offset(szMsgNr4),szMsgNr5-szMsgNr4,offset(BytesDone5)
  call accept c,[ServerSocket],0,0
  cmp eax,-1 ; check for errors
  mov ebx,offset(szMsgNr4)
  je ExitVidHttpThread
  mov [ClientSocket],eax
; receive http get request from client
; call DosWrite c,2,offset(szMsgNr5),szMsgNr6-szMsgNr5,offset(BytesDone5)
  call recv c,[ClientSocket],offset(Request),2048,0
  cmp eax,-1 ; check for errors
  je CloseSocket ; failure
; call DosWrite c,2,offset(Request),eax,offset(BytesDone5)
; verify request from client
  cmp [dword(request+0)],' TEG'
  jne Send501Response
  cmp [dword(request+4)],'TH /'
  jne Send404Response
; send http 200 response to client
; call DosWrite c,2,offset(szMsgNr6),szMsgNr7-szMsgNr6,offset(BytesDone5)
; call DosWrite c,2,offset(Header200),Trailer200-Header200,offset(BytesDone5)
  call send c,[ClientSocket],offset(Header200),Trailer200-Header200,0
  cmp eax,-1 ; check for errors
  je CloseSocket ; failure
label SendVidHttpStream near
  call DosSleep c,20 ; mSeconds
; request video stream buffer
  call DosRequestMutexSem c,[sVideoMutex],-1
  test eax,eax ; check for errors
  jnz ExitVidHttpThread ; exit
  cmp [VidLength],0 ; nothing
  je SentHttpStream ; ignore
; verify next image available
  mov eax,[VidNumber] ; next
  cmp eax,[VidHttpNumber]
  je SentHttpStream ; ignore
  mov [VidHttpNumber],eax
; send mime headers to http client
  call send c,[ClientSocket],offset(HeaderS00),[HdrLength],0
  cmp eax,-1 ; check for errors
  je StopVidHttpStream ; stop
; send stream data to http client
  mov edi,[VidLength] ; size
  mov esi,offset(VidBuffer)
label SendHttpStream near
  mov eax,edi ; image size
  cmp eax,4096 ; maximum
  jna NotTooLargeSize5
  mov eax,4096 ; maximum
label NotTooLargeSize5 near
; send stream data to http client
  call send c,[ClientSocket],esi,eax,0
  cmp eax,-1 ; check for errors
  je StopVidHttpStream ; stop
  add esi,eax ; next address
  sub edi,eax ; remaining
  jnz SendHttpStream ; more
label SentHttpStream near
; release videostream buffer
  call DosReleaseMutexSem c,[sVideoMutex]
  test eax,eax ; check for errors
  jnz ExitVidPipeThread ; exit
  jmp SendVidHttpStream ; more
label StopVidHttpStream near
; release video stream buffer
  call DosReleaseMutexSem c,[sVideoMutex]
  test eax,eax ; check for errors
  jnz ExitVidHttpThread ; exit
label CloseSocket near
; close client connection
; call DosWrite c,2,offset(szMsgNr7),szMsgNr8-szMsgNr7,offset(BytesDone5)
  call soclose c,[ClientSocket]
  mov [ClientSocket],0 ; available
  jmp AcceptClient ; continue
label Send404Response near
; send http 404 response to client
; call DosWrite c,2,offset(szMsgNr6),szMsgNr7-szMsgNr6,offset(BytesDone5)
; call DosWrite c,2,offset(Header404),Trailer404-Header404,offset(BytesDone5)
  call send c,[ClientSocket],offset(Header404),Trailer404-Header404,0
  jmp CloseSocket ; continue
label Send501Response near
; send http 501 response to client
; call DosWrite c,2,offset(szMsgNr6),szMsgNr7-szMsgNr6,offset(BytesDone5)
; call DosWrite c,2,offset(Header501),Trailer501-Header501,offset(BytesDone5)
  call send c,[ClientSocket],offset(Header501),Trailer501-Header501,0
  jmp CloseSocket ; continue
label ExitVidHttpThread near
; report the server error
  call psock_errno c,ebx
  call sock_errno ; report
; exit video http thread
  call DosExit c,0,0
endp VidHttpThread

udataseg
adSize=4096 ; max data size
aiSize=8192 ; data+parm size
aiUsed=8 ; number of buffers
atSize=aiSize*aiUsed ; total
; isochronous audio buffers
aIsoData db atSize dup(?)

dataseg
aIsoFree dd aiUsed
aIsoThis dd offset(aIsoData)

dataseg
aIsoPost dd 0

udataseg
; audio stream buffer
AudBuffer db adSize dup(?)
AudLength dd ? ; used
AudNumber dd ? ; next

dataseg
MuteIndex dd 0
MuteVolume db 0,0

udataseg
BytesDone6 dd ?

dataseg
sAudInfo0 db ' set audio frequency',13,10
sAudInfo1 db ' set audio mike volume',13,10
sAudInfo2 db ' set audio reserved',13,10
sAudInfo3 db ' set audio alt interface',13,10
sAudInfo4 db ' starting iso audio',13,10
sAudInfo5 db ' queueing iso audio',13,10
sAudInfo6 db ' stopping iso audio',13,10
label sAudInfo7 byte

codeseg
proc ObtainAudio c near
arg @@parameter:dword
  call DosSleep c,50 ; mSeconds
; issue set endpoint sample frequency
  call DosWrite c,2,offset(sAudInfo0),sAudInfo1-sAudInfo0,offset(BytesDone6)
  call UsbCtrlMessage c,[fhDevice],22h,01h,0100h,[aAddrEndPoint],3,offset(aSetFrequency),0
  test eax,eax ; check for errors
  jnz BadObtainAudio ; failure
  call DosSleep c,50 ; mSeconds
; issue set microphone mute/volume
  call DosWrite c,2,offset(sAudInfo1),sAudInfo2-sAudInfo1,offset(BytesDone6)
; call UsbCtrlMessage c,[fhDevice],21h,01h,0101h,0502h,2,offset(MuteVolume),0
  call UsbCtrlMessage c,[fhDevice],21h,01h,0101h,[MuteIndex],1,offset(MuteVolume),0
  test eax,eax ; check for errors
  jnz BadObtainAudio ; failure
  call DosSleep c,50 ; mSeconds
; issue set alternative interface
  call DosWrite c,2,offset(sAudInfo3),sAudInfo4-sAudInfo3,offset(BytesDone6)
  call UsbCtrlMessage c,[fhDevice],01h,0Bh,[aAltInterface],[aNumInterface],0,0,0
  test eax,eax ; check for errors
  jnz BadObtainAudio ; failure
  call DosSleep c,50 ; mSeconds
; open isochronous audio transfer
  call DosWrite c,2,offset(sAudInfo4),sAudInfo5-sAudInfo4,offset(BytesDone6)
  call UsbIsoOpen c,[fhDevice],[aAddrEndpoint],[aAltInterface],aiUsed,[aIsoFrameSize]
  test eax,eax ; check for errors
  jnz BadObtainAudio ; failure
; foreground server priority
  call DosSetPriority c,2,4,15,0
; prepare for frame size arrays
  mov edi,offset(aIsoData)
label QueueEmptyIsoBuffers near
; initialize frame size array
  mov ecx,[aIsoFrameUsed]
  test ecx,ecx ; wIsoFrameCount
  jz EndSetFrameSizeArray
  mov eax,[aIsoFrameSize]
label SetIsoFrameSizeArray near
; set individual iso frame sizes
  mov [word(edi+ecx*2+adSize+4-2)],ax
  loop SetIsoFrameSizeArray
label EndSetFrameSizeArray near
  cmp [EndThread],0 ; continue
  jne BadObtainAudio ; terminate
; queue empty isochronous audio buffers
; call DosWrite c,2,offset(sAudInfo5),sAudInfo6-sAudInfo5,offset(BytesDone6)
  lea eax,[edi+adSize] ; parm buffer pointer
  mov [word(eax+2)],adSize ; data buffer size
  call UsbStartIsoTransfer c,[fhDevice],[aAddrEndpoint],[aAltInterface],[iAudioEvent],eax,edi,[aIsoFrameSize],[aIsoFrameUsed]
  test eax,eax ; check for errors
  jnz BadObtainAudio ; failure
  dec [aIsoFree] ; count
  lea edi,[edi+aiSize]
  jnz QueueEmptyIsoBuffers
label AwaitFilledIsoBuffers near
; await filled isochronous buffers
; call DosWrite c,2,offset(sGood3),sGood4-sGood3,offset(BytesDone6)
  call DosWaitEventSem c,[iAudioEvent],3000
  test eax,eax ; check for errors
  jnz BadObtainAudio ; failure
; update filled isochronous buffers
  call DosResetEventSem c,[iAudioEvent],offset(aIsoPost)
  mov eax,[aIsoPost] ; additional
  add [aIsoFree],eax ; current
label ProcessRawIsoData near
; address current isochronous buffer
  mov esi,[aIsoThis] ; this buffer
; request audio stream buffer
  call DosRequestMutexSem c,[sAudioMutex],-1
  test eax,eax ; check for errors
  jnz BadObtainAudio ; failure
; supply current iso buffer
  inc [AudNumber] ; next
  mov ecx,[aIsoFrameUsed]
  test ecx,ecx ; wIsoFrameCount
  jz ConcatenatedPayloads
; individual iso frames
  lea edx,[esi+adSize+4]
  mov edi,offset(AudBuffer)
  sub ebx,ebx ; 1st frame index
label CopyIndividualFrame near
  movzx ecx,[word(edx+ebx*2)]
  mov eax,ecx ; data length
  rep movsb ; actual copy
  sub esi,eax ; data length
; reset size to wIsoFrameLength
  mov eax,[aIsoFrameSize]
  mov [word(edx+ebx*2)],ax
  add esi,eax ; bump pointer
; loop until all frames done
  inc ebx ; next frame index
  cmp ebx,[aIsoFrameUsed]
  jb CopyIndividualFrame
; set audio chunk length
  sub edi,offset(AudBuffer)
  mov [AudLength],edi
  jmp QueueEmptyIsoBuffer
label ConcatenatedPayloads near
; set audio chunk length
  mov ecx,[dword(esi+adSize)]
  shr ecx,16 ; usDatalength
  mov [AudLength],ecx
; copy chunck to audio buffer
  mov edi,offset(AudBuffer)
  rep movsb ; actual copy
label QueueEmptyIsoBuffer near
; release audio stream buffer
  call DosReleaseMutexSem c,[sAudioMutex]
  test eax,eax ; check for errors
  jnz BadObtainAudio ; failure
; address current isochronous buffer
  mov esi,[aIsoThis] ; this buffer
  cmp [EndThread],0 ; continue
  jne BadObtainAudio ; terminate
; queue empty isochronous audio buffer
; call DosWrite c,2,offset(sAudInfo5),sAudInfo6-sAudInfo5,offset(BytesDone6)
  lea eax,[esi+adSize] ; parm buffer pointer
  mov [word(eax+2)],adSize ; data buffer size
  call UsbStartIsoTransfer c,[fhDevice],[aAddrEndpoint],[aAltInterface],[iAudioEvent],eax,esi,[aIsoFrameSize],[aIsoFrameUsed]
  test eax,eax ; check for errors
  jnz BadObtainAudio ; failure
; update next iso buffer pointer
  add [aIsoThis],aiSize ; bump pointer
  cmp [aIsoThis],offset(aIsoData+atSize)
  jne DecrementFreeBuffers ; proper
  mov [aIsoThis],offset(aIsoData)
label DecrementFreeBuffers near
  dec [aIsoFree] ; count
  jnz ProcessRawIsoData
  jmp AwaitFilledIsoBuffers
label BadObtainAudio near
  cmp [EndThread],0 ; continue
  jne EndObtainAudio ; terminate
  call ShowReturnCode ; info
; show appropriate error message
  call DosWrite c,2,offset(sFail5),sFail6-sFail5,offset(BytesDone6)
label EndObtainAudio near
; exit the obtain thread
  call DosExit c,0,0
endp ObtainAudio

dataseg
HeaderR00 db 'RIFF' ; riff
LengthR00 dd 0 ; filelength
          db 'WAVE' ; type
          db 'fmt ' ; format
          dd 16 ; format length
WavOutFnc dw 1,1 ; pcm,channels
WavOutSps dd InFreq ; samples/sec
WavOutBps dd InFreq*2 ; bytes/sec
WavOutBaf dw 2 ; block align
WavOutSnb dw 16 ; bits/sample
label TrailerR00 byte

dataseg
HeaderD00 db 'data' ; data
LengthD00 dd 0 ; chunck length
label TrailerD00 byte

dataseg
; pipe name
szNPipeA db '\PIPE\Webcam\Audio',0

dataseg
fhNPipeA dd 0 ; pipe handle

dataseg
AudPipeNumber dd 0

udataseg
BytesDone8 dd ?

codeseg
proc AudPipeThread c near
arg @@parameter:dword
; create named output pipe
  call DosCreateNPipe c,offset(szNPipeA),offset(fhNPipeA),81h,01h,4096,0,8000)
  test eax,eax ; check for errors
  jnz ExitAudPipeThread ; exit
; issue server is on-line message
  call DosWrite c,2,offset(sMsgNr6),sMsgNr7-sMsgNr6,offset(BytesDone8)
; foreground server priority
  call DosSetPriority c,2,4,10,0
label ConnectAudNamedPipe1 near
  call DosConnectNPipe c,[fhNPipeA]
  test eax,eax ; check for errors
  jnz ExitAudPipeThread ; exit
; send riff/wave header to named pipe
  call DosWrite c,[fhNPipeA],offset(HeaderR00),TrailerR00-HeaderR00,offset(BytesDone8)
label SendAudPipeStream near
  call DosSleep c,20 ; mSeconds
; request audio stream buffer
  call DosRequestMutexSem c,[sAudioMutex],-1
  test eax,eax ; check for errors
  jnz ExitAudPipeThread ; exit
  cmp [AudLength],0 ; nothing
  je SentPipeAudio ; ignore
; verify next chunk available
  mov eax,[AudNumber] ; next
  cmp eax,[AudPipeNumber]
  je SentPipeAudio ; ignore
  mov [AudPipeNumber],eax
; send wave data header to named pipe
; call DosWrite c,2,offset(HeaderD00),TrailerD00-HeaderD00,offset(BytesDone8)
  mov eax,[AudLength] ; size
  mov [LengthD00],eax ; size
  call DosWrite c,[fhNPipeA],offset(HeaderD00),TrailerD00-HeaderD00,offset(BytesDone8)
  test eax,eax ; check for errors
  jnz StopAudPipeStream ; stop
; send audio data to named pipe
  mov edi,[AudLength] ; size
  mov esi,offset(AudBuffer)
label SendPipeAudio near
  mov eax,edi ; image size
  cmp eax,4096 ; maximum
  jna NotTooLargeSize8
  mov eax,4096 ; maximum
label NotTooLargeSize8 near
; send audio data to named pipe
  call DosWrite c,[fhNPipeA],esi,eax,offset(BytesDone8)
  test eax,eax ; check for errors
  jnz StopAudPipeStream ; stop
  mov eax,[BytesDone8] ; done
  add esi,eax ; next address
  sub edi,eax ; remaining
  jnz SendPipeAudio ; more
label SentPipeAudio near
; release audio stream buffer
  call DosReleaseMutexSem c,[sAudioMutex]
  test eax,eax ; check for errors
  jnz ExitAudPipeThread ; exit
  jmp SendAudPipeStream ; more
label StopAudPipeStream near
; release audio stream buffer
  call DosReleaseMutexSem c,[sAudioMutex]
  test eax,eax ; check for errors
  jnz ExitAudPipeThread ; exit
; disconnect named output pipe
  call DosDisConnectNPipe c,[fhNPipeA]
  test eax,eax ; check for errors
  jnz ExitAudPipeThread ; exit
  jmp ConnectAudNamedPipe1
label ExitAudPipeThread near
; exit audio pipe thread
  call DosExit c,0,0
endp AudPipeThread

dataseg
ColorIndex dd 3 ; default
; ITU-R BT.601 - SDTV standard
; precalculated yuyv2rgb coefficients
; y=000..255,u=000..255,v=000..255
ayc0 dd 16777216 ; 1.00000000*2E24
buc0 dd 29611786 ; 1.765*2E24
guc0 dd 05754585 ; 0.343*2E24
gvc0 dd 11928600 ; 0.711*2E24
rvc0 dd 23488102 ; 1.400*2E24
yzc0 dd 00000000 ; yMin=000
; ITU-R BT.601 - SDTV standard
; precalculated yuyv2rgb coefficients
; y=016..240,u=016..240,v=016..240
ayc1 dd 19173961 ; 1.14285714*2E24
buc1 dd 33839645 ; 2.017*2E24
guc1 dd 06576669 ; 0.392*2E24
gvc1 dd 13639877 ; 0.813*2E24
rvc1 dd 26776437 ; 1.596*2E24
yzc1 dd 00000016 ; yMin=016
; ITU-R BT.601 - SDTV standard
; precalculated yuyv2rgb coefficients
; y=016..235,u=016..240,v=016..240
ayc2 dd 19535115 ; 1.16438356*2E24
buc2 dd 33839645 ; 2.017*2E24
guc2 dd 06576669 ; 0.392*2E24
gvc2 dd 13639877 ; 0.813*2E24
rvc2 dd 26776437 ; 1.596*2E24
yzc2 dd 00000016 ; yMin=016
; ITU-R BT.709 - HDTV standard
; precalculated yuyv2rgb coefficients
; y=016..235,u=016..240,v=016..240
ayc dd 19535115 ; 1.16438356*2E24
buc dd 35433480 ; 2.112*2E24
guc dd 03573547 ; 0.213*2E24
gvc dd 08942256 ; 0.533*2E24
rvc dd 30081548 ; 1.793*2E24
yzc dd 00000016 ; yMin=016

udataseg
rgbBuffer db IxMax*IyMax*3 dup(?)

codeseg
proc yuyv2rgb near
  push ebp ; save
; convert yuyv to rgb
  mov eax,[ImgBufferSize]
  shr eax,1 ; now (Ix*Iy*2)/2
  lea edi,[eax*2+eax+offset(rgbBuffer)]
label ConvertThisLine near
  mov ecx,[ImageIx]
  shr ecx,1 ; dwords
; update line pointer
  sub edi,[ImageIx]
  sub edi,[ImageIx]
  sub edi,[ImageIx]
; convert yuyv to rgb
label ConvertPixels near
; calculate 1st Y value
  movzx edx,[byte(esi)+0]
  mov eax,[ayc] ; ayf*2E24
  sub edx,[yzc] ; (Y-Z)*2E0
  shl edx,16 ; (Y-Z)*2E16
  mul edx ; ayf*(Y-Z)*2E8
  mov ebp,edx ; retain
; calculate 2nd Y value
  movzx edx,[byte(esi)+2]
  mov eax,[ayc] ; ayf*2E24
  sub edx,[yzc] ; (Y-Z)*2E0
  shl edx,16 ; (Y-Z)*2E16
  mul edx ; ayf*(Y-Z)*2E8
  mov ebx,edx ; retain
; calculate 1st U value
  movzx edx,[byte(esi)+1]
  mov eax,[buc] ; buf*2E24
  sub edx,80h ; (U-80h)*2E0
  shl edx,16 ; (U-80h)*2E16
  imul edx ; buf*(U-80h)*2E8
; calculate 1st B value
  mov eax,ebp ; 1st Y*2E8
  add eax,edx ; 1st B*2E8
  sar eax,8 ; keep 8 bits
  adc eax,0 ; round result
  test ah,ah ; validate
  jz Store1stB ; correct
  mov al,000h ; minimum
  js Store1stB ; correct
  mov al,0FFh ; maximum
label Store1stB near
  mov [byte(edi+0)],al
; calculate 2nd B value
  mov eax,ebx ; 2nd Y*2E8
  add eax,edx ; 2nd B*2E8
  sar eax,8 ; keep 8 bits
  adc eax,0 ; round result
  test ah,ah ; validate
  jz Store2ndB ; correct
  mov al,000h ; minimum
  js Store2ndB ; correct
  mov al,0FFh ; maximum
label Store2ndB near
  mov [byte(edi+3)],al
; calculate 2nd V value
  movzx edx,[byte(esi)+3]
  mov eax,[rvc] ; rvf*2E24
  sub edx,80h ; (V-80h)*2E0
  shl edx,16 ; (V-80h)*2E16
  imul edx ; rvf*(V-80h)*2E8
; calculate 1st R value
  mov eax,ebp ; 1st Y*2E8
  add eax,edx ; 1st R*2E8
  sar eax,8 ; keep 8 bits
  adc eax,0 ; round result
  test ah,ah ; validate
  jz Store1stR ; correct
  mov al,000h ; minimum
  js Store1stR ; correct
  mov al,0FFh ; maximum
label Store1stR near
  mov [byte(edi+2)],al
; calculate 2nd R value
  mov eax,ebx ; 2nd Y*2E8
  add eax,edx ; 2nd R*2E8
  sar eax,8 ; keep 8 bits
  adc eax,0 ; round result
  test ah,ah ; validate
  jz Store2ndR ; correct
  mov al,000h ; minimum
  js Store2ndR ; correct
  mov al,0FFh ; maximum
label Store2ndR near
  mov [byte(edi+5)],al
; calculate 2nd U value
  movzx edx,[byte(esi)+1]
  mov eax,[guc] ; guf*2E24
  sub edx,80h ; (U-80h)*2E0
  shl edx,16 ; (U-80h)*2E16
  imul edx ; guf*(U-80h)*2E8
; calculate 1st G value
  sub ebp,edx ; 1st G*2E8
; calculate 2nd G value
  sub ebx,edx ; 2nd G*2E8
; calculate 1st V value
  movzx edx,[byte(esi)+3]
  mov eax,[gvc] ; gvf*2E24
  sub edx,80h ; (V-80h)*2E0
  shl edx,16 ; (V-80h)*2E16
  imul edx ; gvf*(V-80h)*2E8
; calculate 1st G value
  mov eax,ebp ; 1st G*2E8
  sub eax,edx ; 1st G*2E8
  sar eax,8 ; keep 8 bits
  adc eax,0 ; round result
  test ah,ah ; validate
  jz Store1stG ; correct
  mov al,000h ; minimum
  js Store1stG ; correct
  mov al,0FFh ; maximum
label Store1stG near
  mov [byte(edi+1)],al
; calculate 2nd G value
  mov eax,ebx ; 2nd G*2E8
  sub eax,edx ; 2nd G*2E8
  sar eax,8 ; keep 8 bits
  adc eax,0 ; round result
  test ah,ah ; validate
  jz Store2ndG ; correct
  mov al,000h ; minimum
  js Store2ndG ; correct
  mov al,0FFh ; maximum
label Store2ndG near
  mov [byte(edi+4)],al
; update pixel pointers
  lea esi,[esi+4] ; yuuv
  lea edi,[edi+6] ; rgb
; loop till line complete
  dec ecx ; next dword
  jnz ConvertPixels
; update line pointer
  sub edi,[ImageIx]
  sub edi,[ImageIx]
  sub edi,[ImageIx]
; loop till image complete
  cmp edi,offset(rgbBuffer)
  ja ConvertThisLine
  pop ebp ; restore
  ret ; return
endp yuyv2rgb

codeseg
proc dec2bin near
; decimal to binary
  sub eax,eax ; input
  sub edx,edx ; output
label ConvertInput near
  inc edi ; next position
  mov al,[edi] ; digit
; convert decimal digit
  cmp al,'0' ; minimum
  jb Enddec2bin ; done
  cmp al,'9' ; maximum
  ja Enddec2bin ; done
  sub al,'0' ; digit
  lea edx,[edx*4+edx]
  lea edx,[edx*2+eax]
  jmp ConvertInput
label Enddec2bin Near
  ret ; return
endp dec2bin

codeseg
proc hex2bin near
; convert hex to binary
  xor edx,edx ; binary output
  xor ecx,ecx ; wildcard mask
label ConvertHexDigit near
  inc edi ; next position
  mov al,[edi] ; input
; convert decimal
  cmp al,"0" ; min
  jb NotDecimal
  cmp al,"9" ; max
  ja NotDecimal
  sub al,"0"-00h
  shl edx,4 ; output
  xor dl,al ; supply
  shl ecx,4 ; ticket
  jmp ConvertHexDigit
label NotDecimal near
; convert character
  cmp al,"A" ; min
  jb NotHex2bin
  cmp al,"F" ; max
  ja NotHex2bin
  sub al,"A"-0Ah
  shl edx,4 ; output
  xor dl,al ; supply
  shl ecx,4 ; ticket
  jmp ConvertHexDigit
label NotHex2bin near
; convert wildcard
  cmp al,"#" ; token
  jne EndHex2bin
  shl ecx,4 ; ticket
  xor cl,0Fh ; token
  shl edx,4 ; output
  jmp ConvertHexDigit
label EndHex2bin near
; prepare wildcard
  not ecx ; mask
  ret ; return
endp hex2bin

dataseg
MaxAlternate dd -1
MaxFrameTime dd 0

dataseg
DevSelect db '0'
VideoMJPG db '1'
VideoYUYV db '1'

dataseg
VideoIx dd 0 ; Ix
VideoIy dd 0 ; Iy

dataseg
AudioPipe db '0'
VideoHttp db '0'
VideoPipe db '0'
VideoStdo db '0'

dataseg
AudioFreq dd 0

codeseg
proc ProcessArguments near
; scan for forward slash
  mov al,[edi] ; character
  inc edi ; next position
  cmp al,00h ; terminator
  je EndScanString ; done
  cmp al,'/' ; parameter
  jne ProcessArguments
; color index argument
  cmp [byte(edi)],'c'
  jne NotColorIndex
  call dec2bin ; convert
; check color index value
  cmp edx,3 ; max value
  jnb ProcessArguments
; store color index value
  mov [ColorIndex],edx
  jmp ProcessArguments
label NotColorIndex near
; device select argument
  cmp [byte(edi)],'d'
  jne NotSelectDevice
  mov [DevSelect],'1'
; update vendor specification
  call hex2bin ; obtain vendor
  mov [idVendorMask],ecx ; mask
  mov [idVendor],edx ; vendor
  cmp [byte(edi)],":"
  jne ProcessArguments
; update product specification
  call hex2bin ; obtain product
  mov [idProductMask],ecx ; mask
  mov [idProduct],edx ; product
  cmp [byte(edi)],":"
  jne ProcessArguments
; update release specification
  call hex2bin ; obtain release
  mov [bcdDeviceMask],ecx ; mask
  mov [bcdDevice],edx ; release
  jmp ProcessArguments
label NotSelectDevice near
; frame interval argument
  cmp [byte(edi)],'f'
  jne NotFrameInterval
  call dec2bin ; convert
  mov [MaxFrameTime],edx
  jmp ProcessArguments
label NotFrameInterval near
; alt interface argument
  cmp [byte(edi)],'i'
  jne NotAltSetting
  call dec2bin ; convert
  mov [MaxAlternate],edx
  jmp ProcessArguments
label NotAltSetting near
; audio MJPG argument
  cmp [byte(edi)],'m'
  jne NotVideoMJPG
  mov [VideoMJPG],'1'
  mov [VideoYUYV],'0'
  jmp ProcessArguments
label NotVideoMJPG near
; audio YUYV argument
  cmp [byte(edi)],'u'
  jne NotVideoYUYV
  mov [VideoYUYV],'1'
  mov [VideoMJPG],'0'
  jmp ProcessArguments
label NotVideoYUYV near
; audio server argument
  cmp [byte(edi)],'a'
  jne NotAudServer
  mov [AudioPipe],'1'
  call dec2bin ; convert
  mov [AudioFreq],edx
  jmp ProcessArguments
label NotAudServer near
; http server argument
  cmp [byte(edi)],'h'
  jne NotHttpServer
  mov [VideoHttp],'1'
  jmp ProcessArguments
label NotHttpServer near
; named pipe argument
  cmp [byte(edi)],'n'
  jne NotPipeServer
  mov [VideoPipe],'1'
  jmp ProcessArguments
label NotPipeServer near
; standard output argument
  cmp [byte(edi)],'s'
  jne NotStdoServer
  mov [VideoStdo],'1'
  jmp ProcessArguments
label NotStdoServer near
; video width argument
  cmp [byte(edi)],'x'
  jne NotVideoWidth
  call dec2bin ; convert
; store video width
  mov [VideoIx],edx
  jmp ProcessArguments
label NotVideoWidth near
; video height argument
  cmp [byte(edi)],'y'
  jne NotVideoHeight
  call dec2bin ; convert
; store video height
  mov [VideoIy],edx
  jmp ProcessArguments
label NotVideoHeight near
; tcp/ip port argument
  cmp [byte(edi)],'p'
  jne ProcessArguments
  call dec2bin ; convert
; check tcp/ip port number
  cmp edx,0FFFFh ; max
  ja ProcessArguments
  cmp edx,00400h ; min
  jb ProcessArguments
; store tcp/ip port number
  mov [SocketAddress+3],dl
  mov [SocketAddress+2],dh
  jmp ProcessArguments
label EndScanString near
; set color coefficients
  mov edx,[ColorIndex]
  cmp edx,3 ; default
  jnb EndSetValues
  mov edi,offset(ayc)
  mov esi,offset(ayc0)
  lea edx,[edx+edx*2]
  lea esi,[esi+edx*8]
  mov ecx,6 ; dwords
  rep movsd ; values
label EndSetValues near
; set default image
  cmp [VideoIx],0
  jne EndSetImage
  cmp [VideoIy],0
  jne EndSetImage
  mov [VideoIx],Ix
  mov [VideoIy],Iy
label EndSetImage near
; set default video
  cmp [AudioPipe],'0'
  jne EndSetVideo
  cmp [VideoHttp],'0'
  jne EndSetVideo
  cmp [VideoPipe],'0'
  jne EndSetVideo
  cmp [VideoStdo],'0'
  jne EndSetVideo
  mov [VideoPipe],'1'
label EndSetVideo near
; skip sanity checks
  ret ; return
endp ProcessArguments

udataseg
BytesRead dd ?
DevNumber dd ?
DevReport db ReportSize dup(?)
ReportSize = 4096

dataseg
bcdDevice dd 0
bcdDeviceMask dd 0
idProduct dd 0
idProductMask dd 0
idVendor dd 0
idVendorMask dd 0

codeseg
proc ObtainUvcDevice near
; obtain number of attached usb devices
  call UsbQueryNumberDevices c,offset(DevNumber)
  test eax,eax ; check for errors
  jnz EndUvcDevice ; stop
label InspectThisDevice near
  cmp [DevNumber],eax ; present
  jnz VerifyProperDevice ; yes
; report webcam not found failure
  call DosWrite c,2,offset(sFail6),sFail7-sFail6,offset(BytesDone)
  dec [DevNumber] ; failure
  jmp EndUvcDevice ; stop
label VerifyProperDevice near
; look for attached uvc device
  mov [BytesRead],ReportSize
  call UsbQueryDeviceReport c,[DevNumber],offset(BytesRead),offset(DevReport)
  test eax,eax ; check for errors
  jnz EndUvcDevice ; stop
  dec [DevNumber] ; previous
  cmp [DevReport+4],0EFh
  jne InspectThisDevice
  cmp [DevReport+5],002h
  jne InspectThisDevice
  cmp [DevReport+6],001h
  jne InspectThisDevice
; find function class video
; address compound descriptor
  mov esi,offset(DevReport)
  mov ebx,[BytesRead] ; size
  lea ebx,[esi+ebx] ; boundary
  mov ecx,[esi] ; size/type
Label BumpDescriptor near
; point to next descriptor
  and ecx,0FFh ; length
  add esi,ecx ; next
  cmp esi,ebx ; boundary
  jnb InspectThisDevice
  mov ecx,[esi] ; size/type
label FindVideoClass near
; find association descriptor
  cmp ch,0Bh ; association
  jne BumpDescriptor
  cmp [byte(esi)+4],0Eh
  jne BumpDescriptor
  cmp [byte(esi)+5],03h
  jne BumpDescriptor
; accept any uvc device
  cmp [DevSelect],'0'
  je AcceptThisDevice
; verify device selection
  sub edx,edx ; ensure zero
  mov dx,[word(DevReport)+08h]
  and edx,[idVendorMask]
  cmp edx,[idVendor]
  jne InspectThisDevice
  mov dx,[word(DevReport)+0Ah]
  and edx,[idProductMask]
  cmp edx,[idProduct]
  jne InspectThisDevice
  mov dx,[word(DevReport)+0Ch]
  and edx,[bcdDeviceMask]
  cmp edx,[bcdDevice]
  jne InspectThisDevice
label AcceptThisDevice near
; use attached uvc device
  mov ax,[word(DevReport)+08h]
  mov [dword(idVendor)],eax
  mov ax,[word(DevReport)+0Ah]
  mov [dword(idProduct)],eax
  mov ax,[word(DevReport)+0Ch]
  mov [dword(bcdDevice)],eax
; use video support
  mov [RunVideo],1
; find function class audio
; address compound descriptor
  mov esi,offset(DevReport)
  mov ebx,[BytesRead] ; size
  lea ebx,[esi+ebx] ; boundary
  mov ecx,[esi] ; size/type
Label DescriptorBump near
; point to next descriptor
  and ecx,0FFh ; length
  add esi,ecx ; next
  cmp esi,ebx ; boundary
  jnb EndUseAudio ; no
  mov ecx,[esi] ; size/type
label FindAudioClass near
; find association descriptor
  cmp ch,0Bh ; association
  jne DescriptorBump
  cmp [byte(esi)+4],01h
  jne DescriptorBump
  cmp [byte(esi)+5],02h
  jne DescriptorBump
; use audio support
  mov [RunAudio],1
; audio preparation
  call GatherAudio
label EndUseAudio near
  sub eax,eax ; success
label EndUvcDevice near
  ret ; return
endp ObtainUvcDevice

InFreq=48000
InSize=100

dataseg
; audio streaming
aAddrEndpoint dd 0
aAltInterface dd 0
aIsoFrameSize dd 0
;aIsoFrameUsed dd 0 ; concat
aIsoFrameUsed dd adSize/InSize
aNumInterface dd 0
aSetFrequency dd 0

dataseg
FrequencyMatch db 0

proc GatherAudio near
; point to next descriptor
  and ecx,0FFh ; length
  add esi,ecx ; next
  cmp esi,ebx ; boundary
  jnb EndGatherAudio ; no
  mov ecx,[esi] ; size/type
label FindInterface near
; find interface descriptor
  cmp ch,04h ; interface
  jne GatherAudio
  cmp [byte(esi)+5],1
  jne GatherAudio
; verify audio control
  cmp [byte(esi)+6],1
  jne NotControl ; no
; audio control interface
  shld eax,ecx,16 ; proper
; use interface setting
  mov [byte(MuteIndex)+0],al
Label NextAudioControl near
; point to next descriptor
  and ecx,0FFh ; length
  add esi,ecx ; next
  cmp esi,ebx ; boundary
  jnb EndGatherAudio ; no
  mov ecx,[esi] ; size/type
; use control descriptor
  cmp ch,24h ; control
  jne FindInterface
; feature unit descriptor
  shld eax,ecx,16 ; proper
  cmp al,6 ; feature unit
  jne NextAudioControl
; use feature unit identifier
  mov [byte(MuteIndex)+1],ah
; ignore bmaControls
  jmp FindInterface
label NotControl near
; verify audio streaming
  cmp [byte(esi)+6],2
  jne GatherAudio
; verify having bandwidth
  cmp [byte(esi)+3],0
  jna GatherAudio
; audio streaming interface
  shld eax,ecx,16 ; proper
; save interface settings
  mov [byte(aAltInterface)],ah
  mov [byte(aNumInterface)],al
Label NextAudioStream near
; point to next descriptor
  and ecx,0FFh ; length
  add esi,ecx ; next
  cmp esi,ebx ; boundary
  jnb EndGatherAudio ; stop
  mov ecx,[esi] ; size/type
; use endpoint descriptor
  cmp ch,05h ; endpoint
  jne CheckStreaming
; setup bEndpointAddress
  movzx eax,[byte(esi)+2]
  mov [aAddrEndpoint],eax
; setup wMaxPacketSize
  movzx eax,[word(esi)+4]
; check calculated size
  cmp eax,[aIsoFrameSize]
  jae EndSetFrameSize ; ok
  mov [aIsoFrameSize],eax
label EndSetFrameSize near
; verify frequency matched
  cmp [FrequencyMatch],1
  jne GatherAudio ; no
  jmp EndGatherAudio
label CheckStreaming near
; use streaming descriptor
  cmp ch,24h ; streaming
  jne NextAudioStream
  cmp [byte(esi)+2],2
  jne NextAudioStream
  cmp [byte(esi)+3],1
  jne NextAudioStream
; check sample frequency
  lea edi,[esi+7] ; start
  movzx edx,[byte(edi)]
; inspect bSamFreqType
  test edx,edx ; discrete
  jnz CheckDiscrete
  mov edx,[AudioFreq]
; check continuous
  mov eax,[edi+0]
  shr eax,8 ; minimum
  cmp edx,eax
  jb StoreFrequency
  mov eax,[edi+3]
  shr eax,8 ; maximum
  cmp edx,eax
  ja StoreFrequency
  mov eax,edx ; proper
  jmp StoreFrequency
label CheckDiscrete near
  mov eax,[edi] ; dword
  shr eax,8 ; discrete
  cmp eax,[AudioFreq]
  je StoreFrequency
  add edi,3 ; next
  sub edx,1 ; next
  jnz CheckDiscrete
label StoreFrequency near
  mov [aSetFrequency],eax
; store samples/second
  mov [WavOutSps],eax
; set number of channels
  movzx eax,[byte(esi)+4]
  mov [WavOutFnc+2],ax
; set number of bits/sample
  movzx edx,[byte(esi)+6]
  mov [WavOutSnb],dx
; set block alignment
  mul edx ; bps*channels
  shr eax,3 ; alignment
  mov [WavOutBaf],ax
; set bytes/second
  mul [WavOutSps]
  mov [WavOutBps],eax
; set iso frame size
  sub edx,edx ; zeroes
  mov edi,1000 ; mSec
  div edi ; bytes/mSec
  movzx edx,[WavOutBaf]
  lea eax,[eax+edx*2]
  mov [aIsoFrameSize],eax
; verify frequency setting
  mov eax,[aSetFrequency]
  cmp eax,[AudioFreq]
  jne NextAudioStream
  mov [FrequencyMatch],1
  jmp NextAudioStream
label EndGatherAudio near
  ret ; return
endp GatherAudio

dataseg
; video streaming
vAddrEndpoint dd 0
vAltInterface dd 0
vIsoFrameSize dd 0
vIsoFrameUsed dd 0
vNumInterface dd 0

dataseg
StreamFormat dd 'Huh?'

codeseg
proc ProcessDescriptors near
; address compound descriptor
  mov esi,offset(DevReport)
  mov ebx,[BytesRead] ; size
  lea ebx,[esi+ebx] ; boundary
  mov eax,[esi] ; size/type
Label NextDescriptor near
; point to next descriptor
  and eax,0FFh ; length
  add esi,eax ; next
  cmp esi,ebx ; boundary
  jnb EndDescriptor ; stop
  mov eax,[esi] ; size/type
label FindDescriptor near
; find interface descriptor
  cmp ah,04h ; interface
  jne NextDescriptor
  cmp [byte(esi)+5],0Eh
  jne NextDescriptor
  cmp [byte(esi)+6],02h
  jne NextDescriptor
; verify having bandwidth
  cmp [byte(esi)+3],00h
  jnz GetVidEndpoint
; video streaming interface
Label NextVideoStream near
; point to next descriptor
  and eax,0FFh ; length
  add esi,eax ; next
  cmp esi,ebx ; boundary
  jnb EndDescriptor ; stop
  mov eax,[esi] ; size/type
  cmp ah,24h ; streaming
  jne FindDescriptor
; decode video streaming
  shld edx,eax,16 ; subtype
; verify decode yuyv video
  cmp [VideoYUYV],'1' ; use
  jne EndDecodeYUYV ; skip
  cmp dl,04h ; format yuyv
  je FormatInxYUYV
  cmp dl,05h ; frame yuyv
  je FrameInxYUYV
label EndDecodeYUYV near
; verify decode mjpg video
  cmp [VideoMJPG],'1' ; use
  jne EndDecodeMJPG ; skip
  cmp dl,06h ; format mjpg
  je FormatInxMJPG
  cmp dl,07h ; frame mjpg
  je FrameInxMJPG
label EndDecodeMJPG near
  jmp NextVideoStream
label FormatInxMJPG near
; setup bFormatIndex
  mov [Negotiate+2],dh
  jmp NextVideoStream
label FormatInxYUYV near
; setup bFormatIndex
  mov [Negotiate+2],dh
  jmp NextVideoStream
label FrameInxMJPG near
; frame index Ix*Iy mjpg
  cmp [StreamFormat],'mjpg'
  je nextVideoStream
; verify frame wWidth
  mov ecx,[VideoIx]
  test ecx,ecx ; used
  jz EndMatchIxMJPG
  cmp cx,[word(esi)+5]
  jne NextVideoStream
label EndMatchIxMJPG near
; verify frame wHeight
  mov ecx,[VideoIy]
  test ecx,ecx ; used
  jz EndMatchIyMJPG
  cmp cx,[word(esi)+7]
  jne NextVideoStream
label EndMatchIyMJPG near
; setup bFrameIndex
  mov [Negotiate+3],dh
; setup dwFrameInterval
  call SetupFrameInterval
; switch video stream format
  mov [StreamFormat],'mjpg'
  jmp NextVideoStream
label FrameInxYUYV near
; frame index Ix*Iy yuyv
  cmp [StreamFormat],'yuyv'
  je nextVideoStream
; verify frame wWidth
  mov ecx,[VideoIx]
  test ecx,ecx ; used
  jz EndMatchIxYUYV
  cmp cx,[word(esi)+5]
  jne NextVideoStream
label EndMatchIxYUYV near
; verify frame wHeight
  mov ecx,[VideoIy]
  test ecx,ecx ; used
  jz EndMatchIyYUYV
  cmp cx,[word(esi)+7]
  jne NextVideoStream
label EndMatchIyYUYV near
; setup bFrameIndex
  mov [Negotiate+3],dh
; setup dwFrameInterval
  call SetupFrameInterval
; switch video stream format
  mov [StreamFormat],'yuyv'
  jmp NextVideoStream
label GetVidEndpoint near
; verify alternate setting
  mov edx,[vAltInterface]
  cmp edx,[MaxAlternate]
  jnb NextDescriptor
; setup bInterfaceNumber
  movzx edx,[byte(esi)+2]
  mov [vNumInterface],edx
; setup bAlternateSetting
  movzx edx,[byte(esi)+3]
  mov [vAltInterface],edx
label NextEndpoint near
; point to next descriptor
  and eax,0FFh ; length
  add esi,eax ; next
  cmp esi,ebx ; boundary
  jnb EndDescriptor ; stop
  mov eax,[esi] ; size/type
  cmp ah,05h ; endpoint
  jne FindDescriptor
; setup bEndpointAddress
  movzx edx,[byte(esi)+2]
  mov [vAddrEndpoint],edx
; setup wMaxPacketSize
  movzx edx,[word(esi)+4]
  mov [vIsoFrameSize],edx
  jmp NextDescriptor
label EndDescriptor near
; show video stream format
  mov eax,[StreamFormat]
  bswap eax ; proper format
  mov [dword(sInfo5+7)],eax
  call DosWrite c,2,offset(sInfo5),sInfo6-sInfo5,offset(BytesDone)
; update iso frame length
  mov eax,[vIsoFrameSize]
  shld edx,eax,21 ; multi
  and ah,07h ; isolate
  and dl,03h ; isolate
  mov [vIsoFrameSize],eax
  cmp dl,01h ; double
  jb EndMultiple ; single
  je AddMultiple ; double
  add eax,eax ; triple
label AddMultiple near
  add [vIsoFrameSize],eax
label EndMultiple near
; verify iso frame length
  mov eax,[vIsoFrameSize]
  test eax,eax ; available
  jnz EndVerifySize ; yes
; report invalid frame size
  call ShowReturnCode ; info
  call DosWrite c,2,offset(sFail3),sFail4-sFail3,offset(BytesDone)
  mov al,1 ; failure
  test eax,eax
  ret ; return
label EndVerifySize near
; calculate iso frame count
  sub edx,edx ; ensure zeroes
  mov eax,vdSize ; data size
  div [vIsoFrameSize] ; count
  and al,0F8h ; microframes
  mov [vIsoFrameUsed],eax
; apply sanity checks
  cmp esi,ebx ; boundary
  ret ; return
endp ProcessDescriptors

dataseg
ImageIx dd Ix
ImageIy dd Iy

codeseg
proc SetupFrameInterval near
; setup dwDefaultFrameInterval
  cmp [MaxFrameTime],0 ; default
  mov edx,[esi+21] ; default
  jna SetFrameInterval
; obtain bFrameIntervalType
  movzx edx,[byte(esi+25)]
  test edx,edx ; continuous
  jnz EndContinuous ; discrete
  mov dl,2 ; fastest/slowest
label EndContinuous near
  cmp edx,[MaxFrameTime]
  jna GetFrameInterval
  mov edx,[MaxFrameTime]
label GetFrameInterval near
  mov edx,[esi+26+edx*4-4]
label SetFrameInterval near
  mov [dword(Negotiate)+4],edx
; save video image variables
  movzx edx,[word(esi)+5]
  mov [ImageIx],edx ; wWidth
  mov [HdrSOF+8],dl ; <(Ix)
  mov [HdrSOF+7],dh ; >(Ix)
  movzx edx,[word(esi)+7]
  mov [ImageIy],edx ; wHeight
  mov [HdrSOF+6],dl ; <(Iy)
  mov [HdrSOF+5],dh ; >(Iy)
; dwMaxVideoFrameBufferSize
  mov edx,[dword(esi)+17]
  mov [ImgBufferSize],edx
  ret ; return
endp SetupFrameInterval

include 'webcam.inc'

end MainRoutine
