.386p
model use16 small
ideal

extrn Dos16Write:far

dataseg
; device driver header
hdrlnk dd 0FFFFFFFFh
hdratr dw 0D180h
hdrstr dw offset(strategy)
hdridc dw offset(idcentry)
hdrddn db "$       "
hdrres db 8 dup(0)
hdrbit dd 000000010h

dataseg
; device helper
devhlp dd 0

dataseg
; allocgdtselector
gdtsel dw @data

dataseg
; attachdd usbd
idcepi dw 6 dup(0)

dataseg
; attach device specification
adsvid dw 0 ; vendor identification
adspid dw 0 ; product identification
adsdrn dw 0 ; device release number

dataseg
; attached device address
adaproper dw 0 ; good device
adarecent dw 0 ; last device

dataseg
; register class driver request
regheader db 0,0,10h,0,0,0,0,0,0,0,0,0,0
regctcfnc db 91h,43h ; usbd register
regsupply dd idctarget
regobtain dw 0,0,0,0,0
; supply request block
idctarget dd idcentry
idcdatsel dw @data

dataseg
; standard device request
sdrheader db 0,0,10h,0,0,0,0,0,0,0,0,0,0
sdrctcfnc db 91h,41h ; usbd acceptio
sdrsupply dd sdrreqblk
sdrobtain dw 0,0,0,0,0
; supply request block
sdrreqblk dw 0
sdrreqept dw 0
sdrreqflg dw 0
sdrbufad1 dd 0
sdrbufsz1 dw 0
sdrbufad2 dd 0
sdrbufsz2 dw 0
sdrdefsfr dw 0
sdrdefpkz dw 0
sdrtarget dd idcentry
sdrdatsel dw @data
sdrcatgry db 92h ; class
sdrreqdat dd 0,0,0
sdrmaxerr db 3
sdrnxtblk dd 0

dataseg
; terminate device request
tdrheader db 0,0,10h,0,0,0,0,0,0,0,0,0,0
tdrctcfnc db 91h,42h ; usbd cancelio
tdrsupply dd sdrreqblk
tdrobtain dw 0,0,0,0,0

dataseg
flsilence db 0

codeseg
proc DevBeep near
; obtain user attention
  cmp [flsilence],0 ; beep
  jne EndDevBeep ; silent
  push bx ; save register
  mov bx,3000 ; frequency
  mov cx,200 ; duration
  mov dl,52h ; sound beep
  call [devhlp] ; helper
  pop bx ; restore register
label EndDevBeep near
  ret ; return
endp DevBeep

codeseg
proc idcentry c far
arg @@offset,@@selector
; obtain packet pointer
  mov bx,[@@offset] ; packet
  mov es,[@@selector] ; packet
; set parm failure status code
  mov ax,8113h ; error/done/parm
; obtain driver function code
  mov cl,[es:bx+14] ; function
; handle idcdevioctl request
  cmp [byte(es:bx+02)],10h
  jne EndIdcEntry ; failure
; handle usb class request
  cmp [byte(es:bx+13)],92h
  jne EndIdcEntry ; failure
; handle process complete
  cmp cl,44h ; process irq
  jne NotInterrupt ; other
; provide completion status
  mov ax,[es:bx+03] ; status
  mov [word(sdrheader+03)],ax
; provide completion result
  push es ; save register
  les di,[dword(es:bx+15)]
  cmp [byte(es:di+06)],0
  je Use2ndLength ; control
; bulk/interrupt/isochronous
; obtain completion toggle
  mov dl,[byte(es:di+05)]
; obtain completion length
  mov cx,[word(es:di+10)]
  les di,[dword(es:di+06)]
; supply completion length
  mov [word(es:di-02)],cx
; update completion toggle
  test ah,80h ; any error
  jnz EndUpdateToggle ; yes
  xor dl,008h ; acknowledged
label EndUpdateToggle near
; supply completion toggle
  mov [byte(es:di-07)],dl
  jmp EndProvideResult
label Use2ndLength near
; obtain completion length
  mov cx,[word(es:di+16)]
  les di,[dword(es:di+06)]
; supply completion length
  mov [word(es:di+06)],cx
label EndProvideResult near
  pop es ; restore register
; release blocked thread
  push bx ; save register
  mov ax,ds ; event number
  mov bx,offset(sdrreqblk)
  mov dl,05h ; release
  call [devhlp] ; helper
  pop bx ; restore register
  jmp IdcGoodStatus
label NotInterrupt near
; handle device attached
  cmp cl,45h ; check service
  jne NotAttached ; other
; get device information
  push es ; save register
  les di,[dword(es:bx+15)]
  les di,[dword(es:di+00)]
  mov si,[word(es:di+00)]
  mov cx,[word(es:di+28)]
  mov dx,[word(es:di+30)]
  mov di,[word(es:di+32)]
  pop es ; restore register
; retain last device address
  mov [adarecent],si ; address
; verify device not present
  cmp [adaproper],0 ; absent
  mov ax,0119h ; done/rejected
  jne EndIdcEntry ; present
; verify attached device
  cmp cx,[adsvid] ; vendor
  jne EndIdcEntry ; reject
  cmp dx,[adspid] ; product
  jne EndIdcEntry ; reject
  cmp di,[adsdrn] ; release
  jne EndIdcEntry ; reject
; mark device configured
  push es ; save register
  les di,[dword(es:bx+15)]
  les di,[dword(es:di+00)]
  mov al,[byte(es:di+43)]
  mov [byte(es:di+02)],al
  pop es ; restore register
; retain good device address
  mov [adaproper],si ; address
  call DevBeep ; attach alert
  jmp IdcGoodStatus ; done
label NotAttached near
; handle device detached
  cmp cl,46h ; detach device
  jne NotDetached ; other
; get device address
  push es ; save register
  les di,[dword(es:bx+15)]
  mov si,[word(es:di+00)]
  pop es ; restore register
; verify this device present
  cmp [adaproper],si ; address
  mov ax,0119h ; done/rejected
  jne EndIdcEntry ; other device
; remove good device address
  mov [adaproper],0 ; absent
  call DevBeep ; detach alert
  jmp IdcGoodStatus ; done
label NotDetached near
; handle invalid request
  jmp EndIdcEntry ; failure
label IdcGoodStatus near
; set success status code
  mov ax,0100h ; ok/done
label EndIdcEntry near
; return status code
  mov [es:bx+03],ax
  ret ; return
endp idcentry

codeseg
proc IdcUsbd c near
uses ds,di,es,si,bx,cx
; obtain usbd entry point
  mov dx,ds ; data selector
  lea di,[idcepi+06] ; target
  mov cx,es ; packet selector
  mov es,dx ; data selector
; provide usbd data selector
  mov ds,[idcepi+10] ; selector
; invoke usbd function processor
  call [dword(es:di)] c,bx,cx
  ret ; return
endp IdcUsbd

codeseg
proc IssueIoRequest near
; setup device address
  mov [sdrreqblk],si
; obtain buffer address
  push bx ; save register
  mov si,[gdtsel] ; gdtselector
  mov ax,[word(es:bx+16)] ; >address
  mov bx,[word(es:bx+14)] ; <address
  mov dl,2Eh ; phystogdtselector
  call [devhlp] ; helper
  pop bx ; restore register
  mov ax,810Ch ; error/done/general
  jc NotIssueIoRequest ; failure
; provide read setup packet
  cmp [byte(es:bx+02)],04h
  jne EndProvideRead ; write
  push es ; save register
  mov es,si ; selector
; get device descriptor
  mov [word(es:0)],0680h
  mov [word(es:2)],0100h
  mov [word(es:4)],0000h
  mov [word(es:6)],0012h
  pop es ; restore register
label EndProvideRead near
; obtain data buffer size
  push es ; save register
  mov es,si ; selector
  mov di,[es:6] ; size
  pop es ; restore register
; verify data buffer size
  sub cx,08h ; setup length
  cmp cx,di ; data buffer size
  mov ax,8113h ; error/done/parm
  jb NotIssueIoRequest ; failure
; verify setup packet passed
  push es ; save register
  mov es,si ; selector
  mov cx,[es:0] ; request
  mov dx,[es:4] ; endpoint
  pop es ; restore register
  cmp cl,0ECh ; not setup
  je NotControlTransfer
label ControlTransfer near
; provide setup packet address
  mov [word(sdrbufad1+0)],0
  mov [word(sdrbufad1+2)],si
; provide setup packet size
  mov [sdrbufsz1],8 ; size
; provide data buffer address
  mov [word(sdrbufad2+0)],8
  mov [word(sdrbufad2+2)],si
; provide data buffer size
  mov [sdrbufsz2],di ; size
; default control transfer
  mov cx,0004h ; transfer
  mov dx,0000h ; endpoint
  jmp StartTransfer ; control
label NotControlTransfer near
; bulk/interrupt/isochronous
  mov cl,ch ; data toggle
; provide transfer type
  mov ch,020h ; bulk
  cmp dh,002h ; bulk
  je EndSetTransferType
  mov ch,040h ; interrupt
  cmp dh,003h ; interrupt
; je EndSetTransferType
; isochronous to be done
; mov ch,080h ; isochronous
; cmp dh,001h ; isochronous
  jne NotIssueIoRequest ; failure
label EndSetTransferType near
  and cx,0E008h ; transfer
  and dx,0008Fh ; endpoint
; provide initiation toggle
  xor ch,cl ; provide toggle
; provide transfer direction
  mov cl,001h ; device-to-host
  cmp dl,080h ; device-to-host
  jnb EndProvideDirection ; no
  mov cl,002h ; host-to-device
label EndProvideDirection near
; provide data buffer address
  mov [word(sdrbufad1+0)],8
  mov [word(sdrbufad1+2)],si
; provide data buffer size
  mov [sdrbufsz1],di ; size
label StartTransfer near
; setup transfer information
  mov [sdrreqflg],cx ; transfer
; setup endpoint information
  mov [sdrreqept],dx ; endpoint
; reset maximum packet size
  mov [sdrdefpkz],0 ; default
; start acceptio operation
  push es bx ; save registers
  mov bx,ds ; get data selector
  mov es,bx ; set packet selector
  mov bx,offset(sdrheader) ; packet
  call IdcUsbd ; function acceptio
  mov ax,[es:bx+03] ; status
  test ah,80h ; any error
  mov al,0Ch ; general
  jnz EndIssueIoRequest
; await process complete
  push bx ; save register
  mov ax,ds ; event number
  mov bx,offset(sdrreqblk)
  mov cx,1000h ; max 4 seconds
  mov di,0000h ; max 4 seconds
  mov dx,0004h ; interruptable
  call [devhlp] ; helper
  pop bx ; restore register
  mov ax,[es:bx+03] ; status
  jnc EndIssueIoRequest ; normal
; terminate current device request
  mov bx,offset(tdrheader) ; packet
  call IdcUsbd ; function cancelio
  mov ax,8111h ; error/done/stop
label EndIssueIoRequest near
  pop bx es ; restore registers
label NotissueIoRequest near
  ret ; return
endp IssueIoRequest

codeseg
proc strategy far
; set parm failure status code
  mov ax,8113h ; error/done/parm
; obtain driver request code
  mov cl,[es:bx+02] ; request
; handle doswrite request
  cmp cl,08h ; write normal
  jb NotDosWrite ; other
  cmp cl,09h ; write verify
  ja NotDosWrite ; other
; verify buffer length
  mov cx,[word(es:bx+18)]
  cmp cx,08h ; setup length
  jb EndStrategy ; failure
; access proper device
  mov si,[adaproper]
  call IssueIoRequest
  cmp al,20h ; i/o error
  jne EndStrategy ; other
  mov al,0Ah ; write fault
  jmp EndStrategy ; done
label NotDosWrite near
; handle dosread request
  cmp cl,04h ; read normal
  jne NotDosRead ; other
; verify buffer length
  mov cx,[word(es:bx+18)]
  cmp cx,1Ah ; total length
  jb EndStrategy ; failure
; access recent device
  mov si,[adarecent]
  call IssueIoRequest
  cmp al,20h ; i/o error
  jne EndStrategy ; other
  mov al,0Bh ; read fault
  jmp EndStrategy ; done
label NotDosRead near
; handle init completion
  cmp cl,1Fh ; init complete
  jne NotInitComplete
; register class driver
  push es bx ; save registers
  mov bx,ds ; get data selector
  mov es,bx ; set packet selector
  mov bx,offset(regheader) ; packet
  call IdcUsbd ; function register
  mov ax,[es:bx+03] ; status
  pop bx es ; restore registers
  mov [es:bx+03],ax ; status
  jmp EndStrategy ; done
label NotInitComplete near
; handle initialization
  cmp cl,00h ; initialize
  je Initialize ; once
label EndStrategy near
; return status code
  mov [es:bx+03],ax
  ret ; return
endp strategy

codeseg
; end of code segment
label EndCode near

dataseg
; end of data segment
label EndData byte

dataseg
flverbose db 0

dataseg
ddname db "USBD$   "

dataseg
InitMsg0 db "USBECD.SYS: D="
msgvid db "0000:"
msgpid db "0000:"
msgdrn db "0000 N="
msgddn db "$        "
InitMsg1 db "Specified driver name NOT available",13,10
InitMsg2 db "Required USBD.SYS driver NOT available",13,10
InitMsg3 db "Required GDT selector NOT available",13,10
InitMsg4 db "USB 1.1 Expanded Control Driver loaded",13,10
label InitMsg5 byte
Written dw 0

codeseg
proc bin2hex near
; convert binary to hex
  and dx,dx ; binary input
  jz EndBin2hex ; complete
label ConvertBinData near
  mov al,dh ; byte data
  shr al,4 ; nibble data
  cmp al,10 ; character
  jb NotCharacter
; convert to character
  add al,"A"-0Ah ; ascii
  jmp StoreCharacter
label NotCharacter near
; convert to decimal
  add al,"0"-00h ; ascii
label StoreCharacter near
  mov [ds:si],al ; store
  inc si ; next position
  shl dx,4 ; next input
  jnz ConvertBinData
label EndBin2hex near
  ret ; return
endp bin2hex

codeseg
proc chr2ddn near
; convert char to ddname
  xor si,si ; first position
label UpdateDriverName near
  inc di ; next position
  mov al,[es:di] ; obtain
; validate character
  cmp al,"!" ; control
  jb EndChr2ddn ; reject
  cmp al,'"' ; special
  je EndChr2ddn ; reject
  cmp al,"*" ; special
  je EndChr2ddn ; reject
  cmp al,"." ; special
  je EndChr2ddn ; reject
  cmp al,"/" ; special
  je EndChr2ddn ; reject
  cmp al,":" ; special
  je EndChr2ddn ; reject
  cmp al,"<" ; special
  je EndChr2ddn ; reject
  cmp al,">" ; special
  je EndChr2ddn ; reject
  cmp al,"?" ; special
  je EndChr2ddn ; reject
  cmp al,"\" ; special
  je EndChr2ddn ; reject
  cmp al,"|" ; special
  je EndChr2ddn ; reject
; update ddname character
  mov [hdrddn+si],al ; set
  mov [msgddn+si],al ; set
  inc si ; next position
  cmp si,8 ; maximum
  jb UpdateDriverName
label EndChr2ddn near
  ret ; return
endp chr2ddn

codeseg
proc hex2bin near
; convert hex to binary
  xor dx,dx ; binary output
label ConvertHexData near
  inc di ; next position
  mov al,[es:di] ; obtain
; convert decimal digit
  cmp al,"0" ; min
  jb NotDecimal
  cmp al,"9" ; max
  ja NotDecimal
  sub al,"0"-00h
  shl dx,4 ; output
  xor dl,al ; supply
  jmp ConvertHexData
label NotDecimal near
; convert character
  cmp al,"A" ; min
  jb EndHex2bin
  cmp al,"F" ; max
  ja EndHex2bin
  sub al,"A"-0Ah
  shl dx,4 ; output
  xor dl,al ; supply
  jmp ConvertHexData
label EndHex2bin near
  ret ; return
endp hex2bin

codeseg
proc Initialize near
; address driver parameters
  push es ; save register
  les di,[dword(es:bx+18)]
label ScanParmString near
; search for forward slash
  mov al,[es:di] ; data
  inc di ; next position
  cmp al,00h ; terminator
  je EndScanParmString
  cmp al,"/" ; parameter
  jne ScanParmString
; obtain /D: parameter
  cmp [byte(es:di)],"D"
  jne NotParmDevice
  inc di ; next position
  cmp [byte(es:di)],":"
  jne ScanParmString
; update vendor specification
  call hex2bin ; obtain vendor
  mov [adsvid],dx ; setup vendor
  mov si,offset(msgvid) ; vendor
  call bin2hex ; supply vendor
  cmp [byte(es:di)],":"
  jne ScanParmString
; update product specification
  call hex2bin ; obtain product
  mov [adspid],dx ; setup product
  mov si,offset(msgpid) ; product
  call bin2hex ; supply product
  cmp [byte(es:di)],":"
  jne ScanParmString
; update release specification
  call hex2bin ; obtain release
  mov [adsdrn],dx ; setup release
  mov si,offset(msgdrn) ; release
  call bin2hex ; supply release
  jmp ScanParmString
label NotParmDevice near
; obtain /N: parameter
  cmp [byte(es:di)],"N"
  jne NotParmDriver
  inc di ; next position
  cmp [byte(es:di)],":"
  jne ScanParmString
; update driver ddname
  call chr2ddn ; update
  jmp ScanParmString
label NotParmDriver near
; obtain /S parameter
  cmp [byte(es:di)],"S"
  jne NotParmSilent
; update silence flag
  mov [flsilence],1
  jmp ScanParmString
label NotParmSilent near
; obtain /V parameter
  cmp [byte(es:di)],"V"
  jne ScanParmString
; update verbose flag
  mov [flverbose],1
  jmp ScanParmString
label EndScanParmString near
  pop es ; restore register
; save devhlp entry point
  mov ax,[es:bx+14]
  mov [word(devhlp+00)],ax
  mov ax,[es:bx+16]
  mov [word(devhlp+02)],ax
; reduce module size
  mov ax,offset(EndCode)
  mov [es:bx+14],ax
  mov ax,offset(EndData)
  mov [es:bx+16],ax
; write startup message
  mov si,InitMsg1-InitMsg0
  mov di,offset(InitMsg0)
label ReduceLength near
  dec si ; use offset
  cmp [InitMsg0+si]," "
  je ReduceLength
  add si,2 ; length
  call IssueMessage
; verify driver ddname
  push bx ; save register
  mov bx,offset(hdrddn)
  mov di,offset(idcepi)
  mov dl,2Ah ; attachdd
  call [devhlp] ; helper
  pop bx ; restore register
  mov si,InitMsg2-InitMsg1
  mov di,offset(InitMsg1)
  jnc InitFailure ; used
; obtain USBD$ idc info
  push bx ; save register
  mov bx,offset(ddname)
  mov di,offset(idcepi)
  mov dl,2Ah ; attachdd
  call [devhlp] ; helper
  pop bx ; restore register
  mov si,InitMsg3-InitMsg2
  mov di,offset(InitMsg2)
  jc InitFailure ; error
; allocate GDT selector
  push es ; save register
  mov es,[gdtsel] ; selector
  mov di,offset(gdtsel) ; offset
  mov dl,2Dh ; allocgdtselector
  mov cx,0001h ; one selector
  call [devhlp] ; helper
  pop es ; restore register
  mov si,InitMsg4-InitMsg3
  mov di,offset(InitMsg3)
  jc InitFailure ; error
; write success message
  mov si,InitMsg5-InitMsg4
  mov di,offset(InitMsg4)
  call IssueMessage
; set success status code
  mov ax,0100h ; ok/done
  jmp EndStrategy ; success
label InitFailure near
; indicate init failure
  sub ax,ax ; ensure zeroes
  mov [es:bx+13],al ; data byte
  mov [es:bx+14],ax ; code size
  mov [es:bx+16],ax ; data size
; write failure message
  call IssueMessage
; set failure status code
  mov ax,8115h ; error/done/quiet
  jmp EndStrategy ; failure
endp Initialize

codeseg
proc IssueMessage near
; issue message to stdout
  cmp [flverbose],1 ; verbose
  jne EndIssueMessage ; suppressed
  call Dos16Write pascal,0,ds,di,si,ds,offset(Written)
label EndIssueMessage near
  ret ; return
endp IssueMessage

end
