/* File created by MERGEC 1.0 (c) 1995 Tillmann Steinbrecher */

/* UNTGZ Decompression Utiliy 0.95 Copyright (c) 1996,97 Tillmann Steinbrecher  

   This freeware program may be distributed according to the terms of the
   GNU general public license version 2 - see file 'copying' for details.

   Revision History
	Ver. 0.01	Sep  9, 1995	original version
	Ver. 0.02	Sep 13, 1995	implemented crc-check
	Ver. 0.03	Sep 15, 1995	minor modifications (speedup???)
	Ver. 0.04	Sep 16, 1995	Implemented list-feature, much more
	Ver. 0.05	Sep 17, 1995	LOTS of bug fixes
	Ver. 0.06	Sep 18, 1995	minor bug fixes
	Ver. 0.07	Sep 23, 1995	implemented timestamp support
	Ver. 0.08	Sep 28, 1995	increased buffer size, 32bit version
	Ver. 0.09	Nov 25, 1995    implemented checksum-routines, bugfixes
	Ver. 0.90       Jan 06, 1996    revamped routines for creating subdirs
	Ver. 0.91	Jan 15, 1996	bugfixes, added Win32 long filenames
	Ver. 0.92	Jan 20, 1996	much better wildcard matching (MATCH.C)
	Ver. 0.92.1	Apr 11, 1996	timestamp bugfix (DOS version only)
	Ver. 0.93	May 11, 1996	rename-option, support uncompressed tar
	Ver. 0.94	Jun  8, 1996    added -d and -t. pkzip archive support.
	Ver. 0.95	Jan 26, 1997    added -y. doesn't crash w/ broken .gz
					fixed crc-bug & timestamp bug in win32 
					version.

 If you improve this code, please send it to:
                        tst@bigfoot.com
                        (note new e-mail adress)

 Known bugs:
     - none in this release.
       Please report any bugs you can find.

 To Do:
     - add PKZIP archive support - DONE
     - add -d option (same as gzip -d) - DONE
     - add -t option (for testing archives) - DONE
     - add -y option for "yes on all queries" - DONE
     - fix all known bugs - DONE

     - whatever YOU suggest
*/


#include <stdio.h>
#include <ctype.h>
#include <conio.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <string.h>
#include <errno.h>
#include <io.h>
#include <dos.h>
#include <process.h>

#ifdef __BORLANDC__
  #include <alloc.h>
  #include <dir.h>
  #include <time.h>
#endif

#include    "untgz.h"

#include    "inflate.c"
/* 32-Bit CRC engine, from FUNZIP.C Version 3.83
   put in the public domain by Mark J.Adler.
   Minor modifications by Tillmann Steinbrecher			*/

#include "crc_tab.h"

unsigned long updcrc(unsigned char *s,unsigned long n)
	       /* pointer to bytes to pump through */
	       /* number of bytes in s[] */
/* Run a set of bytes through the crc shift register.  If s is a NULL
   pointer, then initialize the crc shift register contents instead.
   Return the current crc in either case. */
{
  register unsigned long c;       /* temporary variable */

  static unsigned long crc = 0xffffffffL; /* shift register contents */

  if (s == (unsigned char *)NULL)
    c = 0xffffffffL;
  else
  {
    c = crc;
    while (n--)
      c = crc_32_tab[((int)c ^ (*s++)) & 0xff] ^ (c >> 8);
  }
  crc = c;
  return c ^ 0xffffffffL;       /* (instead of ~c for 64-bit machines) */
}

#include    "match.c"
/* Convert long (UNIX-Style) filenames to DOS 8+3 Format
   Copyright (c) 1996,97 Tillmann Steinbrecher. */

int dos_pathname(char name[], char dos_name[]){
	int pos=0,length=1,newpos=0,max=8;
	while(name[pos]){
		 if(name[pos]=='.'){
		   if(length!=1){
			if(max!=3){ max=3;length=0; }
			else { length=max+1; }
			}
		   else if(name[pos+1]!='/') pos++;
		  }
		if(length<=max){
			dos_name[newpos]=name[pos];
                        if(dos_name[newpos]==',') dos_name[newpos]='_';
                        if(dos_name[newpos]=='+') dos_name[newpos]='_';
			if(dos_name[newpos]=='\\') dos_name[newpos]='_';
			if(dos_name[newpos]=='=') dos_name[newpos]='_';
                        newpos++;
		}
		pos++; length++;
		if(name[pos]=='/'){ max=8;length=0; }
	   }
		dos_name[newpos]=0;
/*		printf("%s, length=%i\n",dos_name,strlen(dos_name)); */
		return 1;
	}

/* TAR stream decompression engine Copyright (c) 1996,97 T. Steinbrecher */

#ifndef PROG_NAME
	#define	PROG_NAME	"untar-engine"
#endif

/* #define VERBOSE */

typedef struct {
  char name[100];
  char operm[8];
  char ouid[8];
  char ogid[8];
  char osize[12];
  char otime[12];
  char ocsum[8];
  char flags;
  char filler[355];
} TARHEADER;

  int outfile;
  long position=-1,size;
  long datapos=0;
  char dosname[100]="";
  char skip=0, answer=0, s_answer=0;
  struct ftime timedate;

int cdecl c_break(void){
	printf(PROG_NAME ": error - aborted, file may be corrupt.");
	error++;
	printf(PROG_NAME ": found %i errors\n",error);
	exit(2);
	return 0; /* Never reached ... */
	}

int ask(void){
	if(answer=='a'||answer=='A') return 1;
	if(answer=='s'||answer=='S') { printf(" skipped"); return 0; }
	for(;;){
		printf(" [YNASRQ] Y\b");
		answer=getche();
		if(answer=='y'||answer=='Y'||answer==13) return 1;
		if(answer=='n'||answer=='N'||answer==27) return 0;
		if(answer=='a'||answer=='A') return 1;
		if(answer=='r'||answer=='R') return 2;
		if(answer=='s'||answer=='S') return 0;
		if(answer=='q'||answer=='Q') c_break();
		printf("\nYes, No, Always, Skip, Rename or Quit\a");
	       }
	  }

int istarheader(unsigned char *hdr,long csum,char askflag){
	long newsum=0;
	int cnt;
	for(cnt=0;cnt<=147;cnt++) newsum+=*(hdr+cnt);
	for(cnt=156;cnt<512;cnt++) newsum+=*(hdr+cnt);
	newsum+=256;
#ifdef VERBOSE
	printf("newsum=%li csum=%li\n",newsum,csum); 
#endif
	if(newsum==csum) return 1;
        else {
	  if(askflag){
	        if(s_answer=='a'||s_answer=='A'||s_answer==13) return 0;
                printf(PROG_NAME ": warning - possibly invalid tar archive, skip to next block");
	for(;;){
		printf(" (Y/N/A/Q) A\b");
                s_answer=getche();
		if(s_answer=='y'||s_answer=='Y') return 0;
		if(s_answer=='n'||s_answer=='N') return 1;
		if(s_answer=='a'||s_answer=='A'||s_answer==13) {
			printf(PROG_NAME ": searching for valid tar header ...");
			return 0;
		      }	
		if(s_answer=='q'||s_answer=='Q') c_break();
                printf("\nYes, No, Always or Quit\a");
	       }
	     } else return 0;
           }     
	}

int createnewdir(char name[]){
	char stat;
	if (name[strlen(name)-1] == '/') name[strlen(name)-1] = 0;
	printf(" Creating directory: %s ", name);
	stat = mkdir(name
#ifdef GNUDOS
	,0
#endif
	);
	if (stat && (errno==EACCES))
	{
	  printf(PROG_NAME ": warning - duplicate directory name\n");
	  stat=0;
	}

	if (stat) {
	  printf(PROG_NAME ": error - unable to create directory\n");
	  error++;
	  return -1;
		}
	return 0;
    }

int create_path(char *path){
	char create[128],pos;
	printf("- missing directory!\n Auto-creating directories for %s\n",path);
        for(pos=0;pos<=(strrchr(path,'/')-path);pos++){
          if(path[pos]=='/') { 
		create[pos]=0;
		createnewdir(create);
		create[pos]='/';
		printf("OK\n");
			   }
	  else create[pos]=path[pos];
        }
	printf(" Directories created, extracting %s ",path);
	return 0;
	}


int openfile(char oldname[],char name[]) {
      printf(" Extracting %s ",oldname);
      if(strcmp(oldname,name))printf("to %s ",name);
      outfile = open(name, O_WRONLY|O_BINARY|O_CREAT|O_EXCL, S_IWRITE|S_IREAD);
      if (outfile < 0 && errno==ENOENT) {
		create_path(name);
		outfile = open(name, O_WRONLY|O_BINARY|O_CREAT|O_EXCL, S_IWRITE|S_IREAD);
	      }
      if (outfile < 0 && errno==EEXIST){
	  printf(PROG_NAME ": file %s exists - overwrite",name);

      switch(ask()){
	  case 1:
		outfile=open(name, O_WRONLY|O_BINARY|O_TRUNC, S_IWRITE|S_IREAD);
		printf("\n Overwritig %s ",name);
		break;
	  case 2:
		printf("\nEnter new name:");
		gets(name);
		return(openfile(oldname,name)); /* Recursive retry */
	  default:
		printf("\n Skipping %s ",name);
		return 1;
	     }

	  }
	 if(outfile<0){
		printf(PROG_NAME ": error - can't create file, skipping %s ",dosname);
		error++;
		return 1;
	    }
	return 0;
	}


int untarstream(unsigned char data[], unsigned long datasize)
{
  unsigned long dsize=0;
  TARHEADER header;
  long perm, uid, gid, time, csum;
  struct time filetime;
  struct date filedate;

  datapos=0;
  for(;;){
   if(position==-1) {
do{
    memcpy( &header, data+datapos,512);
    if (header.name[0] == 0) break; 
    sscanf(header.operm, "%lo", &perm);
    sscanf(header.ouid, "%lo", &uid);
    sscanf(header.ogid, "%lo", &gid);
    sscanf(header.ocsum, "%lo", &csum);
    sscanf(header.osize, "%lo", &size);
    sscanf(header.otime, "%lo", &time);
#ifdef VERBOSE
    printf("otime= %s ocsum= %s ",header.otime,header.ocsum);
#endif
    datapos+=512;
    if(datapos>datasize) return 0;
}while(!istarheader((char*)&header,csum,1));
    if (header.name[0] == 0) break; 
    position=0;
    skip=0;
#ifdef _32BIT_VERSION_
    strcpy(dosname,header.name);
#else	
    dos_pathname(header.name,dosname);
#endif

/* Adjust the time so that is set correctly

   uuuh this is a dirty workaround for a bug which
   I couldn't fix otherwise.

   Can you do any better? */

#ifdef TIME_BUG_WORKAROUND

        #ifdef _OS2_VERSION_                            /* OS/2 Version */
                if(timezone==18000) time -= 10800;
                else time= time - 25200 + timezone;

        #elif defined (_32BIT_VERSION_)                           /* Win32 version */
           time = time - 28800 + timezone;
	#endif

        #ifndef _32BIT_VERSION_                         /* DOS version */
                if(timezone==18000) time -= 10800;
                else time= time - 25200 + timezone;
        #endif

#endif

    unixtodos(time,&filedate,&filetime);
    timedate.ft_tsec=filetime.ti_sec;
    timedate.ft_min=filetime.ti_min;
    timedate.ft_hour=filetime.ti_hour;
    timedate.ft_day=filedate.da_day;
    timedate.ft_month=filedate.da_mon;
    timedate.ft_year=filedate.da_year-1980;

    if (header.flags=='5'||header.name[strlen(header.name)-1]=='/')
    {
       if (header.name[strlen(header.name)-1] == '/')
	header.name[strlen(header.name)-1] = 0;
       createnewdir(dosname);
       skip=1; /* Directory ??? */
	}
    else if(match(header.name,filespec,ignore_case))
          { skip=openfile(header.name,dosname); }
	 else { skip=1; printf(" Omitting %s ",header.name); }
}

   if ((size-position) <= (datasize-datapos)){
	dsize = size-position;

       }

   else dsize = (datasize-datapos);
   if(!skip){
    if (write(outfile,data+datapos,dsize)<dsize){
	printf(PROG_NAME ": error - can't write file, disk full?");
	error++;
	c_break();
    }
   }
   position += dsize;
   datapos += dsize;
   if(size==position) {
	if(!skip){
		setftime(outfile,&timedate);
		close(outfile);
		}
	position=-1;
	if(datapos % 512) datapos=( (datapos / 512) + 1) * 512;
	printf("OK   \n");
       }
   if(datasize==datapos)
	 return 0;  /* Finished processing buffer */
       }
return 0;
}

int listtarstream(unsigned char data[],unsigned long datasize)
{
  unsigned int dsize=0;
  TARHEADER header;
  long perm, uid, gid, time, csum;
  struct time filetime;
  struct date filedate;
  datapos=0;
  for(;;){
   if(position==-1) {
do{
    memcpy( &header, data+datapos,512);
    if (header.name[0] == 0) break;
    sscanf(header.operm, "%lo", &perm);
    sscanf(header.ouid, "%lo", &uid);
    sscanf(header.ogid, "%lo", &gid);
    sscanf(header.ocsum, "%lo", &csum);
    sscanf(header.osize, "%lo", &size);
    sscanf(header.otime, "%lo", &time);
    datapos+=512;
    if(datapos>datasize) return 0;
}while(!istarheader((char*)&header,csum,1));
    if (header.name[0] == 0) break;
    position=0;
    skip=0;
    dos_pathname(header.name,dosname);

#ifdef TIME_BUG_WORKAROUND

        #ifdef _OS2_VERSION_                            /* OS/2 Version */
                if(timezone==18000) time -= 10800;
                else time= time - 25200 + timezone ;

        #elif defined(_32BIT_VERSION_)                           /* Win32 version */
           time = time - 28800 + timezone;
	#endif

        #ifndef _32BIT_VERSION_                         /* DOS version */
                if(timezone==18000) time -= 10800;
                else time= time - 25200 + timezone;
        #endif

#endif

    unixtodos(time,&filedate,&filetime);

    if (header.flags=='5'||header.name[strlen(header.name)-1]=='/')
    {
       if (header.name[strlen(header.name)-1] == '/')
	header.name[strlen(header.name)-1] = 0;
       printf(" <DIR>  %02i-%02i-%02i %02i:%02i %s\n",
      filedate.da_day,filedate.da_mon,filedate.da_year,
      filetime.ti_hour,filetime.ti_min,header.name);

    }


    else if(match(header.name,filespec,ignore_case))
	  {
       printf("%li	%02i-%02i %02i %02i:%02i %s ",
      size,filedate.da_day,filedate.da_mon,filedate.da_year,
      filetime.ti_hour,filetime.ti_min,header.name);

      if(strcmp(header.name,dosname))printf("[%s]",dosname);
	printf("\n");
	  }
    fprintf(stderr," Searching ...\r");
}

   if ((size-position) < (datasize-datapos)){
	dsize = size-position;
       }
   else dsize = (datasize-datapos);
   position += dsize;
   datapos += dsize;
   if(size==position) {
	position=-1;
	if(datapos % 512) datapos=( (datapos / 512) + 1) * 512;
       }
   if(datasize==datapos)
	 return 0;  /* Finished processing buffer */
       }
 return 0;
}


/*	Interface to INFLATE.C decompression routines / tar stream handler
	Copyright (c) 1996,97 Tillmann Steinbrecher */


/* #define DEBUG	*/

#ifndef PROG_NAME
	#define	PROG_NAME	"gzip-engine"
#endif


/* gzip header bit flag definitions */
#define IS_MULTI	2
#define IS_EXTRA	4
#define IS_FILENAME	8
#define	IS_COMMENT	16
#define IS_ENCRYPT	32

/* pkzip header bit flag definitions */

#define PK_IS_ENCRYPT 1
#define PK_IS_ENDHEADER 9
#define PK_IS_EXTENDED 8

UWORD mask_bits[] = {
    0x0000,
    0x0001, 0x0003, 0x0007, 0x000f, 0x001f, 0x003f, 0x007f, 0x00ff,
    0x01ff, 0x03ff, 0x07ff, 0x0fff, 0x1fff, 0x3fff, 0x7fff, 0xffff
};

int outcnt=0;
ULONG outsiz=0;
byte *outptr;
byte *outbuf;
FILE* in;
char headertype;

typedef struct{
	UWORD magic;
	byte method;
	byte flags;
	ULONG time;
	byte extra_flags;
	byte os;
}gzip_hdr;

typedef struct{
        unsigned long magic;
	unsigned char version;
	unsigned char os;
	unsigned int bitflag;
	unsigned int method;
	unsigned int modtime;
	unsigned int moddate;
	unsigned long crc32;
	unsigned long c_size;
	unsigned long u_size;
	unsigned int filename_size;
	unsigned int extra_field_length;
}pkzip_hdr;


typedef struct{
	ULONG crc32;
	ULONG size;
}gzip_end;

typedef struct{
	long magic;		/* NO magic number according to APPNOTE.TXT,
				   but to ensure compability with Tar, we add
				   it ... uuuh... */
        unsigned long crc32;
        unsigned long comp_size;
        unsigned long size;
}pkzip_end;



pkzip_hdr pk_header;
gzip_hdr gz_header;

int extract_tar(void){
	char* buffer;
	int cnt;
	if((buffer=malloc(UNC_OUTBUFSIZ))==0){
		printf(PROG_NAME": error - can't allocate memory");
		return -1;
		}
	while(!feof(in)){
		cnt=fread(buffer,1,UNC_OUTBUFSIZ,in);
		    switch(command){
			case CMD_EXTRACT:
			    untarstream(buffer,cnt);
			    break;
			case CMD_LIST:
			    listtarstream(buffer,cnt);
			    break;
			default:
			    printf(PROG_NAME ": internal error - nothing to do.\n");
			}
	  }
	return 0;
	}

int check_valid(void){
	gzip_end end_info;
	pkzip_end pk_end_info;
	ULONG new_crc32, storedcrc;
	new_crc32=updcrc(outbuf,0);
switch(headertype){
case HEADER_GZIP:
	if(fread(&end_info,1,sizeof(end_info),in)<sizeof(end_info)){
                fseek(in,(-8),SEEK_CUR);	 /* If we couldn't get it the first
						    time, then we'll seek back and try again */
                if(fread(&end_info,1,sizeof(end_info),in)<sizeof(end_info)){
                 printf(PROG_NAME ": error - can't read stored crc.\n");
                 }
		}
	storedcrc=end_info.crc32;
	break;
case HEADER_PKZIP:
	storedcrc=pk_header.crc32;
	break;
case HEADER_PKZIP_END:
        fread(&pk_end_info,sizeof(pk_end_info),1,in);
        storedcrc=pk_end_info.crc32;
	break;
default:
        printf(PROG_NAME ": internal error - cannot locate crc32\n");
        return -1;
}

/* printf("new crc32: %lx, stored crc32: %lx\n", new_crc32, storedcrc); */


  if(new_crc32!=storedcrc){
		printf(PROG_NAME ": warning - broken file(s), crc32 error!\n");
		return -1;
	       }
	else if(command==CMD_TEST) printf("\rArchive has valid crc32.\n");
	return 0;
 }

int read_tar_header(void){
	  TARHEADER unc_hdr;
	  long csum;
	  fread(&unc_hdr,512,1,in);
	  sscanf(unc_hdr.ocsum, "%lo", &csum);
	  if(istarheader((char*)&unc_hdr,csum,0)){
		fseek(in,0,SEEK_SET);
		printf("Archive is in uncompressed TAR format\n");
		return 0;
		}
	    else return 1;
	  }


int read_gzip_header(void){

	char orig_name[260]="";/* 260 bytes hopefully is enough for filename */
	char comments[4096];   /* 4096 bytes hopefully is enough for comments */
	char ch;
	struct time filetime;
	struct date filedate;

        fread(&gz_header,sizeof(gz_header),1,in);

         if(gz_header.magic!=0x8b1f) {
/*        printf(PROG_NAME ": warning - bad magic number (0x%x), not a gzip file.\n",gz_header.magic); */
	  return 1;
	 }

        headertype=HEADER_GZIP;

        if(gz_header.method!=8) {
		printf(PROG_NAME ": error - unknown compression (%i)\n",gz_header.method);
		return -1;
		}
	if(gz_header.flags & IS_MULTI) {
		fprintf(stderr, PROG_NAME ": error - multi-volume archives not supported\n");
		return -1;
		}
        if(gz_header.flags & IS_EXTRA){
		fprintf(stderr, PROG_NAME ": error - don't know how to handle extended gzip header.\n");
		return -1;
		}
        if(gz_header.flags & IS_FILENAME){
		fscanf(in,"%s",orig_name);
		if(getc(in)==EOF) {
			fprintf(stderr, PROG_NAME ": error - unexpected EOF\n");
			return -1;
		       }
		}
        if(gz_header.flags & IS_COMMENT){
		fscanf(in,"%s",comments);
		fprintf(stderr, "comments:\n%s",comments);
		if(getc(in)==EOF) {
			fprintf(stderr, PROG_NAME ": error - unexpected EOF\n");
			return -1;
		       }

		}
	if(gz_header.flags & IS_ENCRYPT){
		fprintf(stderr, PROG_NAME ": error - file is encrypted.\n");
		return -1;
		}

    #ifdef TIME_BUG_WORKAROUND

        #ifdef _OS2_VERSION_                            /* OS/2 Version */
                if(timezone!=18000) gz_header.time= gz_header.time - 18000 + timezone;

        #elif defined (_32BIT_VERSION_)                  /* Win32 version */
           gz_header.time = gz_header.time - 28800 + timezone;
	#endif

        #ifndef _32BIT_VERSION_                         /* DOS version */
              if(timezone!=18000) gz_header.time= gz_header.time - 18000 + timezone;
        #endif

   #endif

	unixtodos(gz_header.time,&filedate,&filetime);
	printf("Archive %s created %02i-%02i-%02i %02i:%02i on ",
	orig_name, filedate.da_day, filedate.da_mon,
	filedate.da_year, filetime.ti_hour, filetime.ti_min);

        switch(gz_header.os){
		case 0x00:
			printf("MS-DOS");
			break;
		case 0x01:
			printf("Amiga");
			break;
		case 0x02:
			printf("VAX/VMS");
			break;
		case 0x03:
			printf("UNIX");
			break;
		case 0x05:
			printf("Atari");
			break;
		case 0x06:
			printf("OS/2");
			break;
		case 0x07:
			printf("Macintosh");
			break;
		case 0x0a:
			printf("TOPS20");
			break;
		case 0x0b:
			printf("Windows NT");
			break;
		case 0x0f:
			printf("PRIMOS");
			break;
		default:
                        printf("unknown (0x%X)",gz_header.os);
		}
	printf(" platform\n");
	updcrc(NULL,0);	/* Initialize CRC engine */
	return 0;
}







int read_pkzip_header(void){

	char orig_name[260]="";/* 260 bytes hopefully is enough for filename */
	char extra_field[260]="";
	fread(&pk_header,sizeof(pk_header),1,in);

	if(pk_header.magic!=0x04034b50)  return 1;

	if(pk_header.bitflag & PK_IS_ENCRYPT){
		fprintf(stderr, PROG_NAME ": error - zip file is encrypted.\n");
		return -1;
		}

	if(pk_header.method!=8) {
		printf(PROG_NAME ": error - ");
		switch(pk_header.method){
			case 0:
			 printf("unstore");
			 break;
			case 1:
			 printf("unshrink");
			 break;
			case 2:
			case 3:
			case 4:
			case 5:
			 printf("unreduce");
			 break;
			case 6:
			 printf("exploding");
			 break;
			case 7:
			 printf("untokenizing");
			 break;
			default:
			 printf("zip compression type %i",pk_header.method);
			 break;
			 }
		printf(" not supported, use unzip to extract\n");
		return -1;
	       }

		fread(orig_name,pk_header.filename_size,1,in);
		fread(extra_field,pk_header.extra_field_length,1,in);

	printf("ZIP Archive containing %s created on ",	orig_name);

	switch(pk_header.os){
		case 0x00:
			printf("MS-DOS");
			break;
		case 0x01:
			printf("Amiga");
			break;
		case 0x02:
			printf("VAX/VMS");
			break;
		case 0x03:
			printf("UNIX");
			break;
		case 0x05:
			printf("Atari");
			break;
		case 0x06:
			printf("OS/2");
			break;
		case 0x07:
			printf("Macintosh");
			break;
		case 0x08:
			printf("Z-System");
			break;
		case 0x09:
			printf("CP/M");
			break;
		case 0x0a:
			printf("TOPS20");
			break;
		case 0x0b:
			printf("Windows NT");
			break;
		case 0x0f:
			printf("PRIMOS");
			break;
		default:
			printf("unknown (0x%X)",pk_header.os);
		}
	printf(" platform");

	if(pk_header.bitflag & PK_IS_ENDHEADER){
		printf(" (Tar-style)");
		headertype=HEADER_PKZIP_END;
		}
	else headertype=HEADER_PKZIP;
        printf("\n");

        if(pk_header.bitflag & PK_IS_EXTENDED){
                printf(PROG_NAME ": warning -  %u bytes extra field ignored\n",
                       pk_header.extra_field_length);
		headertype=HEADER_PKZIP_END;
		}


	updcrc(NULL,0);	/* Initialize CRC engine */
	return 0;
}






int ReadByte(UWORD *x){
	register int ch=getc(in);
	if(ch==EOF){ 
		error++;
		printf(PROG_NAME": error - unexpected end of file.");
		c_break();
	  }
	*x=(UWORD)ch;
	return 8;
	}

int FlushOutput(void){
 if (outcnt)
  {
/*  fwrite(outbuf,1,outcnt,stdout);
    printf(outbuf);exit(1); */
    updcrc(outbuf,outcnt);
    switch(command){
	case CMD_EXTRACT:
	    untarstream(outbuf,outcnt);
	    break;
	case CMD_LIST:
	    listtarstream(outbuf,outcnt);
	    break;
        case CMD_TEST:
            break;
	case CMD_UNPACK:
	    write(outfile,outbuf,outcnt);
	    break;
	default:
	    printf(PROG_NAME ": internal error - nothing to do.\n");
	}
    outsiz += outcnt;
    outptr = outbuf;
    outcnt = 0;
  }
  return 0;
	}



char aname[128];

void usage(void){
        printf("USAGE:  " EXE_NAME " <filename> <filespec> to extract from TGZ/TAR archive\n"
               "        " EXE_NAME " -l <filename> <filespec> to list/test TGZ/TAR archive\n"
	       "        " EXE_NAME " -t <filename> to test CRC of GZ/TGZ archive\n"
	       "        " EXE_NAME " -d <infile> <outfile> to decompress GZ archive\n"
	       "        " EXE_NAME " -y <switches> <files> to assume YES on all queries\n\n"	
               "        GZIP compressed, PKZIP compressed and uncompressed TAR\n"
	       "        archives are supported.\n\n"
	       "        This freeware program may be distributed according to\n"
	       "        the terms of the GNU general public license version 2.\n\n"
	       "        If you have any suggestions or encounter problems using\n"
               "        this program, please send a message to tst@bigfoot.com.\n"
               "        Your comments are highly appreciated.           Thanks.\n\n");
	      }

void print_list(void){
	printf("\nSize	Date  Year Time  Name [DOS Name]\n\
------- ----- ---- ----- ---------------------------------------------------\n");
}


int cdecl
main(int argc,char **argv){
	int i;
	int stat;
	printf("\n" LONG_NAME VERSION TEST_STATUS " version\n"
		"Copyright (c) 1996,97 Tillmann Steinbrecher. "BUILD_DATE"\n\n");

#ifndef _32BIT_VERSION_
	ctrlbrk(c_break);
#endif

	command=CMD_EXTRACT;
	if(argc<2){ usage(); return 1; }

	  for (i=1; i < argc; i++){
   if((argv[i][0]=='-'||argv[i][0]=='/'))
     {
      if(i+1==argc){printf(PROG_NAME ": error - missing filename");c_break();}
      if(argv[i][1]=='l'||argv[i][1]=='L') command=CMD_LIST;
      else if(argv[i][1]=='y'||argv[i][1]=='Y') { answer='a'; s_answer='a'; }
      else if(argv[i][1]=='t'||argv[i][1]=='T') command=CMD_TEST;
      else if(argv[i][1]=='d'||argv[i][1]=='G') {
                command=CMD_UNPACK;
                if(i+2==argc) {printf(PROG_NAME ": error - must specify output file");c_break();}
              }
      else {printf(PROG_NAME ": error - unknown command line option '%c'",argv[i][1]);c_break();}
 	 }
     else {
	if(i<argc-1){ strcpy(aname,argv[i]);
		      if(!strcmp(argv[i+1],".")){
			 printf(PROG_NAME ": error - '%s' is not a valid filespec.",argv[i+1]);
			 c_break();
			}
		      strcpy(filespec,argv[i+1]);
		      break;
		}
	else{	      strcpy(aname,argv[i]);
		      strcpy(filespec,"*");
		      break;
		}
	  }
    }

	if((in=fopen(aname,"rb"))==0){
		printf(PROG_NAME ": error - can't open %s.\n",aname);
		return 1;
		}

	stat=read_gzip_header();
	if(stat) {
		fseek(in,0,SEEK_SET);
		stat=read_pkzip_header();
		}

	      if(!stat){
                if((outbuf=(byte*)malloc(OUTBUFSIZ))==0){
                        printf(PROG_NAME": error - can't allocate memory for write buffer");
                        return -1;
                        }
                                                          
                outptr=outbuf;

                if(command==CMD_LIST) print_list();
		if(command==CMD_TEST) printf(" Testing %s ...\n",aname);
		if(command==CMD_UNPACK) {
			printf(" Decompression only:");
			openfile(aname,filespec);
		}
                if(inflate_entry()) printf(PROG_NAME ": decompression engine error - bad compressed data.\n");
		FlushOutput();
		check_valid();
                if(command==CMD_LIST) printf("------- ----- ---- ----- ---------------------------------------------------\n");
		return 0;
		}
	      if(stat==-1) return -1;

	fseek(in,0,SEEK_SET);
	stat=read_tar_header();

	if(!stat){
		if(command==CMD_LIST) print_list();
		if(command==CMD_TEST) {
			printf(PROG_NAME ": error - can't test uncompressed TAR archive");
			c_break();
			}
		if(command==CMD_UNPACK){
			printf(PROG_NAME ": error - already in uncompressed TAR format");
			c_break();
		       }
		extract_tar();
                if(command==CMD_LIST)
                        printf("------- ----- ---- ----- ---------------------------------------------------\n");
		 }
	else printf(PROG_NAME": error - not a supported archive type\n");


	return 0;
	}
