/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Statistic {
    public static int refreshFreq;
    public static int timeScale;
    public static String tv3url;
    public static boolean building;
    public static long timestamp;
    public static statItem items;
    public static ArrayList plainItemsList;
    public static int dataTime;
    public static int dataTimeDelta;
    public static long updated;
    public static int[] graphTimeAxis;
    public static int[] memGraphRatio;
    public static int graphTimeAxisLen;
    public static int graphTimeAxisPos;
    public static boolean needRebuild;
    private static Timer timer;
    private static StatusListener statusListener;

    public static void Init(String string, int n, int n2) {
        if (timer != null) {
            timer.cancel();
        }
        items = null;
        plainItemsList = new ArrayList();
        tv3url = string;
        refreshFreq = n;
        timeScale = n2;
        graphTimeAxisLen = n2 / n + 2;
        graphTimeAxis = new int[graphTimeAxisLen];
        memGraphRatio = new int[graphTimeAxisLen + 2];
        timer = new Timer();
        timer.schedule((TimerTask)new TimerUpdate(), 150L, (long)(n * 1000));
    }

    public static void Update() {
        Statistic.reqStat(false);
    }

    public static void setStatusListener(StatusListener statusListener) {
        Statistic.statusListener = statusListener;
    }

    public static boolean reqStat(boolean bl) {
        InputStream inputStream;
        URLConnection uRLConnection;
        String string = tv3url.endsWith("/") ? tv3url + "statistic" : tv3url + "/statistic";
        if (!bl) {
            string = string + "?compact=Y";
        }
        Statistic.sendStatus("read data...", 0);
        try {
            URL uRL = new URL(string);
            uRLConnection = uRL.openConnection();
            uRLConnection.setAllowUserInteraction(true);
            uRLConnection.setRequestProperty("Accept-Format", "no-spaces");
            inputStream = uRLConnection.getInputStream();
        }
        catch (MalformedURLException malformedURLException) {
            Statistic.sendStatus("invalid URL", 1);
            return false;
        }
        catch (IOException iOException) {
            Statistic.sendStatus("cannot open connection", 1);
            return false;
        }
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            building = bl;
            sAXParser.parse(inputStream, (DefaultHandler)new XMLEvents(items));
            building = false;
        }
        catch (SAXException sAXException) {
            if (needRebuild) {
                needRebuild = false;
                return Statistic.reqStat(true);
            }
            Statistic.sendStatus("SAXException", 1);
            return false;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Statistic.sendStatus("parse error", 1);
            return false;
        }
        catch (IOException iOException) {
            Statistic.sendStatus("input/output error", 1);
            return false;
        }
        if (needRebuild) {
            needRebuild = false;
            return Statistic.reqStat(true);
        }
        updated = uRLConnection.getDate();
        if (System.currentTimeMillis() - updated >= 3540000L) {
            updated += 3600000L;
        }
        int n = (int)(updated / 1000L);
        if (bl) {
            dataTimeDelta = 0;
        } else {
            if (n < dataTime) {
                return Statistic.reqStat(true);
            }
            dataTimeDelta = n - dataTime;
            Statistic.graphTimeAxis[Statistic.graphTimeAxisPos] = n;
        }
        dataTime = n;
        if (++graphTimeAxisPos == graphTimeAxisLen) {
            graphTimeAxisPos = 0;
        }
        Statistic.sendStatus("ready", bl ? 2 : 3);
        return true;
    }

    private static void sendStatus(final String string, final int n) {
        if (statusListener != null) {
            try {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        statusListener.displayStatus(string, n);
                    }
                });
            }
            catch (Exception exception) {
                System.err.println("-1-");
            }
        }
    }

    public static int calcGraphAxisTime(int[] nArray, int n) {
        int n2 = graphTimeAxisPos;
        if (--n2 < 0) {
            n2 = graphTimeAxisLen - 1;
        }
        int n3 = graphTimeAxis[n2];
        nArray[0] = n - 1;
        int n4 = 1;
        while (n4 < graphTimeAxisLen) {
            if (--n2 < 0) {
                n2 = graphTimeAxisLen - 1;
            }
            if (graphTimeAxis[n2] == 0) break;
            nArray[n4] = n - 1 - n * (n3 - graphTimeAxis[n2]) / timeScale;
            ++n4;
        }
        nArray[n4] = nArray[n4 - 1];
        nArray[n4 + 1] = nArray[0];
        return n4;
    }
}

