/*****************************************************************************
*
*                                     raw.c
*
*   from DKBTrace (c) 1990  David Buck
*
*  This module contains the code to read and write the default file format
*  generated by DKBTrace.  The format is as follows:
*
*
*  (header:)
*    wwww hhhh       - Width, Height (16 bits, LSB first)
*
*  (each scanline:)
*    llll            - Line number (16 bits, LSB first)
*    rr rr rr ...    - Red data for line (8 bits per pixel,
*                       left to right, 0-255 (255=bright, 0=dark))
*    gg gg gg ...    - Green data for line (8 bits per pixel,
*                       left to right, 0-255 (255=bright, 0=dark))
*    bb bb bb ...    - Blue data for line (8 bits per pixel,
*                       left to right, 0-255 (255=bright, 0=dark))
*
* This software is freely distributable. The source and/or object code may be
* copied or uploaded to communications services so long as this notice remains
* at the top of each file.  If any changes are made to the program, you must
* clearly indicate in the documentation and in the programs startup message
* who it was who made the changes. The documentation should also describe what
* those changes were. This software may not be included in whole or in
* part into any commercial package without the express written consent of the
* author.  It may, however, be included in other public domain or freely
* distributed software so long as the proper credit for the software is given.
*
* This software is provided as is without any guarantees or warranty. Although
* the author has attempted to find and correct any bugs in the software, he
* is not responsible for any damage caused by the use of the software.  The
* author is under no obligation to provide service, corrections, or upgrades
* to this package.
*
* Despite all the legal stuff above, if you do find bugs, I would like to hear
* about them.  Also, if you have any comments or questions, you may contact me
* at the following address:
*
*     David Buck
*     22C Sonnet Cres.
*     Nepean Ontario
*     Canada, K2H 8W7
*
*  I can also be reached on the following bulleton boards:
*
*     OMX              (613) 731-3419
*     Mystic           (613) 596-4249  or  (613) 596-4772
*
*  Fidonet:   1:163/109.9
*  Internet:  dbuck@ccs.carleton.ca
*  The "You Can Call Me RAY" BBS    (708) 358-5611
*
*  IBM Port by Aaron A. Collins. Aaron may be reached on the following BBS'es:
*
*     The "You Can Call Me RAY" BBS (708) 358-5611
*     The Information Exchange BBS  (708) 945-5575
*
*****************************************************************************/

#include "frame.h"
#include "dkbproto.h"

struct Raw_File_Handle_Struct {
   FILE_HANDLE root;
   FILE *Red_File, *Green_File, *Blue_File;
   char *Red_Buffer, *Green_Buffer, *Blue_Buffer;
   int line_number;
   };

typedef struct Raw_File_Handle_Struct RAW_FILE_HANDLE;

FILE_HANDLE *Get_Raw_File_Handle()
   {
   RAW_FILE_HANDLE *handle;

   if ((handle = (RAW_FILE_HANDLE *) malloc(sizeof(RAW_FILE_HANDLE))) == NULL) {
      PRINT ("Cannot allocate memory for output file handle\n");
      return(NULL);
      }

   handle->root.Default_File_Name_p = Default_Raw_File_Name;
   handle->root.Open_File_p = Open_Raw_File;
   handle->root.Write_Line_p = Write_Raw_Line;
   handle->root.Read_Line_p = Read_Raw_Line;
   handle->root.Close_File_p = Close_Raw_File;
   return ((FILE_HANDLE *) handle);
   }

char *Default_Raw_File_Name()
   {
   return ("data");
   }

int Open_Raw_File (handle, name, width, height, buffer_size, mode)
   FILE_HANDLE *handle;
   char *name;
   int *width;
   int *height;
   int buffer_size;
   int mode;
   {
   RAW_FILE_HANDLE *raw_handle;
   char file_name[256];

   handle->mode = mode;
   handle->filename = name;
   raw_handle = (RAW_FILE_HANDLE *) handle;
   raw_handle->line_number = 0;

   switch (mode) {
      case READ_MODE:
         strcpy (file_name, name);
         strcat (file_name, RED_RAW_FILE_EXTENSION);

         if ((raw_handle->Red_File = fopen (file_name, "rb")) == NULL)
            return(0);

         strcpy (file_name, name);
         strcat (file_name, GREEN_RAW_FILE_EXTENSION);

         if ((raw_handle->Green_File = fopen (file_name, "rb")) == NULL)
            return(0);

         strcpy (file_name, name);
         strcat (file_name, BLUE_RAW_FILE_EXTENSION);

         if ((raw_handle->Blue_File = fopen (file_name, "rb")) == NULL)
            return(0);

         if (buffer_size != 0) {
            if ((raw_handle->Red_Buffer = malloc (buffer_size)) == NULL)
               return(0);

            setvbuf (raw_handle->Red_File, raw_handle->Red_Buffer, _IOFBF, buffer_size);
            }

         if (buffer_size != 0) {
            if ((raw_handle->Green_Buffer = malloc (buffer_size)) == NULL)
               return(0);

            setvbuf (raw_handle->Green_File, raw_handle->Green_Buffer, _IOFBF, buffer_size);
            }

         if (buffer_size != 0) {
            if ((raw_handle->Blue_Buffer = malloc (buffer_size)) == NULL)
               return(0);

            setvbuf (raw_handle->Blue_File, raw_handle->Blue_Buffer, _IOFBF, buffer_size);
            }

         handle->width = *width;
         handle->height = *height;
         handle->buffer_size = buffer_size;
         break;

      case WRITE_MODE:
         strcpy (file_name, name);
         strcat (file_name, RED_RAW_FILE_EXTENSION);

         if ((raw_handle->Red_File = fopen (file_name, "wb")) == NULL)
            return(0);

         if (buffer_size != 0) {
            if ((raw_handle->Red_Buffer = malloc (buffer_size)) == NULL)
               return(0);

            setvbuf (raw_handle->Red_File, raw_handle->Red_Buffer, _IOFBF, buffer_size);
            }

         strcpy (file_name, name);
         strcat (file_name, GREEN_RAW_FILE_EXTENSION);

         if ((raw_handle->Green_File = fopen (file_name, "wb")) == NULL)
            return(0);

         if (buffer_size != 0) {
            if ((raw_handle->Green_Buffer = malloc (buffer_size)) == NULL)
               return(0);

            setvbuf (raw_handle->Green_File, raw_handle->Green_Buffer, _IOFBF, buffer_size);
            }

         strcpy (file_name, name);
         strcat (file_name, BLUE_RAW_FILE_EXTENSION);

         if ((raw_handle->Blue_File = fopen (file_name, "wb")) == NULL)
            return(0);

         if (buffer_size != 0) {
            if ((raw_handle->Blue_Buffer = malloc (buffer_size)) == NULL)
               return(0);

            setvbuf (raw_handle->Blue_File, raw_handle->Blue_Buffer, _IOFBF, buffer_size);
            }

         handle->width = *width;
         handle->height = *height;
         handle->buffer_size = buffer_size;

         break;

      case APPEND_MODE:
         strcpy (file_name, name);
         strcat (file_name, RED_RAW_FILE_EXTENSION);

         if ((raw_handle->Red_File = fopen (file_name, "ab")) == NULL)
            return(0);

         if (buffer_size != 0) {
            if ((raw_handle->Red_Buffer = malloc (buffer_size)) == NULL)
               return(0);

            setvbuf (raw_handle->Red_File, raw_handle->Red_Buffer, _IOFBF, buffer_size);
            }

         strcpy (file_name, name);
         strcat (file_name, GREEN_RAW_FILE_EXTENSION);

         if ((raw_handle->Green_File = fopen (file_name, "ab")) == NULL)
            return(0);

         if (buffer_size != 0) {
            if ((raw_handle->Green_Buffer = malloc (buffer_size)) == NULL)
               return(0);

            setvbuf (raw_handle->Green_File, raw_handle->Green_Buffer, _IOFBF, buffer_size);
            }

         strcpy (file_name, name);
         strcat (file_name, BLUE_RAW_FILE_EXTENSION);

         if ((raw_handle->Blue_File = fopen (file_name, "ab")) == NULL)
            return(0);

         if (buffer_size != 0) {
            if ((raw_handle->Blue_Buffer = malloc (buffer_size)) == NULL)
               return(0);

            setvbuf (raw_handle->Blue_File, raw_handle->Blue_Buffer, _IOFBF, buffer_size);
            }

         handle->width = *width;
         handle->height = *height;
         handle->buffer_size = buffer_size;

         break;
      }
   return(1);
   }

void Write_Raw_Line (handle, line_data, line_number)
   FILE_HANDLE *handle;
   COLOUR *line_data;
   int line_number;
   {
   register int x;
   RAW_FILE_HANDLE *raw_handle;
   char file_name[256];

   raw_handle = (RAW_FILE_HANDLE *) handle;

   for (x = 0 ; x < handle->width ; x++)
      putc((int) floor (line_data[x].Red * 255.0), raw_handle->Red_File);

   for (x = 0 ; x < handle->width ; x++)
      putc((int) floor (line_data[x].Green * 255.0), raw_handle->Green_File);

   for (x = 0 ; x < handle->width ; x++)
      putc((int) floor (line_data[x].Blue * 255.0), raw_handle->Blue_File);

   if (handle->buffer_size == 0) {
      fflush(raw_handle->Red_File);                       /* close and reopen file for */
      strcpy (file_name, handle->filename);
      strcat (file_name, RED_RAW_FILE_EXTENSION);
      raw_handle->Red_File = freopen(file_name, "ab",
                    raw_handle->Red_File);                /* integrity in case we crash*/

      fflush(raw_handle->Green_File);                       /* close and reopen file for */
      strcpy (file_name, handle->filename);
      strcat (file_name, GREEN_RAW_FILE_EXTENSION);
      raw_handle->Green_File = freopen(file_name, "ab",
                    raw_handle->Green_File);                /* integrity in case we crash*/

      fflush(raw_handle->Blue_File);                       /* close and reopen file for */
      strcpy (file_name, handle->filename);
      strcat (file_name, BLUE_RAW_FILE_EXTENSION);
      raw_handle->Blue_File = freopen(file_name, "ab",
                    raw_handle->Blue_File);                /* integrity in case we crash*/
      }
   }

int Read_Raw_Line (handle, line_data, line_number)
   FILE_HANDLE *handle;
   COLOUR *line_data;
   int *line_number;
   {
   int data, i;
   RAW_FILE_HANDLE *raw_handle;
   
   raw_handle = (RAW_FILE_HANDLE *) handle;

   for (i = 0 ; i < handle->width ; i++) {
      if ((data = getc(raw_handle->Red_File)) == EOF) {
         if (i == 0)
            return(0);
         else
            return(-1);
         }

      line_data[i].Red = (DBL) data / 255.0;
      }

   for (i = 0 ; i < handle->width ; i++) {
      if ((data = getc(raw_handle->Green_File)) == EOF)
         return(-1);

      line_data[i].Green = (DBL) data / 255.0;
      }

   for (i = 0 ; i < handle->width ; i++) {
      if ((data = getc(raw_handle->Blue_File)) == EOF)
         return(-1);

      line_data[i].Blue = (DBL) data / 255.0;
      }

   *line_number = raw_handle->line_number++;
   return (1);
   }

void Close_Raw_File (handle)
   FILE_HANDLE *handle;
   {
   RAW_FILE_HANDLE *raw_handle;

   raw_handle = (RAW_FILE_HANDLE *) handle;

   fclose (raw_handle->Red_File);
   fclose (raw_handle->Green_File);
   fclose (raw_handle->Blue_File);

   if (handle->buffer_size != 0) {
      free (raw_handle->Red_Buffer);
      free (raw_handle->Green_Buffer);
      free (raw_handle->Blue_Buffer);
      }
	free (handle);
   }

