/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.utils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Zipper {
    private ZipOutputStream zipFile;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String zipUp(String resultsFile, String suffix, Map<String, BufferedInputStream> extras, String folder, String folder2) throws IOException {
        String outputFile = resultsFile + suffix;
        try {
            block6: {
                this.zipFile = new ZipOutputStream(new FileOutputStream(outputFile));
                File results = new File(resultsFile);
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(results));
                this.addToZip(results.getName(), results.lastModified(), bis);
                if (extras != null) {
                    for (String fileName : extras.keySet()) {
                        this.addToZip(fileName, results.lastModified(), extras.get(fileName));
                    }
                }
                if (folder == null) break block6;
                File dir = new File(folder);
                this.traverse(dir.getName(), dir);
                if (folder2 == null) break block6;
                dir = new File(folder2);
                this.traverse(dir.getName(), dir);
            }
            Object var12_12 = null;
            if (this.zipFile == null) return outputFile;
            this.zipFile.flush();
            this.zipFile.close();
            this.zipFile = null;
            return outputFile;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (this.zipFile == null) throw throwable;
            this.zipFile.flush();
            this.zipFile.close();
            this.zipFile = null;
            throw throwable;
        }
    }

    private void traverse(String currDir, File dir) throws IOException {
        if (!"".equals(currDir)) {
            currDir = currDir + "/";
        }
        String[] fileArray = dir.list();
        for (int i = 0; i < fileArray.length; ++i) {
            File currFile = new File(dir.getPath() + File.separator + fileArray[i]);
            String relPath = currDir + currFile.getName();
            if (currFile.isDirectory()) {
                this.traverse(relPath, currFile);
                continue;
            }
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(currFile));
            this.addToZip(relPath, currFile.lastModified(), bis);
        }
    }

    private void addToZip(String relPath, long lastModified, BufferedInputStream bis) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int i;
            while ((i = bis.read()) != -1) {
                baos.write(i);
            }
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            bis.close();
            bis = null;
            throw throwable;
        }
        bis.close();
        bis = null;
        byte[] b = baos.toByteArray();
        int len = b.length;
        ZipEntry ze = new ZipEntry(relPath);
        ze.setSize(len);
        CRC32 crc = new CRC32();
        crc.update(b);
        ze.setCrc(crc.getValue());
        ze.setTime(lastModified);
        this.zipFile.putNextEntry(ze);
        this.zipFile.write(b, 0, len);
        this.zipFile.closeEntry();
    }
}

