/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.sgml;

import com.totalvalidator.exceptions.ValidationException;
import com.totalvalidator.sgml.Element;
import com.totalvalidator.validations.problem.ValidationProblem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagValidator {
    private static final String GREATER_THAN = "&gt;";
    private static final String LESS_THAN = "&lt;";
    private static final Character SPACE = Character.valueOf(' ');
    private static final String CDATA = "cdata";
    private Element e;
    private List<String> orderedList;
    private List<String> unorderedList;
    private int currentOrdered;
    private Map<String, Integer> elementsFound = new HashMap<String, Integer>();
    private String listItem;

    public TagValidator(Element e) {
        this.e = e;
        this.orderedList = e.getOrderedList();
        this.unorderedList = e.getUnorderedList();
        this.currentOrdered = 0;
    }

    public ValidationProblem checkOrderedItems(String testElement) throws ValidationException {
        if (this.orderedList.size() == 0) {
            return null;
        }
        String rule = this.e.getRule(testElement);
        if (rule == null && "#pcdata".equals(testElement)) {
            rule = this.e.getRule(CDATA);
        }
        if (rule == null) {
            return new ValidationProblem(null, null);
        }
        boolean foundIt = false;
        boolean listGroup = false;
        String candidate = null;
        int tmpOrdered = this.currentOrdered;
        while (tmpOrdered < this.orderedList.size() && !foundIt) {
            candidate = this.orderedList.get(tmpOrdered);
            if (candidate.startsWith("LIST_GROUP")) {
                if (this.listItem != null && this.e.getListGroup(candidate).contains(this.listItem)) {
                    if (this.listItem.equals(testElement)) {
                        foundIt = true;
                    } else if (this.required(this.listItem)) {
                        return new ValidationProblem("This tag or content is not allowed here. One of the following was expected: &lt;" + this.listItem + GREATER_THAN, ValidationProblem.INCORRECT_ELEMENT);
                    }
                } else if (this.e.getListGroup(candidate).contains(testElement)) {
                    boolean foundOne = false;
                    for (String candidateItem : this.e.getListGroup(candidate)) {
                        if (this.elementsFound.containsKey(candidate)) {
                            foundOne = true;
                        }
                        if (candidateItem.equals(testElement)) {
                            foundIt = true;
                            listGroup = true;
                            break;
                        }
                        if (!this.required(candidateItem)) continue;
                        if (!this.e.isOrList(candidate)) {
                            return new ValidationProblem("This tag or content is not allowed here. One of the following was expected: &lt;" + candidateItem + GREATER_THAN, ValidationProblem.INCORRECT_ELEMENT);
                        }
                        if (!foundOne) {
                            foundIt = true;
                            listGroup = true;
                            break;
                        }
                        return ValidationProblem.INCORRECT_ELEMENT2;
                    }
                }
            } else {
                if (candidate.equals(testElement)) {
                    foundIt = true;
                    break;
                }
                if (this.required(candidate)) {
                    return new ValidationProblem("This tag or content is not allowed here. One of the following was expected: &lt;" + candidate + GREATER_THAN, ValidationProblem.INCORRECT_ELEMENT);
                }
            }
            if (foundIt) continue;
            ++tmpOrdered;
        }
        if (!foundIt) {
            return ValidationProblem.INCORRECT_ELEMENT2;
        }
        if (listGroup && this.e.isOrList(candidate)) {
            this.listItem = testElement;
        }
        if (rule.equals("+")) {
            this.elementsFound.put(testElement, 1);
        } else if (rule.equals("") || rule.equals("?")) {
            int count = 0;
            Integer obj = this.elementsFound.get(testElement);
            if (obj != null) {
                count = obj;
            }
            if (count > 0 && !"#pcdata".equals(testElement)) {
                return ValidationProblem.ONLY_ONE_ALLOWED;
            }
            this.elementsFound.put(testElement, 1);
            if (listGroup) {
                if (this.listItem != null || testElement.equals(this.e.getListGroup(candidate).get(this.e.getListGroup(candidate).size() - 1))) {
                    ++tmpOrdered;
                }
            } else if ("".equals(rule)) {
                ++tmpOrdered;
            }
        }
        this.currentOrdered = tmpOrdered;
        return null;
    }

    public ValidationProblem inList(String testElement) {
        if (this.orderedList.size() > 0 || this.unorderedList.size() > 0) {
            return null;
        }
        String rule = this.e.getRule(testElement);
        if (rule == null && "#pcdata".equals(testElement)) {
            rule = this.e.getRule(CDATA);
        }
        if (rule == null) {
            return new ValidationProblem(null, null);
        }
        Map<String, List<String>> lists = this.e.getListGroups();
        boolean inListGroup = false;
        for (String groupName : lists.keySet()) {
            List<String> listGroup = this.e.getListGroup(groupName);
            if (!listGroup.contains(testElement)) continue;
            inListGroup = true;
            break;
        }
        if (this.listItem != null) {
            if (!this.listItem.startsWith("LIST_GROUP")) {
                if (!this.listItem.equals(testElement)) {
                    return new ValidationProblem("This tag or content is not allowed here. One of the following was expected: &lt;" + this.listItem + GREATER_THAN, ValidationProblem.INCORRECT_ELEMENT);
                }
            } else if (!inListGroup) {
                TreeSet<String> list = new TreeSet<String>();
                List<String> listGroup = this.e.getListGroup(this.listItem);
                if (listGroup != null) {
                    for (String item : listGroup) {
                        list.add(item);
                    }
                }
                if (!list.isEmpty()) {
                    return new ValidationProblem("This tag or content is not allowed here. One of the following was expected: " + this.makeResultsList(list), ValidationProblem.INCORRECT_ELEMENT);
                }
                return ValidationProblem.INCORRECT_ELEMENT2;
            }
        } else if (this.e.isOrList()) {
            this.listItem = inListGroup ? "LIST_GROUP" : testElement;
        }
        if (rule.equals("+")) {
            this.elementsFound.put(testElement, 1);
        } else if (rule.equals("") || rule.equals("?")) {
            int count = 0;
            Integer obj = this.elementsFound.get(testElement);
            if (obj != null) {
                count = obj;
            }
            if (count > 0 && !"#pcdata".equals(testElement)) {
                return ValidationProblem.ONLY_ONE_ALLOWED;
            }
            this.elementsFound.put(testElement, 1);
        }
        return null;
    }

    public ValidationProblem checkUnorderedItems(String testElement) {
        if (this.unorderedList.size() == 0) {
            return null;
        }
        String rule = this.e.getRule(testElement);
        if (rule == null && "#pcdata".equals(testElement)) {
            rule = this.e.getRule(CDATA);
        }
        if (rule == null) {
            return new ValidationProblem(null, null);
        }
        if (rule.equals("+")) {
            this.elementsFound.put(testElement, 1);
        } else if (rule.equals("") || rule.equals("?")) {
            int count = 0;
            Integer obj = this.elementsFound.get(testElement);
            if (obj != null) {
                count = obj;
            }
            if (count > 0 && !"#pcdata".equals(testElement)) {
                return ValidationProblem.ONLY_ONE_ALLOWED;
            }
            this.elementsFound.put(testElement, 1);
        }
        return null;
    }

    public ValidationProblem allowedTags() {
        TreeSet<String> list = new TreeSet<String>();
        for (String element : this.e.getRules().keySet()) {
            if (element.startsWith("LIST_GROUP")) {
                for (String item : this.e.getListGroup(element)) {
                    list.add(item);
                }
                continue;
            }
            String rule = this.e.getRule(element);
            if (rule.equals("+") || rule.equals("*")) {
                list.add(element);
                continue;
            }
            if (!rule.equals("") && !rule.equals("?")) continue;
            int count = 0;
            Integer obj = this.elementsFound.get(element);
            if (obj != null) {
                count = obj;
            }
            if (count != 0) continue;
            list.add(element);
        }
        if (!list.isEmpty()) {
            return new ValidationProblem("This tag or content is not allowed here. One of the following was expected: " + this.makeResultsList(list), ValidationProblem.INCORRECT_ELEMENT);
        }
        return ValidationProblem.INCORRECT_ELEMENT2;
    }

    public String finalise() {
        if (this.orderedList.size() > 0) {
            while (this.currentOrdered < this.orderedList.size()) {
                String candidate2 = this.orderedList.get(this.currentOrdered);
                if (candidate2.startsWith("LIST_GROUP")) {
                    if (this.listItem != null && this.e.getListGroup(candidate2).contains(this.listItem)) {
                        if (this.required(this.listItem)) {
                            return LESS_THAN + this.listItem + GREATER_THAN;
                        }
                    } else {
                        TreeSet<String> results = new TreeSet<String>();
                        for (String candidate2 : this.e.getListGroup(candidate2)) {
                            if (!this.required(candidate2)) continue;
                            results.add(candidate2);
                        }
                        if (!results.isEmpty()) {
                            return this.makeResultsList(results);
                        }
                    }
                } else if (this.required(candidate2)) {
                    return LESS_THAN + candidate2 + GREATER_THAN;
                }
                ++this.currentOrdered;
            }
            return null;
        }
        if (this.unorderedList.size() > 0) {
            for (int currentUnordered = 0; currentUnordered < this.unorderedList.size(); ++currentUnordered) {
                String candidate = this.unorderedList.get(currentUnordered);
                if (candidate.startsWith("LIST_GROUP") || !this.required(candidate)) continue;
                return LESS_THAN + candidate + GREATER_THAN;
            }
            return null;
        }
        if (this.e.isOrList()) {
            if (this.listItem != null) {
                if (!this.listItem.startsWith("LIST_GROUP") && this.required(this.listItem)) {
                    return LESS_THAN + this.listItem + GREATER_THAN;
                }
            } else {
                String candidate3 = null;
                TreeSet<String> results = new TreeSet<String>();
                for (String candidate3 : this.e.getRules().keySet()) {
                    if (!this.required(candidate3)) continue;
                    results.add(candidate3);
                }
                if (!results.isEmpty()) {
                    return this.makeResultsList(results);
                }
            }
        } else {
            String candidate4 = null;
            TreeSet<String> results = new TreeSet<String>();
            for (String candidate4 : this.e.getRules().keySet()) {
                if (!this.required(candidate4)) {
                    return null;
                }
                results.add(candidate4);
            }
            if (!results.isEmpty()) {
                return this.makeResultsList(results);
            }
        }
        return null;
    }

    private String makeResultsList(Set<String> elements) {
        StringBuilder results = new StringBuilder();
        for (String element : elements) {
            results.append(LESS_THAN).append(element).append(GREATER_THAN).append(SPACE);
        }
        return results.toString();
    }

    private boolean required(String candidate) {
        if (CDATA.equals(candidate) || "#pcdata".equals(candidate) || "EMPTY".equals(candidate)) {
            return false;
        }
        String rule = this.e.getRule(candidate);
        if (rule == null) {
            System.out.println("Null rule for " + candidate + " with element " + this.e.getName());
            return false;
        }
        if (rule.equals("+") || rule.equals("")) {
            return !this.elementsFound.containsKey(candidate);
        }
        return false;
    }

    public boolean excludes(String elementName) {
        return this.e.getExcludes().contains(elementName);
    }

    public boolean includes(String elementName) {
        return this.e.getIncludes().contains(elementName);
    }

    public boolean specialIncludes(String elementName) {
        return this.e.getSpecialIncludes().contains(elementName);
    }
}

