/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.reports;

import com.totalvalidator.exceptions.ValidationException;
import com.totalvalidator.parser.CommandLineParser;
import com.totalvalidator.reports.MainReportPage;
import com.totalvalidator.sgml.CData;
import com.totalvalidator.sgml.CSSPiece;
import com.totalvalidator.sgml.EntityEncoder;
import com.totalvalidator.sgml.Piece;
import com.totalvalidator.sgml.SupportedDTDs;
import com.totalvalidator.sgml.Tag;
import com.totalvalidator.snapshot.Snapshot;
import com.totalvalidator.utils.FileUtils;
import com.totalvalidator.utils.GeneralUtils;
import com.totalvalidator.validations.SpellingValidation;
import com.totalvalidator.validations.problem.CoreProblem;
import com.totalvalidator.validations.problem.CssError;
import com.totalvalidator.validations.problem.CssWarning;
import com.totalvalidator.validations.problem.HtmlError;
import com.totalvalidator.validations.problem.HtmlWarning;
import com.totalvalidator.validations.problem.LinkError;
import com.totalvalidator.validations.problem.LinkWarning;
import com.totalvalidator.validations.problem.ParsingError;
import com.totalvalidator.validations.problem.ParsingWarning;
import com.totalvalidator.validations.problem.Section508Problem;
import com.totalvalidator.validations.problem.SpellingWarning;
import com.totalvalidator.validations.problem.ValidationError;
import com.totalvalidator.validations.problem.ValidationProblem;
import com.totalvalidator.validations.problem.ValidationWarning;
import com.totalvalidator.validations.problem.wai.WaiA2Error;
import com.totalvalidator.validations.problem.wai.WaiA2Warning;
import com.totalvalidator.validations.problem.wai.WaiAA2Error;
import com.totalvalidator.validations.problem.wai.WaiAAA2Error;
import com.totalvalidator.validations.problem.wai.WaiAAAError;
import com.totalvalidator.validations.problem.wai.WaiAAError;
import com.totalvalidator.validations.problem.wai.WaiAAWarning;
import com.totalvalidator.validations.problem.wai.WaiAError;
import com.totalvalidator.validations.problem.wai.WaiAWarning;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagReport {
    private static final int WRAP_AMT = 110;
    private static final String PADDING = "     ";
    private static final String PADDING2 = "     ";
    private static final String UP_LINK = "<p><a href=\"#\"><img src=\"../images/up.gif\" alt=\"\"/> top</a></p>\n";
    private static final String PARENT_FOLDER = "../";
    private static final String SNAPSHOT_MARKER = "<!-- MARKER -->";
    private static final String SNAPSHOT_NAV_MARKER = "<!-- NAV MARKER -->";
    private static final String PARSING_ERROR_TITLE = "<h3>Parsing Errors</h3>\n";
    private static final String LINK_ERROR_TITLE = "<h3>Link Errors</h3>\n";
    private static final String HTML_ERROR_TITLE = "<h3>HTML Errors</h3>\n";
    private static final String WAI_A_ERROR_TITLE = "<h3>WCAG v1 A Errors</h3>\n";
    private static final String WAI_AA_ERROR_TITLE = "<h3>WCAG v1 AA Errors</h3>\n";
    private static final String WAI_AAA_ERROR_TITLE = "<h3>WCAG v1 AAA Errors</h3>\n";
    private static final String WAI_A2_ERROR_TITLE = "<h3>WCAG v2 A Errors</h3>\n";
    private static final String WAI_AA2_ERROR_TITLE = "<h3>WCAG v2 AA Errors</h3>\n";
    private static final String WAI_AAA2_ERROR_TITLE = "<h3>WCAG v2 AAA Errors</h3>\n";
    private static final String SECTION_508_ERROR_TITLE = "<h3>Section 508 Errors</h3>\n";
    private static final String PARSING_WARN_TITLE = "<h3>Parsing Warnings</h3>\n";
    private static final String LINK_WARN_TITLE = "<h3>Link Warnings</h3>\n";
    private static final String HTML_WARN_TITLE = "<h3>HTML Warnings</h3>\n";
    private static final String WAI_A_WARN_TITLE = "<h3>WCAG v1 A Warnings</h3>\n";
    private static final String WAI_AA_WARN_TITLE = "<h3>WCAG v1 AA Warnings</h3>\n";
    private static final String WAI_A2_WARN_TITLE = "<h3>WCAG v2 A Warnings</h3>\n";
    private static final String SECTION_508_WARN_TITLE = "<h3>Section 508 Warnings</h3>\n";
    private static final String SPELL_WARN_TITLE = "<h3>Spell Check Warnings</h3>\n";
    private static final String INPAGE_NAVIGATION = "\n<div class=\"pagenavbar\"><map id=\"pagenavbar\" title=\"Page Navigation Bar\"><p><a href=\"#summary\">Summary</a> | <a href=\"#layout\">Page Layout</a> ";
    private static final String MORE_INFO = "| <a href=\"#info\">More Information</a> ";
    private static final String REVALIDATE = "| <a href=\"#revalidate\">Revalidate</a> ";
    private static final String SCREENSHOT = "| <a href=\"#screenshots\">Screenshots</a> ";
    private static final String INPAGE_NAVIGATION_END = "</p></map></div>\n";
    private static final String NULL_IMAGE = "<span><img class=\"updown\" src=\"../images/null.gif\" alt=\"\"/></span>";
    private static final String WARNINGS = " warning(s)";
    private static final String ERRORS = " error(s)";
    private static final String NO_PROBLEMS = "<p><span class=\"success\"><img src=\"../images/ln_validated.gif\" alt=\"Success: No problems found\"/></span></p>\n";
    private static final String SUCCESS = "<span class=\"success\"><img src=\"images/sn_validated.gif\" alt=\"Success: No problems found\"/></span>";
    private static final String AND = " and ";
    private static final Pattern SPAN_PATTERN = Pattern.compile("<span>");
    private static final String COMMA = ", ";
    private int errorTotal = 0;
    private int parsingErrorTotal = 0;
    private int htmlErrorTotal = 0;
    private int waiAErrorTotal = 0;
    private int waiAAErrorTotal = 0;
    private int waiAAAErrorTotal = 0;
    private int waiA2ErrorTotal = 0;
    private int waiAA2ErrorTotal = 0;
    private int waiAAA2ErrorTotal = 0;
    private int section508ErrorTotal = 0;
    private int linkErrorTotal = 0;
    private int cssErrorTotal = 0;
    private int warningsTotal = 0;
    private int parsingWarnTotal = 0;
    private int htmlWarnTotal = 0;
    private int waiAWarnTotal = 0;
    private int waiA2WarnTotal = 0;
    private int section508WarnTotal = 0;
    private int waiAAWarnTotal = 0;
    private int linkWarnTotal = 0;
    private int cssWarnTotal = 0;
    private int spellWarnTotal = 0;
    private int problemNumber = 1;
    private List<String> listOfProblems = new ArrayList<String>();
    private String formatted;
    private File saveFile;

    public String format(List<Piece> pieces, String page, MainReportPage mainReportPage, CommandLineParser cl, int linksTested, List<String> options, String revalidateOptions, EntityEncoder ee, String docType, boolean servlet, boolean online, boolean isXml) throws ValidationException {
        boolean section508 = cl.isUS508();
        if (this.somethingToDo(pieces) || cl.isShowSuccess()) {
            StringBuilder output = new StringBuilder();
            output.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en-GB\" lang=\"en-GB\">\n<head>\n\t<meta http-equiv=\"content-type\" content=\"application/xhtml+xml; charset=UTF-8\" />\n\t<link rel=\"shortcut icon\" href=\"http://www.totalvalidator.com/favicon.ico\" type=\"image/x-icon\" />\n\t<title>Total Validator Results</title>\n\t<meta name=\"author\" content=\"Total Validator\" />\n\t<link rel=\"stylesheet\" href=\"");
            output.append(PARENT_FOLDER);
            if (servlet) {
                output.append("images/mainstyle.css\" />\n</head>\n<body>\n<div class=\"main\">\n<div class=\"pagehead\">\n<h1><img src=\"");
                output.append(PARENT_FOLDER);
                output.append("images/tvheader2.gif\" alt=\"Total Validator\"/><br/>HTML / XHTML / WCAG / Section 508 / Links / Spelling</h1></div><div class=\"topnavbar\"><map id=\"navbar\" title=\"Navigation Bar\"><p><a href=\"http://www.totalvalidator.com/index.html\">Home</a> | <a href=\"http://www.totalvalidator.com/tools/index.html\">Tools</a> | <a href=\"http://www.totalvalidator.com/downloads/index.html\">Downloads</a> | <a href=\"http://www.totalvalidator.com/purchases/index.html\">Purchases</a> | <a href=\"http://www.totalvalidator.com/support/index.html\">Support</a> | <a href=\"http://www.totalvalidator.com/home/sitemap.html\">Site Map</a></p></map></div>");
            } else {
                output.append("images/mainstyle.css\" />\n</head>\n<body>\n<div class=\"main\">\n<div class=\"pagehead\">\n<h1><img src=\"");
                output.append(PARENT_FOLDER);
                output.append("images/tvheader2.gif\" alt=\"Total Validator\"/><br/>HTML / XHTML / WCAG / Section 508 / Links / Spelling</h1></div><div class=\"topnavbar\"><map id=\"navbar\" title=\"Navigation Bar\"><p><a href=\"");
                if (cl.isExtension()) {
                    output.append("http://www.totalvalidator.com/support/extension.html\">Help</a> | <a href=\"http://www.totalvalidator.com/index.html\">Website</a> | <a href=\"http://www.totalvalidator.com/validator/FeedbackForm\">Feedback</a></p></map></div>");
                } else {
                    try {
                        output.append(FileUtils.getAbsoluteInstallFolder().toURI().toURL());
                    }
                    catch (MalformedURLException e) {
                        // empty catch block
                    }
                    output.append("help/help.html\">Help</a> | <a href=\"http://www.totalvalidator.com/index.html\">Website</a> | <a href=\"http://www.totalvalidator.com/validator/FeedbackForm\">Feedback</a></p></map></div>");
                }
            }
            int headerLength = output.length();
            boolean moreInfo = this.formatPieces(output, pieces, cl, ee, !cl.isShortReport(), section508, cl.isWCAG2());
            this.addSummary(mainReportPage, output, headerLength, mainReportPage.getSummaryPage(), page, linksTested, options, docType, section508, online, cl.isScreenshotsTaken(), isXml);
            output.insert(headerLength, INPAGE_NAVIGATION_END);
            output.insert(headerLength, "\n<!-- NAV MARKER -->\n");
            if (revalidateOptions != null) {
                output.insert(headerLength, REVALIDATE);
            }
            if (moreInfo) {
                output.insert(headerLength, MORE_INFO);
            }
            output.insert(headerLength, INPAGE_NAVIGATION);
            if (this.errorTotal + this.warningsTotal > 0) {
                output.append(UP_LINK);
                if (revalidateOptions != null) {
                    this.addRevalidate(output, revalidateOptions, page, cl.getIgnoreMessages());
                }
            }
            output.append(SNAPSHOT_MARKER).append("\n");
            output.append("<div class=\"footer\">\n<p class=\"footer\">Copyright 2011 Total Validator.\nAll rights reserved.</p>\n</div>\n</div>\n</body>\n</html>");
            this.formatted = output.toString();
        }
        this.updateMainReport(page, mainReportPage, section508);
        return this.formatted;
    }

    private void updateMainReport(String page, MainReportPage mainReportPage, boolean section508) {
        StringBuilder summary = new StringBuilder();
        if (this.errorTotal != 0) {
            summary.append(this.buildTotalErrorsString(true, section508));
            if (this.warningsTotal != 0) {
                summary.append(AND).append(this.buildTotalWarningsString(true, section508));
            }
        } else if (this.warningsTotal != 0) {
            summary.append(this.buildTotalWarningsString(true, section508));
        } else {
            summary.append(SUCCESS);
        }
        mainReportPage.setPageDetails(page, summary.toString());
    }

    private void addRevalidate(StringBuilder output, String revalidateOptions, String page, List<String> ignoreMessages) {
        output.append("<h2><a id=\"revalidate\" name=\"revalidate\"></a>Revalidate</h2>\n<p>In order to clarify the above report you can suppress some of the validation ");
        output.append("checks by amending the list below and then clicking the Revalidate button to revalidate this page.</p>\n");
        output.append("<form method=\"post\" action=\"").append(revalidateOptions).append("&amp;revalidateurl=").append(page).append("\">\n");
        output.append("<label title=\"Ignore errors/warnings\" for=\"errors\">Ignore Errors/Warnings:</label>\n");
        this.listOfProblems.addAll(ignoreMessages);
        Collections.sort(this.listOfProblems);
        output.append("<input id=\"errors\" name=\"errors\" value=\"");
        Iterator<String> iter = this.listOfProblems.iterator();
        while (iter.hasNext()) {
            output.append(iter.next());
            if (!iter.hasNext()) continue;
            output.append(",");
        }
        output.append("\" />\n");
        output.append("<input value=\"Revalidate\" name=\"submitForm\" type=\"submit\" />\n");
        output.append("</form>\n");
        output.append("<p>Note that if you do not amend the above list then no problems will be found when you revalidate. ");
        output.append("Also note that screenshots are not retaken when you revalidate.</p>\n");
        output.append(UP_LINK);
    }

    private void addSummary(MainReportPage mainReportPage, StringBuilder output, int headerLength, String summary, String page, int linksTested, List<String> options, String docType, boolean section508, boolean online, boolean screenshotsTaken, boolean isXml) {
        if (docType != null) {
            docType = SupportedDTDs.getDTDNameFromDocType(docType, isXml);
        }
        String totalErrorsMessage = this.buildTotalErrorsString(false, section508);
        String totalWarningsMessage = this.buildTotalWarningsString(false, section508);
        output.insert(headerLength, "</span></p>\n");
        if (this.errorTotal + this.warningsTotal > 0) {
            output.insert(headerLength, "<a href=\"#p1\"><img src=\"../images/down.gif\" alt=\"\"/> Go to first problem</a>");
        }
        if (online) {
            output.insert(headerLength, "<p><span class=\"strong\"><a id=\"p0\" name=\"p0\"></a><a id=\"p" + this.problemNumber + "\" name=\"p" + this.problemNumber + "\"></a>");
            if (this.errorTotal + this.warningsTotal == 0) {
                output.insert(headerLength, NO_PROBLEMS);
            }
            output.insert(headerLength, mainReportPage.getSummary(linksTested, 0, totalErrorsMessage, this.warningsTotal, totalWarningsMessage, options, docType));
        } else {
            output.insert(headerLength, "<p><span class=\"strong\">");
            output.insert(headerLength, "<a href=\"" + summary + "\"><img src=\"../images/left.gif\" alt=\"\"/> Back to website summary</a></span></p>\n");
            output.insert(headerLength, "<p><span class=\"strong\"><a id=\"p0\" name=\"p0\"></a><a id=\"p" + this.problemNumber + "\" name=\"p" + this.problemNumber + "\"></a>");
            if (screenshotsTaken) {
                output.insert(headerLength, "<p><span class='error'>NOTE: Screenshots will appear in another tab/window, or be sent as an email attachment</span></p>\n");
            }
            if (this.errorTotal + this.warningsTotal == 0) {
                output.insert(headerLength, NO_PROBLEMS);
            }
            output.insert(headerLength, "<tr><td class=\"nowrapl\"></td></tr></table>\n");
            if (docType != null) {
                output.insert(headerLength, "<tr><td class=\"nowrapl\">(X)HTML used for this page:</td><td class=\"rhs\">" + docType + "</td></tr>\n");
            }
            if (this.warningsTotal != 0) {
                output.insert(headerLength, "<tr><td class=\"nowrapl\">Total warnings found:</td><td class=\"rhs\">" + totalWarningsMessage + "</td></tr>\n");
            }
            output.insert(headerLength, "<tr><td class=\"nowrapl\">Total errors found:</td><td class=\"rhs\">" + totalErrorsMessage + "</td></tr>\n");
            output.insert(headerLength, "</td></tr>\n");
            String pageLink = "Uploaded Page".equals(page) ? page : "<a href=\"" + page + "\">" + page + "</a>";
            output.insert(headerLength, pageLink);
            output.insert(headerLength, "<tr><td class=\"nowrapl\">Page checked:</td><td class=\"rhs\">");
            output.insert(headerLength, "<table summary=\"Summary of tests\">");
        }
        output.insert(headerLength, "<h2><a id=\"summary\" name=\"summary\"></a>Summary</h2>\n");
    }

    private String buildTotalWarningsString(boolean summaryPage, boolean section508) {
        StringBuilder totalWarningsMessage = new StringBuilder();
        totalWarningsMessage.append(this.warningsTotal);
        if (summaryPage) {
            totalWarningsMessage.append(WARNINGS);
        }
        if (this.warningsTotal > 0) {
            String sep;
            String string = sep = summaryPage ? ": " : " (";
            if (this.parsingWarnTotal > 0) {
                totalWarningsMessage.append(sep).append("Parsing: ").append(this.parsingWarnTotal);
                sep = COMMA;
            }
            if (this.htmlWarnTotal > 0) {
                totalWarningsMessage.append(sep).append("HTML: ").append(this.htmlWarnTotal);
                sep = COMMA;
            }
            if (this.cssWarnTotal > 0) {
                totalWarningsMessage.append(sep).append("CSS: ").append(this.cssWarnTotal);
                sep = COMMA;
            }
            if (section508) {
                if (this.section508WarnTotal > 0) {
                    totalWarningsMessage.append(sep).append("Section 508: ").append(this.section508WarnTotal);
                    sep = COMMA;
                }
            } else {
                if (this.waiAWarnTotal > 0) {
                    totalWarningsMessage.append(sep).append("WGAG v1 A: ").append(this.waiAWarnTotal);
                    sep = COMMA;
                }
                if (this.waiAAWarnTotal > 0) {
                    totalWarningsMessage.append(sep).append("WCAG v1 AA: ").append(this.waiAAWarnTotal);
                    sep = COMMA;
                }
                if (this.waiA2WarnTotal > 0) {
                    totalWarningsMessage.append(sep).append("WCAG v2 A: ").append(this.waiA2WarnTotal);
                    sep = COMMA;
                }
            }
            if (this.linkWarnTotal > 0) {
                totalWarningsMessage.append(sep).append("Link Warnings: ").append(this.linkWarnTotal);
                sep = COMMA;
            }
            if (this.spellWarnTotal > 0) {
                totalWarningsMessage.append(sep).append("Spell Check: ").append(this.spellWarnTotal);
            }
            if (!summaryPage) {
                totalWarningsMessage.append(")");
            }
        }
        return totalWarningsMessage.toString();
    }

    private String buildTotalErrorsString(boolean summaryPage, boolean section508) {
        StringBuilder totalErrorsMessage = new StringBuilder();
        totalErrorsMessage.append(this.errorTotal);
        if (summaryPage) {
            totalErrorsMessage.append(ERRORS);
        }
        if (this.errorTotal > 0) {
            String sep;
            String string = sep = summaryPage ? ": " : " (";
            if (this.parsingErrorTotal > 0) {
                totalErrorsMessage.append(sep).append("Parsing: ").append(this.parsingErrorTotal);
                sep = COMMA;
            }
            if (this.htmlErrorTotal > 0) {
                totalErrorsMessage.append(sep).append("HTML: ").append(this.htmlErrorTotal);
                sep = COMMA;
            }
            if (this.cssErrorTotal > 0) {
                totalErrorsMessage.append(sep).append("CSS: ").append(this.cssErrorTotal);
                sep = COMMA;
            }
            if (section508) {
                if (this.section508ErrorTotal > 0) {
                    totalErrorsMessage.append(sep).append("Section 508: ").append(this.section508ErrorTotal);
                    sep = COMMA;
                }
            } else {
                if (this.waiAErrorTotal > 0) {
                    totalErrorsMessage.append(sep).append("WCAG v1 A: ").append(this.waiAErrorTotal);
                    sep = COMMA;
                }
                if (this.waiAAErrorTotal > 0) {
                    totalErrorsMessage.append(sep).append("WCAG v1 AA: ").append(this.waiAAErrorTotal);
                    sep = COMMA;
                }
                if (this.waiAAAErrorTotal > 0) {
                    totalErrorsMessage.append(sep).append("WCAG v1 AAA: ").append(this.waiAAAErrorTotal);
                    sep = COMMA;
                }
                if (this.waiA2ErrorTotal > 0) {
                    totalErrorsMessage.append(sep).append("WCAG v2 A: ").append(this.waiA2ErrorTotal);
                    sep = COMMA;
                }
                if (this.waiAA2ErrorTotal > 0) {
                    totalErrorsMessage.append(sep).append("WCAG v2 AA: ").append(this.waiAA2ErrorTotal);
                    sep = COMMA;
                }
                if (this.waiAAA2ErrorTotal > 0) {
                    totalErrorsMessage.append(sep).append("WCAG v2 AAA: ").append(this.waiAAA2ErrorTotal);
                    sep = COMMA;
                }
            }
            if (this.linkErrorTotal > 0) {
                totalErrorsMessage.append(sep).append("Link Errors: ").append(this.linkErrorTotal);
            }
            if (!summaryPage) {
                totalErrorsMessage.append(")");
            }
        }
        return totalErrorsMessage.toString();
    }

    private boolean somethingToDo(List<Piece> pieces) {
        for (Piece piece : pieces) {
            if (piece.getErrorCount() <= 0 && piece.getWarningCount() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean formatPieces(StringBuilder output, List<Piece> pieces, CommandLineParser cl, EntityEncoder ee, boolean longReport, boolean section508, boolean wcag2) throws ValidationException {
        output.append("<h2><a id=\"layout\" name=\"layout\"></a>Page Layout</h2><p>\n");
        output.append("The line numbers refer to lines in the original source.<br/>Any with a line number of '0' are implicit tags added by Total Validator:</p>\n");
        TreeMap<String, CoreProblem> problems = new TreeMap<String, CoreProblem>();
        HashMap<String, Integer> problemCount = new HashMap<String, Integer>();
        if (pieces.size() == 0) {
            output.append("<span class=\"strong\">Nothing to process</span>");
        } else {
            output.append("<pre>\n");
            int indentLevel = 0;
            for (Piece piece : pieces) {
                GeneralUtils.LOGGER.fine(piece.toString());
                int errorCount = piece.getErrorCount();
                this.errorTotal += errorCount;
                int warningCount = piece.getWarningCount();
                this.warningsTotal += warningCount;
                if (errorCount == 0 && warningCount == 0 && !GeneralUtils.LOGGER.isLoggable(Level.FINE) && piece.isVirtual()) {
                    if (!(piece instanceof Tag) || !longReport || !piece.isEndTag() || !piece.hasMatchingTag() || piece.getMatchingTag().isVirtual() || --indentLevel >= 0) continue;
                    indentLevel = 0;
                    continue;
                }
                if (!cl.isShowContent() && !(piece instanceof Tag) && errorCount == 0 && warningCount == 0) continue;
                boolean endTag = piece.isEndTag();
                boolean matchingTag = piece.hasMatchingTag();
                if (longReport && endTag && matchingTag && --indentLevel < 0) {
                    indentLevel = 0;
                }
                if (errorCount > 0 || warningCount > 0) {
                    output.append(this.formatNumber(piece.getLineNumber()));
                    ValidationProblem[] messages = piece.getMessages();
                    boolean firstError = true;
                    for (int j = 0; j < messages.length; ++j) {
                        if (firstError) {
                            firstError = false;
                            output.append("<a id=\"p").append(this.problemNumber).append("\" name=\"p").append(this.problemNumber++).append("\"></a><a href=\"#p").append(this.problemNumber).append("\"><img class=\"updown\" src=\"../images/down.gif\" alt=\"next problem\"/></a>");
                            output.append("<a href=\"#p").append(this.problemNumber - 2).append("\"><img class=\"updown\" src=\"../images/up.gif\" alt=\"previous problem\"/></a>");
                        } else {
                            output.append("     ");
                            output.append(NULL_IMAGE);
                            output.append(NULL_IMAGE);
                        }
                        output.append("<span class=\"strong\">");
                        CoreProblem coreProblem = messages[j].getCoreProblem();
                        String problem = coreProblem.getProblemNumber();
                        if (!this.listOfProblems.contains(problem)) {
                            this.listOfProblems.add(problem);
                        }
                        String probNumber = coreProblem.getProblemNumber();
                        if (coreProblem.hasLongMessage()) {
                            if (!problems.containsKey(probNumber)) {
                                problems.put(probNumber, coreProblem);
                                problemCount.put(probNumber, 1);
                            } else {
                                problemCount.put(probNumber, (Integer)problemCount.get(probNumber) + 1);
                            }
                            if (coreProblem instanceof ParsingError) {
                                ++this.parsingErrorTotal;
                            } else if (coreProblem instanceof CssError) {
                                ++this.cssErrorTotal;
                            } else if (coreProblem instanceof LinkError) {
                                ++this.linkErrorTotal;
                            } else if (coreProblem instanceof HtmlError) {
                                ++this.htmlErrorTotal;
                            } else if (coreProblem instanceof WaiAError) {
                                ++this.waiAErrorTotal;
                                if (coreProblem instanceof Section508Problem) {
                                    ++this.section508ErrorTotal;
                                }
                            } else if (coreProblem instanceof WaiA2Error) {
                                ++this.waiA2ErrorTotal;
                            } else if (coreProblem instanceof WaiAAError) {
                                ++this.waiAAErrorTotal;
                                if (coreProblem instanceof Section508Problem) {
                                    ++this.section508ErrorTotal;
                                }
                            } else if (coreProblem instanceof WaiAA2Error) {
                                ++this.waiAA2ErrorTotal;
                            } else if (coreProblem instanceof WaiAAAError) {
                                ++this.waiAAAErrorTotal;
                            } else if (coreProblem instanceof WaiAAA2Error) {
                                ++this.waiAAA2ErrorTotal;
                            } else if (coreProblem instanceof ParsingWarning) {
                                ++this.parsingWarnTotal;
                            } else if (coreProblem instanceof CssWarning) {
                                ++this.cssWarnTotal;
                            } else if (coreProblem instanceof LinkWarning) {
                                ++this.linkWarnTotal;
                            } else if (coreProblem instanceof HtmlWarning) {
                                ++this.htmlWarnTotal;
                            } else if (coreProblem instanceof WaiAWarning) {
                                ++this.waiAWarnTotal;
                                if (coreProblem instanceof Section508Problem) {
                                    ++this.section508WarnTotal;
                                }
                            } else if (coreProblem instanceof WaiAAWarning) {
                                ++this.waiAAWarnTotal;
                            } else if (coreProblem instanceof WaiA2Warning) {
                                ++this.waiA2WarnTotal;
                            } else if (coreProblem instanceof SpellingWarning) {
                                ++this.spellWarnTotal;
                            } else {
                                GeneralUtils.LOGGER.info(problem + " not assigned to count");
                            }
                            output.append("<a href=\"#").append(problem).append("\">").append(problem).append("</a>");
                        } else {
                            output.append(problem);
                            if (problem.charAt(0) == 'E') {
                                ++this.linkErrorTotal;
                            } else {
                                ++this.linkWarnTotal;
                            }
                        }
                        output.append(" ");
                        output.append(this.wrapLines(messages[j].getShortMessage(), "", "          ", 110 - "     ".length(), false)).append("</span>\n");
                    }
                    String indent = this.indent(indentLevel);
                    if (piece instanceof Tag || piece instanceof CData) {
                        indent = indent + "     ";
                        int malformed = piece.getMalformed();
                        boolean addStartTag = malformed != 3 && malformed != 5;
                        output.append(this.wrapLines(SpellingValidation.format(ee.encode(piece.getMarkedText())), indent, indent, 110, addStartTag));
                        output.append(malformed == 2 || malformed == 4 ? "\n" : "&gt;\n");
                    } else if (piece instanceof CSSPiece) {
                        indent = indent + "     ";
                        output.append(this.wrapLines(ee.encode(piece.getMarkedText()), indent, indent, 109, false)).append("\n");
                    } else {
                        indent = "      ";
                        output.append(this.wrapLines(SpellingValidation.format(ee.encode(piece.getMarkedText())), indent, indent, 109, false)).append("\n");
                    }
                    if (!longReport) {
                        output.append('\n');
                    }
                } else if (longReport) {
                    output.append(this.formatNumber(piece.getLineNumber()));
                    String indent = this.indent(indentLevel);
                    if (piece instanceof Tag || piece instanceof CData) {
                        output.append(this.wrapLines(ee.encode(piece.getText()), indent, indent + "     ", 110 - indent.length(), true)).append("&gt;\n");
                    } else {
                        output.append(this.wrapLines(ee.encode(piece.getText()), indent, indent + "     ", 110 - indent.length(), false)).append("\n");
                    }
                }
                if (!longReport || endTag || !matchingTag) continue;
                ++indentLevel;
            }
            if (!problems.isEmpty()) {
                output.append("</pre>\n");
                output.append(UP_LINK);
                output.append("<h2><a id=\"info\" name=\"info\"></a>More Information</h2>\n");
                String title = "";
                for (String probNumber : problems.keySet()) {
                    CoreProblem coreProblem = (CoreProblem)problems.get(probNumber);
                    if (coreProblem instanceof ParsingError && !PARSING_ERROR_TITLE.equals(title)) {
                        title = PARSING_ERROR_TITLE;
                        output.append(title);
                    } else if (coreProblem instanceof LinkError && !LINK_ERROR_TITLE.equals(title)) {
                        title = LINK_ERROR_TITLE;
                        output.append(title);
                    } else if (coreProblem instanceof HtmlError && !HTML_ERROR_TITLE.equals(title)) {
                        title = HTML_ERROR_TITLE;
                        output.append(title);
                    }
                    if (section508) {
                        if (coreProblem instanceof Section508Problem && coreProblem instanceof ValidationError && !SECTION_508_ERROR_TITLE.equals(title)) {
                            title = SECTION_508_ERROR_TITLE;
                            output.append(title);
                        }
                    } else if (wcag2) {
                        if (coreProblem instanceof WaiA2Error && !WAI_A2_ERROR_TITLE.equals(title)) {
                            title = WAI_A2_ERROR_TITLE;
                            output.append(title);
                        } else if (coreProblem instanceof WaiAA2Error && !WAI_AA2_ERROR_TITLE.equals(title)) {
                            title = WAI_AA2_ERROR_TITLE;
                            output.append(title);
                        } else if (coreProblem instanceof WaiAAA2Error && !WAI_AAA2_ERROR_TITLE.equals(title)) {
                            title = WAI_AAA2_ERROR_TITLE;
                            output.append(title);
                        }
                    } else if (coreProblem instanceof WaiAError && !WAI_A_ERROR_TITLE.equals(title)) {
                        title = WAI_A_ERROR_TITLE;
                        output.append(title);
                    } else if (coreProblem instanceof WaiAAError && !WAI_AA_ERROR_TITLE.equals(title)) {
                        title = WAI_AA_ERROR_TITLE;
                        output.append(title);
                    } else if (coreProblem instanceof WaiAAAError && !WAI_AAA_ERROR_TITLE.equals(title)) {
                        title = WAI_AAA_ERROR_TITLE;
                        output.append(title);
                    }
                    if (coreProblem instanceof ParsingWarning && !PARSING_WARN_TITLE.equals(title)) {
                        title = PARSING_WARN_TITLE;
                        output.append(title);
                    } else if (coreProblem instanceof LinkWarning && !LINK_WARN_TITLE.equals(title)) {
                        title = LINK_WARN_TITLE;
                        output.append(title);
                    } else if (coreProblem instanceof HtmlWarning && !HTML_WARN_TITLE.equals(title)) {
                        title = HTML_WARN_TITLE;
                        output.append(title);
                    }
                    if (section508) {
                        if (coreProblem instanceof Section508Problem && coreProblem instanceof ValidationWarning && !SECTION_508_WARN_TITLE.equals(title)) {
                            title = SECTION_508_WARN_TITLE;
                            output.append(title);
                        }
                    } else if (wcag2) {
                        if (coreProblem instanceof WaiA2Warning && !WAI_A2_WARN_TITLE.equals(title)) {
                            title = WAI_A2_WARN_TITLE;
                            output.append(title);
                        }
                    } else if (coreProblem instanceof WaiAWarning && !WAI_A_WARN_TITLE.equals(title)) {
                        title = WAI_A_WARN_TITLE;
                        output.append(title);
                    } else if (coreProblem instanceof WaiAAWarning && !WAI_AA_WARN_TITLE.equals(title)) {
                        title = WAI_AA_WARN_TITLE;
                        output.append(title);
                    }
                    if (coreProblem instanceof SpellingWarning && !SPELL_WARN_TITLE.equals(title)) {
                        title = SPELL_WARN_TITLE;
                        output.append(title);
                    }
                    output.append("<p><a id=\"").append(probNumber).append("\" name=\"").append(probNumber).append("\"></a>").append("<span class=\"strong\">");
                    output.append(probNumber).append(" - ").append(problemCount.get(probNumber)).append(" instance(s):</span> ");
                    output.append(coreProblem.getLongMessage()).append("</p>\n");
                }
            } else {
                output.append("</pre>\n");
                output.append(UP_LINK);
            }
        }
        return !problems.isEmpty();
    }

    private String wrapLines(String source, String indent1, String indent2, int wrapAmount, boolean addStartTag) {
        source = source.replace('\n', ' ');
        if (wrapAmount < 10) {
            wrapAmount = source.length();
        }
        String indent = indent1;
        int wrap = this.encodedExtra(source, wrapAmount);
        StringBuilder result = new StringBuilder();
        while (source.length() > wrap) {
            int index = this.findWrapPoint(source, wrap);
            result.append(indent);
            if (addStartTag) {
                result.append("&lt;");
                addStartTag = false;
            }
            result.append(SPAN_PATTERN.matcher(source.substring(0, index)).replaceAll("<span class='error'>")).append("\n");
            source = source.substring(index).trim();
            indent = indent2;
            wrap = this.encodedExtra(source, wrapAmount);
        }
        result.append(indent);
        if (addStartTag) {
            result.append("&lt;");
            addStartTag = false;
        }
        result.append(SPAN_PATTERN.matcher(source).replaceAll("<span class='error'>"));
        return result.toString();
    }

    private int findWrapPoint(String source, int wrapPoint) {
        int newWrapPoint = source.lastIndexOf(32, wrapPoint);
        if (newWrapPoint == -1 && ((newWrapPoint = source.indexOf(32, wrapPoint)) == -1 || newWrapPoint > wrapPoint)) {
            int index2;
            newWrapPoint = wrapPoint;
            int index1 = source.lastIndexOf(38, newWrapPoint - 1);
            if (index1 != -1 && (index2 = source.indexOf(59, index1)) != -1 && index2 >= newWrapPoint && index2 - index1 < 10) {
                newWrapPoint = index1;
            }
            if ((index1 = source.lastIndexOf(60, newWrapPoint - 1)) != -1 && (index2 = source.indexOf(62, index1)) != -1 && index2 >= newWrapPoint) {
                if (index1 != 0) {
                    newWrapPoint = index1;
                } else if (index2 + 2 < source.length()) {
                    newWrapPoint = index2 + 1;
                }
            }
        }
        return newWrapPoint;
    }

    private int encodedExtra(String source, int wrap) {
        int newWrap;
        int index1;
        int index2 = 0;
        for (newWrap = wrap; source.length() > newWrap && (index1 = source.indexOf(38, index2)) != -1 && index1 < newWrap && (index2 = source.indexOf(59, index1)) != -1 && index2 <= newWrap; newWrap += index2 - index1) {
        }
        index2 = 0;
        while (source.length() > newWrap && (index1 = source.indexOf(60, index2)) != -1 && index1 < newWrap && (index2 = source.indexOf(62, index1)) != -1 && index2 <= newWrap) {
            newWrap += index2 - index1 + 1;
        }
        return newWrap;
    }

    private String formatNumber(int i) {
        StringBuilder sb = new StringBuilder();
        if (i < 1000) {
            sb.append(" ");
        }
        if (i < 100) {
            sb.append(" ");
        }
        if (i < 10) {
            sb.append(" ");
        }
        sb.append(i).append(" ");
        return sb.toString();
    }

    private String indent(int indentLevel) {
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < indentLevel; ++i) {
            indent.append("  ");
        }
        return indent.toString();
    }

    public int getErrorTotal() {
        return this.errorTotal;
    }

    public int getWarningsTotal() {
        return this.warningsTotal;
    }

    public String saveResults(String outputDir) throws ValidationException {
        String fileName = null;
        try {
            this.saveFile = File.createTempFile("page", ".html", new File(outputDir));
        }
        catch (IOException e1) {
            throw new ValidationException(e1);
        }
        fileName = this.saveFile.getName();
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.saveFile), "UTF-8")));
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
        pw.print(this.formatted);
        this.formatted = null;
        pw.flush();
        pw.close();
        pw = null;
        return fileName;
    }

    public String addSnapshots(String[] snapshots) throws IOException {
        String line;
        StringBuilder theFinalPage = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.saveFile), "UTF-8"));
        while ((line = br.readLine()) != null) {
            if (SNAPSHOT_MARKER.equals(line)) {
                Snapshot.printSnapshots(snapshots, theFinalPage, null, UP_LINK);
                continue;
            }
            if (SNAPSHOT_NAV_MARKER.equals(line)) {
                theFinalPage.append(SCREENSHOT).append("\n");
                continue;
            }
            theFinalPage.append(line).append("\n");
        }
        return theFinalPage.toString();
    }
}

