/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.validations;

import com.totalvalidator.Cancellor;
import com.totalvalidator.Validator;
import com.totalvalidator.exceptions.CancelledException;
import com.totalvalidator.exceptions.ValidationException;
import com.totalvalidator.parser.CommandLineParser;
import com.totalvalidator.sgml.EntityEncoder;
import com.totalvalidator.sgml.Piece;
import com.totalvalidator.sgml.RealAttribute;
import com.totalvalidator.sgml.Tag;
import com.totalvalidator.utils.FileUtils;
import com.totalvalidator.utils.GeneralUtils;
import com.totalvalidator.utils.PageReference;
import com.totalvalidator.validations.AccessibilityValidation;
import com.totalvalidator.validations.Validation;
import com.totalvalidator.validations.http.TestFileLink;
import com.totalvalidator.validations.http.TestHttpLink;
import com.totalvalidator.validations.http.TestLink;
import com.totalvalidator.validations.problem.ValidationProblem;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkValidation
implements Validation {
    public static final String SINGLE_THREAD = "SingleThread";
    private List<TestHttpLink> threads = new ArrayList<TestHttpLink>();
    private String urlOrigin;
    private List<PageReference> pagesToCheck;
    private Map<String, List<ValidationProblem>> linksTested;
    private long timeOut;
    private String baseUrl;
    private boolean reportBroken;
    private EntityEncoder ee;
    private Validator validator;
    private CommandLineParser cl;
    private boolean followLinks;
    private String referer;
    private boolean noQuery;
    private boolean noSession;
    private int concurrencyLimit;
    private boolean concurrencyLimited;
    private static int linkCount = 0;
    private static Set<String> protocols = new HashSet<String>();
    private static final String BACKGROUND = "background";
    private static final String DATA = "data";
    private static final String LONGDESC = "longdesc";
    private static final String PROFILE = "profile";
    private static final String SRC = "src";
    private static final String HREF = "href";
    private static final String CITE = "cite";
    private static final String ITEMTYPE = "itemtype";
    private static final String USEMAP = "usemap";
    private static final String MANIFEST = "manifest";
    private static final String ALTIMG = "altimg";
    private static final String ICON = "icon";
    private static final String POSTER = "poster";
    private static final String A = "a";
    private static final String FRAME = "frame";
    private static final String IFRAME = "iframe";
    private static final String IMG = "img";
    private static final String BLOCKQUOTE = "blockquote";
    private static final String Q = "q";
    private static final String HEAD = "head";
    private static final String SCRIPT = "script";
    private static final String BASE = "base";
    private static final String BODY = "body";
    private static final String OBJECT = "object";
    private static final String INPUT = "input";
    private static final String AREA = "area";
    private static final String LINK = "link";
    private static final String DEL = "del";
    private static final String INS = "ins";
    private static final String EMBED = "embed";
    private static final String AUDIO = "audio";
    private static final String SOURCE = "source";
    private static final String HTML = "html";
    private static final String MATH = "math";
    private static final String COMMAND = "command";
    private static final String VIDEO = "video";
    private static final String META = "meta";
    private static final String HTTP_EQUIV = "http-equiv";
    private static final String CONTENT = "content";
    private static final String REFRESH = "refresh";
    private static final String URLEQ = "url=";
    private static final Pattern AMP_PATTERN;
    private static final Pattern SPACE_PATTERN;
    private static final String FORM = "form";
    private static final String ACTION = "action";
    private static final String METHOD = "method";
    private static final String GET = "get";
    private static final String POST = "post";
    private static final String BUTTON = "button";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String SUBMIT = "submit";
    private static final String VALUE = "value";
    private static final String DISABLED = "disabled";
    private static final String TEXTAREA = "textarea";
    private static final String PASSWORD = "password";
    private static final String TEXT = "text";
    private static final String HIDDEN = "hidden";
    private static final String CHECKBOX = "checkbox";
    private static final String CHECKED = "checked";
    private static final String RADIO = "radio";
    private static final String SELECT = "select";
    private static final Object MULTIPLE;
    private static final Object OPTGROUP;
    private static final String OPTION = "option";
    private static final Object SELECTED;

    public LinkValidation(CommandLineParser cl, String referer, String urlOrigin, List<PageReference> pagesToCheck, Map<String, List<ValidationProblem>> linksTested, EntityEncoder ee, Validator validator) {
        this.baseUrl = referer;
        if (!referer.toLowerCase(Locale.ENGLISH).startsWith("file")) {
            this.referer = referer;
        }
        this.urlOrigin = urlOrigin;
        this.pagesToCheck = pagesToCheck;
        this.linksTested = linksTested;
        this.timeOut = cl.getTimeOut();
        this.reportBroken = cl.isBrokenLinks();
        this.ee = ee;
        this.validator = validator;
        this.cl = cl;
        this.followLinks = cl.isFollowLinks();
        this.noQuery = cl.isNoQuery();
        this.noSession = cl.isNoSession();
        this.concurrencyLimit = cl.getConcurrencyLimit();
        this.concurrencyLimited = this.concurrencyLimit > 0;
    }

    @Override
    public void validate(List<Piece> pieces, Cancellor cancellor) throws ValidationException, CancelledException {
        for (Piece tag : pieces) {
            cancellor.isCancelled();
            if (tag.isMalformed() || !(tag instanceof Tag) || tag.isEndTag() || tag.isVirtual()) continue;
            this.checkLink(tag, pieces);
        }
        while (this.threads.size() > 0) {
            ListIterator<TestHttpLink> iter = this.threads.listIterator();
            while (iter.hasNext()) {
                cancellor.isCancelled();
                TestHttpLink tl = iter.next();
                if (this.concurrencyLimited && !tl.isStarted()) continue;
                this.getResults(tl);
                this.safelyRemoveThread(iter);
                if (!this.concurrencyLimited) continue;
                this.startThreads();
            }
        }
    }

    private void getResults(TestHttpLink tl) {
        try {
            tl.join(this.timeOut);
        }
        catch (InterruptedException ie) {
            GeneralUtils.LOGGER.severe("Interrupted waiting for " + tl.getURL());
        }
        if (tl.isAlive()) {
            tl.interrupt();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (tl.isAlive()) {
                GeneralUtils.LOGGER.fine("Link Validation thread still running");
                tl.setConnectionError("Timed out");
            }
        }
        this.retrieveResults(tl);
    }

    private void checkLink(Piece tag, List<Piece> pieces) {
        String link = null;
        String attr = null;
        String link2 = null;
        String attr2 = null;
        String link3 = null;
        String attr3 = null;
        String link4 = null;
        boolean dontFollow = false;
        boolean dontFollow3 = false;
        boolean formLink = false;
        String element = tag.getStrippedElement();
        if (element == null) {
            return;
        }
        if (element.equals(FRAME) || element.equals(IFRAME)) {
            attr = SRC;
            link = tag.getAttr(attr);
            attr2 = LONGDESC;
            link2 = tag.getAttr(attr2);
        } else if (element.equals(IMG)) {
            attr = SRC;
            link = this.checkProtocol(tag.getAttr(attr));
            if (link != null) {
                dontFollow = true;
            }
            attr2 = LONGDESC;
            link2 = tag.getAttr(attr2);
            attr3 = USEMAP;
            link3 = this.checkProtocol(tag.getAttr(attr3));
            if (link3 != null) {
                dontFollow3 = true;
            }
        } else if (element.equals(BLOCKQUOTE) || element.equals(Q) || element.equals(INS) || element.equals(DEL)) {
            attr = CITE;
            link = tag.getAttr(attr);
        } else if (element.equals(HEAD)) {
            attr = PROFILE;
            link = this.checkProtocol(tag.getAttr(attr));
            if (link != null) {
                dontFollow = true;
            }
        } else if (element.equals(SCRIPT) || element.equals(INPUT) || element.equals(EMBED) || element.equals(AUDIO) || element.equals(SOURCE)) {
            attr = SRC;
            link = this.checkProtocol(tag.getAttr(attr));
            if (link != null) {
                dontFollow = true;
            }
        } else {
            String action;
            if (element.equals(BASE)) {
                String base = tag.getAttr(HREF);
                if (base == null) {
                    return;
                }
                int index = base.lastIndexOf(47);
                if (index != -1) {
                    this.baseUrl = base;
                }
                this.validURI(base, false, tag, HREF);
                return;
            }
            if (element.equals(BODY)) {
                attr = BACKGROUND;
                link = this.checkProtocol(tag.getAttr(attr));
                if (link != null) {
                    dontFollow = true;
                }
            } else if (element.equals(OBJECT)) {
                attr = DATA;
                link = this.checkProtocol(tag.getAttr(attr));
                if (link != null) {
                    dontFollow = true;
                }
                if ((link3 = this.checkProtocol(tag.getAttr(attr3 = USEMAP))) != null) {
                    dontFollow3 = true;
                }
            } else if (element.equals(A) || element.equals(AREA) || element.equals(LINK)) {
                attr = HREF;
                link = tag.getAttr(attr);
            } else if (element.equals(HTML)) {
                attr = MANIFEST;
                link = tag.getAttr(attr);
            } else if (element.equals(META)) {
                int index;
                String value = tag.getAttr(HTTP_EQUIV);
                if (value != null && value.equalsIgnoreCase(REFRESH) && (value = tag.getAttr(attr = CONTENT)) != null && value.length() > 0 && (index = value.toLowerCase(Locale.ENGLISH).indexOf(URLEQ)) != -1) {
                    link = value.substring(index + URLEQ.length());
                }
            } else if (element.equals(MATH)) {
                attr = ALTIMG;
                link = this.checkProtocol(tag.getAttr(attr));
                if (link != null) {
                    dontFollow = true;
                }
            } else if (element.equals(COMMAND)) {
                attr = ICON;
                link = this.checkProtocol(tag.getAttr(attr));
                if (link != null) {
                    dontFollow = true;
                }
            } else if (element.equals(VIDEO)) {
                attr = SRC;
                link = this.checkProtocol(tag.getAttr(attr));
                if (link != null) {
                    dontFollow = true;
                }
                if ((link3 = this.checkProtocol(tag.getAttr(attr3 = POSTER))) != null) {
                    dontFollow3 = true;
                }
            } else if (element.equals(FORM) && this.cl.getMaxPages() != 1 && (action = tag.getAttr(attr = ACTION)) != null && action.trim().length() > 0) {
                action = action.trim();
                String actionURL = this.cl.getActionURL();
                if (this.cl.isNoQuery()) {
                    action = this.trimQuery(action);
                }
                if (this.cl.isNoSession()) {
                    action = this.trimRewrite(action);
                }
                if (this.cl.isActionRegex() && action.matches(actionURL) || action.equals(actionURL)) {
                    link = action;
                    formLink = true;
                    this.setFormDefaults(tag, pieces);
                }
            }
        }
        link4 = tag.getAttr(ITEMTYPE);
        if (!this.reportBroken && dontFollow) {
            link = null;
        }
        if (!this.reportBroken && dontFollow3) {
            link3 = null;
        }
        if (link != null) {
            this.processLink(link, dontFollow, tag, pieces, attr, formLink);
        }
        if (link2 != null) {
            this.processLink(link2, false, tag, pieces, attr2, formLink);
        }
        if (link3 != null) {
            this.processLink(link3, dontFollow3, tag, pieces, attr3, formLink);
        }
        if (link4 != null) {
            this.processLink(link4, false, tag, pieces, ITEMTYPE, formLink);
        }
    }

    private String checkProtocol(String link) {
        if (link != null) {
            for (String protocol : protocols) {
                if (!link.startsWith(protocol)) continue;
                return null;
            }
        }
        return link;
    }

    private void setFormDefaults(Piece tag, List<Piece> pieces) {
        String value;
        String method = tag.getAttr(METHOD);
        if (method == null || !method.equalsIgnoreCase(GET) && !method.equalsIgnoreCase(POST)) {
            this.cl.setFormPost(false);
        } else {
            this.cl.setFormPost(method.equalsIgnoreCase(POST));
        }
        this.cl.resetNVPairs();
        String submitButton = this.cl.getSubmitButton();
        boolean checkSubmit = submitButton.length() > 0;
        List<Piece> buttonTags = AccessibilityValidation.findInnerTags(tag, pieces, BUTTON);
        for (Piece buttonTag : buttonTags) {
            Map<String, RealAttribute> attrs = buttonTag.getAttributes();
            String name = buttonTag.getAttr(NAME);
            String type = buttonTag.getAttr(TYPE);
            if (type == null) {
                type = SUBMIT;
            }
            if (name == null || !type.equals(SUBMIT) || attrs.containsKey(DISABLED)) continue;
            value = buttonTag.getAttr(VALUE);
            if (value == null) {
                value = AccessibilityValidation.findInnerText(buttonTag, pieces);
            }
            if (checkSubmit && !submitButton.equals(name)) continue;
            this.cl.addNVPair(name, value, false);
        }
        List<Piece> textAreaTags = AccessibilityValidation.findInnerTags(tag, pieces, TEXTAREA);
        for (Piece textArea : textAreaTags) {
            Map<String, RealAttribute> attrs = textArea.getAttributes();
            String name = textArea.getAttr(NAME);
            if (name == null || attrs.containsKey(DISABLED)) continue;
            value = AccessibilityValidation.findInnerText(textArea, pieces);
            this.cl.addNVPair(name, value, false);
        }
        List<Piece> inputTags = AccessibilityValidation.findInnerTags(tag, pieces, INPUT);
        for (Piece inputTag : inputTags) {
            Map<String, RealAttribute> attrs = inputTag.getAttributes();
            String name = inputTag.getAttr(NAME);
            String type = inputTag.getAttr(TYPE);
            if (type == null) {
                type = TEXT;
            }
            if (name == null || attrs.containsKey(DISABLED)) continue;
            String value2 = inputTag.getAttr(VALUE);
            if (TEXT.equals(type) || HIDDEN.equals(type) || PASSWORD.equals(type)) {
                if (value2 == null) continue;
                this.cl.addNVPair(name, value2, false);
                continue;
            }
            if (SUBMIT.equals(type)) {
                if (value2 == null || checkSubmit && !submitButton.equals(name)) continue;
                this.cl.addNVPair(name, value2, false);
                continue;
            }
            if (CHECKBOX.equals(type)) {
                if (!attrs.containsKey(CHECKED) || value2 == null) continue;
                this.cl.addNVPair(name, value2, false);
                continue;
            }
            if (!RADIO.equals(type) || !attrs.containsKey(CHECKED) || value2 == null) continue;
            this.cl.addNVPair(name, value2, true);
        }
        List<Piece> selectTags = AccessibilityValidation.findInnerTags(tag, pieces, SELECT);
        for (Piece selectTag : selectTags) {
            boolean single;
            Map<String, RealAttribute> attrs = selectTag.getAttributes();
            String name = selectTag.getAttr(NAME);
            if (name == null || attrs.containsKey(DISABLED)) continue;
            boolean bl = single = !attrs.containsKey(MULTIPLE);
            if (!selectTag.hasMatchingTag()) continue;
            int startIndex = pieces.indexOf(selectTag) + 1;
            Piece endTag = selectTag.getMatchingTag();
            int endIndex = pieces.indexOf(endTag);
            for (int i = startIndex; i < endIndex; ++i) {
                String inner_e;
                Piece t = pieces.get(i);
                if (t.isEndTag() || (inner_e = t.getStrippedElement()) == null) continue;
                Map<String, RealAttribute> t_attrs = t.getAttributes();
                if (inner_e.equals(OPTGROUP) && (t_attrs == null || !t_attrs.containsKey(DISABLED))) {
                    List<Piece> optionTags = AccessibilityValidation.findInnerTags(t, pieces, OPTION);
                    for (Piece optionTag : optionTags) {
                        this.processOption(optionTag, pieces, name, single);
                    }
                    continue;
                }
                if (inner_e.equals(OPTION)) {
                    this.processOption(t, pieces, name, single);
                    continue;
                }
                if (!inner_e.equals(SELECT) || !t.hasMatchingTag()) continue;
                i = pieces.indexOf(t.getMatchingTag());
            }
        }
        this.cl.completeNVPairs();
        GeneralUtils.LOGGER.fine(this.cl.getNVPairs().toString());
    }

    private void processOption(Piece optionTag, List<Piece> pieces, String name, boolean single) {
        Map<String, RealAttribute> attrs = optionTag.getAttributes();
        if (attrs != null && !attrs.containsKey(DISABLED) && attrs.containsKey(SELECTED)) {
            String value = optionTag.getAttr(VALUE);
            if (value == null) {
                value = AccessibilityValidation.findInnerText(optionTag, pieces);
            }
            this.cl.addNVPair(name, value, single);
        }
    }

    private void processLink(String link, boolean dontFollow, Piece tag, List<Piece> pieces, String attribute, boolean formLink) {
        String lowerCaseLink;
        String string = lowerCaseLink = (link = this.testLink(link, tag, pieces, attribute, false, this.baseUrl, formLink)) != null ? link.toLowerCase(Locale.ENGLISH) : "";
        if (link != null && !this.skipFolders(link) && (lowerCaseLink.startsWith(this.urlOrigin.toLowerCase() + "/") || this.reportBroken || this.followLinks)) {
            GeneralUtils.LOGGER.fine("Link Count: " + ++linkCount);
            if (lowerCaseLink.startsWith("file")) {
                TestFileLink tf = new TestFileLink(link, tag, attribute, this.urlOrigin, dontFollow, this.followLinks, this.linksTested);
                this.retrieveResults(tf);
            } else if (lowerCaseLink.indexOf("jigsaw.w3.org/css-validator") != -1 || lowerCaseLink.indexOf("validator.w3.org/check") != -1 || lowerCaseLink.indexOf("totalvalidator.com/validator/revalidate") != -1 || lowerCaseLink.indexOf("totalvalidator.com/validator/validate&") != -1 || lowerCaseLink.endsWith("totalvalidator.com/validator/validate") || lowerCaseLink.indexOf("totalvalidator.com/validator/feedback&") != -1 || lowerCaseLink.endsWith("totalvalidator.com/validator/feedback")) {
                this.linksTested.put(link, new ArrayList());
            } else if (formLink) {
                this.cl.setActionURL(link);
                this.pagesToCheck.add(new PageReference(link, this.referer, true));
                ++this.validator.pagesLeft;
                this.linksTested.put(link, new ArrayList());
            } else {
                TestHttpLink tl = new TestHttpLink(this, link, this.referer, tag, attribute, this.urlOrigin, dontFollow, this.linksTested, this.cl);
                if (System.getProperty(SINGLE_THREAD, "false").equals("true")) {
                    tl.start();
                    this.getResults(tl);
                } else if (this.concurrencyLimited) {
                    this.addThread(tl);
                    this.startThreads();
                } else {
                    this.addThread(tl);
                    tl.start();
                }
            }
        }
    }

    private boolean skipFolders(String link) {
        for (Pattern folder : this.cl.getPatternsToInclude(this.urlOrigin)) {
            if (!folder.matcher(link).matches()) continue;
            return false;
        }
        for (Pattern folder : this.cl.getPatternsToSkip(this.urlOrigin)) {
            if (!folder.matcher(link).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean localAnchor(String link, Piece tag, List<Piece> pieces, String attribute, boolean redirected) {
        if (link.charAt(0) != '#') {
            return false;
        }
        if ("#".equals(link)) {
            return true;
        }
        link = link.substring(1, link.length());
        try {
            link = URLDecoder.decode(link, "UTF-8");
        }
        catch (Exception e) {
            GeneralUtils.LOGGER.log(Level.SEVERE, "URL Decoder Failure", e);
        }
        if (pieces != null) {
            boolean foundMatching = false;
            for (Piece tag2 : pieces) {
                String id;
                if (!(tag2 instanceof Tag)) continue;
                String name = tag2.getAttr(NAME);
                if (name != null) {
                    try {
                        name = URLDecoder.decode(name, "UTF-8");
                    }
                    catch (Exception e) {
                        GeneralUtils.LOGGER.log(Level.SEVERE, "URL Decoder Failure", e);
                    }
                    if (name.equals(link)) {
                        foundMatching = true;
                        break;
                    }
                }
                if ((id = tag2.getAttr("id")) == null) continue;
                try {
                    name = URLDecoder.decode(id, "UTF-8");
                }
                catch (Exception e) {
                    GeneralUtils.LOGGER.log(Level.SEVERE, "URL Decoder Failure", e);
                }
                if (!id.equals(link)) continue;
                foundMatching = true;
                break;
            }
            if (!foundMatching) {
                tag.setProblemValue(redirected ? ValidationProblem.BAD_REDIRECT_ANCHOR : ValidationProblem.BAD_ANCHOR, attribute);
            }
        }
        return true;
    }

    private boolean alreadyTested(String link) {
        if (this.linksTested.containsKey(link)) {
            return true;
        }
        this.linksTested.put(link, null);
        GeneralUtils.LOGGER.fine("In alreadyTested: " + link);
        return false;
    }

    private static boolean invalidType(String link) {
        return link == null || link.length() == 0 || link.toLowerCase(Locale.ENGLISH).startsWith("mailto:") || link.toLowerCase(Locale.ENGLISH).startsWith("ftp:");
    }

    private String tidyUpLink(String link, Piece tag, String attribute, boolean redirected, String base) {
        if ((link = link.trim()).toLowerCase(Locale.ENGLISH).startsWith("javascript")) {
            return null;
        }
        if (link.toLowerCase(Locale.ENGLISH).startsWith("http") || link.toLowerCase(Locale.ENGLISH).startsWith("file:")) {
            if (link.equals(this.urlOrigin) || link.equals(this.urlOrigin + "/")) {
                return null;
            }
            String testLink = link;
            if (link.toLowerCase(Locale.ENGLISH).startsWith("file:") && link.indexOf(32) != -1) {
                testLink = SPACE_PATTERN.matcher(link).replaceAll("%20");
            }
            if (!this.validURI(testLink, redirected, tag, attribute)) {
                return null;
            }
            try {
                if (link.charAt(link.length() - 1) == '/' && "/".equals(new URL(testLink).getPath())) {
                    link = link.substring(0, link.length() - 1);
                }
            }
            catch (MalformedURLException e) {}
        } else {
            String testLink = FileUtils.resolveRelativeUrl(link, base, this.ee);
            if (testLink == null) {
                tag.setProblemValue(ValidationProblem.newLinkError(42, "Bad character(s) found in link in attribute '" + attribute + "':"), attribute);
                GeneralUtils.LOGGER.fine("BAD LINK : " + link);
                return null;
            }
            link = testLink;
        }
        link = AMP_PATTERN.matcher(link).replaceAll("&");
        if (this.noQuery) {
            link = this.trimQuery(link);
        }
        if (this.noSession) {
            link = this.trimRewrite(link);
        }
        return this.trimAnchors(link);
    }

    private boolean validURI(String testLink, boolean redirected, Piece tag, String attribute) {
        try {
            new URI(testLink);
        }
        catch (Exception e) {
            String[] result = this.ee.decode(testLink, false, false);
            testLink = result[0];
            try {
                new URI(testLink);
            }
            catch (Exception e2) {
                if (redirected) {
                    tag.setProblemValue(ValidationProblem.newLinkWarning(43, "Bad character(s) found in redirected link in attribute '" + attribute + "':"), attribute);
                } else {
                    tag.setProblemValue(ValidationProblem.newLinkError(42, "Bad character(s) found in link in attribute '" + attribute + "':"), attribute);
                }
                GeneralUtils.LOGGER.fine("BAD LINK : " + testLink);
                return false;
            }
        }
        return true;
    }

    private void retrieveResults(TestLink tl) {
        String link = tl.getLink();
        if (link != null && FileUtils.validContentType(tl.getContentType())) {
            this.pagesToCheck.add(new PageReference(link, this.referer, false));
            ++this.validator.pagesLeft;
        }
        tl = null;
    }

    private String trimRewrite(String url) {
        int index1 = url.indexOf(38);
        if (index1 == -1) {
            index1 = url.length();
        }
        int index2 = -1;
        String suffix = "";
        index2 = url.indexOf(63);
        if (index2 != -1) {
            suffix = url.substring(index2);
        }
        if (index2 == -1) {
            index2 = url.length();
        }
        int index = -1;
        index = url.indexOf(59);
        if (index != -1 && index < index1 && index < index2) {
            String prefix = url.substring(0, index);
            url = prefix + suffix;
        }
        return url;
    }

    private String trimQuery(String url) {
        int index = -1;
        index = url.indexOf(63);
        if (index != -1) {
            url = url.substring(0, index);
        }
        return url;
    }

    private String trimAnchors(String url) {
        int index = -1;
        index = url.indexOf(35);
        if (index != -1) {
            url = url.substring(0, index);
        }
        return url;
    }

    public String testLink(String link, Piece tag, List<Piece> pieces, String attribute, boolean redirected, String base, boolean formLink) {
        String result = null;
        if (!LinkValidation.invalidType(link) && !this.localAnchor(link, tag, pieces, attribute, redirected) && (link = this.tidyUpLink(link, tag, attribute, redirected, base)) != null) {
            if (formLink && link.equals(base) && !this.cl.isFormTested(link)) {
                if (this.alreadyTested(link)) {
                    this.cl.addFormTested(link);
                }
                result = link;
            } else if (this.alreadyTested(link)) {
                List<ValidationProblem> links = this.linksTested.get(link);
                if (links != null && !links.isEmpty()) {
                    tag.addMessages(links);
                }
            } else {
                result = link;
            }
        }
        return result;
    }

    private synchronized void safelyRemoveThread(ListIterator<TestHttpLink> iter) {
        iter.remove();
    }

    private synchronized void addThread(TestHttpLink tl) {
        this.threads.add(tl);
    }

    private synchronized void startThreads() {
        int count = 0;
        for (TestHttpLink thread : this.threads) {
            if (!thread.isAlive()) continue;
            ++count;
        }
        if (count < this.concurrencyLimit) {
            for (TestHttpLink thread : this.threads) {
                if (thread.isAlive() || thread.isStarted() || count >= this.concurrencyLimit) continue;
                ++count;
                thread.setStarted(true);
                thread.start();
                break;
            }
        }
    }

    static {
        protocols.add("data:");
        protocols.add("dav:");
        protocols.add("h323:");
        protocols.add("imap:");
        protocols.add("ldap:");
        protocols.add("mailto:");
        protocols.add("news:");
        protocols.add("nntp:");
        protocols.add("pop:");
        protocols.add("rtsp:");
        protocols.add("sms:");
        protocols.add("snmp:");
        protocols.add("telnet:");
        protocols.add("urn:");
        protocols.add("icon:");
        protocols.add("ws:");
        protocols.add("wss:");
        protocols.add("snews:");
        AMP_PATTERN = Pattern.compile("&amp;");
        SPACE_PATTERN = Pattern.compile(" ");
        MULTIPLE = "multiple";
        OPTGROUP = "optgroup";
        SELECTED = "selected";
    }
}

