/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.validations;

import com.totalvalidator.Cancellor;
import com.totalvalidator.exceptions.CancelledException;
import com.totalvalidator.exceptions.ValidationException;
import com.totalvalidator.parser.DTDParser;
import com.totalvalidator.sgml.Attribute;
import com.totalvalidator.sgml.CData;
import com.totalvalidator.sgml.Element;
import com.totalvalidator.sgml.EntityEncoder;
import com.totalvalidator.sgml.Piece;
import com.totalvalidator.sgml.RealAttribute;
import com.totalvalidator.sgml.SupportedDTDs;
import com.totalvalidator.sgml.Tag;
import com.totalvalidator.sgml.TagValidator;
import com.totalvalidator.utils.FileUtils;
import com.totalvalidator.utils.MyReader;
import com.totalvalidator.validations.Validation;
import com.totalvalidator.validations.problem.CoreProblem;
import com.totalvalidator.validations.problem.ValidationProblem;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLValidation
implements Validation {
    private boolean firstTag;
    private boolean charsetFound;
    private boolean bestfit;
    private EntityEncoder encoder;
    private boolean isXml;
    private String docType;
    Map<String, Element> elements;
    private boolean scriptMetaTag;
    private boolean styleMetaTag;
    private MyReader myReader;
    private Piece theFirstTag;
    private String httpCharset;
    private String bomCharset;
    private Map<String, Piece> ids;
    private Map<String, Piece> names;
    private boolean isHtml5;
    private int charsetCount;
    private static final List<String> intrinsicEvents = new ArrayList<String>();
    private static final List<String> nameTags = new ArrayList<String>();
    private static final String CONTENT = "content";
    private static final String SCRIPT_TYPE = "content-script-type";
    private static final String STYLE_TYPE = "content-style-type";
    private static final String META = "meta";
    private static final String HTTP = "http";
    private static final String DOCTYPE = "!doctype";
    private static final String HTTP_EQUIV = "http-equiv";
    private static final String HTML = "html";
    private static final String SHAPE = "shape";
    private static final String COORDS = "coords";
    private static final String BORDER = "border";
    private static final String FOR = "for";
    private static final String BUTTON = "button";
    private static final String RESET = "reset";
    private static final String SELECT = "select";
    private static final String TEXTAREA = "textarea";
    private static final String OBJECT = "object";
    private static final String CANVAS = "canvas";
    private static final String ISINDEX = "isindex";
    private static final String INPUT = "input";
    private static final String TYPE = "type";
    private static final String HIDDEN = "hidden";
    private static final String HTML_40 = "HTML 4.0";
    private static final String XMLNS = "xmlns";
    private static final String ID = "id";
    private static final String A = "a";
    private static final String NAME = "name";
    private static final String STYLE = "style";
    private static final String CONTENT_TYPE = "content-type";
    private static final String QUESTION_MARK = "?";
    private static final String AT = "@";
    private static final String XHTML_11 = "XHTML 1.1";
    private static final String BASIC_11 = "XHTML Basic 1.1";
    private static final String RDF = "XHTML+RDFa";
    private static final String XML = "?xml";
    private static final String VERSION = "version";
    private static final String ENCODING = "encoding";
    private static final String STANDALONE = "standalone";
    private static final String PUBLIC = "public";
    private static final String SYSTEM = "system";
    private static final String USEMAP = "usemap";
    private static final String MAP = "map";
    private static final String TD = "td";
    private static final String HEADERS = "headers";
    private static final String TH = "th";
    private static final String FORM = "form";
    private static final String TABLE = "table";
    private static final String LANG = "lang";
    private static final String XML_LANG = "xml:lang";
    private static final String AREA = "area";
    private static final String LINK = "link";
    private static final String ITEMPROP = "itemprop";
    private static final String HEAD = "head";
    private static final String NOSCRIPT = "noscript";
    private static final String SCOPED = "scoped";
    private static final String DEL = "del";
    private static final String INS = "ins";
    private static final String AUDIO = "audio";
    private static final String IMG = "img";
    private static final String MENU = "menu";
    private static final String VIDEO = "video";
    private static final String CONTROLS = "controls";
    private static final String TOOLBAR = "toolbar";
    private static final String OL = "ol";
    private static final String LI = "li";
    private static final String VALUE = "value";
    private static final String FIGURE = "figure";
    private static final String FIGCAPTION = "figcaption";
    private static final String TBODY = "tbody";
    private static final String TR = "tr";
    private static final String COL = "col";
    private static final String SPAN = "span";
    private static final String THEAD = "thead";
    private static final String TFOOT = "tfoot";
    private static final String DATALIST = "datalist";
    private static final String OPTION = "option";
    private static final String LABEL = "label";
    private static final String OUTPUT = "output";
    private static final String METER = "meter";
    private static final String PROGRESS = "progress";
    private static final String ITEMREF = "itemref";
    private static final String REFID = "refid";
    private static final String LIST = "list";
    private static final String KEYGEN = "keygen";
    private static final String CONTEXTMENU = "contextmenu";
    private static final List<String> BLOCK;
    private static final String BLOCK_ELEMENTS = "p | h1 | h2 | h3 | h4 | h5 | h6 | ul | ol | dir | menu | pre | dl | div | center | noscript | noframes | blockquote | form | isindex | hr | table | fieldset | address";
    private static final List<String> INLINE_PARENTS;
    private static final String INLINE_PARENT_ELEMENTS = "tt | i | b | u | s | strike | big | small | em | strong | dfn | code | samp | kbd | var | cite | abbr | acronym | sub | sup | span | bdo | font | address | a | p | h1 | h2 | h3 | h4 | h5 | h6 | pre | q | dt | label | legend | caption ";
    private static final List<String> NOT_PHRASING;
    private static final String FLOW_NOT_PHRASING_ELEMENTS = "address | article | aside | blockquote | details | div | dl | fieldset | figure | footer | form | h1 | h2 | h3 | h4 | h5 | h6 | header | hgroup | hr | menu | nav | ol | p | pre | section | style | table | ul | figcaption";
    private static final List<String> PHRASING_PARENTS;
    private static final String PHRASING_PARENT_ELEMENTS = "h1 | h2 | h3 | h4 | h5 | h6 | p | pre | figcaption | q | cite | em | strong | small | mark | dfn | abbr | time | progress | meter | code | var | samp | kbd | sub | sup | span | i | b | bdo | ruby | dt | rt | rp | th | legend | label | button | datalist | output | summary";
    private static final String ACCEPT = "accept";
    private static final String ALT = "alt";
    private static final String AUTOCOMPLETE = "autocomplete";
    private static final String CHECKED = "checked";
    private static final String FORMACTION = "formaction";
    private static final String FORMENCTYPE = "formenctype";
    private static final String FORMMETHOD = "formmethod";
    private static final String FORMNOVALIDATE = "formnovalidate";
    private static final String FORMTARGET = "formtarget";
    private static final String HEIGHT = "height";
    private static final String MAX = "max";
    private static final String MAXLENGTH = "maxlength";
    private static final String MIN = "min";
    private static final String MULTIPLE = "multiple";
    private static final String PATTERN = "pattern";
    private static final String PLACEHOLDER = "placeholder";
    private static final String READONLY = "readonly";
    private static final String REQUIRED = "required";
    private static final String SIZE = "size";
    private static final String SRC = "src";
    private static final String STEP = "step";
    private static final String WIDTH = "width";
    private static final String IMAGE = "image";
    private static final String CHARSET_MIDDLE = "_charset_";
    private static final String URL = "url";
    private static final String NUMBER = "number";
    private static final String CHARSET = "charset";
    private static final String CONTENT_LANG = "content-language";
    private static final String SOURCE = "source";
    private static final String COMMAND = "command";
    private static final String RADIOGROUP = "radiogroup";
    private static final String RADIO = "radio";
    private static final String CHECKBOX = "checkbox";
    private static final String DATA = "data";
    private static final String SUMMARY = "summary";
    private static final String LANGUAGE = "language";
    private static final String SCRIPT = "script";
    private static final String TEXT_JAVASCRIPT = "text/javascript";
    private static final String DEFAULT = "default";
    private static final char SPACE = ' ';
    private static final String[] FORM_ATTRS;
    private static Map<String, String[]> INPUT_TYPES;

    public HTMLValidation(DTDParser parser, String docType, boolean bestfit, MyReader myReader, String httpCharset, String bomCharset, String otherCharset) {
        this.bestfit = bestfit;
        this.myReader = myReader;
        this.encoder = parser.getEncoder();
        this.isXml = parser.isXml();
        this.elements = parser.getElements();
        this.docType = docType;
        this.isHtml5 = SupportedDTDs.isHTML5(docType);
        this.httpCharset = httpCharset;
        this.bomCharset = bomCharset;
        if (httpCharset != null || bomCharset != null || otherCharset != null) {
            this.charsetFound = true;
        }
    }

    @Override
    public void validate(List<Piece> pieces, Cancellor cancellor) throws ValidationException, CancelledException {
        this.ids = new HashMap<String, Piece>();
        this.names = new HashMap<String, Piece>();
        HTMLValidation.uniqueIdCheck(pieces, this.ids, this.names, true, "Anchor 'name' and 'id' attributes must be unique in the same document:", ValidationProblem.NON_UNIQUE_ID);
        this.firstTag = true;
        this.theFirstTag = null;
        boolean xmlDecFound = false;
        for (Piece piece : pieces) {
            cancellor.isCancelled();
            if (piece.isMalformed() || piece.getStrippedElement() == null) continue;
            if (this.isXml) {
                if (piece instanceof CData || piece.getElement(false).startsWith(AT)) continue;
                if (piece.getElement(false).startsWith(QUESTION_MARK)) {
                    boolean xmlDeclaration = false;
                    if (piece.getElement(false).equals(XML)) {
                        xmlDeclaration = true;
                        this.validateDeclaration(piece);
                    }
                    if (this.firstTag) {
                        if (!xmlDeclaration && !xmlDecFound) {
                            piece.setProblem(ValidationProblem.XML_DEC_NOT_FIRST);
                            continue;
                        }
                        xmlDecFound = true;
                        continue;
                    }
                    if (!xmlDeclaration) continue;
                    if (xmlDecFound) {
                        piece.setProblem(ValidationProblem.XML_DEC_DUPLICATE);
                    } else {
                        piece.setProblem(ValidationProblem.XML_DEC_NOT_FIRST);
                        this.firstTag = true;
                    }
                    xmlDecFound = true;
                    continue;
                }
            }
            this.checkElement(piece, pieces);
            if (!this.firstTag || piece.getText() == null || piece.getText().length() == 0) continue;
            this.theFirstTag = piece;
            this.firstTag = false;
        }
        if (this.theFirstTag != null) {
            if (this.myReader.getContentTypeHeader() != null) {
                this.checkContentType(this.theFirstTag, this.myReader.getContentTypeHeader(), true);
            }
            if (!this.charsetFound && this.myReader.isHttpStream()) {
                this.theFirstTag.setProblem(ValidationProblem.MISSING_CHARSET);
            }
        }
    }

    private void validateDeclaration(Piece piece) {
        Map<String, RealAttribute> attributes = piece.getAttributes();
        if (attributes == null) {
            piece.setProblem(ValidationProblem.MISSING_XML_VERSION);
        } else {
            boolean foundVersion = false;
            for (String attrName : attributes.keySet()) {
                String value;
                if (attrName.equals(VERSION)) {
                    foundVersion = true;
                    String version = piece.getAttr(VERSION);
                    if (version != null && version.equals("1.0")) continue;
                    piece.setProblemValue(ValidationProblem.BAD_XML_VERSION, VERSION);
                    continue;
                }
                if (attrName.equals(ENCODING)) {
                    value = piece.getAttr(ENCODING);
                    if (value == null || Attribute.validID(value, false) != -1 || value.indexOf(58) != -1) {
                        piece.setProblemValue(ValidationProblem.BAD_XML_ENCODING, ENCODING);
                        continue;
                    }
                    this.charsetFound = true;
                    this.validateEncoding(value, piece, ENCODING);
                    continue;
                }
                if (attrName.equals(STANDALONE)) {
                    value = piece.getAttr(STANDALONE);
                    if (value != null && (value.equals("yes") || value.equals("no"))) continue;
                    piece.setProblemValue(ValidationProblem.BAD_XML_STANDALONE, STANDALONE);
                    continue;
                }
                if (attrName.equals(QUESTION_MARK)) continue;
                piece.setProblemAttribute(ValidationProblem.UNKNOWN_XML_ATTRIBUTE, attrName);
            }
            if (!foundVersion) {
                piece.setProblem(ValidationProblem.MISSING_XML_VERSION);
            }
        }
    }

    private void checkElement(Piece piece, List<Piece> pieces) throws ValidationException {
        String element = piece.getElement(this.isXml);
        Piece parentTag = piece.getParent();
        if (piece.isSingleton() && piece instanceof Tag && !this.isXml && !this.isHtml5) {
            if (piece.getText() == null) {
                piece.setProblem(ValidationProblem.BAD_SINGLETON);
            } else {
                int len = piece.getText().length();
                piece.setProblem(ValidationProblem.BAD_SINGLETON, len - 1, len);
            }
        }
        if (!this.elements.containsKey(element)) {
            piece.setProblemElement(ValidationProblem.NO_SUCH_ELEMENT);
            return;
        }
        element = piece.getStrippedElement();
        Element e = this.elements.get(element);
        if (DOCTYPE.equals(element)) {
            String rootElement;
            if (parentTag != null) {
                piece.setProblemElement(ValidationProblem.TOP_LEVEL_ELEMENT);
            }
            if (!this.firstTag && (this.theFirstTag instanceof Tag || this.theFirstTag.getText() != null && this.theFirstTag.getText().length() != 0)) {
                piece.setProblemElement(ValidationProblem.NOT_FIRST_TAG);
            }
            if (this.isXml && !piece.getOrigElement(this.isXml).equals(DOCTYPE.toUpperCase())) {
                piece.setProblemElement(ValidationProblem.XML_DOCTYPE_MIXED_CASE);
            }
            Map<String, RealAttribute> attributes = piece.getAttributes();
            boolean foundType = false;
            boolean foundID = false;
            if (attributes != null) {
                for (RealAttribute attr : attributes.values()) {
                    String val = attr.getValue();
                    if (val.equals("NO_VAL")) continue;
                    if (val.equalsIgnoreCase(this.docType)) {
                        foundType = true;
                        continue;
                    }
                    if (!val.startsWith(HTTP)) continue;
                    foundID = true;
                }
            }
            if (this.isHtml5) {
                if (attributes == null || !attributes.containsKey(HTML)) {
                    piece.setProblem(ValidationProblem.MISSING_ROOT_ELEMENT);
                } else {
                    rootElement = piece.getOrigAttrName(HTML, false);
                    if (rootElement != null && this.isXml && !rootElement.equals(HTML)) {
                        piece.setProblemAttribute(ValidationProblem.ROOT_MIXED_CASE, HTML);
                    }
                }
                if (foundType) {
                    rootElement = piece.getOrigAttrName(HTML, false);
                    if (rootElement != null && this.isXml && !rootElement.equals(HTML)) {
                        piece.setProblemAttribute(ValidationProblem.ROOT_MIXED_CASE, HTML);
                    }
                    if (attributes == null || !attributes.containsKey(SYSTEM)) {
                        piece.setProblem(ValidationProblem.MISSING_SYSTEM_KEYWORD);
                    } else {
                        String systemKey = piece.getOrigAttrName(SYSTEM, false);
                        if (systemKey != null && this.isXml && !systemKey.equals(SYSTEM.toUpperCase())) {
                            piece.setProblemAttribute(ValidationProblem.SYSTEM_MIXED_CASE, SYSTEM);
                        }
                    }
                } else if (attributes != null && attributes.size() > 1) {
                    if (this.bestfit) {
                        piece.setProblem(ValidationProblem.WRONG_DOCTYPE_ERROR);
                    } else {
                        piece.setProblem(ValidationProblem.WRONG_DOCTYPE_WARNING);
                    }
                }
            } else if (!foundType) {
                if (this.bestfit) {
                    piece.setProblem(ValidationProblem.WRONG_DOCTYPE_ERROR);
                } else {
                    piece.setProblem(ValidationProblem.WRONG_DOCTYPE_WARNING);
                }
            } else {
                if (this.isXml && !foundID) {
                    piece.setProblem(ValidationProblem.MISSING_SYSTEM_ID);
                }
                if (attributes == null || !attributes.containsKey(HTML)) {
                    piece.setProblem(ValidationProblem.MISSING_ROOT_ELEMENT);
                } else {
                    rootElement = piece.getOrigAttrName(HTML, false);
                    if (rootElement != null && this.isXml && !rootElement.equals(HTML)) {
                        piece.setProblemAttribute(ValidationProblem.ROOT_MIXED_CASE, HTML);
                    }
                }
                if (attributes == null || !attributes.containsKey(PUBLIC)) {
                    piece.setProblem(ValidationProblem.MISSING_PUBLIC_KEYWORD);
                } else {
                    String publicKey = piece.getOrigAttrName(PUBLIC, false);
                    if (publicKey != null && this.isXml && !publicKey.equals(PUBLIC.toUpperCase())) {
                        piece.setProblemAttribute(ValidationProblem.PUBLIC_MIXED_CASE, PUBLIC);
                    }
                }
            }
        } else {
            String httpHeader;
            if (this.firstTag && (piece instanceof Tag || piece.getText() != null && piece.getText().length() != 0)) {
                piece.setProblem(ValidationProblem.MISSING_DOCTYPE);
            }
            if (this.isXml && piece instanceof Tag && !piece.getElement(this.isXml).equals(piece.getOrigElement(this.isXml))) {
                piece.setProblemElement(ValidationProblem.WRONG_CASE_ELEMENT);
            }
            if (piece.isEndTag()) {
                TagValidator validator;
                if (e.mustntHaveEndTag()) {
                    piece.setProblemElement(ValidationProblem.NO_END_TAG_ALLOWED);
                }
                if (piece.hasMatchingTag() && (validator = piece.getMatchingTag().getValidator()) != null) {
                    String missingElement = validator.finalise();
                    piece.removeValidator();
                    if (missingElement != null) {
                        piece.setProblem(new ValidationProblem("One or more of the following tags are missing from within the enclosing tag: " + missingElement, ValidationProblem.MISSING_ELEMENT));
                    }
                }
                return;
            }
            if (e.mustHaveEndTag() && !piece.hasMatchingTag() && !piece.isSingleton()) {
                piece.setProblemElement(ValidationProblem.MISSING_END_TAG);
            }
            piece.makeValidator(e);
            if (parentTag == null) {
                if (!HTML.equals(element) && (piece instanceof Tag || piece.getText() != null && piece.getText().length() != 0)) {
                    if (this.isXml) {
                        piece.setProblemElement(ValidationProblem.NOT_TOP_LEVEL_ELEMENT);
                    } else {
                        piece.setProblemElement(ValidationProblem.NOT_TOP_LEVEL_ELEMENT_OLD);
                    }
                }
            } else {
                if (HTML.equals(element)) {
                    piece.setProblemElement(ValidationProblem.TOP_LEVEL_ELEMENT);
                }
                ValidationProblem message = null;
                TagValidator validator = parentTag.getValidator();
                if (validator != null) {
                    message = validator.checkOrderedItems(element);
                    if ((message = this.checkInclusions(message, element, parentTag)) != null) {
                        piece.setProblemElement(message);
                    } else {
                        message = validator.checkUnorderedItems(element);
                        if ((message = this.checkInclusions(message, element, parentTag)) != null) {
                            piece.setProblemElement(message);
                        } else {
                            message = validator.inList(element);
                            if ((message = this.checkInclusions(message, element, parentTag)) != null) {
                                piece.setProblemElement(message);
                            } else {
                                message = this.checkExclusions(element, parentTag);
                                if (message != null) {
                                    piece.setProblemElement(message);
                                }
                            }
                        }
                    }
                }
                this.specificElementTests(element, piece, parentTag, pieces);
            }
            if (piece instanceof Tag) {
                this.checkAttributes(piece, pieces, e.getAttr());
            }
            if (META.equals(element) && (httpHeader = piece.getAttr(HTTP_EQUIV)) != null && piece.getAttr(CONTENT) != null) {
                if (SCRIPT_TYPE.equalsIgnoreCase(httpHeader)) {
                    this.scriptMetaTag = true;
                }
                if (STYLE_TYPE.equalsIgnoreCase(httpHeader)) {
                    this.styleMetaTag = true;
                }
            }
        }
    }

    private void specificElementTests(String element, Piece piece, Piece parentTag, List<Piece> pieces) {
        String parentElement = parentTag.getStrippedElement();
        if (parentElement == null) {
            return;
        }
        if (TABLE.equals(element) && (this.parentTagHasChild(piece, piece, pieces, THEAD) || this.parentTagHasChild(piece, piece, pieces, TFOOT)) && this.parentTagHasChild(piece, piece, pieces, TR) && !this.parentTagHasChild(piece, piece, pieces, TBODY)) {
            piece.getMatchingTag().setProblem(new ValidationProblem("One or more of the following tags are missing from within the enclosing tag: &lt;tbody&gt;", ValidationProblem.MISSING_ELEMENT));
        }
        if (this.isHtml5) {
            if (parentElement != null && NOSCRIPT.equals(parentElement) && HTMLValidation.getParentItem(parentTag, HEAD) != null && !LINK.equals(element) && !STYLE.equals(element) && !META.equals(element)) {
                piece.setProblemElement(ValidationProblem.INCORRECT_ELEMENT2);
            } else if (SOURCE.equals(element) && parentTag.getAttr(SRC) != null) {
                piece.setProblemElement(ValidationProblem.INCORRECT_ELEMENT2);
            } else if (AREA.equals(element)) {
                String shape;
                if (HTMLValidation.getParentItem(piece, MAP) == null) {
                    piece.setProblemElement(ValidationProblem.INCORRECT_ELEMENT2);
                }
                if ((shape = piece.getAttr(SHAPE)) != null && !DEFAULT.equals(shape) && piece.getAttr(COORDS) == null) {
                    piece.setProblem(new ValidationProblem("The 'coords' attribute for this tag is missing:", ValidationProblem.MISSING_ATTRIBUTE));
                }
            } else if (LINK.equals(element)) {
                if (piece.getAttr(ITEMPROP) == null && !HEAD.equals(parentElement) && !NOSCRIPT.equals(parentElement)) {
                    piece.setProblemElement(ValidationProblem.INCORRECT_ELEMENT2);
                }
                if (NOSCRIPT.equals(parentElement) && HTMLValidation.getParentItem(parentTag, HEAD) == null) {
                    piece.setProblemElement(ValidationProblem.INCORRECT_ELEMENT2);
                }
            } else if (META.equals(element)) {
                boolean itemprop;
                boolean name = piece.getAttr(NAME) != null;
                boolean equiv = piece.getAttr(HTTP_EQUIV) != null;
                boolean charset = piece.getAttr(CHARSET) != null;
                boolean bl = itemprop = piece.getAttr(ITEMPROP) != null;
                if (!name && !equiv && !charset && !itemprop || name && equiv || name && charset || name && itemprop || equiv && charset || equiv && itemprop || charset && itemprop) {
                    piece.setProblemElement(ValidationProblem.META_EXACTLY_ONE);
                }
                String content = piece.getAttr(CONTENT);
                if (charset) {
                    if (++this.charsetCount > 1) {
                        piece.setProblemAttribute(ValidationProblem.ONLY_ONE_CHARSET, CHARSET);
                    } else if (this.isXml && !"UTF-8".equalsIgnoreCase(piece.getAttr(CHARSET))) {
                        piece.setProblemValue(ValidationProblem.UTF8_ONLY, CHARSET);
                    }
                } else if (equiv && CONTENT_TYPE.equals(piece.getAttr(HTTP_EQUIV)) && content != null && content.indexOf(CHARSET) != -1) {
                    if (++this.charsetCount > 1) {
                        piece.setProblemValue(ValidationProblem.ONLY_ONE_CHARSET, CONTENT);
                    }
                    if (this.isXml) {
                        piece.setProblemAttribute(ValidationProblem.CHARSET_NOT_ALLOWED, CONTENT);
                    }
                }
                if ((name || equiv || itemprop) && content != null && content.length() == 0) {
                    piece.setProblemElement(ValidationProblem.BLANK_CONTENT);
                }
                if (equiv && CONTENT_LANG.equals(piece.getAttr(HTTP_EQUIV))) {
                    piece.setProblemValue(ValidationProblem.CONTENT_LANG, HTTP_EQUIV);
                }
                if (itemprop && !HEAD.equals(parentElement) && !NOSCRIPT.equals(parentElement)) {
                    piece.setProblemElement(ValidationProblem.INCORRECT_ELEMENT2);
                }
                if (NOSCRIPT.equals(parentElement) && HTMLValidation.getParentItem(parentTag, HEAD) == null) {
                    piece.setProblemElement(ValidationProblem.INCORRECT_ELEMENT2);
                }
            } else if (STYLE.equals(element)) {
                Map<String, RealAttribute> attrs = piece.getAttributes();
                if (!(attrs != null && attrs.containsKey(SCOPED) || HEAD.equals(parentElement) || NOSCRIPT.equals(parentElement))) {
                    piece.setProblemElement(ValidationProblem.INCORRECT_ELEMENT2);
                }
                if (NOSCRIPT.equals(parentElement) && HTMLValidation.getParentItem(parentTag, HEAD) == null) {
                    piece.setProblemElement(ValidationProblem.INCORRECT_ELEMENT2);
                }
            } else if (A.equals(element) || DEL.equals(element) || INS.equals(element) || MAP.equals(element) || CANVAS.equals(element) || AUDIO.equals(element) || VIDEO.equals(element) || NOSCRIPT.equals(element) || OBJECT.equals(element)) {
                Map<String, RealAttribute> attrs;
                if (PHRASING_PARENTS.contains(parentElement)) {
                    this.markChildren(piece, pieces, NOT_PHRASING);
                }
                if (OBJECT.equals(element) && ((attrs = piece.getAttributes()) == null || !attrs.containsKey(TYPE) && !attrs.containsKey(DATA))) {
                    piece.setProblem(new ValidationProblem("The 'type' or 'data' attribute for this tag is missing:", ValidationProblem.MISSING_ATTRIBUTE));
                }
            } else if (LI.equals(element) && piece.getAttr(VALUE) != null && !OL.equals(parentElement)) {
                piece.setProblemAttribute(new ValidationProblem("The 'value' attribute is not valid for this tag here:", ValidationProblem.NO_SUCH_ATTRIBUTE), VALUE);
            } else if (LI.equals(element) && MENU.equals(parentElement)) {
                this.diallowAllSiblings(parentTag, pieces, LI);
            } else if (OPTION.equals(element) && DATALIST.equals(parentElement)) {
                this.diallowAllSiblings(parentTag, pieces, OPTION);
            } else if (TABLE.equals(element)) {
                if (piece.hasMatchingTag()) {
                    int startIndex = pieces.indexOf(piece) + 1;
                    int endIndex = pieces.indexOf(piece.getMatchingTag());
                    ArrayList<Piece> tfoots = new ArrayList<Piece>();
                    for (int i = startIndex; i < endIndex; ++i) {
                        String e;
                        Piece t = pieces.get(i);
                        if (t.isEndTag() || t.getParent() != piece || (e = t.getStrippedElement()) == null || !TFOOT.equals(e)) continue;
                        tfoots.add(t);
                    }
                    if (tfoots.size() > 1) {
                        for (Piece t : tfoots) {
                            t.setProblemElement(ValidationProblem.ONLY_ONE_ALLOWED);
                        }
                    }
                }
                if (!this.parentTagHasChild(piece, piece, pieces, TR) && !this.parentTagHasChild(piece, piece, pieces, TBODY) && piece.hasMatchingTag()) {
                    piece.getMatchingTag().setProblem(new ValidationProblem("One or more of the following tags are missing from within the enclosing tag: &lt;tbody&gt; &lt;tr&gt;", ValidationProblem.MISSING_ELEMENT));
                }
            } else if (TBODY.equals(element) && TABLE.equals(parentElement) && this.parentTagHasChild(piece, parentTag, pieces, TR)) {
                piece.setProblemElement(ValidationProblem.INCORRECT_ELEMENT2);
            } else if (COL.equals(element) && parentTag.getAttr(SPAN) != null) {
                piece.setProblemElement(ValidationProblem.INCORRECT_ELEMENT2);
            } else if (TD.equals(element)) {
                Piece grandParent = parentTag.getParent();
                String grandParentElement = null;
                if (grandParent != null) {
                    grandParentElement = grandParent.getStrippedElement();
                }
                if (grandParentElement != null && THEAD.equals(grandParentElement)) {
                    piece.setProblemElement(ValidationProblem.INCORRECT_ELEMENT2);
                }
            } else if (FIGCAPTION.equals(element)) {
                if (!FIGURE.equals(parentElement)) {
                    piece.setProblemElement(ValidationProblem.INCORRECT_ELEMENT2);
                } else {
                    int startIndex = pieces.indexOf(parentTag) + 1;
                    int endIndex = pieces.indexOf(parentTag.getMatchingTag());
                    int childrenCount = 0;
                    int figCount = 0;
                    int index = 0;
                    for (int i = startIndex; i < endIndex; ++i) {
                        Piece t = pieces.get(i);
                        if (t.isEndTag() || t.getParent() != parentTag) continue;
                        ++childrenCount;
                        String e = t.getStrippedElement();
                        if (e == null || !FIGCAPTION.equals(e)) continue;
                        ++figCount;
                        if (t != piece) continue;
                        index = childrenCount;
                    }
                    if (index > 1 && index < childrenCount) {
                        piece.setProblemElement(ValidationProblem.INCORRECT_ELEMENT2);
                    }
                    if (figCount > 1) {
                        piece.setProblemElement(ValidationProblem.ONLY_ONE_ALLOWED);
                    }
                }
            }
            if (A.equals(parentElement) || BUTTON.equals(parentElement)) {
                Map<String, RealAttribute> attrs = piece.getAttributes();
                if ((AUDIO.equals(element) || VIDEO.equals(element)) && attrs != null && attrs.containsKey(CONTROLS)) {
                    piece.setProblemElement(ValidationProblem.INCORRECT_ELEMENT2);
                } else if ((IMG.equals(element) || OBJECT.equals(element)) && piece.getAttr(USEMAP) != null) {
                    piece.setProblemElement(ValidationProblem.INCORRECT_ELEMENT2);
                } else {
                    String type = piece.getAttr(TYPE);
                    if (INPUT.equals(element) && (type == null || !HIDDEN.equals(type))) {
                        piece.setProblemElement(ValidationProblem.INCORRECT_ELEMENT2);
                    } else if (MENU.equals(element) && type != null && TOOLBAR.equals(type)) {
                        piece.setProblemElement(ValidationProblem.INCORRECT_ELEMENT2);
                    }
                }
            }
        } else if ((DEL.equals(element) || INS.equals(element)) && INLINE_PARENTS.contains(parentElement)) {
            this.markChildren(piece, pieces, BLOCK);
        }
    }

    private void diallowAllSiblings(Piece parentTag, List<Piece> pieces, String childElement) {
        String tagElement = parentTag.getStrippedElement();
        if (tagElement == null) {
            return;
        }
        if (parentTag.hasMatchingTag()) {
            int startIndex = pieces.indexOf(parentTag) + 1;
            int endIndex = pieces.indexOf(parentTag.getMatchingTag());
            for (int i = startIndex; i < endIndex; ++i) {
                String element;
                Piece t = pieces.get(i);
                if (t.isEndTag() || t.getParent() != parentTag || (element = t.getStrippedElement()) != null && element.equals(childElement)) continue;
                t.setProblemElement(ValidationProblem.INCORRECT_ELEMENT2);
            }
        }
    }

    private boolean parentTagHasChild(Piece tag, Piece parentTag, List<Piece> tags, String childElement) {
        String tagElement = parentTag.getStrippedElement();
        if (tagElement == null) {
            return false;
        }
        if (parentTag.hasMatchingTag()) {
            int startIndex = tags.indexOf(parentTag) + 1;
            int endIndex = tags.indexOf(parentTag.getMatchingTag());
            for (int i = startIndex; i < endIndex; ++i) {
                String element;
                Piece t = tags.get(i);
                if (t.isEndTag() || t == tag || t.getParent() != parentTag || (element = t.getStrippedElement()) == null || !element.equals(childElement)) continue;
                return true;
            }
        }
        return false;
    }

    private void markChildren(Piece piece, List<Piece> pieces, List<String> theList) {
        String tagElement = piece.getStrippedElement();
        if (tagElement == null) {
            return;
        }
        if (piece.hasMatchingTag()) {
            int startIndex = pieces.indexOf(piece) + 1;
            int endIndex = pieces.indexOf(piece.getMatchingTag());
            for (int i = startIndex; i < endIndex; ++i) {
                String element;
                Piece t = pieces.get(i);
                if (t.isEndTag() || t.getParent() != piece || (element = t.getStrippedElement()) == null || !theList.contains(element)) continue;
                t.setProblemElement(ValidationProblem.INCORRECT_ELEMENT2);
            }
        }
    }

    private ValidationProblem checkExclusions(String element, Piece parentPiece) {
        ValidationProblem message = null;
        do {
            TagValidator validator;
            if ((validator = parentPiece.getValidator()) == null || !validator.excludes(element)) continue;
            message = ValidationProblem.INCORRECT_ELEMENT2;
            break;
        } while ((parentPiece = parentPiece.getParent()) != null);
        return message;
    }

    private ValidationProblem checkInclusions(ValidationProblem message, String element, Piece piece) {
        if (message != null && message.getShortMessage() == null) {
            boolean excluded = false;
            Piece parentPiece = piece;
            do {
                TagValidator validator;
                if ((validator = parentPiece.getValidator()) == null || !validator.excludes(element)) continue;
                excluded = true;
                break;
            } while ((parentPiece = parentPiece.getParent()) != null);
            boolean included = false;
            parentPiece = piece;
            TagValidator parentValidator = piece.getValidator();
            if (!excluded) {
                if (parentValidator != null && parentValidator.specialIncludes(element)) {
                    included = true;
                } else {
                    do {
                        TagValidator validator;
                        if ((validator = parentPiece.getValidator()) == null || !validator.includes(element)) continue;
                        included = true;
                        break;
                    } while ((parentPiece = parentPiece.getParent()) != null);
                }
            }
            message = !included ? (parentValidator != null ? parentValidator.allowedTags() : null) : null;
        }
        return message;
    }

    private void checkAttributes(Piece piece, List<Piece> pieces, Attribute attr) {
        Iterator<String> iter;
        Map<String, RealAttribute> attributes = piece.getAttributes();
        String element = piece.getStrippedElement();
        if (attributes == null) {
            if (attr == null) {
                return;
            }
            iter = attr.getRequiredIterator();
            while (iter.hasNext()) {
                String attrName = iter.next();
                piece.setProblem(new ValidationProblem("The '" + attrName + "' attribute for this tag is missing:", ValidationProblem.MISSING_ATTRIBUTE));
            }
        } else if (attr == null) {
            for (String attrName : attributes.keySet()) {
                if (attrName == null || attrName.equals("") || attrName.startsWith("NO_NAME")) continue;
                piece.setProblemAttribute(new ValidationProblem("The '" + attrName + "' attribute is not valid for this tag here:", ValidationProblem.NO_SUCH_ATTRIBUTE), attrName);
            }
        } else {
            for (String attrName : attributes.keySet()) {
                RealAttribute ra;
                if (attrName.length() == 0) continue;
                RealAttribute realAttr = attributes.get(attrName);
                String attrValue = realAttr.getValue();
                String context = null;
                if (COORDS.equals(attrName) && (ra = attributes.get(SHAPE)) != null) {
                    context = ra.getValue();
                }
                String origName = piece.getOrigAttrName(attrName, true);
                if (!(!this.isXml || origName == null || attrName.startsWith("NO_NAME") || attrName.equals(origName) || HTML.equals(element) && origName.equals("xsi:schemaLocation"))) {
                    piece.setProblemAttribute(ValidationProblem.WRONG_CASE_ATTRIBUTE, attrName);
                }
                origName = piece.getOrigAttrName(attrName, false);
                if (!(this.isXml || origName == null || attrName.startsWith("NO_NAME") || attrName.equalsIgnoreCase(origName))) {
                    piece.setProblemAttribute(new ValidationProblem("The '" + origName + "' attribute is not valid for this tag here:", ValidationProblem.NO_SUCH_ATTRIBUTE), attrName);
                }
                if (this.isHtml5 && attr.isEmbedOrDataAttribute(attrName) && !attrName.startsWith("xmlns:")) {
                    int index = attrName.indexOf(58) + 1;
                    if (index == 0) {
                        index = Attribute.validID(attrName, this.isXml);
                    }
                    if (index != -1) {
                        piece.setProblemAttribute(new ValidationProblem("The '" + attrName + "' attribute name has an invalid character at index: " + index, ValidationProblem.INVALID_ATTR_NAME), attrName);
                    }
                }
                if (!(attr.exists(attrName) || attrName.startsWith("NO_NAME") || this.isXml && HTML.equals(element) && origName.equals("xsi:schemaLocation"))) {
                    piece.setProblemAttribute(new ValidationProblem("The '" + attrName + "' attribute is not valid for this tag here:", ValidationProblem.NO_SUCH_ATTRIBUTE), attrName);
                    continue;
                }
                if (this.isXml) {
                    if (attrValue.equals("NO_VAL")) {
                        piece.setProblemAttribute(new ValidationProblem("The '" + attrName + "' attribute's value is missing:", ValidationProblem.MISSING_ATTR_VALUE), attrName);
                        continue;
                    }
                    if (HTML.equals(element) && (this.docType.indexOf(XHTML_11) != -1 || this.docType.indexOf(BASIC_11) != -1 || this.docType.indexOf(RDF) != -1)) {
                        if (attrName.equals("xmlns:xsi")) {
                            if (attrValue.equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
                            piece.setProblemValue(new ValidationProblem("The '" + attrName + "' attribute does not have a valid value: " + "It must be \"http://www.w3.org/2001/XMLSchema-instance\":", ValidationProblem.INVALID_ATTR_VALUE), attrName);
                            continue;
                        }
                        if (attrName.equals(VERSION)) {
                            if (this.docType.indexOf(XHTML_11) != -1 && !attrValue.equals("-//W3C//DTD XHTML 1.1//EN")) {
                                piece.setProblemValue(new ValidationProblem("The '" + attrName + "' attribute does not have a valid value: " + "It must be \"-//W3C//DTD XHTML 1.1//EN\":", ValidationProblem.INVALID_ATTR_VALUE), attrName);
                            } else if (this.docType.indexOf(BASIC_11) != -1 && !attrValue.equals("-//W3C//DTD XHTML Basic 1.1//EN")) {
                                piece.setProblemValue(new ValidationProblem("The '" + attrName + "' attribute does not have a valid value: " + "It must be \"-//W3C//DTD XHTML Basic 1.1//EN\":", ValidationProblem.INVALID_ATTR_VALUE), attrName);
                            }
                            if (this.docType.indexOf(RDF) == -1 || attrValue.equals("XHTML+RDFa 1.0") || attrValue.equals("XHTML+RDFa 1.1")) continue;
                            piece.setProblemValue(new ValidationProblem("The '" + attrName + "' attribute does not have a valid value: " + "It must be \"XHTML+RDFa 1.0\" or \"XHTML+RDFa 1.1\":", ValidationProblem.INVALID_ATTR_VALUE), attrName);
                            continue;
                        }
                        this.commonAttributeChecks(attrName, attrValue, element, piece, pieces, attr, context);
                        continue;
                    }
                    this.commonAttributeChecks(attrName, attrValue, element, piece, pieces, attr, context);
                    continue;
                }
                if (attrValue.equals("NO_VAL")) {
                    if (attr.isBoolean(attrName) || attr.isEmbedOrDataAttribute(attrName) || BORDER.equals(attrName) && this.docType.indexOf(HTML_40) != -1) continue;
                    piece.setProblemValue(new ValidationProblem("The '" + attrName + "' attribute does not have a valid value: ", ValidationProblem.INVALID_ATTR_VALUE), attrName);
                    continue;
                }
                if (attr.isBoolean(attrName) && !this.isHtml5) {
                    piece.setProblemValue(new ValidationProblem("The '" + attrName + "' attribute has a boolean value, and this may be ignored or cause errors in older browsers/robots:", ValidationProblem.XML_ATTRIBUTE), attrName);
                    continue;
                }
                this.commonAttributeChecks(attrName, attrValue, element, piece, pieces, attr, context);
            }
            iter = attr.getRequiredIterator();
            while (iter.hasNext()) {
                String attrName;
                attrName = iter.next();
                if (attributes.containsKey(attrName)) continue;
                piece.setProblem(new ValidationProblem("The '" + attrName + "' attribute for this tag is missing:", ValidationProblem.MISSING_ATTRIBUTE));
            }
            if (this.isHtml5 && INPUT.equals(element) && !attributes.containsKey(TYPE)) {
                this.checkInputTypes("text", attributes, piece);
            }
        }
        String attrName = XMLNS;
        if (this.isXml && HTML.equals(element) && (attributes == null || !attributes.containsKey(attrName))) {
            piece.setProblem(new ValidationProblem("The '" + attrName + "' attribute for this tag is missing:", ValidationProblem.MISSING_ATTRIBUTE));
        }
        if (this.isXml && !piece.isValuesInQuotes()) {
            piece.setProblem(ValidationProblem.MISSING_QUOTES);
        }
    }

    private void commonAttributeChecks(String attrName, String attrValue, String element, Piece piece, List<Piece> pieces, Attribute attr, String context) {
        String resultVal = attr.checkValue(attrName, attrValue, this.isXml, this.isHtml5, this.encoder, context);
        if (resultVal != null) {
            piece.setProblemValue(new ValidationProblem("The '" + attrName + "' attribute does not have a valid value: " + resultVal, ValidationProblem.INVALID_ATTR_VALUE), attrName);
        } else if (CONTENT.equals(attrName)) {
            String httpEquiv = piece.getAttr(HTTP_EQUIV);
            if (httpEquiv != null && CONTENT_TYPE.equalsIgnoreCase(httpEquiv)) {
                this.checkContentType(piece, attrValue, false);
            }
        } else if (ID.equals(attrName)) {
            this.checkIdAndName(attrValue, piece, element);
        } else if (XML_LANG.equals(attrName)) {
            String lang = piece.getAttr(LANG);
            if (lang != null) {
                if (!lang.equalsIgnoreCase(attrValue)) {
                    piece.setProblemValue(ValidationProblem.DIFFERENT_LANGS, XML_LANG);
                }
            } else if (this.isHtml5 && !this.isXml) {
                piece.setProblemValue(ValidationProblem.MISSING_LANG, XML_LANG);
            }
        } else if (intrinsicEvents.contains(attrName)) {
            if (!(this.myReader.isScriptLanguageHeader() || this.scriptMetaTag || this.isHtml5)) {
                piece.setProblemAttribute(ValidationProblem.DEFAULT_SCRIPTING_LANGUAGE, attrName);
            }
        } else if (STYLE.equals(attrName)) {
            if (!(this.myReader.isStyleLanguageHeader() || this.styleMetaTag || this.isHtml5)) {
                piece.setProblemAttribute(ValidationProblem.DEFAULT_STYLE_LANGUAGE, attrName);
            }
        } else if (FOR.equals(attrName) && LABEL.equals(element)) {
            HTMLValidation.findMatchingItem(attrValue, piece, FOR, element, this.ids, ValidationProblem.NO_MATCHING_CONTROL);
        } else if (FOR.equals(attrName) && OUTPUT.equals(element)) {
            StringTokenizer st = new StringTokenizer(attrValue);
            while (st.hasMoreTokens()) {
                HTMLValidation.findMatchingItem(st.nextToken(), piece, FOR, element, this.ids, ValidationProblem.NO_MATCHING_ID);
            }
        } else if (REFID.equals(attrName) && ITEMREF.equals(element)) {
            HTMLValidation.findMatchingItem(attrValue, piece, REFID, element, this.ids, ValidationProblem.NO_MATCHING_REFID);
        } else if (LIST.equals(attrName) && INPUT.equals(element)) {
            HTMLValidation.findMatchingItem(attrValue, piece, LIST, element, this.ids, ValidationProblem.NO_MATCHING_DATALIST);
        } else if (USEMAP.equals(attrName) && (this.docType.indexOf(XHTML_11) != -1 || this.docType.indexOf(RDF) != -1)) {
            HTMLValidation.findMatchingItem(attrValue, piece, USEMAP, element, this.ids, ValidationProblem.NO_MATCHING_MAP);
        } else if (CONTEXTMENU.equals(attrName)) {
            HTMLValidation.findMatchingItem(attrValue, piece, CONTEXTMENU, element, this.ids, ValidationProblem.NO_MATCHING_MENU);
        } else if (HEADERS.equals(attrName)) {
            StringTokenizer st = new StringTokenizer(attrValue);
            while (st.hasMoreTokens()) {
                HTMLValidation.findMatchingItem(st.nextToken(), piece, HEADERS, element, this.ids, ValidationProblem.NO_MATCHING_CELL);
            }
        } else if (FORM.equals(attrName)) {
            if (this.isHtml5) {
                HTMLValidation.findMatchingItem(attrValue, piece, FORM, element, this.ids, ValidationProblem.NO_MATCHING_FORM);
            } else {
                HTMLValidation.findMatchingItem(attrValue, piece, FORM, element, this.names, ValidationProblem.NO_MATCHING_FORM);
            }
        } else if (this.isHtml5) {
            Map<String, RealAttribute> attrs = piece.getAttributes();
            if (BORDER.equals(attrName) && IMG.equals(element)) {
                piece.setProblemAttribute(ValidationProblem.IMG_BORDER, BORDER);
            } else if (NAME.equals(attrName) && A.equals(element)) {
                piece.setProblemAttribute(ValidationProblem.A_NAME, NAME);
            } else if (SUMMARY.equals(attrName) && TABLE.equals(element)) {
                piece.setProblemAttribute(ValidationProblem.TABLE_SUMMARY, SUMMARY);
            } else if (LANGUAGE.equals(attrName) && SCRIPT.equals(element)) {
                String type;
                piece.setProblemAttribute(ValidationProblem.SCRIPT_LANGUAGE, LANGUAGE);
                if (attrs.containsKey(TYPE) && ((type = piece.getAttr(TYPE)) == null || !TEXT_JAVASCRIPT.equals(type))) {
                    piece.setProblemAttribute(ValidationProblem.SCRIPT_TYPE, TYPE);
                }
            } else if (USEMAP.equals(attrName) && attrValue.length() > 1 && attrValue.charAt(0) == '#') {
                HTMLValidation.findMatchingItem(attrValue.substring(1), piece, USEMAP, element, this.names, ValidationProblem.NO_MATCHING_MAP);
            } else if (TYPE.equals(attrName)) {
                if (COMMAND.equals(element)) {
                    if (!RADIO.equals(attrValue) && attrs.containsKey(RADIOGROUP)) {
                        piece.setProblemAttribute(new ValidationProblem("The 'radiogroup' attribute is not allowed in this context:", ValidationProblem.ATTRIBUTE_NOT_ALLOWED), RADIOGROUP);
                    }
                    if (!RADIO.equals(attrValue) && !CHECKBOX.equals(attrValue) && attrs.containsKey(CHECKED)) {
                        piece.setProblemAttribute(new ValidationProblem("The 'checked' attribute is not allowed in this context:", ValidationProblem.ATTRIBUTE_NOT_ALLOWED), CHECKED);
                    }
                } else if (BUTTON.equals(element)) {
                    if (RESET.equals(attrValue) || BUTTON.equals(attrValue)) {
                        for (String formAttr : FORM_ATTRS) {
                            if (!attrs.containsKey(formAttr)) continue;
                            piece.setProblemAttribute(new ValidationProblem("The '" + formAttr + "' attribute is not allowed in this context:", ValidationProblem.ATTRIBUTE_NOT_ALLOWED), formAttr);
                        }
                    }
                } else if (INPUT.equals(element)) {
                    this.checkInputTypes(attrValue, attrs, piece);
                    if (attrs.containsKey(VALUE)) {
                        if (HIDDEN.equals(attrValue) && attrs.containsKey(NAME) && CHARSET_MIDDLE.equals(piece.getAttr(NAME))) {
                            piece.setProblemAttribute(new ValidationProblem("The 'value' attribute is not allowed for this input 'type':", ValidationProblem.SIBLING_NOT_ALLOWED), VALUE);
                        } else if (URL.equals(attrValue)) {
                            resultVal = Attribute.validAbsUrl(piece.getAttr(VALUE));
                            if (resultVal != null) {
                                piece.setProblemValue(new ValidationProblem("The 'value' attribute does not have a valid value: " + resultVal, ValidationProblem.INVALID_ATTR_VALUE), VALUE);
                            }
                        } else if (NUMBER.equals(attrValue) && (resultVal = Attribute.validFloat(piece.getAttr(VALUE))) != null) {
                            piece.setProblemValue(new ValidationProblem("The 'value' attribute does not have a valid value: " + resultVal, ValidationProblem.INVALID_ATTR_VALUE), VALUE);
                        }
                    }
                    if (IMAGE.equals(attrValue) && !attrs.containsKey(ALT)) {
                        piece.setProblem(new ValidationProblem("The 'alt' attribute for this tag is missing:", ValidationProblem.MISSING_ATTRIBUTE));
                    }
                }
            }
        }
    }

    private void checkInputTypes(String attrValue, Map<String, RealAttribute> attrs, Piece piece) {
        if (INPUT_TYPES.containsKey(attrValue)) {
            String[] notAllowed = INPUT_TYPES.get(attrValue);
            for (int i = 0; i < notAllowed.length; ++i) {
                if (!attrs.containsKey(notAllowed[i])) continue;
                piece.setProblemAttribute(new ValidationProblem("The '" + notAllowed[i] + "' attribute is not allowed for this input 'type':", ValidationProblem.SIBLING_NOT_ALLOWED), notAllowed[i]);
            }
        }
    }

    private void checkIdAndName(String idValue, Piece piece, String element) {
        String name;
        if (nameTags.contains(element) && (name = piece.getAttr(NAME)) != null && !name.equals(idValue)) {
            piece.setProblemValue(ValidationProblem.DIFFERENT_ID_AND_NAME, ID);
            piece.setProblemValue(ValidationProblem.DIFFERENT_ID_AND_NAME, NAME);
        }
    }

    public static void uniqueIdCheck(List<Piece> pieces, Map<String, Piece> ids, Map<String, Piece> names, boolean nameCheck, String problemText, CoreProblem problem) {
        if (names == null) {
            names = new HashMap<String, Piece>();
        }
        HashMap<String, Piece> anames = new HashMap<String, Piece>();
        HashMap<String, Set<Piece>> matches = new HashMap<String, Set<Piece>>();
        for (Piece tag : pieces) {
            HashSet<Object> matchingTags;
            if (!(tag instanceof Tag) || tag.isEndTag() || tag.isVirtual()) continue;
            String id = tag.getAttr(ID);
            if (id != null) {
                HashSet<Piece> matchingTags2;
                id = id.toLowerCase(Locale.ENGLISH);
                if (ids.keySet().contains(id)) {
                    if (matches.keySet().contains(id)) {
                        matches.get(id).add(tag);
                    } else {
                        matchingTags2 = new HashSet<Piece>();
                        matchingTags2.add(ids.get(id));
                        matchingTags2.add(tag);
                        matches.put(id, matchingTags2);
                    }
                } else if (anames.keySet().contains(id) && tag != anames.get(id)) {
                    if (nameCheck) {
                        if (matches.keySet().contains(id)) {
                            matches.get(id).add(tag);
                        } else {
                            matchingTags2 = new HashSet();
                            matchingTags2.add(tag);
                            matches.put(id, matchingTags2);
                        }
                    }
                } else {
                    ids.put(id, tag);
                }
            }
            String name = tag.getAttr(NAME);
            String element = tag.getStrippedElement();
            if (name == null || element == null) continue;
            name = name.toLowerCase(Locale.ENGLISH);
            if (anames.keySet().contains(name) && A.equals(element)) {
                if (!nameCheck) continue;
                if (matches.keySet().contains(name)) {
                    matches.get(name).add(tag);
                    continue;
                }
                matchingTags = new HashSet<Object>();
                matchingTags.add(anames.get(name));
                matchingTags.add(tag);
                matches.put(name, matchingTags);
                continue;
            }
            if (ids.keySet().contains(name) && tag != ids.get(name) && A.equals(element)) {
                if (!nameCheck) continue;
                if (matches.keySet().contains(name)) {
                    matches.get(name).add(tag);
                    continue;
                }
                matchingTags = new HashSet();
                matchingTags.add(tag);
                matches.put(name, matchingTags);
                continue;
            }
            if (A.equals(element)) {
                anames.put(name, tag);
            }
            names.put(name, tag);
        }
        HTMLValidation.addProblemsWithLineNumbers(matches, problemText, problem, null);
    }

    static void addProblemsWithLineNumbers(Map<String, Set<Piece>> matches, String problemText, CoreProblem problem, String attrName) {
        for (String id : matches.keySet()) {
            Set<Piece> matchingTags = matches.get(id);
            if (matchingTags.size() == 1) continue;
            for (Piece tag : matchingTags) {
                int tagLine = tag.getLineNumber();
                TreeSet<Integer> lineNumbers = new TreeSet<Integer>();
                for (Piece tag2 : matchingTags) {
                    int lineNumber = tag2.getLineNumber();
                    if (lineNumber == tagLine) continue;
                    lineNumbers.add(lineNumber);
                }
                ValidationProblem vp = null;
                if (lineNumbers.size() > 0) {
                    StringBuilder list = new StringBuilder();
                    Iterator i$ = lineNumbers.iterator();
                    while (i$.hasNext()) {
                        int number = (Integer)i$.next();
                        list.append(number).append(' ');
                    }
                    vp = new ValidationProblem(problemText + " See matching tag(s) on line(s): " + list, problem);
                } else {
                    vp = new ValidationProblem(problemText, problem);
                }
                if (attrName == null) {
                    tag.setProblem(vp);
                    continue;
                }
                tag.setProblemValue(vp, attrName);
            }
        }
    }

    public static void findMatchingItem(String itemRef, Piece piece, String attrName, String inputElement, Map<String, Piece> items, ValidationProblem problem) {
        itemRef = itemRef.toLowerCase(Locale.ENGLISH);
        if (items.keySet().contains(itemRef)) {
            boolean foundMatch = false;
            Piece matchingTag = items.get(itemRef);
            String element = matchingTag.getStrippedElement();
            if (element != null) {
                if (REFID.equals(attrName)) {
                    foundMatch = true;
                } else if (FOR.equals(attrName) && OUTPUT.equals(inputElement)) {
                    foundMatch = true;
                } else if (FOR.equals(attrName) && LABEL.equals(inputElement)) {
                    String type;
                    if (BUTTON.equals(element) || SELECT.equals(element) || TEXTAREA.equals(element) || METER.equals(element) || OUTPUT.equals(element) || PROGRESS.equals(element) || OBJECT.equals(element) || ISINDEX.equals(element) || KEYGEN.equals(element)) {
                        Piece formTag = HTMLValidation.getParentItem(piece, FORM);
                        Piece matchingFormTag = HTMLValidation.getParentItem(matchingTag, FORM);
                        if (formTag != null && matchingFormTag != null && matchingFormTag == formTag) {
                            foundMatch = true;
                        }
                    } else if (INPUT.equals(element) && ((type = matchingTag.getAttr(TYPE)) == null || !HIDDEN.equalsIgnoreCase(type))) {
                        Piece formTag = HTMLValidation.getParentItem(piece, FORM);
                        Piece matchingFormTag = HTMLValidation.getParentItem(matchingTag, FORM);
                        if (formTag != null && matchingFormTag != null && matchingFormTag == formTag) {
                            foundMatch = true;
                        }
                    }
                } else if (USEMAP.equals(attrName) && MAP.equals(element)) {
                    foundMatch = true;
                } else if (LIST.equals(attrName) && DATALIST.equals(element)) {
                    foundMatch = true;
                } else if (CONTEXTMENU.equals(attrName) && MENU.equals(element)) {
                    foundMatch = true;
                } else if (HEADERS.equals(attrName) && (TH.equals(element) || TD.equals(element))) {
                    Piece tableTag = HTMLValidation.getParentItem(piece, TABLE);
                    Piece matchingTableTag = HTMLValidation.getParentItem(matchingTag, TABLE);
                    if (tableTag != null && matchingTableTag != null && matchingTableTag == tableTag) {
                        foundMatch = true;
                    }
                } else if (FORM.equals(attrName) && FORM.equals(element)) {
                    foundMatch = true;
                }
            }
            if (!foundMatch) {
                piece.setProblemValue(problem, attrName);
            }
        } else {
            piece.setProblemValue(problem, attrName);
        }
    }

    private static Piece getParentItem(Piece piece, String element) {
        Piece currentTag = piece;
        Piece parentTag = null;
        do {
            String parentElement = null;
            if ((currentTag = currentTag.getParent()) != null) {
                parentElement = currentTag.getStrippedElement();
            }
            if (parentElement == null || !parentElement.equals(element)) continue;
            parentTag = currentTag;
            break;
        } while (currentTag != null);
        return parentTag;
    }

    private void checkContentType(Piece piece, String type, boolean httpHeader) {
        if (type == null) {
            return;
        }
        type = type.trim().toLowerCase(Locale.ENGLISH);
        if (this.isXml) {
            if (!(type.startsWith("application/xhtml+xml") || type.startsWith("text/html") || type.startsWith("text/xml") || type.startsWith("application/xml"))) {
                if (httpHeader) {
                    piece.setProblem(ValidationProblem.BAD_XML_CONTENT_TYPE_HEADER);
                } else {
                    piece.setProblemValue(ValidationProblem.BAD_XML_CONTENT_TYPE, CONTENT);
                }
            } else if (type.startsWith("text/html") && (this.docType.indexOf(XHTML_11) != -1 || this.docType.indexOf(BASIC_11) != -1 || this.docType.indexOf(RDF) != -1)) {
                if (httpHeader) {
                    piece.setProblem(ValidationProblem.POOR_XML_CONTENT_TYPE_HEADER);
                } else {
                    piece.setProblemValue(ValidationProblem.POOR_XML_CONTENT_TYPE, CONTENT);
                }
            }
        } else if (!type.startsWith("text/html")) {
            if (httpHeader) {
                piece.setProblem(ValidationProblem.BAD_HTML_CONTENT_TYPE_HEADER);
            } else {
                piece.setProblemValue(ValidationProblem.BAD_HTML_CONTENT_TYPE, CONTENT);
            }
        }
        if (!httpHeader) {
            String typeCharset = FileUtils.getCharset(type, "CHARSET");
            if (typeCharset != null) {
                this.charsetFound = true;
                this.validateEncoding(typeCharset, piece, CONTENT);
            } else if (this.isHtml5) {
                piece.setProblemValue(ValidationProblem.MISSING_META_CHARSET, CONTENT);
            }
        }
    }

    private void validateEncoding(String charset, Piece piece, String attrName) {
        try {
            if (!Charset.isSupported(charset)) {
                piece.setProblemValue(ValidationProblem.BAD_CHARSET, attrName);
            } else if (this.httpCharset != null && !this.httpCharset.equalsIgnoreCase(charset)) {
                piece.setProblemValue(new ValidationProblem("The 'content-type' HTTP header specifies a character set of " + this.httpCharset + ", which is different to the value given here:", ValidationProblem.CHARSET_MISMATCH), attrName);
            } else if (this.bomCharset != null && !this.bomCharset.equalsIgnoreCase(charset)) {
                piece.setProblemValue(new ValidationProblem("The BOM specifies character set of " + this.bomCharset + ", which is different to the value given here:", ValidationProblem.CHARSET_MISMATCH_BOM), attrName);
            }
        }
        catch (IllegalCharsetNameException e) {
            piece.setProblemValue(ValidationProblem.BAD_CHARSET, attrName);
        }
    }

    static {
        nameTags.add(A);
        nameTags.add("applet");
        nameTags.add(FORM);
        nameTags.add("frame");
        nameTags.add("iframe");
        nameTags.add(IMG);
        nameTags.add(MAP);
        intrinsicEvents.add("onclick");
        intrinsicEvents.add("ondblclick");
        intrinsicEvents.add("onmousedown");
        intrinsicEvents.add("onmouseup");
        intrinsicEvents.add("onmouseover");
        intrinsicEvents.add("onmousemove");
        intrinsicEvents.add("onmouseout");
        intrinsicEvents.add("onkeypress");
        intrinsicEvents.add("onkeydown");
        intrinsicEvents.add("onkeyup");
        intrinsicEvents.add("onfocus");
        intrinsicEvents.add("onblur");
        intrinsicEvents.add("onsubmit");
        intrinsicEvents.add("onreset");
        intrinsicEvents.add("onselect");
        intrinsicEvents.add("onchange");
        intrinsicEvents.add("onload");
        intrinsicEvents.add("onunload");
        BLOCK = new ArrayList<String>();
        INLINE_PARENTS = new ArrayList<String>();
        NOT_PHRASING = new ArrayList<String>();
        PHRASING_PARENTS = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(FLOW_NOT_PHRASING_ELEMENTS, "|");
        while (st.hasMoreTokens()) {
            NOT_PHRASING.add(st.nextToken().trim());
        }
        st = new StringTokenizer(PHRASING_PARENT_ELEMENTS, "|");
        while (st.hasMoreTokens()) {
            PHRASING_PARENTS.add(st.nextToken().trim());
        }
        st = new StringTokenizer(BLOCK_ELEMENTS, "|");
        while (st.hasMoreTokens()) {
            BLOCK.add(st.nextToken().trim());
        }
        st = new StringTokenizer(INLINE_PARENT_ELEMENTS, "|");
        while (st.hasMoreTokens()) {
            INLINE_PARENTS.add(st.nextToken().trim());
        }
        FORM_ATTRS = new String[]{FORMACTION, FORMENCTYPE, FORMMETHOD, FORMNOVALIDATE, FORMTARGET};
        INPUT_TYPES = new HashMap<String, String[]>();
        String[] notAllowed = new String[]{ACCEPT, ALT, AUTOCOMPLETE, CHECKED, FORMACTION, FORMENCTYPE, FORMMETHOD, FORMNOVALIDATE, FORMTARGET, HEIGHT, LIST, MAX, MAXLENGTH, MIN, MULTIPLE, PATTERN, PLACEHOLDER, READONLY, REQUIRED, SIZE, SRC, STEP, WIDTH};
        INPUT_TYPES.put(HIDDEN, notAllowed);
        INPUT_TYPES.put(RESET, notAllowed);
        INPUT_TYPES.put(BUTTON, notAllowed);
        String[] notAllowed2 = new String[]{ACCEPT, ALT, CHECKED, FORMACTION, FORMENCTYPE, FORMMETHOD, FORMNOVALIDATE, FORMTARGET, HEIGHT, MAX, MIN, MULTIPLE, SRC, STEP, WIDTH};
        INPUT_TYPES.put("text", notAllowed2);
        INPUT_TYPES.put("search", notAllowed2);
        INPUT_TYPES.put(URL, notAllowed2);
        INPUT_TYPES.put("tel", notAllowed2);
        String[] notAllowed3 = new String[]{ACCEPT, ALT, CHECKED, FORMACTION, FORMENCTYPE, FORMMETHOD, FORMNOVALIDATE, FORMTARGET, HEIGHT, MAX, MIN, SRC, STEP, WIDTH};
        INPUT_TYPES.put("email", notAllowed3);
        String[] notAllowed4 = new String[]{ACCEPT, ALT, CHECKED, FORMACTION, FORMENCTYPE, FORMMETHOD, FORMNOVALIDATE, FORMTARGET, HEIGHT, LIST, MAX, MIN, MULTIPLE, SRC, STEP, WIDTH};
        INPUT_TYPES.put("password", notAllowed4);
        String[] notAllowed5 = new String[]{ACCEPT, ALT, CHECKED, FORMACTION, FORMENCTYPE, FORMMETHOD, FORMNOVALIDATE, FORMTARGET, HEIGHT, MAXLENGTH, MULTIPLE, PATTERN, PLACEHOLDER, SIZE, SRC, WIDTH};
        INPUT_TYPES.put("datetime", notAllowed5);
        INPUT_TYPES.put("date", notAllowed5);
        INPUT_TYPES.put("month", notAllowed5);
        INPUT_TYPES.put("week", notAllowed5);
        INPUT_TYPES.put("time", notAllowed5);
        INPUT_TYPES.put("datetime-local", notAllowed5);
        INPUT_TYPES.put(NUMBER, notAllowed5);
        String[] notAllowed6 = new String[]{ACCEPT, ALT, CHECKED, FORMACTION, FORMENCTYPE, FORMMETHOD, FORMNOVALIDATE, FORMTARGET, HEIGHT, MAXLENGTH, MULTIPLE, PATTERN, PLACEHOLDER, READONLY, REQUIRED, SIZE, SRC, WIDTH};
        INPUT_TYPES.put("range", notAllowed6);
        String[] notAllowed7 = new String[]{ACCEPT, ALT, CHECKED, FORMACTION, FORMENCTYPE, FORMMETHOD, FORMNOVALIDATE, FORMTARGET, HEIGHT, MAX, MAXLENGTH, MIN, MULTIPLE, PATTERN, PLACEHOLDER, READONLY, REQUIRED, SIZE, SRC, STEP, WIDTH};
        INPUT_TYPES.put("color", notAllowed7);
        String[] notAllowed8 = new String[]{ACCEPT, ALT, AUTOCOMPLETE, FORMACTION, FORMENCTYPE, FORMMETHOD, FORMNOVALIDATE, FORMTARGET, HEIGHT, LIST, MAX, MAXLENGTH, MIN, MULTIPLE, PATTERN, PLACEHOLDER, READONLY, SIZE, SRC, STEP, WIDTH};
        INPUT_TYPES.put(CHECKBOX, notAllowed8);
        INPUT_TYPES.put(RADIO, notAllowed8);
        String[] notAllowed9 = new String[]{ALT, AUTOCOMPLETE, CHECKED, FORMACTION, FORMENCTYPE, FORMMETHOD, FORMNOVALIDATE, FORMTARGET, HEIGHT, LIST, MAX, MAXLENGTH, MIN, PATTERN, PLACEHOLDER, READONLY, SIZE, SRC, STEP, WIDTH};
        INPUT_TYPES.put("file", notAllowed9);
        String[] notAllowed10 = new String[]{ACCEPT, ALT, AUTOCOMPLETE, CHECKED, HEIGHT, LIST, MAX, MAXLENGTH, MIN, MULTIPLE, PATTERN, PLACEHOLDER, READONLY, REQUIRED, SIZE, SRC, STEP, WIDTH};
        INPUT_TYPES.put("submit", notAllowed10);
        String[] notAllowed11 = new String[]{ACCEPT, AUTOCOMPLETE, CHECKED, LIST, MAX, MAXLENGTH, MIN, MULTIPLE, PATTERN, PLACEHOLDER, READONLY, REQUIRED, SIZE, STEP};
        INPUT_TYPES.put(IMAGE, notAllowed11);
    }
}

