/*
 * Decompiled with CFR 0.152.
 */
package com.totalvalidator.snapshot;

import com.totalvalidator.app.AuthenticationDialog;
import com.totalvalidator.exceptions.ValidationException;
import com.totalvalidator.parser.CommandLineParser;
import com.totalvalidator.snapshot.Snapshot;
import com.totalvalidator.utils.FileUtils;
import com.totalvalidator.utils.GeneralUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;

public class SnapshotThread
extends Thread {
    private static final String ONLINE_SERVICE = GeneralUtils.getAppServerHome() + "/validator/Revalidate";
    private static final String MULTIPART_BOUNDARY = "-----------------------------4713348823330";
    private static final String MULTIPART_PREFIX = "-------------------------------4713348823330\r\nContent-Disposition: form-data; name=\"";
    private static final String MULTIPART_SUFFIX = "\r\n-------------------------------4713348823330--";
    private static final String MULTIPART_LF = "\r\n";
    public static final long INDIVIDUAL_MAX_TIME = 600000L;
    public static final long OVERALL_MAX_TIME = 1200000L;
    private String[] browsersToUse;
    private String theUrl;
    private String outputDir;
    private boolean returning;
    private boolean savePicture;
    private long waitTime;
    private String resolution;
    private List<String> fileNames = new ArrayList<String>();
    private boolean tool;
    private CommandLineParser clp;
    private String emailAddress;
    private Snapshot[] snapshot;

    public SnapshotThread(String theUrl, String outputDir, boolean savePicture, CommandLineParser clp, boolean tool) {
        this.theUrl = theUrl;
        this.outputDir = outputDir;
        this.returning = tool || !clp.isAddress();
        this.savePicture = savePicture;
        this.tool = tool;
        this.clp = clp;
        this.browsersToUse = clp.getBrowsers();
        this.waitTime = clp.getWaitTime();
        this.resolution = clp.getResolution();
        this.emailAddress = clp.isAddress() ? clp.getToAddress() : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        int i;
        if (this.tool) {
            StringBuilder validateurl;
            block27: {
                GeneralUtils.LOGGER.fine("In SnapshotThread");
                validateurl = new StringBuilder(ONLINE_SERVICE);
                if (this.clp.isUploadOnline() || this.clp.getSourceName() != null) {
                    GeneralUtils.LOGGER.fine("Getting Page Source");
                    String pageSource = this.getPageSource();
                    if (pageSource == null) {
                        int i2 = 0;
                        while (i2 < this.browsersToUse.length) {
                            this.fileNames.add('B' + this.browsersToUse[i2]);
                            this.fileNames.add("Could not read the page source for snapshot");
                            ++i2;
                        }
                        return;
                    }
                    GeneralUtils.LOGGER.fine("Posting");
                    String uploadedPath = this.postToOnlineService(pageSource);
                    if (uploadedPath == null) {
                        int i3 = 0;
                        while (i3 < this.browsersToUse.length) {
                            this.fileNames.add('B' + this.browsersToUse[i3]);
                            this.fileNames.add("The online service could not be reached at this time. Please try again later.");
                            ++i3;
                        }
                        return;
                    }
                    if (uploadedPath.indexOf("testpage") == 0) {
                        validateurl.append("?revalidateurl=url2&filename=").append(this.encodeURIComponent(uploadedPath));
                        break block27;
                    } else {
                        GeneralUtils.LOGGER.severe(uploadedPath);
                        int i4 = 0;
                        while (i4 < this.browsersToUse.length) {
                            this.fileNames.add('B' + this.browsersToUse[i4]);
                            this.fileNames.add("The online service could not be reached at this time. Please try again later.");
                            ++i4;
                        }
                        return;
                    }
                }
                validateurl.append("?revalidateurl=").append(this.encodeURIComponent(this.theUrl));
            }
            for (int i5 = 0; i5 < this.browsersToUse.length; ++i5) {
                validateurl.append("&screenshot=").append(this.encodeURIComponent(this.browsersToUse[i5]));
            }
            validateurl.append("&resolution=").append(this.encodeURIComponent(this.resolution));
            validateurl.append("&delay=").append(this.encodeURIComponent(this.waitTime + ""));
            validateurl.append("&tool=true&dtd=false&checklinks=false");
            if (this.emailAddress != null) {
                validateurl.append("&email=").append(this.encodeURIComponent(this.emailAddress));
                validateurl.append("&suffix=").append(this.encodeURIComponent(this.clp.getSuffix()));
                URL[] urls = new URL[2];
                try {
                    urls[0] = new URL(validateurl.toString());
                    FileUtils.getReader(urls, false, this.clp, null, false, null);
                    return;
                }
                catch (MalformedURLException e) {
                    GeneralUtils.LOGGER.log(Level.SEVERE, "Invalid URL: " + validateurl, e);
                    return;
                }
                catch (ValidationException e) {
                    GeneralUtils.LOGGER.log(Level.SEVERE, "Screenshot failed", e);
                    return;
                }
            }
            try {
                GeneralUtils.launchBrowser(validateurl.toString());
                return;
            }
            catch (Exception e) {
                GeneralUtils.LOGGER.log(Level.SEVERE, "Failed to launch browser", e);
                int i6 = 0;
                while (i6 < this.browsersToUse.length) {
                    this.fileNames.add('B' + this.browsersToUse[i6]);
                    this.fileNames.add("The online service could not be reached at this time. Please try again later.");
                    ++i6;
                }
                return;
            }
        }
        HashMap<String, ArrayList<String>> browserLists = new HashMap<String, ArrayList<String>>();
        for (i = 0; i < this.browsersToUse.length; ++i) {
            String host = Snapshot.browserHosts.get(this.browsersToUse[i]);
            ArrayList<String> browserList = (ArrayList<String>)browserLists.get(host);
            if (browserList == null) {
                browserList = new ArrayList<String>();
                browserLists.put(host, browserList);
            }
            browserList.add(this.browsersToUse[i]);
        }
        this.snapshot = new Snapshot[browserLists.size()];
        i = 0;
        for (ArrayList<String> browserList : browserLists.values()) {
            this.snapshot[i] = new Snapshot(browserList, this.theUrl, this.outputDir, this.returning, this.savePicture, this.waitTime, this.resolution);
            this.snapshot[i++].start();
        }
        i = 0;
        while (i < this.snapshot.length) {
            try {
                this.snapshot[i].join(600000L);
            }
            catch (InterruptedException e) {
                GeneralUtils.LOGGER.log(Level.SEVERE, "Interrupted waiting for Snapshots to return", e);
            }
            if (this.snapshot[i].isAlive()) {
                this.snapshot[i].interrupt();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.snapshot[i].isAlive()) {
                    this.snapshot[i].closeConnection();
                }
            }
            this.fileNames.addAll(this.snapshot[i].getSnapshots());
            ++i;
        }
    }

    private String encodeURIComponent(String theString) {
        try {
            return URLEncoder.encode(theString, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return theString;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getPageSource() {
        StringBuilder sb = new StringBuilder();
        URL[] urls = new URL[2];
        BufferedReader br = null;
        urls[0] = new URL(this.theUrl);
        br = new BufferedReader(FileUtils.getReader(urls, true, this.clp, null, false, null).getReader());
        String line = null;
        while ((line = br.readLine()) != null) {
            sb.append(line).append("\n");
        }
        Object var7_6 = null;
        if (br == null) return sb.toString();
        try {
            br.close();
            return sb.toString();
        }
        catch (IOException e2) {}
        return sb.toString();
        {
            catch (Exception e) {
                GeneralUtils.LOGGER.log(Level.SEVERE, "Could not read page: " + this.theUrl, e);
                String string = null;
                Object var7_7 = null;
                if (br == null) return string;
                try {
                    br.close();
                    return string;
                }
                catch (IOException e2) {
                    // empty catch block
                }
                return string;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (br == null) throw throwable;
            try {
                br.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String postToOnlineService(String pageSource) {
        String results;
        block34: {
            IOException e2;
            HttpURLConnection httpConnection;
            PrintWriter pw;
            BufferedReader br;
            block31: {
                block32: {
                    br = null;
                    pw = null;
                    httpConnection = null;
                    results = null;
                    URL url = new URL(ONLINE_SERVICE);
                    URLConnection connection = url.openConnection();
                    if (connection instanceof HttpURLConnection) {
                        GeneralUtils.logProxies(url);
                        boolean notAuthenticated = true;
                        while (notAuthenticated) {
                            Object var12_12;
                            notAuthenticated = false;
                            httpConnection = (HttpURLConnection)connection;
                            httpConnection.setDoInput(true);
                            httpConnection.setDoOutput(true);
                            httpConnection.setRequestMethod("POST");
                            httpConnection.setRequestProperty("content-type", "multipart/form-data; boundary=-----------------------------4713348823330");
                            StringBuilder sb = new StringBuilder();
                            if (pageSource != null) {
                                sb.append(MULTIPART_PREFIX).append("type\"\r\n\r\nfile").append(MULTIPART_LF);
                                sb.append(MULTIPART_PREFIX).append("revalidateurl\"\r\n\r\nurl2").append(MULTIPART_LF);
                                sb.append(MULTIPART_PREFIX).append("url2\"; filename=\"validator.html\"\r\n'");
                                sb.append("Content-Type: text/html\r\n\r\n");
                                sb.append(pageSource);
                            } else {
                                sb.append(MULTIPART_PREFIX).append("type\"\r\n\r\nurl").append(MULTIPART_LF);
                                sb.append(MULTIPART_PREFIX).append("url\"\r\n\r\n").append(this.theUrl);
                            }
                            sb.append(MULTIPART_SUFFIX);
                            pw = new PrintWriter(httpConnection.getOutputStream());
                            pw.println(sb.toString());
                            pw.close();
                            pw = null;
                            httpConnection.connect();
                            int response = -1;
                            try {
                                response = httpConnection.getResponseCode();
                                var12_12 = null;
                            }
                            catch (Throwable throwable) {
                                var12_12 = null;
                                results = FileUtils.getContent(httpConnection);
                                throw throwable;
                            }
                            results = FileUtils.getContent(httpConnection);
                            if (response == 407) {
                                if (AuthenticationDialog.getAuthDetails(null, httpConnection, true, ONLINE_SERVICE, Integer.MAX_VALUE) != -1) {
                                    connection = url.openConnection();
                                    notAuthenticated = true;
                                    continue;
                                }
                                results = null;
                                continue;
                            }
                            if (response == 200) continue;
                            results = null;
                        }
                    }
                    Object var14_14 = null;
                    if (httpConnection == null) break block31;
                    if (br == null) break block32;
                    try {
                        while (br.readLine() != null) {
                        }
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                FileUtils.readStream(httpConnection);
            }
            if (pw != null) {
                pw.close();
                pw = null;
            }
            if (br == null) break block34;
            try {
                br.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
            br = null;
            {
                break block34;
                catch (IOException e3) {
                    GeneralUtils.LOGGER.log(Level.SEVERE, "Problem talking to online server", e3);
                    results = null;
                    Object var14_15 = null;
                    if (httpConnection != null) {
                        if (br != null) {
                            try {
                                while (br.readLine() != null) {
                                }
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                        }
                        FileUtils.readStream(httpConnection);
                    }
                    if (pw != null) {
                        pw.close();
                        pw = null;
                    }
                    if (br == null) break block34;
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    br = null;
                }
            }
            catch (Throwable throwable) {
                Object var14_16 = null;
                if (httpConnection != null) {
                    if (br != null) {
                        try {
                            while (br.readLine() != null) {
                            }
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    FileUtils.readStream(httpConnection);
                }
                if (pw != null) {
                    pw.close();
                    pw = null;
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                    br = null;
                }
                throw throwable;
            }
        }
        return results;
    }

    public String[] getSnapshots() {
        String[] names = new String[this.fileNames.size()];
        this.fileNames.toArray(names);
        return names;
    }

    public void closeConnections() {
        if (this.snapshot != null) {
            for (int i = 0; i < this.snapshot.length; ++i) {
                if (this.snapshot[i] == null || !this.snapshot[i].isAlive()) continue;
                this.snapshot[i].interrupt();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!this.snapshot[i].isAlive()) continue;
                this.snapshot[i].closeConnection();
            }
        }
    }
}

