; GIMP Dynamic Text Test Script  for GIMP 1.0
;   <Toolbox>/Xtns/Script-Fu/Logos/Dynamic Text Test
; Copyright (C) 1998 Marco Lamberto <lm@geocities.com>
; Web page: http://www.geocities.com/Tokyo/1474/gimp/
;
; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.


(define (script-fu-dynamic-text-test)
  (let* (
    (image  0)
    (layer  0)
    (oldfg  0)
    (oldbg  0)
    (nlayer  0)
  ))

; create the image
  (set! image (car (gimp-image-new 256 256 RGB)))
  (gimp-undo-push-group-start image)
  (set! layer (car (gimp-layer-new image 256 256 RGB_IMAGE
    "Background" 100 NORMAL)))

; attach the background layer
  (gimp-image-add-layer image layer 0)
  (gimp-image-set-active-layer image layer)

; paint the background layer
  (set! oldfg (car (gimp-palette-get-foreground)))
  (set! oldbg (car (gimp-palette-get-background)))
  (gimp-palette-set-background '(0 0 0))
  (gimp-drawable-fill layer BG-IMAGE-FILL)
  (gimp-palette-set-background '(255 255 255))
  (gimp-rect-select image 0 0 52 256 REPLACE 0 0)
  (gimp-bucket-fill image layer BG-BUCKET-FILL NORMAL 100 0 FALSE 1 1)
  (gimp-selection-clear image)
  (gimp-palette-set-foreground oldfg)
  (gimp-palette-set-background oldbg)
  
; first gdt layer
  (set! nlayer (car (plug-in-dynamic-text 1 image layer
    "GDynText"
    "ransomnote" "medium" "r" "normal" 50 0 TRUE 0 -90 0 '(170 170 170))))
  (gimp-layer-set-offsets nlayer 1 18)

; second gdt layer
  (set! nlayer (car (plug-in-dynamic-text 1 image layer
    "GIMP Dynamic Text\nis a GIMP 1.0 plug-in\nthat works like the text\ntool but allows you\nwriting multi-line text\nand made you able of\nmodifying it later as\nyou want."
    "helvetica" "black" "r" "condensed" 20 0 TRUE 0 0 0 '(170 170 170))))
  (gimp-layer-set-offsets nlayer 54 38)

; ending touch ;)
  (gimp-image-set-active-layer image layer)
  (gimp-undo-push-group-end image)
  (gimp-display-new image)
  (gimp-displays-flush)
)



(script-fu-register "script-fu-dynamic-text-test"
  "<Toolbox>/Xtns/Script-Fu/Test/Dynamic Text"
  "GDynText Test"
  "Marco Lamberto <lm@geocities.com>"
  "Marco Lamberto"
  "Jan 1999"
  "")

; vim: set ts=2 sw=2 tw=79 ai nowrap:
