:userdoc.
:docprof toc=1234.

:title.Texi2ipf
:h1.Title page
:lines align=center.
Texi2ipf 2&per.1 -- a Texinfo to IPF converter
:elines.
:lines align=center.
Based on work by M&per. Groeber and B&per. A&per. Erlenbacher
:elines.
:lines align=center.
 Martin "Herbert" Dietze
:elines.
:p.:p.:p.
:p.Copyright (C) 1996, 1997 by Herbert&per.
:p.Permission is granted to make and distribute verbatim or modified copies
of this manual in terms of the Copyright notice below&per.
:p.Permission is granted to copy and distribute translations of this manual
into another language, under the above conditions&per.
:h1 id='Top'.Top
:p.This manual provides some information about using texi2ipf, a Texinfo to
IPF converter&per. It can also be used as test file for texi2ipf's output&per.
:p.:parml tsize=40 break=none compact.
:pt.:link reftype=hd refid='Introduction'.Introduction:elink.:pd.Historical notes etc&per.
:pt.:link reftype=hd refid='Using it'.Using it:elink.:pd.Usage and basic features&per.
:pt.:link reftype=hd refid='Change log'.Change log:elink.:pd.What I did to it and when&per.
:eparml.
:p.
:h1 id='Introduction'.Introduction
:p.:parml tsize=40 break=none compact.
:pt.:link reftype=hd refid='Historical notice'.Historical notice:elink.:pd.Its roots&per.
:pt.:link reftype=hd refid='Further notices'.Further notices:elink.:pd.What you might like to know&per.
:eparml.
:p.
:h2 id='Historical notice'.Historical notice
:p.The :hp1.texi2ipf:ehp1. program is mainly Beverly A&per. Eschenbacher's work
from 1988, 1989 and 1990 as his :hp1.texi2roff:ehp1. was the base for Marcus
Groebner making a Texinfo to IPF converter out of it in 1992/93&per.
:p.As I needed a tool to convert my master's thesis written in Texinfo to
IPF I tried it but found it not suitable for my needs -- it did not
treat :hp1.@def*:ehp1. templates correctly and produced blank pages where I
had menus in my sources&per. So I decided to take a closer look at the
sources and add the features I found missing and fix a few bugs I
found&per.
:p.I don't claim to have done much on the program, it is still mainly
Beverly's and Marcus' work but as nobody else seems to have maintained
it any more I have decided to make my modifications public, they have
made the program a bit more usable for me after all&per.
:p.The result works -- let's say -- not too bad, the sources look like what
they are&colon. the result of at least three people doing this or that &colon.-)
:p.
:h2 id='Further notices'.Further notices
:p.The program comes shipping as an OS/2 executable (compiled and linked
using IBM's VisualAge C++ tools) with Texinfo documentation (you are
just reading it!) and the C sources&per.
:p.Asking me for license stuff I can only say "no idea!" as it is not only
my work&per. As far as I'm concerned my stuff can be considered as GPL'ed,
nobody pays nobody nothing&per. You may also want to take a look at the
original license shipped with :hp1.texi2roff:ehp1. in the file
:hp1.copyright:ehp1. for all that was written by Beverly&per.
:p.If anybody of you out there adds some useful feature or fixes a bug
(there :hp1.should:ehp1. be some more) please feel free to send me a mail, I
am always interested in further enhancements&per. My email address is&colon.
:xmp.
  herbert@wiloyee&per.shnet&per.org
:exmp.
:font facename=default size=0x0.
:p.I will try to release all future versions to at least those two ftp
sites / directories&colon.
:ol.
:li.:font facename=Courier size=16x8.ftp&per.cdrom&per.com/pub/os2/:font facename=default size=0x0.
:li.:font facename=Courier size=16x8.ftp&per.leo&per.org/pub/comp/os/os2/leo/:font facename=default size=0x0.
:eol.
:p.By the way&colon. You may find this manual a bit too verbose for such a small
utility, it is indeed, but this also makes it a good demo file for the
program's capabilities&per.&per.&per.
:p.
:h1 id='Using it'.Using it
:p.:parml tsize=40 break=none compact.
:pt.:link reftype=hd refid='Usage'.Usage:elink.:pd.How to invoke it&per.
:pt.:link reftype=hd refid='Features'.Features:elink.:pd.What it can do&per.
:pt.:link reftype=hd refid='Limitations'.Limitations:elink.:pd.What it cannot do&per.
:pt.:link reftype=hd refid='Compiling it'.Compiling it:elink.:pd.Compatibility etc&per.
:eparml.
:p.
:h2 id='Usage'.Usage
:p.The program reads the Texinfo source, translates it and writes the
result to stdout&per. It has no further options&per. A sample invocation looks
like&colon.
:xmp.
texi2ipf texi2ipf&per.texi >texi2ipf&per.ipf
:exmp.
:font facename=default size=0x0.
:p.Redirecting the standard output to a file via ">" creates us an ipf
source that can be compiled via&colon.
:xmp.
ipfc -inf texi2ipf&per.ipf
:exmp.
:font facename=default size=0x0.
:p.If encountering a Texinfo command it does not recognize (there are still
some) it will ignore it and emit a warning message&per. If the Texinfo
commands ignored is not important for the ipf output the warnings can be
ignored&per. Only if the program runs into a situation it cannot recover
from it will abort with an error message&per. This is only very rarely the
case (e&per.g&per. not correctly nested :font facename=Courier size=16x8.@:font facename=default size=0x0.&per.&per. :font facename=Courier size=16x8.@end &per.&per.:font facename=default size=0x0.
environments)&per.
:p.The program can, of course, only handle standard Texinfo commands&per. It
will parse all :font facename=Courier size=16x8.@ifinfo:font facename=default size=0x0. &per.&per. :font facename=Courier size=16x8.@end:font facename=default size=0x0. ifinfo environments and
ignore all :font facename=Courier size=16x8.@tex:font facename=default size=0x0. &per.&per. :font facename=Courier size=16x8.@end tex:font facename=default size=0x0. environments&per. How it treats
some special Texinfo features will be described in the next section
(see :link reftype=hd  refid='Features'.Features:elink.)&per.
:p.
:h2 id='Features'.Features
:p.:hp5.Overall features:ehp5.
:p.Like mentioned in the previous section (see :link reftype=hd  refid='Usage'.Usage:elink.) the program parses
only :font facename=Courier size=16x8.@iftex:font facename=default size=0x0. &per.&per. :font facename=Courier size=16x8.@end iftex:font facename=default size=0x0. environments&per. As :hp1.info:ehp1. is
a hypertext format like :hp1.inf:ehp1. is there is only a small subset of
features not covered by both formats&per. One of them is the missing
handling of bitmaps in info, for this I use the pseudo-ipf tag
:font facename=Courier size=16x8.@ipfline{}:font facename=default size=0x0. described more below&per. Here's a list of further
features&colon.
:ul.
:li.:font facename=Courier size=16x8.@def*:font facename=default size=0x0. templates produce an entry in the main index&per. Using the
:font facename=Courier size=16x8.@cindex:font facename=default size=0x0. command will do this, too&per. Texinfo-like indices
(:font facename=Courier size=16x8.@printindex:font facename=default size=0x0.) are not (yet) supported&per. See :link reftype=hd  refid='Limitations'.Limitations:elink.
for more information&per.
:li.Texinfo menus are simulated&per. This is not really necessary but looks
better than blank pages&per. Please, note that menu descriptions continueing
in the line(s) after the menu entry will only be handled correctly if
indented more than 25 columns&per.
:li.The program will create a node for every document structuring command
except the :font facename=Courier size=16x8.@*heading:font facename=default size=0x0. commands (You see two of them in this
section!)&per.
:li.For being able to enter plain ipf code into the Texinfo document I
provide a pseudo-tag :font facename=Courier size=16x8.@ipfline{}:font facename=default size=0x0.&per. Its handling will be
described more verbosely below&per.
:eul.
:p.:hp5.Entering plain ipf:ehp5.
:p.As info knows no images inside info documents we may want to enter plain
ipf code into our Texinfo documents still being able to process them via
:hp1.makeinfo:ehp1., :hp1.texi2dvi:ehp1. etc&per. For this task :hp1.texi2ipf:ehp1.
recognizes a pseudo-tag :font facename=Courier size=16x8.@ipfline{}:font facename=default size=0x0. containing plain ipf code
as argument&per. To avoid conflicts with other formatting tools you should
use it the following way&colon.
:xmp.

@c Define this macro somewhere near the beginning of your document&per.
@c It expands to nothing for "makeinfo" and is necessary to avoid
@c errors when creating an Info file&per.
@c The "@ifinfo" block is necessary because the "@macro" command is
@c only known to "makeinfo"&per. Please, note that older versions of
@c "makeinfo" do not recognize the "@macro" command either&per.

@ifinfo
@macro ipfline{line}
@end macro
@end ifinfo

@c [&per.&per.&per.]

@c Now somewhere inside the document enter the ipf commands as
@c arguments to "@ipfline{}"&per. In this example we use plain
@c ipf to include a bitmap and some explaining text only into
@c the ipf output&per. Like the macro above we put in into a "@ifinfo"
@c block because the (empty) macro "@ipfline{}" would cause
@c errors to any formatter but "makeinfo" or "texi2ipf"&per.

@ifinfo
@ipfline{The following example shows a simple LAN consisting of}
@ipfline{three machines connected by a ring&amp.colon&per.}
@ipfline{&colon.p&per.&colon.artwork name='lan&per.bmp' align=center&per.}
@end ifinfo
:exmp.
:font facename=default size=0x0.
:p.This will enter the text and the bitmap into the ipf output just the
way it is inside of the :font facename=Courier size=16x8.@ipfline{}:font facename=default size=0x0. arguments&per.
:p.
:h2 id='Limitations'.Limitations
:p.Disregarding the fact that the program is still pretty buggy <g> there
are a few features I would like it to have but yet it has not&colon.
:ul.
:li.The program does not yet recognize all Texinfo commands&per. This is not so
bad as most of them are not of interest for producing ipf output&per. But
this still leads to unnecessary warning messages&per.
:li.There is no support for the :font facename=Courier size=16x8.@defindex:font facename=default size=0x0. and :font facename=Courier size=16x8.@printindex:font facename=default size=0x0.
commands&per. This results in almost empty pages only containing "Sorry, no
&per.&per. index!"&per. I plan to add this but I have no idea when&per.
:li.Footnotes produce text in "(" and ")" rather than real footnotes:link refid=1 reftype=fn.(1):elink.:fn id=1.Bla
blub:efn.&per.
:eul.
:p.
:h2 id='Compiling it'.Compiling it
:p.First thing I did when starting working on it was changing the code from
K&amp.R C to ANSI C&per. So it will not compile on a pre-ANSI C compiler any
more&per. It should not make any problems with non-Unix compilers any more
(emx/gcc offers all the Unix functions not available with other PC
compilers)&per.
:p.I have compiled the program using the following compilers / operating
systems&colon.
:ul.
:li.GNU CC under AIX and OS/2&per.
:li.IBM's xlC compiler under AIX&per.
:li.IBM's CSet++ 2&per.1 and VisualAge C++ 3&per.0 under OS/2&per.
:eul.
:p.The makefile contains predefined sections for those compilers that only
need to be uncommented&per.
:p.By the way&colon. Yes I know the code :hp1.is:ehp1. ugly&per. This is partially my
fault as I did not get into the way it works too much when I first
started modifying it&per. It also was quite unreadable when I took my first
look at it&per.&per.&per.
:p.
:h1 id='Change log'.Change log
:p.:parml tsize=40 break=none compact.
:pt.:link reftype=hd refid='Release 2&per.1'.Release 2&per.1:elink.:pd.The second public release&per.
:pt.:link reftype=hd refid='Release 2&per.0'.Release 2&per.0:elink.:pd.The first public release&per.
:eparml.
:p.
:h2 id='Release 2&per.1'.Release 2&per.1, February 1997
:ul.
:li.Added this documentation&per.
:li.Changed the handling of all :font facename=Courier size=16x8.@*heading:font facename=default size=0x0. commands and added the missing
:font facename=Courier size=16x8.@chapheading:font facename=default size=0x0. command&per. They will no longer produce nodes but rather
produce real headings like in the Info file&per.
:p.This makes it more consistent to the commands' definition saying they
do not generate Table-Of-Contents entries&per. Note, that all the other
:font facename=Courier size=16x8.@chapter:font facename=default size=0x0., :font facename=Courier size=16x8.@*section:font facename=default size=0x0., :font facename=Courier size=16x8.@unnumbered*:font facename=default size=0x0. commands do
:hp1.not:ehp1. generate headings inside the text window as these lines
appear in the title of the frame anyway&per.
:li.Upped stack size under OS/2 to 0x30000 Bytes&per.
:li.Changed the :font facename=Courier size=16x8.setclear():font facename=default size=0x0. and :font facename=Courier size=16x8.findtag():font facename=default size=0x0. routine&per. The program
now no longer crashes with large :font facename=Courier size=16x8.@set:font facename=default size=0x0. names&per.
:li.:font facename=Courier size=16x8.@ignore:font facename=default size=0x0. will now be handled like real comments&per.
:li.Fixed a bug in :font facename=Courier size=16x8.eat_first_word():font facename=default size=0x0. that made the program crash
sometimes&per.
:li.Fixed the handling of a few :font facename=Courier size=16x8.@def*:font facename=default size=0x0. commands (index entry)&per.
:li.Added routine :font facename=Courier size=16x8.remove_texicmds():font facename=default size=0x0. for better formatting of
automatically created index entries from :font facename=Courier size=16x8.@def*:font facename=default size=0x0. commands&per.
:li.Menu entry descriptions can now be continued in the next line(s) if
indented more than 25 columns&per. Also use :font facename=Courier size=16x8.remove_texicmds():font facename=default size=0x0. when
processing menu entries&per.
:li.Added support for the :font facename=Courier size=16x8.@bye:font facename=default size=0x0. tag for leaving the document before
the physical end of file&per.
:eul.
:p.
:h2 id='Release 2&per.0'.Release 2&per.0, December 1996
:ul.
:li.Converted any K&amp.R stuff to ANSI C (prototypes etc&per.)&per. Still the code
looks rather shrouded &colon.-)
:li.Changed the table&per.h for a better handling of all the :font facename=Courier size=16x8.@def*:font facename=default size=0x0. stuff&per. Now
any definition will start with a new paragraph&per. The leading "--" will
not appear anymore&per. I also added the :font facename=Courier size=16x8.@deftp:font facename=default size=0x0. command and the pseudo-
Texinfo command :font facename=Courier size=16x8.@ifhtml:font facename=default size=0x0. (ignored, no error message) that may be used
by users of texi2html and the :font facename=Courier size=16x8.@macro:font facename=default size=0x0. command (ignored, no error mes-
sage)&per.
:li.Added my name to the banner &colon.-)
:li.Removed the :font facename=Courier size=16x8.#include <string&per.h>:font facename=default size=0x0. from texi2ipf&per.h and added it to those
&per.c files that needed it&per.
:li.Texinfo menus will now be simulated in the output &per.ipf file&per. This
is not really necessary but it looks better than blank pages&per.
:li.:font facename=Courier size=16x8.@include:font facename=default size=0x0. statements inside of menus will no longer crash the program&per.
:li.All Texinfo :font facename=Courier size=16x8.@def*:font facename=default size=0x0. commands will now produce an index entry in
the main index&per. Support for seperate indices like "Concept index",
"Types index" etc&per. may be possible in future but has not yet been
added&per. The :font facename=Courier size=16x8.@printindex:font facename=default size=0x0. command still produces the "Sorry, no
&per.&per.&per. index" entry in the resulting &per.IPF file&per. Commands dealing with
custom indices will now produce a more verbose error (ignore) message&per.
:li.Changed the makefile&per. Compiles well under Unix systems (AIX and
LINUX) and with IBM's VisualAge C++ for OS/2&per.
:li.Added support for pseudo-Texinfo command @ipfline{} (my invention)
for entering IPF commands into the Texinfo source file&per. The syntax
is&colon. "@ipfline{<Sequence of IPF code not longer than one line>}" and
it should be put into :font facename=Courier size=16x8.@ifinfo:font facename=default size=0x0. / :font facename=Courier size=16x8.@end ifinfo:font facename=default size=0x0. blocks to
avoid trouble with e&per.g&per. texi2dvi or texi2html&per.
:eul.
:euserdoc.
