/* 
 *   Die Makrosprache ist voll Rexx-Kompatibel
 *   Besonderheiten, die das Lesen und Einfgen von
 *   Text in den Editor beinhalten, werden in diesem
 *   Makro und in 'MAKRO2.CMD' vorgestellt. 
 */

   say 'Makro gestartet'

/***************************************************************************/
/* Markierten Text in Variable schreiben                                   */
/* a) ber Zwischenablage: (Cut und Copy mglich)                          */

   ok = VRMethod( "MLE_1", "Copy")
   MarkierterText = VRMethod( "Application", "GetClipboard")

/* b) direkt:                                                              

   MarkierterText = VRGet( "MLE_1", "SelectedText") */

/***************************************************************************/
/* Interpretieren des Textes (hier als Beispiel: Lnge bestimmen           */

   laenge = length(MarkierterText)

/***************************************************************************/
/* Bestimmen der Positionen fr MarkierungStart und MarkierungEnde         */	

   Markierung_Start = VRGet( "MLE_1", "SelectedStart")
   Markierung_Ende  = VRGet( "MLE_1", "SelectedEnd")

/***************************************************************************/
/* Setzen der Markierung im Text von MarkierungStart bis MarkierungEnde    */

   ok = VRSet( "MLE_1", "SelectedStart", Markierung_Ende)
   ok = VRSet( "MLE_1", "SelectedEnd", Markierung_Ende)

/***************************************************************************/
/* Einfgen von Text auf verschiedene Weisen                               */

   ok = VRMethod( "MLE_1", "Insert", " (Lnge des Markierten Textes: " )

   ok = VRMethod( "Application", "PutClipboard", laenge)
   ok = VRMethod( "MLE_1", "Paste" )

   ok = VRMethod( "MLE_1", "Insert", ")" )

/***************************************************************************/
say "Testmakro ausgefhrt"
say D2C(13)||"Bitte schauen Sie sich doch einmal die Dateien"
say "<makro.cmd> und <makro2.cmd> im Installationsverzeichnis an  "
