/* 
 * tkOS2Pixmap.c --
 *
 *	This file contains the Xlib emulation functions pertaining to
 *	creating and destroying pixmaps.
 *
 * Copyright (c) 1996-1998 Illya Vaes
 * Copyright (c) 1995 Sun Microsystems, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */


#include "tkOS2Int.h"


/*
 *----------------------------------------------------------------------
 *
 * Tk_GetPixmap --
 *
 *	Creates an in memory drawing surface.
 *
 * Results:
 *	Returns a handle to a new pixmap.
 *
 * Side effects:
 *	Allocates a new OS/2 bitmap, hps, DC.
 *
 *----------------------------------------------------------------------
 */

Pixmap
Tk_GetPixmap(display, d, width, height, depth)
    Display* display;
    Drawable d;
    int width;
    int height;
    int depth;
{
    TkOS2Drawable *newTodPtr, *todPtr;
    BITMAPINFOHEADER2 bmpInfo;
    LONG rc;
    DEVOPENSTRUC dop = {0L, (PSZ)"DISPLAY", NULL, 0L, 0L, 0L, 0L, 0L, 0L};
    SIZEL sizl = {0,0}; /* use same page size as device */
    sizl.cx = width; sizl.cy = height;
    
    display->request++;

    newTodPtr = (TkOS2Drawable*) ckalloc(sizeof(TkOS2Drawable));
    if (newTodPtr == NULL) {
	return (Pixmap)None;
    }

    newTodPtr->type = TOD_BITMAP;
    newTodPtr->bitmap.depth = depth;
    todPtr = (TkOS2Drawable *)d;
    if (todPtr->type != TOD_BITMAP) {
        newTodPtr->bitmap.parent = todPtr->window.handle;
        if (todPtr->window.winPtr == NULL) {
            newTodPtr->bitmap.colormap = DefaultColormap(display,
                    DefaultScreen(display));
        } else {
            newTodPtr->bitmap.colormap = todPtr->window.winPtr->atts.colormap;
        }
    } else {
        newTodPtr->bitmap.colormap = todPtr->bitmap.colormap;
        newTodPtr->bitmap.parent = todPtr->bitmap.parent;
    }
    bmpInfo.cbFix = 16L;
    bmpInfo.cx = width;
    bmpInfo.cy = height;
    bmpInfo.cPlanes = 1;
    bmpInfo.cBitCount = depth;
    newTodPtr->bitmap.dc = DevOpenDC(hab, OD_MEMORY, (PSZ)"*", 5L,
                                     (PDEVOPENDATA)&dop, NULLHANDLE);
    if (newTodPtr->bitmap.dc == DEV_ERROR) {
        ckfree((char *) newTodPtr);
        return (Pixmap)None;
    }
    newTodPtr->bitmap.hps = GpiCreatePS(hab, newTodPtr->bitmap.dc, &sizl,
                                        PU_PELS | GPIT_MICRO | GPIA_ASSOC);
    if (newTodPtr->bitmap.hps == GPI_ERROR) {
        DevCloseDC(newTodPtr->bitmap.dc);
        ckfree((char *) newTodPtr);
        return (Pixmap)None;
    }
    newTodPtr->bitmap.handle = GpiCreateBitmap(newTodPtr->bitmap.hps,
                                               &bmpInfo, 0L, NULL, NULL);

    if (newTodPtr->bitmap.handle == NULLHANDLE) {
	ckfree((char *) newTodPtr);
	return (Pixmap)None;
    }
    sizl.cx = width;
    sizl.cy = height;
    rc = GpiSetBitmapDimension(newTodPtr->bitmap.handle, &sizl);
    rc = GpiSetBitmap(newTodPtr->bitmap.hps, newTodPtr->bitmap.handle);
    if (rc == HBM_ERROR) {
        GpiDestroyPS(newTodPtr->bitmap.hps);
        DevCloseDC(newTodPtr->bitmap.dc);
        ckfree((char *) newTodPtr);
        return (Pixmap)None;
    }

    return (Pixmap)newTodPtr;
}

/*
 *----------------------------------------------------------------------
 *
 * Tk_FreePixmap --
 *
 *	Release the resources associated with a pixmap.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Deletes the bitmap created by Tk_FreePixmap.
 *
 *----------------------------------------------------------------------
 */

void
Tk_FreePixmap(display, pixmap)
    Display* display;
    Pixmap pixmap;
{
    TkOS2Drawable *todPtr = (TkOS2Drawable *) pixmap;
    HBITMAP hbm;

    display->request++;
    if (todPtr != NULL) {
        hbm = GpiSetBitmap(todPtr->bitmap.hps, NULLHANDLE);
	GpiDeleteBitmap(todPtr->bitmap.handle);
        GpiDestroyPS(todPtr->bitmap.hps);
        DevCloseDC(todPtr->bitmap.dc);
	ckfree((char *)todPtr);
    }
}

/*
 *----------------------------------------------------------------------
 *
 * TkSetPixmapColormap --
 *
 *      The following function is a hack used by the photo widget to
 *      explicitly set the colormap slot of a Pixmap.
 *
 * Results:
 *      None.
 *
 * Side effects:
 *      None.
 *
 *----------------------------------------------------------------------
 */

void
TkSetPixmapColormap(pixmap, colormap)
    Pixmap pixmap;
    Colormap colormap;
{
    TkOS2Drawable *todPtr = (TkOS2Drawable *)pixmap;

    todPtr->bitmap.colormap = colormap;
    /*
    rc = (HPAL) TkOS2SelectPalette(todPtr->bitmap.hps, todPtr->bitmap.parent,
                                   colormap);
    */
}
