/************************************************************************\
*                                                                        *
*         Microsoft C  Language Sample TalkThru HLLAPI Module             *
*                                                                        *
*       (C) Copyright Software Corporation of America, Inc. 1991.        *
*       All Rights Reserved.                                             *
*                                                                        *
*			Stop Host Notification - 25                                     *
*                                                                        *
\************************************************************************/
 
#include "stdio.h"

#define INCL_DOSSEMAPHORES
#include "os2.h"
 
#include "clim.h"                     /* Include the CLIM header        */
#include "hapi.h"                     /* Include sample subs. header    */
 
void pascal hllapi();
 
 
/************************************************************************\
*                                                                        *
*        Global Variables                                                *
*                                                                        *
\************************************************************************/
 
extern int CLIMFunction;              /* API function                   */
extern int CLIMLength;                /* API string length              */
extern int CLIMReturnCode;            /* API return code                */
 
 
/************************************************************************\
*                                                                        *
*  HapiStopHostNote - Function to issue HLLAPI call #25                       *
*                                                                        *
\************************************************************************/
 
int HapiStopHostNote(ShortName)
char ShortName;
{
 
    CLIMFunction   = PCB_STOP_HOST_NOTE;         /* Set Function Code   */
    CLIMLength     = 0;                          /* Set Length          */
    CLIMReturnCode = -1;                         /* Initialize Ret. Code*/
 
    hllapi(&CLIMFunction, &ShortName, &CLIMLength, &CLIMReturnCode);
 
    return(CLIMReturnCode);                      /* Return to Caller    */
}
 
